/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.pc.boxes;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.storage.pc.search.Search;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.pc.StorageWidget;
import com.cobblemon.mod.common.client.storage.ClientBox;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.List;
import java.util.Objects;
import me.justahuman.more_cobblemon_tweaks.api.BoxViewHolder;
import me.justahuman.more_cobblemon_tweaks.features.pc.boxes.PrimaryColorCache;
import me.justahuman.more_cobblemon_tweaks.utils.Textures;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5253;

public class BoxListSlot
extends class_4185
implements CobblemonRenderable {
    private static final class_2960 POINTER = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/pc_pointer.png");
    private final StorageWidget parent;
    private final BetterOnPress betterOnPress;
    public final int boxIndex;

    public BoxListSlot(StorageWidget parent, int boxIndex, int x, int y, BetterOnPress onPress) {
        super(x, y, 25, 25, (class_2561)class_2561.method_43470((String)"BoxSlot"), button -> {}, field_40754);
        this.parent = parent;
        this.betterOnPress = onPress;
        this.boxIndex = boxIndex;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        ClientBox box = this.getBox();
        if (!this.shouldRender() || box == null) {
            return;
        }
        int wallpaperColor = PrimaryColorCache.getWallpaperColor(Utils.getUsedWallpaper(box));
        GuiUtilsKt.blitk((class_4587)context.method_51448(), (class_2960)Textures.BOX_LIST_SLOT_TEXTURE, (Number)this.method_46426(), (Number)this.method_46427(), (Number)25, (Number)25, (Number)0, (Number)0, (Number)25, (Number)25, (Number)0, (Number)Float.valueOf((float)class_5253.class_5254.method_27765((int)wallpaperColor) / 255.0f), (Number)Float.valueOf((float)class_5253.class_5254.method_27766((int)wallpaperColor) / 255.0f), (Number)Float.valueOf((float)class_5253.class_5254.method_27767((int)wallpaperColor) / 255.0f), (Number)Float.valueOf(0.75f));
        if (((BoxViewHolder)this.parent).moreCobblemonTweaks$getSelectedBoxListSlot() == this || this.isHovered(mouseX, mouseY)) {
            GuiUtilsKt.blitk((class_4587)context.method_51448(), (class_2960)POINTER, (Number)Float.valueOf((float)(this.method_46426() + 10) / 0.5f), (Number)Float.valueOf((float)(this.method_46427() - 3) / 0.5f - (float)this.parent.getPcGui().getSelectPointerOffsetY()), (Number)8, (Number)11, (Number)0, (Number)0, (Number)11, (Number)8, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)true, (float)0.5f);
        }
        int index = 0;
        for (int row = 1; row <= 5; ++row) {
            for (int col = 1; col <= 6; ++col) {
                Pokemon pokemon;
                int pokemonIndex;
                if ((pokemonIndex = index++) >= box.getSlots().size() || (pokemon = (Pokemon)box.getSlots().get(pokemonIndex)) == null) continue;
                int pokemonX = this.method_46426() + 1 + (col - 1) * 4;
                int pokemonY = this.method_46427() + 1 + (row - 1) * 5;
                int color = PrimaryColorCache.getPokemonColor(pokemon.getSpecies().resourceIdentifier);
                context.method_25294(pokemonX, pokemonY, pokemonX + 3, pokemonY + 3, color);
            }
        }
    }

    public ClientBox getBox() {
        List boxes = this.parent.getPcGui().getPc().getBoxes();
        return boxes.size() > this.boxIndex ? (ClientBox)boxes.get(this.boxIndex) : null;
    }

    public boolean clickable() {
        return this.getBox() != null && ((BoxViewHolder)this.parent).moreCobblemonTweaks$isBoxListOpen();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isHovered(mouseX, mouseY)) {
            this.betterOnPress.onPress(this, button);
            return true;
        }
        return false;
    }

    public boolean isHovered(double mouseX, double mouseY) {
        return this.clickable() && mouseX >= (double)this.method_46426() && mouseX <= (double)(this.method_46426() + 25) && mouseY >= (double)this.method_46427() && mouseY <= (double)(this.method_46427() + 25);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldRender() {
        ClientBox box = this.getBox();
        if (!this.clickable()) return false;
        if (box == null) {
            return false;
        }
        Search search = this.parent.getPcGui().getSearch();
        boolean emptyBox = box.getSlots().stream().allMatch(Objects::isNull);
        if (search == Search.Companion.getDEFAULT()) return true;
        if (emptyBox) return true;
        if (!box.getSlots().stream().anyMatch(arg_0 -> ((Search)search).passes(arg_0))) return false;
        return true;
    }

    public static interface BetterOnPress {
        public void onPress(BoxListSlot var1, int var2);
    }
}

