/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.pc.boxes;

import com.cobblemon.mod.common.client.render.SpriteType;
import com.cobblemon.mod.common.client.render.models.blockbench.FloatingState;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class PrimaryColorCache {
    private static final Map<class_2960, Integer> POKEMON_COLOR_CACHE = new HashMap<class_2960, Integer>();
    private static final Map<class_2960, Integer> WALLPAPER_COLOR_CACHE = new HashMap<class_2960, Integer>();
    private static final PosableState state = new FloatingState();
    private static final int FALLBACK_COLOR = -7829368;

    public static Integer getPokemonColor(class_2960 species) {
        return POKEMON_COLOR_CACHE.computeIfAbsent(species, $ -> {
            class_2960 textureToSample = VaryingModelRepository.INSTANCE.getSprite(species, state, SpriteType.PROFILE);
            if (textureToSample == null) {
                textureToSample = VaryingModelRepository.INSTANCE.getTexture(species, state);
            }
            try {
                return PrimaryColorCache.samplePrimaryColor(textureToSample);
            }
            catch (Exception e) {
                return -7829368;
            }
        });
    }

    public static Integer getWallpaperColor(class_2960 wallpaper) {
        return WALLPAPER_COLOR_CACHE.computeIfAbsent(wallpaper, $ -> {
            try {
                return PrimaryColorCache.samplePrimaryColor(wallpaper);
            }
            catch (Exception e) {
                return -7829368;
            }
        });
    }

    private static int samplePrimaryColor(class_2960 texture) throws IOException {
        class_3300 rm = class_310.method_1551().method_1478();
        class_3298 resource = (class_3298)rm.method_14486(texture).orElseThrow(() -> new IOException("Resource not found: " + String.valueOf(texture)));
        try (InputStream is = resource.method_14482();){
            int qb;
            int qg;
            int qr;
            int y;
            BufferedImage img = ImageIO.read(is);
            if (img == null) {
                throw new IOException("Unable to read image for " + String.valueOf(texture));
            }
            HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
            int w = img.getWidth();
            int h = img.getHeight();
            for (y = 0; y < h; y += 2) {
                for (int x = 0; x < w; x += 2) {
                    int rgba = img.getRGB(x, y);
                    int a = rgba >> 24 & 0xFF;
                    if (a < 128) continue;
                    int r = rgba >> 16 & 0xFF;
                    int g = rgba >> 8 & 0xFF;
                    int b = rgba & 0xFF;
                    qr = r >> 3 & 0x1F;
                    qg = g >> 3 & 0x1F;
                    qb = b >> 3 & 0x1F;
                    int key = qr << 10 | qg << 5 | qb;
                    counts.merge(key, 1, Integer::sum);
                }
            }
            if (counts.isEmpty()) {
                y = -7829368;
                return y;
            }
            int bestKey = -1;
            double bestScore = Double.NEGATIVE_INFINITY;
            for (Map.Entry e : counts.entrySet()) {
                int key = (Integer)e.getKey();
                int count = (Integer)e.getValue();
                qr = key >> 10 & 0x1F;
                qg = key >> 5 & 0x1F;
                qb = key & 0x1F;
                int rr = qr << 3 | qr >> 2;
                int gg = qg << 3 | qg >> 2;
                int bb = qb << 3 | qb >> 2;
                int max = Math.max(rr, Math.max(gg, bb));
                int min = Math.min(rr, Math.min(gg, bb));
                double d = max == 0 ? 0.0 : (double)(max - min) / (double)max;
                double sat = d;
                double score = (double)count * (1.0 + 0.35 * sat);
                if (!(score > bestScore)) continue;
                bestScore = score;
                bestKey = key;
            }
            int qr2 = bestKey >> 10 & 0x1F;
            int qg2 = bestKey >> 5 & 0x1F;
            int qb2 = bestKey & 0x1F;
            int rr = qr2 << 3 | qr2 >> 2;
            int gg = qg2 << 3 | qg2 >> 2;
            int bb = qb2 << 3 | qb2 >> 2;
            int n = 0xFF000000 | rr << 16 | gg << 8 | bb;
            return n;
        }
    }
}

