/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.mixins.pc;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.PokemonGuiUtilsKt;
import com.cobblemon.mod.common.client.gui.pc.BoxStorageSlot;
import com.cobblemon.mod.common.client.gui.pc.PCGUI;
import com.cobblemon.mod.common.client.gui.pc.PartyStorageSlot;
import com.cobblemon.mod.common.client.gui.pc.ReleaseConfirmButton;
import com.cobblemon.mod.common.client.gui.pc.StorageWidget;
import com.cobblemon.mod.common.client.gui.summary.widgets.SoundlessWidget;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.client.render.gui.PCBoxWallpaperRepository;
import com.cobblemon.mod.common.client.render.models.blockbench.FloatingState;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.storage.ClientBox;
import com.cobblemon.mod.common.client.storage.ClientPC;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.net.messages.server.storage.pc.MovePCPokemonPacket;
import com.cobblemon.mod.common.net.messages.server.storage.pc.ReleasePCPokemonPacket;
import com.cobblemon.mod.common.net.messages.server.storage.pc.RequestChangePCBoxWallpaperPacket;
import com.cobblemon.mod.common.net.messages.server.storage.pc.RequestRenamePCBoxPacket;
import com.cobblemon.mod.common.net.messages.server.storage.pc.SwapPCPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.math.QuaternionUtilsKt;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import kotlin.Triple;
import me.justahuman.more_cobblemon_tweaks.MoreCobblemonTweaks;
import me.justahuman.more_cobblemon_tweaks.api.BoxViewHolder;
import me.justahuman.more_cobblemon_tweaks.api.MultiSelector;
import me.justahuman.more_cobblemon_tweaks.api.MultiSelectorState;
import me.justahuman.more_cobblemon_tweaks.features.pc.boxes.BoxListButton;
import me.justahuman.more_cobblemon_tweaks.features.pc.boxes.BoxListSlot;
import me.justahuman.more_cobblemon_tweaks.features.pc.multiselect.MultiGrabbedStorageSlot;
import me.justahuman.more_cobblemon_tweaks.features.pc.multiselect.SlotPosition;
import me.justahuman.more_cobblemon_tweaks.mixins.accessor.ButtonAccessor;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StorageWidget.class}, remap=false)
public abstract class StorageWidgetMixin
extends SoundlessWidget
implements MultiSelector,
BoxViewHolder {
    @Unique
    private static final int BOX_PREVIEW_SIZE = 9;
    @Unique
    private static final FloatingState BOX_PREVIEW_STATE = new FloatingState();
    @Shadow
    @Final
    private static class_2960 screenOverlayResource;
    @Shadow
    @Final
    private static class_2960 screenGridResource;
    @Shadow
    @Final
    private static class_2960 partyPanelResource;
    @Shadow
    @Final
    private PCGUI pcGui;
    @Shadow
    private int box;
    @Shadow
    @Final
    private ArrayList<PartyStorageSlot> partySlots;
    @Shadow
    @Final
    private ReleaseConfirmButton releaseYesButton;
    @Unique
    private SlotPosition moreCobblemonTweaks$lastHoveredSlot = SlotPosition.ZERO;
    @Unique
    private PCPosition moreCobblemonTweaks$lastPosition = null;
    @Unique
    private int moreCobblemonTweaks$selectedBox = -1;
    @Unique
    private SlotPosition moreCobblemonTweaks$selectionOrigin = null;
    @Unique
    private final List<Pokemon> moreCobblemonTweaks$selection = new ArrayList<Pokemon>();
    @Unique
    private final Map<UUID, MultiGrabbedStorageSlot> moreCobblemonTweaks$grabbedSlots = new HashMap<UUID, MultiGrabbedStorageSlot>();
    @Unique
    private BoxListButton moreCobblemonTweaks$boxListButton;
    @Unique
    private Integer moreCobblemonTweaks$boxListSlotIndex = 0;
    @Unique
    private final List<BoxListSlot> moreCobblemonTweaks$boxListSlots = new ArrayList<BoxListSlot>();
    @Unique
    private BoxListSlot moreCobblemonTweaks$selectedBoxListSlot = null;

    private StorageWidgetMixin(int pX, int pY, int pWidth, int pHeight, @NotNull class_2561 component) {
        super(pX, pY, pWidth, pHeight, component);
    }

    @Inject(method={"<init>(IILcom/cobblemon/mod/common/client/gui/pc/PCGUI;Lcom/cobblemon/mod/common/client/storage/ClientPC;Lcom/cobblemon/mod/common/client/storage/ClientParty;)V"}, at={@At(value="TAIL")})
    private void addCustom(CallbackInfo ci) {
        StorageWidget self = (StorageWidget)this;
        class_4185.class_4241 original = ((ButtonAccessor)this.releaseYesButton).getOnPress();
        ((ButtonAccessor)this.releaseYesButton).setOnPress(button -> {
            if (!this.moreCobblemonTweaks$isMultiSelecting()) {
                original.onPress(button);
                return;
            }
            for (Pokemon pokemon : this.moreCobblemonTweaks$selection) {
                PCPosition position = this.pcGui.getPc().getPosition(pokemon);
                if (position == null) continue;
                CobblemonNetwork.sendToServer((NetworkPacket)new ReleasePCPokemonPacket(pokemon.getUuid(), position));
            }
            this.playSound(CobblemonSounds.PC_RELEASE);
            this.resetSelected();
            this.setDisplayConfirmRelease(false);
            this.moreCobblemonTweaks$clearMultiSelection();
        });
        this.moreCobblemonTweaks$boxListButton = new BoxListButton(self, this.method_46426() + 194, this.method_46427() + 124);
    }

    @Inject(at={@At(value="HEAD")}, method={"onStorageSlotClicked(Lnet/minecraft/class_4185;)V"}, cancellable=true)
    public void onStorageSlotClicked(class_4185 button, CallbackInfo ci) {
        if (!button.method_49606()) {
            ci.cancel();
            return;
        }
        if (!this.moreCobblemonTweaks$isMultiSelecting() && !this.moreCobblemonTweaks$isBoxListOpen()) {
            return;
        }
        ci.cancel();
        if (this.moreCobblemonTweaks$isMultiSelecting()) {
            this.moreCobblemonTweaks$multiSelectSlotClicked(button);
        }
    }

    @Unique
    private CompletableFuture<Void> moreCobblemonTweaks$handleMultiPokemonMoves(Map<Pokemon, PCPosition> moves) {
        return this.moreCobblemonTweaks$handleMultiPokemonMoves(moves, false);
    }

    @Unique
    private CompletableFuture<Void> moreCobblemonTweaks$handleMultiPokemonMoves(Map<Pokemon, PCPosition> moves, boolean nested) {
        if (moves.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        if (!nested) {
            Utils.moveAllCompleted = false;
            Utils.moveAllTimeouts = 0;
            Utils.moveAllCount = 0;
            Utils.moveAllCountUpdater = () -> {
                int count = 0;
                for (Map.Entry e : moves.entrySet()) {
                    Pokemon p = (Pokemon)e.getKey();
                    PCPosition pos = this.pcGui.getPc().getPosition(p);
                    if (pos == null || !pos.equals(e.getValue())) continue;
                    ++count;
                }
                Utils.moveAllCount = count;
            };
            Utils.moveAllTotal = moves.size();
        }
        ClientPC pc = this.pcGui.getPc();
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        for (Map.Entry<Pokemon, PCPosition> entry : moves.entrySet()) {
            Pokemon pokemon = entry.getKey();
            PCPosition target = entry.getValue();
            future = ((CompletableFuture)future).thenComposeAsync($ -> {
                PCPosition source = pc.getPosition(pokemon);
                if (source == null || source.equals((Object)target)) {
                    return CompletableFuture.completedFuture(null);
                }
                this.moreCobblemonTweaks$select(source, false);
                Pokemon targetPokemon = pc.get(target);
                SwapPCPokemonPacket packet = targetPokemon != null ? new SwapPCPokemonPacket(pokemon.getUuid(), source, targetPokemon.getUuid(), target) : new MovePCPokemonPacket(pokemon.getUuid(), source, target);
                CompletableFuture packetFuture = new CompletableFuture();
                Utils.moveAllPokemonFuture = packetFuture;
                CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(() -> StorageWidgetMixin.lambda$moreCobblemonTweaks$handleMultiPokemonMoves$2((NetworkPacket)packet));
                CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS).execute(() -> {
                    if (!packetFuture.isDone()) {
                        packetFuture.complete(null);
                        MoreCobblemonTweaks.LOGGER.warn("Timeouted {} times while moving Pok\u00e9mon {} in the PC. Will retry.", (Object)(++Utils.moveAllTimeouts), (Object)pokemon.getDisplayName(false).getString());
                    }
                });
                return packetFuture;
            });
        }
        future = ((CompletableFuture)future).thenComposeAsync($ -> {
            LinkedHashMap<Pokemon, PCPosition> incompleteMoves = new LinkedHashMap<Pokemon, PCPosition>();
            for (Map.Entry entry : moves.entrySet()) {
                PCPosition currentPosition;
                Pokemon pokemon = (Pokemon)entry.getKey();
                PCPosition target = (PCPosition)entry.getValue();
                if (target.equals((Object)(currentPosition = pc.getPosition(pokemon)))) continue;
                incompleteMoves.put(pokemon, target);
            }
            return !incompleteMoves.isEmpty() && Utils.moveAllTimeouts <= 5 ? this.moreCobblemonTweaks$handleMultiPokemonMoves(incompleteMoves, true) : CompletableFuture.completedFuture(null);
        });
        if (!nested) {
            future = ((CompletableFuture)future).whenComplete(($, t) -> {
                if (t == null) {
                    this.playSound(CobblemonSounds.PC_DROP);
                } else {
                    MoreCobblemonTweaks.LOGGER.error("An error occurred while moving multiple Pok\u00e9mon in the PC.", t);
                }
                Utils.moveAllPokemonFuture = null;
                Utils.moveAllCompleted = true;
                Utils.moveAllCount = 0;
                Utils.moveAllCountUpdater = () -> {};
                Utils.moveAllTimeouts = 0;
            });
        }
        return future;
    }

    @Inject(at={@At(value="TAIL")}, method={"method_48579(Lnet/minecraft/class_332;IIF)V"})
    public void renderGrabbedMultiSelection(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        for (MultiGrabbedStorageSlot slot : this.moreCobblemonTweaks$grabbedSlots.values()) {
            slot.method_25394(context, mouseX, mouseY, delta);
        }
        context.method_51448().method_22909();
    }

    @Unique
    private void moreCobblemonTweaks$multiSelectSlotClicked(class_4185 button) {
        boolean selecting;
        if (!(button instanceof BoxStorageSlot)) {
            return;
        }
        BoxStorageSlot slot = (BoxStorageSlot)button;
        if (slot.getPokemon() == null || class_437.method_25441() || slot.getPosition().getBox() != this.moreCobblemonTweaks$selectedBox && this.moreCobblemonTweaks$selectedBox != -1) {
            boolean emptyOnly = slot.getPokemon() == null;
            ClientPC pc = this.pcGui.getPc();
            PCPosition clickedPos = slot.getPosition();
            int box = clickedPos.getBox();
            SlotPosition clicked = SlotPosition.of(clickedPos);
            LinkedHashMap<Pokemon, PCPosition> moves = new LinkedHashMap<Pokemon, PCPosition>();
            for (Pokemon pokemon : this.moreCobblemonTweaks$selection) {
                PCPosition position = pc.getPosition(pokemon);
                if (position == null) continue;
                MultiGrabbedStorageSlot grabbed = this.moreCobblemonTweaks$grabbedSlots.get(pokemon.getUuid());
                SlotPosition offset = grabbed.localSlot.minus(this.moreCobblemonTweaks$selectionOrigin).plus(grabbed.getPlacingOffset(clicked));
                int index = clicked.plus(offset).index();
                PCPosition target = new PCPosition(box, index++);
                while (emptyOnly && pc.get(target) != null && !this.moreCobblemonTweaks$isSelected(target) && index <= 29) {
                    target = new PCPosition(box, index++);
                }
                if (emptyOnly && pc.get(target) != null && !this.moreCobblemonTweaks$isSelected(target)) break;
                moves.put(pokemon, target);
            }
            this.moreCobblemonTweaks$clearMultiSelection();
            this.moreCobblemonTweaks$handleMultiPokemonMoves(moves);
            return;
        }
        PCPosition lastPosition = this.moreCobblemonTweaks$lastPosition;
        PCPosition clickedPosition = slot.getPosition();
        boolean bl = selecting = !this.moreCobblemonTweaks$isSelected(clickedPosition);
        if (lastPosition != null && class_437.method_25442()) {
            int from = Math.min(lastPosition.getSlot(), clickedPosition.getSlot());
            int to = Math.max(lastPosition.getSlot(), clickedPosition.getSlot());
            for (int i = from; i <= to; ++i) {
                PCPosition position = new PCPosition(clickedPosition.getBox(), i);
                this.moreCobblemonTweaks$select(position, selecting);
            }
        } else {
            this.moreCobblemonTweaks$select(clickedPosition, selecting);
            this.moreCobblemonTweaks$lastPosition = clickedPosition;
        }
        this.playSound(selecting ? CobblemonSounds.PC_GRAB : CobblemonSounds.PC_DROP);
    }

    @Unique
    private void moreCobblemonTweaks$select(PCPosition position, boolean select) {
        Pokemon pokemon = this.pcGui.getPc().get(position);
        if (pokemon == null) {
            return;
        }
        if (select) {
            if (this.moreCobblemonTweaks$isSelected(position)) {
                return;
            }
            SlotPosition slot = SlotPosition.of(position);
            SlotPosition localSlot = SlotPosition.of(this.moreCobblemonTweaks$selection.size());
            int boxStartX = this.method_46426() + 7;
            int boxStartY = this.method_46427() + 11 + (this.pcGui.getDisplayOptions() ? 5 : 0);
            MultiGrabbedStorageSlot grabbedSlot = new MultiGrabbedStorageSlot(boxStartX + slot.x() * 27, boxStartY + slot.y() * 27, (StorageWidget)this, pokemon, slot, localSlot);
            if (this.moreCobblemonTweaks$selection.isEmpty()) {
                this.moreCobblemonTweaks$selectionOrigin = localSlot;
            }
            this.moreCobblemonTweaks$selectedBox = position.getBox();
            this.moreCobblemonTweaks$selection.add(pokemon);
            this.moreCobblemonTweaks$grabbedSlots.put(pokemon.getUuid(), grabbedSlot);
        } else {
            this.moreCobblemonTweaks$selection.remove(pokemon);
            this.moreCobblemonTweaks$grabbedSlots.remove(pokemon.getUuid());
            if (this.moreCobblemonTweaks$selection.isEmpty()) {
                this.moreCobblemonTweaks$selectedBox = -1;
                this.moreCobblemonTweaks$selectionOrigin = null;
            } else {
                for (int i = 0; i < this.moreCobblemonTweaks$selection.size(); ++i) {
                    Pokemon p = this.moreCobblemonTweaks$selection.get(i);
                    MultiGrabbedStorageSlot slot = this.moreCobblemonTweaks$grabbedSlots.get(p.getUuid());
                    slot.localSlot = SlotPosition.of(i);
                    if (i != 0) continue;
                    this.moreCobblemonTweaks$selectionOrigin = slot.localSlot;
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canDeleteSelected()Z"}, cancellable=true)
    public void canDelete(CallbackInfoReturnable<Boolean> cir) {
        if (this.moreCobblemonTweaks$isMultiSelecting()) {
            cir.setReturnValue((Object)(!this.moreCobblemonTweaks$selection.isEmpty() ? 1 : 0));
        }
    }

    @Override
    public boolean moreCobblemonTweaks$isMultiSelecting() {
        return ((MultiSelectorState)this.pcGui).moreCobblemonTweaks$isMultiSelecting();
    }

    @Override
    public boolean moreCobblemonTweaks$isSelected(PCPosition position) {
        Pokemon pokemon = this.pcGui.getPc().get(position);
        return pokemon != null && this.moreCobblemonTweaks$selection.contains(pokemon);
    }

    @Override
    public SlotPosition moreCobblemonTweaks$getSelectionOrigin() {
        return this.moreCobblemonTweaks$selectionOrigin;
    }

    @Override
    public SlotPosition moreCobblemonTweaks$getHoveredSlot(int mouseX, int mouseY) {
        for (class_364 child : this.getChildren()) {
            BoxStorageSlot boxSlot;
            if (!(child instanceof BoxStorageSlot) || !(boxSlot = (BoxStorageSlot)child).isHovered(mouseX, mouseY)) continue;
            this.moreCobblemonTweaks$lastHoveredSlot = SlotPosition.of(boxSlot.getPosition());
            return this.moreCobblemonTweaks$lastHoveredSlot;
        }
        return this.moreCobblemonTweaks$lastHoveredSlot;
    }

    @Override
    public List<Pokemon> moreCobblemonTweaks$getSelectedPokemon() {
        return this.moreCobblemonTweaks$selection;
    }

    @Override
    public void moreCobblemonTweaks$clearMultiSelection() {
        this.moreCobblemonTweaks$selectedBox = -1;
        this.moreCobblemonTweaks$selection.clear();
        this.moreCobblemonTweaks$grabbedSlots.clear();
        this.moreCobblemonTweaks$lastPosition = null;
    }

    @Inject(method={"method_48579(Lnet/minecraft/class_332;IIF)V"}, at={@At(value="TAIL")})
    public void renderBoxListButton(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.moreCobblemonTweaks$isBoxListOpen()) {
            return;
        }
        this.moreCobblemonTweaks$boxListButton.method_25394(context, mouseX, mouseY, delta);
    }

    @Inject(method={"method_25402(DDI)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void boxListButtonClicked(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (this.moreCobblemonTweaks$boxListButton.method_25405(pMouseX, pMouseY)) {
            this.moreCobblemonTweaks$boxListButton.method_25402(pMouseX, pMouseY, pButton);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setBox(I)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void setBoxRestriction(int value, CallbackInfo ci) {
        if (!this.moreCobblemonTweaks$isBoxListOpen()) {
            return;
        }
        int startingBox = value * 30;
        if (startingBox >= this.pcGui.getPc().getBoxes().size()) {
            ((StorageWidget)this).setBox(0);
            ci.cancel();
        } else if (startingBox < 0) {
            int lastBoxIndex = (this.pcGui.getPc().getBoxes().size() - 1) / 30;
            ((StorageWidget)this).setBox(lastBoxIndex);
            ci.cancel();
        }
    }

    @Inject(method={"method_48579(Lnet/minecraft/class_332;IIF)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBoxList(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        ClientBox box;
        if (!this.moreCobblemonTweaks$isBoxListOpen()) {
            return;
        }
        ci.cancel();
        class_4587 matrices = context.method_51448();
        if (this.pcGui.getConfiguration().getShowParty()) {
            GuiUtilsKt.blitk((class_4587)matrices, (class_2960)partyPanelResource, (Number)(this.method_46426() + 182), (Number)(this.method_46427() - 19), (Number)169, (Number)82);
            this.drawScaledText(context, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), LocalizationUtilsKt.lang((String)"ui.party", (Object[])new Object[0]).method_27692(class_124.field_1067), this.method_46426() + 213, (double)this.method_46427() - 15.5, true, true);
        }
        GuiUtilsKt.blitk((class_4587)matrices, (class_2960)screenGridResource, (Number)(this.method_46426() + 7), (Number)(this.method_46427() + (this.pcGui.getDisplayOptions() ? 16 : 11)), (Number)133, (Number)160);
        GuiUtilsKt.blitk((class_4587)matrices, (class_2960)screenOverlayResource, (Number)this.method_46426(), (Number)this.method_46427(), (Number)155, (Number)174);
        for (BoxListSlot boxSlot : this.moreCobblemonTweaks$boxListSlots) {
            boxSlot.method_25394(context, mouseX, mouseY, delta);
        }
        BoxListSlot previewed = this.moreCobblemonTweaks$getPreviewedBoxListSlot(mouseX, mouseY);
        if (previewed != null && (box = previewed.getBox()) != null) {
            int pcGuiX = (this.pcGui.field_22789 - 349) / 2;
            int pcGuiY = (this.pcGui.field_22790 - 205) / 2;
            class_5250 boxName = class_2561.method_43469((String)"cobblemon.ui.pc.box.title", (Object[])new Object[]{previewed.boxIndex + 1}).method_27692(class_124.field_1067);
            if (box.getName() != null) {
                Object clipped = box.getName().getString();
                if (((String)clipped).length() > 13) {
                    clipped = ((String)clipped).substring(0, 13) + "...";
                }
                boxName = class_2561.method_43470((String)clipped).method_27692(class_124.field_1067);
            }
            this.drawScaledText(context, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), boxName, pcGuiX + 5, (double)pcGuiY + 11.5, false, true);
            int previewX = pcGuiX + 6;
            int previewY = pcGuiY + 27;
            List slots = box.getSlots();
            int index = 0;
            for (int row = 1; row <= 5; ++row) {
                for (int col = 1; col <= 6; ++col) {
                    Pokemon pokemon;
                    if ((pokemon = (Pokemon)slots.get(index++)) == null) continue;
                    int pokemonX = previewX + 3 + (col - 1) * 10 + (col > 3 ? 1 : 0);
                    int pokemonY = previewY + 6 + (row - 1) * 11;
                    context.method_44379(pokemonX - 2, pokemonY + 2, pokemonX + 9 + 4, pokemonY + 9 + 4);
                    matrices.method_22903();
                    matrices.method_22904((double)pokemonX + 4.5, (double)(pokemonY + 1), 0.0);
                    matrices.method_22905(2.5f, 2.5f, 1.0f);
                    PokemonGuiUtilsKt.drawProfilePokemon((RenderablePokemon)pokemon.asRenderablePokemon(), (class_4587)matrices, (Quaternionf)QuaternionUtilsKt.fromEulerXYZDegrees((Quaternionf)new Quaternionf(), (Vector3f)new Vector3f(13.0f, 35.0f, 0.0f)), (PoseType)PoseType.PROFILE, (PosableState)BOX_PREVIEW_STATE, (float)0.0f, (float)1.62f, (boolean)true, (boolean)false, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    matrices.method_22909();
                    context.method_44380();
                }
            }
        }
        if (this.pcGui.getConfiguration().getShowParty()) {
            for (PartyStorageSlot partySlot : this.partySlots) {
                partySlot.method_25394(context, mouseX, mouseY, delta);
            }
        }
        this.moreCobblemonTweaks$boxListButton.method_25394(context, mouseX, mouseY, delta);
    }

    @Unique
    private void moreCobblemonTweaks$boxListSlotClicked(BoxListSlot slot, int button) {
        if (!slot.shouldRender()) {
            return;
        }
        if (button == 1 || class_437.method_25442()) {
            this.moreCobblemonTweaks$boxListButton.method_25402(this.moreCobblemonTweaks$boxListButton.method_46426() + 1, this.moreCobblemonTweaks$boxListButton.method_46427() + 1, button);
            ((StorageWidget)this).setBox(slot.boxIndex);
            this.moreCobblemonTweaks$selectedBoxListSlot = null;
            return;
        }
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)CobblemonSounds.PC_CLICK, (float)1.0f));
        if (this.moreCobblemonTweaks$selectedBoxListSlot != null && this.moreCobblemonTweaks$selectedBoxListSlot.shouldRender()) {
            if (this.moreCobblemonTweaks$selectedBoxListSlot != slot) {
                Pokemon pokemon;
                int i;
                class_2960 toBoxWallpaper;
                class_2960 fromBoxWallpaper;
                String toBoxName;
                int fromBoxIndex = this.moreCobblemonTweaks$selectedBoxListSlot.boxIndex;
                int toBoxIndex = slot.boxIndex;
                ClientPC pc = this.pcGui.getPc();
                ClientBox fromBox = this.moreCobblemonTweaks$selectedBoxListSlot.getBox();
                ClientBox toBox = slot.getBox();
                if (fromBox == null || toBox == null) {
                    this.moreCobblemonTweaks$selectedBoxListSlot = null;
                    return;
                }
                String fromBoxName = fromBox.getName() != null ? fromBox.getName().getString() : null;
                String string = toBoxName = toBox.getName() != null ? toBox.getName().getString() : null;
                if (!Objects.equals(fromBoxName, toBoxName)) {
                    new RequestRenamePCBoxPacket(pc.getUuid(), fromBoxIndex, toBoxName).sendToServer();
                    new RequestRenamePCBoxPacket(pc.getUuid(), toBoxIndex, fromBoxName).sendToServer();
                }
                if (!Objects.equals(fromBoxWallpaper = fromBox.getWallpaper(), toBoxWallpaper = toBox.getWallpaper())) {
                    class_2960 altFromBoxWallpaper = null;
                    class_2960 altToBoxWallpaper = null;
                    for (Triple wallpaperData : PCBoxWallpaperRepository.allWallpapers) {
                        if (fromBoxWallpaper.equals(wallpaperData.getFirst())) {
                            altFromBoxWallpaper = (class_2960)wallpaperData.getSecond();
                            continue;
                        }
                        if (!toBoxWallpaper.equals(wallpaperData.getSecond())) continue;
                        altToBoxWallpaper = (class_2960)wallpaperData.getFirst();
                    }
                    new RequestChangePCBoxWallpaperPacket(pc.getUuid(), fromBoxIndex, toBoxWallpaper, altToBoxWallpaper).sendToServer();
                    new RequestChangePCBoxWallpaperPacket(pc.getUuid(), toBoxIndex, fromBoxWallpaper, altFromBoxWallpaper).sendToServer();
                }
                LinkedHashMap<Pokemon, PCPosition> moves = new LinkedHashMap<Pokemon, PCPosition>();
                List fromSlots = fromBox.getSlots();
                List toSlots = toBox.getSlots();
                for (i = 0; i < fromSlots.size(); ++i) {
                    pokemon = (Pokemon)fromSlots.get(i);
                    if (pokemon == null) continue;
                    moves.put(pokemon, new PCPosition(toBoxIndex, i));
                }
                for (i = 0; i < toSlots.size(); ++i) {
                    pokemon = (Pokemon)toSlots.get(i);
                    if (pokemon == null) continue;
                    moves.put(pokemon, new PCPosition(fromBoxIndex, i));
                }
                this.moreCobblemonTweaks$handleMultiPokemonMoves(moves);
            }
            this.moreCobblemonTweaks$selectedBoxListSlot = null;
            return;
        }
        this.moreCobblemonTweaks$selectedBoxListSlot = slot;
    }

    @WrapOperation(method={"setupStorageSlots()V"}, at={@At(value="NEW", target="Lcom/cobblemon/mod/common/client/gui/pc/BoxStorageSlot;")})
    public BoxStorageSlot setupBoxListSlotForEachBoxSlot(int x, int y, StorageWidget parent, ClientPC pc, PCPosition position, class_4185.class_4241 onPress, Operation<BoxStorageSlot> original) {
        Integer n = this.moreCobblemonTweaks$boxListSlotIndex;
        this.moreCobblemonTweaks$boxListSlotIndex = this.moreCobblemonTweaks$boxListSlotIndex + 1;
        BoxListSlot boxListSlot = new BoxListSlot(parent, n, x, y, (slot, button) -> this.moreCobblemonTweaks$boxListSlotClicked(slot, button));
        this.addWidget((class_364)boxListSlot);
        this.moreCobblemonTweaks$boxListSlots.add(boxListSlot);
        return (BoxStorageSlot)original.call(new Object[]{x, y, parent, pc, position, onPress});
    }

    @Inject(method={"resetStorageSlots()V"}, at={@At(value="TAIL")})
    public void resetBoxListSlots(CallbackInfo ci) {
        this.moreCobblemonTweaks$boxListSlots.forEach(widget -> this.removeWidget((class_364)widget));
        this.moreCobblemonTweaks$boxListSlots.clear();
        this.moreCobblemonTweaks$boxListSlotIndex = 30 * this.box;
    }

    @Override
    public boolean moreCobblemonTweaks$isBoxListOpen() {
        return this.moreCobblemonTweaks$boxListButton.isToggled();
    }

    @Override
    public BoxListSlot moreCobblemonTweaks$getSelectedBoxListSlot() {
        return this.moreCobblemonTweaks$selectedBoxListSlot;
    }

    @Override
    public BoxListSlot moreCobblemonTweaks$getPreviewedBoxListSlot(double mouseX, double mouseY) {
        BoxListSlot previewed = this.moreCobblemonTweaks$getSelectedBoxListSlot();
        for (BoxListSlot boxSlot : this.moreCobblemonTweaks$boxListSlots) {
            if (!boxSlot.isHovered(mouseX, mouseY) || !boxSlot.shouldRender()) continue;
            previewed = boxSlot;
        }
        return previewed;
    }

    private void drawScaledText(class_332 context, class_2960 font, class_5250 text, double x, double y, boolean centered, boolean shadow) {
        RenderHelperKt.drawScaledText((class_332)context, (class_2960)font, (class_5250)text, (Number)x, (Number)y, (float)1.0f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)centered, (boolean)shadow, null, null);
    }

    @Inject(at={@At(value="HEAD")}, method={"method_25402(DDI)Z"}, cancellable=true, remap=true)
    public void mouseClicked(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (!this.field_22764) {
            cir.setReturnValue((Object)false);
        }
    }

    @Shadow
    public abstract void setDisplayConfirmRelease(boolean var1);

    @Shadow
    protected abstract void playSound(class_3414 var1);

    @Shadow
    public abstract void setupStorageSlots();

    @Shadow
    public abstract void resetSelected();

    @Shadow
    public abstract boolean canDeleteSelected();

    private static /* synthetic */ void lambda$moreCobblemonTweaks$handleMultiPokemonMoves$2(NetworkPacket packet) {
        CobblemonNetwork.sendToServer((NetworkPacket)packet);
    }
}

