/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.capability;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.capability.BalmCapabilities;
import net.blay09.mods.balm.api.capability.CapabilityType;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class FabricBalmCapabilities
implements BalmCapabilities {
    private final Map<class_2960, CapabilityType<?, ?, ?>> types = new ConcurrentHashMap();

    @Override
    public <TScope, TApi, TContext> CapabilityType<TScope, TApi, TContext> getType(class_2960 identifier, Class<TScope> scopeClass, Class<TApi> apiClass, Class<TContext> contextClass) {
        CapabilityType<Object, Object, Object> type = this.types.get(identifier);
        if (type == null) {
            type = this.registerType(identifier, scopeClass, apiClass, contextClass);
        }
        if (type.scopeClass() != scopeClass) {
            throw new IllegalArgumentException("Incompatible scope for capability " + String.valueOf(identifier) + ", expected " + String.valueOf(type.scopeClass()) + " but got " + String.valueOf(scopeClass));
        }
        if (type.apiClass() != apiClass) {
            throw new IllegalArgumentException("Incompatible API for capability " + String.valueOf(identifier) + ", expected " + String.valueOf(type.apiClass()) + " but got " + String.valueOf(apiClass));
        }
        if (type.contextClass() != contextClass) {
            throw new IllegalArgumentException("Incompatible context for capability " + String.valueOf(identifier) + ", expected " + String.valueOf(type.contextClass()) + " but got " + String.valueOf(contextClass));
        }
        return type;
    }

    @Override
    public <TApi, TContext> TApi getCapability(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, TContext context, CapabilityType<class_2248, TApi, TContext> type) {
        BlockApiLookup lookup = (BlockApiLookup)type.backingType();
        return (TApi)lookup.find(level, pos, state, blockEntity, context);
    }

    @Override
    public <TScope, TApi, TContext> CapabilityType<TScope, TApi, TContext> registerType(class_2960 identifier, Class<TScope> scopeClass, Class<TApi> apiClass, Class<TContext> contextClass) {
        BlockApiLookup lookup = BlockApiLookup.get((class_2960)identifier, apiClass, contextClass);
        CapabilityType<TScope, TApi, TContext> type = new CapabilityType<TScope, TApi, TContext>(identifier, scopeClass, apiClass, contextClass, lookup);
        this.types.put(identifier, type);
        return type;
    }

    @Override
    public <TApi, TContext> void registerProvider(class_2960 identifier, CapabilityType<class_2248, TApi, TContext> type, BiFunction<class_2586, TContext, TApi> provider, Supplier<List<class_2591<?>>> blockEntityTypes) {
        BlockApiLookup lookup = (BlockApiLookup)type.backingType();
        lookup.registerForBlockEntities(provider::apply, (class_2591[])blockEntityTypes.get().toArray(class_2591[]::new));
    }

    @Override
    public <TApi, TContext> void registerFallbackBlockEntityProvider(class_2960 identifier, CapabilityType<class_2248, TApi, TContext> type, final BiFunction<class_2586, TContext, TApi> provider) {
        BlockApiLookup lookup = (BlockApiLookup)type.backingType();
        lookup.registerFallback(new BlockApiLookup.BlockApiProvider<TApi, TContext>(this){

            @Nullable
            public TApi find(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, TContext context) {
                return blockEntity != null ? (Object)provider.apply(blockEntity, context) : null;
            }
        });
    }
}

