/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.event.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.client.ClientStartedEvent;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.event.client.DisconnectedFromServerEvent;
import net.blay09.mods.balm.api.event.client.ItemTooltipEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.balm.fabric.event.FabricBalmEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2791;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class FabricBalmClientEvents {
    private static final List<Consumer<class_437>> screenDrawPreInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static final List<Consumer<class_437>> screenDrawPostInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static final List<Consumer<class_437>> screenMousePressPreInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static final List<Consumer<class_437>> screenMousePressPostInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static final List<Consumer<class_437>> screenMouseReleasePreInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static final List<Consumer<class_437>> screenMouseReleasePostInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static final List<Consumer<class_437>> screenMouseClickPreInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static final List<Consumer<class_437>> screenMouseClickPostInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static final List<Consumer<class_437>> screenKeyPressPreInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static final List<Consumer<class_437>> screenKeyPressPostInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static final List<Consumer<class_437>> screenKeyReleasePreInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static final List<Consumer<class_437>> screenKeyReleasePostInitializers = new CopyOnWriteArrayList<Consumer<class_437>>();
    private static ScreenEvents.BeforeInit beforeInitListener = null;

    private static void initializeScreenEvents() {
        if (beforeInitListener == null) {
            ArrayList<List<Consumer<class_437>>> initializers = new ArrayList<List<Consumer<class_437>>>();
            initializers.add(screenDrawPreInitializers);
            initializers.add(screenDrawPostInitializers);
            initializers.add(screenMousePressPreInitializers);
            initializers.add(screenMousePressPostInitializers);
            initializers.add(screenMouseReleasePreInitializers);
            initializers.add(screenMouseReleasePostInitializers);
            initializers.add(screenMouseClickPreInitializers);
            initializers.add(screenMouseClickPostInitializers);
            initializers.add(screenKeyPressPreInitializers);
            initializers.add(screenKeyPressPostInitializers);
            initializers.add(screenKeyReleasePreInitializers);
            initializers.add(screenKeyReleasePostInitializers);
            beforeInitListener = (client, scr, scaledWidth, scaledHeight) -> {
                for (List list : initializers) {
                    for (Consumer initializer : list) {
                        initializer.accept(scr);
                    }
                }
            };
            ScreenEvents.BEFORE_INIT.register((Object)beforeInitListener);
        }
    }

    public static void registerEvents(FabricBalmEvents events) {
        events.registerTickEvent(TickType.Client, TickPhase.Start, handler -> ClientTickEvents.START_CLIENT_TICK.register(handler::handle));
        events.registerTickEvent(TickType.Client, TickPhase.End, handler -> ClientTickEvents.END_CLIENT_TICK.register(handler::handle));
        events.registerTickEvent(TickType.ClientLevel, TickPhase.Start, handler -> ClientTickEvents.START_WORLD_TICK.register(handler::handle));
        events.registerTickEvent(TickType.ClientLevel, TickPhase.End, handler -> ClientTickEvents.END_WORLD_TICK.register(handler::handle));
        events.registerEvent(ClientStartedEvent.class, () -> ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            ClientStartedEvent event = new ClientStartedEvent(client);
            events.fireEventHandlers(event);
        }));
        events.registerEvent(ConnectedToServerEvent.class, () -> ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            ConnectedToServerEvent event = new ConnectedToServerEvent(client);
            events.fireEventHandlers(event);
        }));
        events.registerEvent(DisconnectedFromServerEvent.class, () -> ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            DisconnectedFromServerEvent event = new DisconnectedFromServerEvent(client);
            events.fireEventHandlers(event);
        }));
        events.registerEvent(ScreenInitEvent.Pre.class, () -> ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            ScreenInitEvent.Pre event = new ScreenInitEvent.Pre(screen);
            events.fireEventHandlers(event);
        }));
        events.registerEvent(ScreenInitEvent.Post.class, () -> ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            ScreenInitEvent.Post event = new ScreenInitEvent.Post(screen);
            events.fireEventHandlers(event);
        }));
        events.registerEvent(ScreenDrawEvent.Pre.class, () -> {
            FabricBalmClientEvents.initializeScreenEvents();
            screenDrawPreInitializers.add(scr -> ScreenEvents.beforeRender((class_437)scr).register((screen, guiGraphics, mouseX, mouseY, tickDelta) -> {
                ScreenDrawEvent.Pre event = new ScreenDrawEvent.Pre(screen, guiGraphics, mouseX, mouseY, tickDelta);
                events.fireEventHandlers(event);
            }));
        });
        events.registerEvent(ScreenDrawEvent.Post.class, () -> {
            FabricBalmClientEvents.initializeScreenEvents();
            screenDrawPostInitializers.add(scr -> ScreenEvents.afterRender((class_437)scr).register((screen, guiGraphics, mouseX, mouseY, tickDelta) -> {
                ScreenDrawEvent.Post event = new ScreenDrawEvent.Post(screen, guiGraphics, mouseX, mouseY, tickDelta);
                events.fireEventHandlers(event);
            }));
        });
        events.registerEvent(ScreenMouseEvent.Click.Pre.class, () -> {
            FabricBalmClientEvents.initializeScreenEvents();
            screenMouseClickPreInitializers.add(scr -> ScreenMouseEvents.allowMouseClick((class_437)scr).register((screen, mouseX, mouseY, button) -> {
                ScreenMouseEvent.Click.Pre event = new ScreenMouseEvent.Click.Pre(screen, mouseX, mouseY, button);
                events.fireEventHandlers(event);
                return !event.isCanceled();
            }));
        });
        events.registerEvent(ScreenMouseEvent.Click.Post.class, () -> {
            FabricBalmClientEvents.initializeScreenEvents();
            screenMouseClickPostInitializers.add(scr -> ScreenMouseEvents.afterMouseClick((class_437)scr).register((screen, mouseX, mouseY, button) -> {
                ScreenMouseEvent.Click.Post event = new ScreenMouseEvent.Click.Post(screen, mouseX, mouseY, button);
                events.fireEventHandlers(event);
            }));
        });
        events.registerEvent(ScreenMouseEvent.Release.Pre.class, () -> {
            FabricBalmClientEvents.initializeScreenEvents();
            screenMouseReleasePreInitializers.add(scr -> ScreenMouseEvents.allowMouseRelease((class_437)scr).register((screen, mouseX, mouseY, button) -> {
                ScreenMouseEvent.Release.Pre event = new ScreenMouseEvent.Release.Pre(screen, mouseX, mouseY, button);
                events.fireEventHandlers(event);
                return !event.isCanceled();
            }));
        });
        events.registerEvent(ScreenMouseEvent.Release.Post.class, () -> {
            FabricBalmClientEvents.initializeScreenEvents();
            screenMouseReleasePostInitializers.add(scr -> ScreenMouseEvents.afterMouseRelease((class_437)scr).register((screen, mouseX, mouseY, button) -> {
                ScreenMouseEvent.Release.Post event = new ScreenMouseEvent.Release.Post(screen, mouseX, mouseY, button);
                events.fireEventHandlers(event);
            }));
        });
        events.registerEvent(ScreenKeyEvent.Press.Pre.class, () -> {
            FabricBalmClientEvents.initializeScreenEvents();
            screenKeyPressPreInitializers.add(scr -> ScreenKeyboardEvents.allowKeyPress((class_437)scr).register((screen, KeyX, KeyY, button) -> {
                ScreenKeyEvent.Press.Pre event = new ScreenKeyEvent.Press.Pre(screen, KeyX, KeyY, button);
                events.fireEventHandlers(event);
                return !event.isCanceled();
            }));
        });
        events.registerEvent(ScreenKeyEvent.Press.Post.class, () -> {
            FabricBalmClientEvents.initializeScreenEvents();
            screenKeyPressPostInitializers.add(scr -> ScreenKeyboardEvents.afterKeyPress((class_437)scr).register((screen, KeyX, KeyY, button) -> {
                ScreenKeyEvent.Press.Post event = new ScreenKeyEvent.Press.Post(screen, KeyX, KeyY, button);
                events.fireEventHandlers(event);
            }));
        });
        events.registerEvent(ScreenKeyEvent.Release.Pre.class, () -> {
            FabricBalmClientEvents.initializeScreenEvents();
            screenKeyReleasePreInitializers.add(scr -> ScreenKeyboardEvents.allowKeyRelease((class_437)scr).register((screen, KeyX, KeyY, button) -> {
                ScreenKeyEvent.Release.Pre event = new ScreenKeyEvent.Release.Pre(screen, KeyX, KeyY, button);
                events.fireEventHandlers(event);
                return !event.isCanceled();
            }));
        });
        events.registerEvent(ScreenKeyEvent.Release.Post.class, () -> {
            FabricBalmClientEvents.initializeScreenEvents();
            screenKeyReleasePostInitializers.add(scr -> ScreenKeyboardEvents.afterKeyRelease((class_437)scr).register((screen, KeyX, KeyY, button) -> {
                ScreenKeyEvent.Release.Post event = new ScreenKeyEvent.Release.Post(screen, KeyX, KeyY, button);
                events.fireEventHandlers(event);
            }));
        });
        events.registerEvent(ItemTooltipEvent.class, () -> ItemTooltipCallback.EVENT.register((stack, context, flag, lines) -> {
            ItemTooltipEvent event = new ItemTooltipEvent(stack, (class_1657)class_310.method_1551().field_1724, lines, flag);
            events.fireEventHandlers(event);
        }));
        events.registerEvent(ChunkLoadingEvent.Unload.class, () -> ClientChunkEvents.CHUNK_UNLOAD.register((level, chunk) -> events.fireEventHandlers(new ChunkLoadingEvent.Unload((class_1936)level, (class_2791)chunk))));
        events.registerEvent(ChunkLoadingEvent.Load.class, () -> ClientChunkEvents.CHUNK_LOAD.register((level, chunk) -> events.fireEventHandlers(new ChunkLoadingEvent.Load((class_1936)level, (class_2791)chunk))));
    }
}

