/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.breeding;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.egg.EggGroup;
import com.cobblemon.mod.common.api.pokemon.evolution.PreEvolution;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.provismet.cobblemon.daycareplus.DaycarePlusMain;
import com.provismet.cobblemon.daycareplus.breeding.FormPropertiesOverride;
import com.provismet.cobblemon.daycareplus.breeding.PotentialPokemonProperties;
import com.provismet.cobblemon.daycareplus.breeding.PreEvoFormOverride;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.feature.BreedableProperty;
import com.provismet.cobblemon.daycareplus.feature.FertilityFeature;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class BreedingUtils
implements SimpleSynchronousResourceReloadListener {
    private static final String DITTO = "Ditto";
    private static final Map<class_2960, PreEvoFormOverride> PRE_EVO_OVERRIDES = new HashMap<class_2960, PreEvoFormOverride>();
    private static final Map<String, FormPropertiesOverride> FORM_PROPERTY_OVERRIDES = new HashMap<String, FormPropertiesOverride>();

    public static boolean isAllowedToBreed(Pokemon pokemon) {
        return BreedableProperty.get(pokemon) && (!DaycarePlusOptions.doCompetitiveBreeding() || DaycarePlusOptions.shouldAllowBreedingWithoutFertility() || FertilityFeature.get(pokemon) > 0);
    }

    public static boolean canBreed(Pokemon parent1, Pokemon parent2) {
        if (!BreedingUtils.isAllowedToBreed(parent1) || !BreedingUtils.isAllowedToBreed(parent2)) {
            return false;
        }
        HashSet eggGroups1 = parent1.getSpecies().getEggGroups();
        HashSet eggGroups2 = parent2.getSpecies().getEggGroups();
        if (eggGroups1.contains(EggGroup.UNDISCOVERED) || eggGroups2.contains(EggGroup.UNDISCOVERED)) {
            return false;
        }
        if (eggGroups1.contains(EggGroup.DITTO) ^ eggGroups2.contains(EggGroup.DITTO)) {
            return true;
        }
        if (parent1.getGender() == Gender.GENDERLESS || parent2.getGender() == Gender.GENDERLESS) {
            return false;
        }
        if (parent1.getGender() == parent2.getGender()) {
            return false;
        }
        return eggGroups1.stream().anyMatch(eggGroups2::contains);
    }

    public static Pokemon getMotherOrNonDitto(Pokemon parent1, Pokemon parent2) {
        if (parent1.getGender() == Gender.FEMALE || parent2.getSpecies().getName().equalsIgnoreCase(DITTO)) {
            return parent1;
        }
        if (parent2.getGender() == Gender.FEMALE || parent1.getSpecies().getName().equalsIgnoreCase(DITTO)) {
            return parent2;
        }
        return parent1;
    }

    public static Optional<PotentialPokemonProperties> getOffspring(@Nullable Pokemon parent1, @Nullable Pokemon parent2) {
        if (parent1 == null || parent2 == null || !BreedingUtils.canBreed(parent1, parent2)) {
            return Optional.empty();
        }
        Pokemon primary = BreedingUtils.getMotherOrNonDitto(parent1, parent2);
        Pokemon secondary = primary == parent1 ? parent2 : parent1;
        return Optional.of(new PotentialPokemonProperties(primary, secondary));
    }

    public static boolean parentsHaveFertility(Pokemon parent1, Pokemon parent2) {
        return FertilityFeature.get(parent1) > 0 && FertilityFeature.get(parent2) > 0;
    }

    public static FormData getBabyForm(Pokemon parent) {
        PreEvolution temp;
        PreEvolution preevo = PreEvolution.Companion.of(parent.getSpecies(), parent.getForm());
        while ((temp = BreedingUtils.getPreEvolution(preevo)) != null) {
            preevo = temp;
        }
        if (preevo.getSpecies().showdownId().equals("nidoranf") || preevo.getSpecies().showdownId().equals("nidoranm")) {
            Species species = BreedingUtils.getRandomGenderSpeciesSplit(MiscUtilsKt.cobblemonResource((String)"nidoranm"), MiscUtilsKt.cobblemonResource((String)"nidoranf"), 0.5);
            if (species != null) {
                preevo = PreEvolution.Companion.of(species, species.getFormByShowdownId(preevo.getForm().formOnlyShowdownId()));
            }
        } else if (preevo.getSpecies().showdownId().equals("volbeat") || preevo.getSpecies().showdownId().equals("illumise")) {
            Species species = BreedingUtils.getRandomGenderSpeciesSplit(MiscUtilsKt.cobblemonResource((String)"volbeat"), MiscUtilsKt.cobblemonResource((String)"illumise"), 0.5);
            if (species != null) {
                preevo = PreEvolution.Companion.of(species, species.getFormByShowdownId(preevo.getForm().formOnlyShowdownId()));
            }
        } else if (preevo.getSpecies().showdownId().equals("indeedee")) {
            preevo = Math.random() > 0.5 ? PreEvolution.Companion.of(preevo.getSpecies(), preevo.getSpecies().getForm(Set.of("female"))) : PreEvolution.Companion.of(preevo.getSpecies(), preevo.getSpecies().getForm(Set.of("male")));
        }
        return preevo.getForm();
    }

    public static String getFormProperties(FormData form) {
        if (FORM_PROPERTY_OVERRIDES.containsKey(form.formOnlyShowdownId())) {
            return FORM_PROPERTY_OVERRIDES.get(form.formOnlyShowdownId()).toString();
        }
        return String.join((CharSequence)" ", form.getAspects());
    }

    @Nullable
    private static PreEvolution getPreEvolution(PreEvolution pokemon) {
        PreEvoFormOverride override;
        if (pokemon == null) {
            return null;
        }
        class_2960 speciesId = pokemon.getSpecies().getResourceIdentifier();
        if (PRE_EVO_OVERRIDES.containsKey(speciesId) && (override = PRE_EVO_OVERRIDES.get(speciesId)).hasForm(pokemon.getForm().formOnlyShowdownId())) {
            return override.getPreEvolution(pokemon.getForm());
        }
        PreEvolution preEvolution = pokemon.getForm().getPreEvolution();
        if (preEvolution == null) {
            return null;
        }
        return PreEvolution.Companion.of(preEvolution.getSpecies(), preEvolution.getSpecies().getFormByShowdownId(pokemon.getForm().formOnlyShowdownId()));
    }

    @Nullable
    private static Species getRandomGenderSpeciesSplit(class_2960 male, class_2960 female, double maleRatio) {
        Species maleSpecies = PokemonSpecies.getByIdentifier((class_2960)male);
        Species femaleSpecies = PokemonSpecies.getByIdentifier((class_2960)female);
        if (Math.random() < maleRatio) {
            return maleSpecies;
        }
        return femaleSpecies;
    }

    public class_2960 getFabricId() {
        return DaycarePlusMain.identifier("reload_listener");
    }

    public void method_14491(class_3300 manager) {
        PRE_EVO_OVERRIDES.clear();
        FORM_PROPERTY_OVERRIDES.clear();
        Map overrides = manager.method_14488("overrides/preevolutions", identifier -> Objects.equals(identifier.method_12836(), "daycareplus") && identifier.method_12832().endsWith(".json"));
        for (Map.Entry entry : overrides.entrySet()) {
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    String text = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    DataResult dataResult = PreEvoFormOverride.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)text));
                    PreEvoFormOverride resolved = (PreEvoFormOverride)((Pair)dataResult.getOrThrow()).getFirst();
                    PRE_EVO_OVERRIDES.put(resolved.species(), resolved);
                    DaycarePlusMain.LOGGER.info("Registered evolution override: {}", (Object)resolved);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Throwable e) {
                DaycarePlusMain.LOGGER.error("DaycarePlus encountered an error whilst parsing override file {}: ", entry.getKey(), (Object)e);
            }
        }
        Map forms = manager.method_14488("overrides/forms", identifier -> Objects.equals(identifier.method_12836(), "daycareplus") && identifier.method_12832().endsWith(".json"));
        for (Map.Entry entry : forms.entrySet()) {
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    String text = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    DataResult dataResult = FormPropertiesOverride.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)text));
                    FormPropertiesOverride resolved = (FormPropertiesOverride)((Pair)dataResult.getOrThrow()).getFirst();
                    String formId = ((class_2960)entry.getKey()).method_12832().replace("overrides/forms", "").replace("/", "").replace(".json", "");
                    FORM_PROPERTY_OVERRIDES.put(formId, resolved);
                    DaycarePlusMain.LOGGER.info("Registered form property override: {} -> {}", (Object)formId, (Object)resolved);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Throwable e) {
                DaycarePlusMain.LOGGER.error("DaycarePlus encountered an error whilst parsing form property file file {}: ", entry.getKey(), (Object)e);
            }
        }
    }
}

