/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.breeding;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.evolution.PreEvolution;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PreEvoFormOverride(class_2960 species, Map<String, SimpleForm> evoMap) {
    public static final Codec<PreEvoFormOverride> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("species").forGetter(PreEvoFormOverride::species), (App)Codec.unboundedMap((Codec)class_5699.field_41759, SimpleForm.CODEC).fieldOf("form_pre_evolutions").forGetter(PreEvoFormOverride::evoMap)).apply((Applicative)instance, PreEvoFormOverride::new));

    public static PreEvoFormOverride simple(class_2960 speciesId, class_2960 preEvoId, Map<String, String> formMap) {
        return new PreEvoFormOverride(speciesId, formMap.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), new SimpleForm(preEvoId, (String)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @Nullable
    public PreEvolution getPreEvolution(String currentFormId) {
        Species species = PokemonSpecies.getByIdentifier((class_2960)this.species);
        if (species == null) {
            return null;
        }
        if (!this.evoMap.containsKey(currentFormId)) {
            return species.getPreEvolution();
        }
        Species childSpecies = this.evoMap.get(currentFormId).getSpecies();
        FormData form = this.evoMap.get(currentFormId).getForm();
        if (childSpecies == null || form == null) {
            return species.getPreEvolution();
        }
        return PreEvolution.Companion.of(childSpecies, form);
    }

    @Nullable
    public PreEvolution getPreEvolution(FormData form) {
        return this.getPreEvolution(form.formOnlyShowdownId());
    }

    public boolean hasForm(String formId) {
        return this.evoMap.containsKey(formId);
    }

    @Override
    @NotNull
    public String toString() {
        String evoMapString = String.join((CharSequence)", ", this.evoMap.entrySet().stream().map(entry -> (String)entry.getKey() + " -> (" + String.valueOf(entry.getValue()) + ")").toList());
        return String.valueOf(this.species) + "[" + evoMapString + "]";
    }

    public record SimpleForm(class_2960 species, String formId) {
        private static final Codec<SimpleForm> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("species").forGetter(SimpleForm::species), (App)class_5699.field_41759.fieldOf("form_id").forGetter(SimpleForm::formId)).apply((Applicative)instance, SimpleForm::new));

        public Species getSpecies() {
            return PokemonSpecies.getByIdentifier((class_2960)this.species);
        }

        public FormData getForm() {
            Species pokemon = this.getSpecies();
            if (pokemon != null) {
                return pokemon.getFormByShowdownId(this.formId);
            }
            return null;
        }

        @Override
        @NotNull
        public String toString() {
            return String.valueOf(this.species) + " " + this.formId;
        }
    }
}

