/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.provismet.cobblemon.daycareplus.config.IncubatorTiers;
import com.provismet.cobblemon.daycareplus.storage.EggStorage;
import com.provismet.cobblemon.daycareplus.storage.IncubatorCollection;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class IncubatorCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess, registrationEnvironment) -> commandDispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"daycareplus").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"incubator").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"data").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(IncubatorCommand::getIncubators)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"modify").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            IncubatorCollection collection = IncubatorCollection.getOrCreate((class_1657)player);
            for (Map.Entry<String, EggStorage> entry : collection) {
                builder.suggest(entry.getKey());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"tier", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (String tier : IncubatorTiers.getTiers()) {
                builder.suggest(tier);
            }
            return builder.buildFuture();
        }).executes(IncubatorCommand::modifyIncubator))))))));
    }

    private static int modifyIncubator(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        String type = StringArgumentType.getString(context, (String)"type");
        String tier = StringArgumentType.getString(context, (String)"tier");
        IncubatorCollection collection = IncubatorCollection.getOrCreate((class_1657)player);
        Optional<EggStorage> storage = collection.get(type);
        Optional<IncubatorTiers.IncubatorSettings> newSettings = IncubatorTiers.get(tier);
        if (newSettings.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)("Invalid tier provided: " + tier)), false);
            return 0;
        }
        if (storage.isPresent()) {
            storage.get().setTier(tier);
            storage.get().setCapacity(newSettings.get().capacity());
            storage.get().setEggsToTick(newSettings.get().eggsToTick());
        } else {
            collection.put(type, EggStorage.fromSettings(tier));
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Modified incubator for ").method_10852(player.method_5477()), true);
        return 1;
    }

    private static int getIncubators(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        IncubatorCollection collection = IncubatorCollection.getCollection(player.method_5845());
        if (collection == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"No incubators found for ").method_10852(player.method_5477()), false);
            return 0;
        }
        class_5250 text = class_2561.method_43470((String)"Found incubators for ").method_10852(player.method_5477()).method_27693(": ");
        for (Map.Entry<String, EggStorage> entry : collection) {
            text = text.method_27693("{" + entry.getKey() + ", eggs: " + entry.getValue().size() + ", capacity: " + entry.getValue().getCapacity() + ", ticking eggs: " + entry.getValue().getEggsToTick() + "} ");
        }
        ((class_2168)context.getSource()).method_9226(() -> ((class_5250)text).method_27661(), false);
        return 1;
    }
}

