/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.provismet.cobblemon.daycareplus.DaycarePlusMain;
import com.provismet.lilylib.util.json.JsonBuilder;
import com.provismet.lilylib.util.json.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class DaycarePlusOptions {
    private static final Path FILE = DaycarePlusOptions.getConfigFolder().resolve("server-config.json");
    private static long ticksPerEggAttempt = 12000L;
    private static double successRatePerEggAttempt = 0.75;
    private static int pastureInventorySize = 128;
    private static int maxPasturesPerPlayer = 3;
    private static boolean showShinyChance = true;
    private static boolean allowHoppers = true;
    private static boolean applyMarks = false;
    private static boolean competitiveBreeding = false;
    private static boolean allowBreedingWithoutFertility = false;
    private static boolean consumeHeldItems = true;
    private static boolean eggsInheritFertility = true;
    private static int maxFertility = 8;
    private static int pointsPerEggCycle = 200;
    private static boolean showEggTooltip = true;
    private static float shinyChanceMultiplier = 1.0f;
    private static float masudaMultiplier = 2.0f;
    private static float crystalMultiplier = 1.0f;
    private static boolean useShinyEvent = true;
    private static double shinyBoosterRate = 0.05;
    private static boolean inheritEggMovesFromBothParents = true;
    private static boolean sizeVariation = true;

    public static Path getConfigFolder() {
        Path directory = FabricLoader.getInstance().getConfigDir().resolve("daycareplus");
        if (!Files.exists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating Daycare+ config directory: ", e);
            }
        }
        return directory;
    }

    public static long getTicksPerEggAttempt() {
        return ticksPerEggAttempt;
    }

    public static double getSuccessRatePerEggAttempt() {
        return successRatePerEggAttempt;
    }

    public static int getPastureInventorySize() {
        return pastureInventorySize;
    }

    public static int getMaxPasturesPerPlayer() {
        return maxPasturesPerPlayer;
    }

    public static boolean shouldShowShinyChance() {
        return showShinyChance;
    }

    public static boolean shouldAllowHoppers() {
        return allowHoppers;
    }

    public static boolean shouldApplyMarks() {
        return applyMarks;
    }

    public static boolean doCompetitiveBreeding() {
        return competitiveBreeding;
    }

    public static boolean shouldAllowBreedingWithoutFertility() {
        return allowBreedingWithoutFertility;
    }

    public static boolean shouldConsumeHeldItems() {
        return consumeHeldItems;
    }

    public static boolean shouldEggsInheritFertility() {
        return eggsInheritFertility;
    }

    public static int getMaxFertility() {
        return maxFertility;
    }

    public static int getEggPoints(int eggCycles) {
        return pointsPerEggCycle * eggCycles;
    }

    public static boolean shouldShowEggTooltip() {
        return showEggTooltip;
    }

    public static boolean shouldUseShinyChanceEvent() {
        return useShinyEvent;
    }

    public static double getShinyBoosterRate() {
        return shinyBoosterRate;
    }

    public static float getShinyChanceMultiplier() {
        return shinyChanceMultiplier;
    }

    public static float getMasudaMultiplier() {
        return masudaMultiplier;
    }

    public static float getCrystalMultiplier() {
        return crystalMultiplier;
    }

    public static boolean doGen6EggMoves() {
        return inheritEggMovesFromBothParents;
    }

    public static boolean doSizeVariationCompatibility() {
        return sizeVariation;
    }

    public static void save() {
        JsonBuilder builder = new JsonBuilder().append("egg_production", new JsonBuilder().append("ticks_per_egg_attempt", (Number)ticksPerEggAttempt).append("success_rate_per_egg_attempt", (Number)successRatePerEggAttempt).append("pasture_inventory_size", (Number)pastureInventorySize).append("max_pastures_per_player", (Number)maxPasturesPerPlayer).append("show_shiny_chance", showShinyChance).append("allow_hoppers", allowHoppers).append("apply_marks", applyMarks)).append("competitive_mode", new JsonBuilder().append("use_competitive_mode", competitiveBreeding).append("allow_breeding_without_fertility", allowBreedingWithoutFertility).append("consume_held_items", consumeHeldItems).append("eggs_inherit_fertility", eggsInheritFertility).append("max_fertility", (Number)maxFertility)).append("shiny_chance", new JsonBuilder().append("use_event_trigger", useShinyEvent).append("standard_multiplier", (Number)Float.valueOf(shinyChanceMultiplier)).append("masuda_multiplier", (Number)Float.valueOf(masudaMultiplier)).append("crystal_multiplier", (Number)Float.valueOf(crystalMultiplier)).append("shiny_booster_rate", (Number)shinyBoosterRate)).append("breeding_rules", new JsonBuilder().append("inherit_moves_from_both_parents", inheritEggMovesFromBothParents).append("ticks_per_egg_cycle", (Number)pointsPerEggCycle).append("show_egg_tooltip", showEggTooltip)).append("compatibility_features", new JsonBuilder().append("size_variation", sizeVariation));
        try (FileWriter writer = new FileWriter(FILE.toFile());){
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)builder.getJson()));
        }
        catch (IOException e) {
            DaycarePlusMain.LOGGER.error("Error whilst saving Daycare+ server-config.json: ", (Throwable)e);
        }
    }

    public static void load() {
        if (!FILE.toFile().exists()) {
            DaycarePlusOptions.save();
            return;
        }
        try {
            JsonReader reader = JsonReader.file((File)FILE.toFile());
            if (reader != null) {
                reader.getObjectAsReader("egg_production").ifPresent(eggProduction -> {
                    eggProduction.getInteger("ticks_per_egg_attempt").ifPresent(val -> {
                        ticksPerEggAttempt = val.intValue();
                    });
                    eggProduction.getDouble("success_rate_per_egg_attempt").ifPresent(val -> {
                        successRatePerEggAttempt = val;
                    });
                    eggProduction.getInteger("pasture_inventory_size").ifPresent(val -> {
                        pastureInventorySize = val;
                    });
                    eggProduction.getInteger("max_pastures_per_player").ifPresent(val -> {
                        maxPasturesPerPlayer = val;
                    });
                    eggProduction.getBoolean("show_shiny_chance").ifPresent(val -> {
                        showShinyChance = val;
                    });
                    eggProduction.getBoolean("allow_hoppers").ifPresent(val -> {
                        allowHoppers = val;
                    });
                    eggProduction.getBoolean("apply_marks").ifPresent(val -> {
                        applyMarks = val;
                    });
                });
                reader.getObjectAsReader("competitive_mode").ifPresent(competitiveMode -> {
                    competitiveMode.getBoolean("use_competitive_mode").ifPresent(val -> {
                        competitiveBreeding = val;
                    });
                    competitiveMode.getBoolean("allow_breeding_without_fertility").ifPresent(val -> {
                        allowBreedingWithoutFertility = val;
                    });
                    competitiveMode.getBoolean("consume_held_items").ifPresent(val -> {
                        consumeHeldItems = val;
                    });
                    competitiveMode.getBoolean("eggs_inherit_fertility").ifPresent(val -> {
                        eggsInheritFertility = val;
                    });
                    competitiveMode.getInteger("max_fertility").ifPresent(val -> {
                        maxFertility = val;
                    });
                });
                reader.getObjectAsReader("shiny_chance").ifPresent(shinyChance -> {
                    shinyChance.getBoolean("use_event_trigger").ifPresent(val -> {
                        useShinyEvent = val;
                    });
                    shinyChance.getFloat("standard_multiplier").ifPresent(val -> {
                        shinyChanceMultiplier = val.floatValue();
                    });
                    shinyChance.getFloat("masuda_multiplier").ifPresent(val -> {
                        masudaMultiplier = val.floatValue();
                    });
                    shinyChance.getFloat("crystal_multiplier").ifPresent(val -> {
                        crystalMultiplier = val.floatValue();
                    });
                    shinyChance.getDouble("shiny_booster_rate").ifPresent(val -> {
                        shinyBoosterRate = val;
                    });
                });
                reader.getObjectAsReader("breeding_rules").ifPresent(breedingRules -> {
                    breedingRules.getBoolean("inherit_moves_from_both_parents").ifPresent(val -> {
                        inheritEggMovesFromBothParents = val;
                    });
                    breedingRules.getInteger("ticks_per_egg_cycle").ifPresent(val -> {
                        pointsPerEggCycle = val;
                    });
                    breedingRules.getBoolean("show_egg_tooltip").ifPresent(val -> {
                        showEggTooltip = val;
                    });
                });
                reader.getObjectAsReader("compatibility_features").ifPresent(compatibility -> compatibility.getBoolean("size_variation").ifPresent(val -> {
                    sizeVariation = val;
                }));
            }
        }
        catch (FileNotFoundException e) {
            DaycarePlusMain.LOGGER.info("No Daycare+ server config found, creating default.");
        }
        catch (Exception e) {
            DaycarePlusMain.LOGGER.error("Error reading Daycare+ server-config.json: ", (Throwable)e);
        }
        DaycarePlusOptions.save();
    }

    static {
        DaycarePlusOptions.load();
    }
}

