/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.gui;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.common.collect.ImmutableList;
import com.provismet.cobblemon.daycareplus.breeding.BreedingUtils;
import com.provismet.cobblemon.daycareplus.breeding.PotentialPokemonProperties;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.feature.BreedableProperty;
import com.provismet.cobblemon.daycareplus.feature.FertilityFeature;
import com.provismet.cobblemon.daycareplus.imixin.IMixinPastureBlockEntity;
import com.provismet.cobblemon.daycareplus.registries.DPIconItems;
import com.provismet.cobblemon.daycareplus.registries.DPItems;
import com.provismet.cobblemon.daycareplus.util.Styles;
import com.provismet.cobblemon.daycareplus.util.tag.DPItemTags;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

public interface DaycareGUI {
    public static SimpleGui create(PokemonPastureBlockEntity pastureBlockEntity, IMixinPastureBlockEntity mixinPasture, class_3222 player, class_2680 state, class_3965 hit) {
        GuiElement offspringInfo;
        Optional<PotentialPokemonProperties> offspring;
        GuiElement parent2Info;
        GuiElement parent1Info;
        GuiElement filler = GuiElementBuilder.from((class_1799)class_1802.field_8871.method_7854()).hideDefaultTooltip().hideTooltip().build();
        GuiElement fillerHeldItem = GuiElementBuilder.from((class_1799)class_1802.field_8736.method_7854()).hideDefaultTooltip().setName((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.no_item").method_27694(Styles.WHITE_NO_ITALICS)).build();
        GuiElement infoButton = GuiElementBuilder.from((class_1799)DPIconItems.INFO.method_7854()).setName((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.info").method_27694(Styles.WHITE_NO_ITALICS)).addLoreLine((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.info.tooltip.1").method_27694(Styles.GRAY_NO_ITALICS)).addLoreLine((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.info.tooltip.2").method_27694(Styles.GRAY_NO_ITALICS)).build();
        GuiElement openPasture = GuiElementBuilder.from((class_1799)CobblemonItems.PASTURE.method_7854()).setName((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.open_pasture").method_27694(Styles.WHITE_NO_ITALICS)).setCallback((index, type, action, gui) -> {
            gui.getPlayer().method_7346();
            mixinPasture.setShouldSkipDaycareGUI(true);
            state.method_55781(gui.getPlayer().method_37908(), (class_1657)gui.getPlayer(), hit);
        }).build();
        GuiElement eggCounter = mixinPasture.getEggCounterButton();
        GuiElement twinBoostCounter = mixinPasture.getTwinBoostCounterButton();
        GuiElement shinyBoostCounter = mixinPasture.getShinyBoostCounterButton();
        Pokemon parent1 = null;
        Pokemon parent2 = null;
        if (!pastureBlockEntity.getTetheredPokemon().isEmpty()) {
            parent1 = ((PokemonPastureBlockEntity.Tethering)pastureBlockEntity.getTetheredPokemon().getFirst()).getPokemon();
        }
        if (pastureBlockEntity.getTetheredPokemon().size() == 2) {
            parent2 = ((PokemonPastureBlockEntity.Tethering)pastureBlockEntity.getTetheredPokemon().getLast()).getPokemon();
        }
        GuiElement missingParent = GuiElementBuilder.from((class_1799)class_1802.field_8077.method_7854()).setName((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.no_parent").method_27694(Styles.WHITE_NO_ITALICS)).addLoreLine((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.no_parent.tooltip").method_27694(Styles.GRAY_NO_ITALICS)).build();
        GuiElement parent1Item = fillerHeldItem;
        if (parent1 != null) {
            parent1Info = DaycareGUI.createButtonForPokemon(parent1);
            if (DaycarePlusOptions.doCompetitiveBreeding() ? parent1.heldItem().method_31573(DPItemTags.COMPETITIVE_BREEDING) : parent1.heldItem().method_31573(DPItemTags.NONCOMPETITIVE_BREEDING)) {
                parent1Item = GuiElementBuilder.from((class_1799)parent1.heldItem()).hideDefaultTooltip().addLoreLine((class_2561)class_2561.method_43471((String)(parent1.heldItem().method_7922() + ".breeding")).method_27694(Styles.GRAY_NO_ITALICS)).build();
            }
        } else {
            parent1Info = missingParent;
        }
        GuiElement parent2Item = fillerHeldItem;
        if (parent2 != null) {
            parent2Info = DaycareGUI.createButtonForPokemon(parent2);
            if (DaycarePlusOptions.doCompetitiveBreeding() ? parent2.heldItem().method_31573(DPItemTags.COMPETITIVE_BREEDING) : parent2.heldItem().method_31573(DPItemTags.NONCOMPETITIVE_BREEDING)) {
                parent2Item = GuiElementBuilder.from((class_1799)parent2.heldItem()).hideDefaultTooltip().addLoreLine((class_2561)class_2561.method_43471((String)(parent2.heldItem().method_7922() + ".breeding")).method_27694(Styles.GRAY_NO_ITALICS)).build();
            }
        } else {
            parent2Info = missingParent;
        }
        if ((offspring = BreedingUtils.getOffspring(parent1, parent2)).isPresent()) {
            Map<Stat, PotentialPokemonProperties.PotentialIV> ivs = offspring.get().getPossibleIVs();
            PokemonProperties props = offspring.get().createPokemonProperties();
            props.setShiny(Boolean.valueOf(false));
            Pokemon tile = props.create();
            ImmutableList.Builder eggData = ImmutableList.builder();
            eggData.add((Object[])new class_2561[]{class_2561.method_43471((String)"property.daycareplus.species").method_27694(Styles.formattedNoItalics(class_124.field_1054)).method_10852((class_2561)tile.getSpecies().getTranslatedName().method_27694(Styles.WHITE_NO_ITALICS)), class_2561.method_43471((String)"property.daycareplus.form").method_27694(Styles.formattedNoItalics(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)tile.getForm().getName()).method_27694(Styles.WHITE_NO_ITALICS)), class_2561.method_43471((String)"property.daycareplus.ability").method_27694(Styles.formattedNoItalics(class_124.field_1054)).method_10852(DaycareGUI.listOfTranslatable((class_2561)class_2561.method_43470((String)", ").method_27694(Styles.WHITE_NO_ITALICS), Styles.WHITE_NO_ITALICS, (String[])offspring.get().getPossibleAbilities().stream().map(AbilityTemplate::getDisplayName).toArray(String[]::new))), class_2561.method_43471((String)"property.daycareplus.nature").method_27694(Styles.formattedNoItalics(class_124.field_1054)).method_10852((class_2561)(offspring.get().getPossibleNatures().isEmpty() ? class_2561.method_43470((String)"?").method_27694(Styles.WHITE_NO_ITALICS) : DaycareGUI.listOfTranslatable((class_2561)class_2561.method_43470((String)",").method_27694(Styles.WHITE_NO_ITALICS), Styles.WHITE_NO_ITALICS, (String[])offspring.get().getPossibleNatures().stream().map(Nature::getDisplayName).toArray(String[]::new))))});
            if (props.getMoves() != null && !props.getMoves().isEmpty()) {
                eggData.add((Object)class_2561.method_43471((String)"property.daycareplus.moves").method_27694(Styles.formattedNoItalics(class_124.field_1054)).method_10852(DaycareGUI.listOfTranslatable((class_2561)class_2561.method_43470((String)", ").method_27694(Styles.WHITE_NO_ITALICS), Styles.WHITE_NO_ITALICS, (String[])props.getMoves().stream().map(move -> "cobblemon.move." + move).toArray(String[]::new))));
            }
            eggData.add((Object[])new class_2561[]{class_2561.method_43473(), class_2561.method_43471((String)"property.daycareplus.ivs").method_27694(Styles.WHITE_NO_ITALICS), class_2561.method_43471((String)"property.daycareplus.hp").method_27694(Styles.colouredNoItalics(10135765)).method_10852((class_2561)class_2561.method_43470((String)ivs.get(Stats.HP).toString()).method_27694(Styles.WHITE_NO_ITALICS)), class_2561.method_43471((String)"property.daycareplus.attack").method_27694(Styles.colouredNoItalics(15508298)).method_10852((class_2561)class_2561.method_43470((String)ivs.get(Stats.ATTACK).toString()).method_27694(Styles.WHITE_NO_ITALICS)), class_2561.method_43471((String)"property.daycareplus.defence").method_27694(Styles.colouredNoItalics(5289295)).method_10852((class_2561)class_2561.method_43470((String)ivs.get(Stats.DEFENCE).toString()).method_27694(Styles.WHITE_NO_ITALICS)), class_2561.method_43471((String)"property.daycareplus.special_attack").method_27694(Styles.colouredNoItalics(16140040)).method_10852((class_2561)class_2561.method_43470((String)ivs.get(Stats.SPECIAL_ATTACK).toString()).method_27694(Styles.WHITE_NO_ITALICS)), class_2561.method_43471((String)"property.daycareplus.special_defence").method_27694(Styles.colouredNoItalics(9356062)).method_10852((class_2561)class_2561.method_43470((String)ivs.get(Stats.SPECIAL_DEFENCE).toString()).method_27694(Styles.WHITE_NO_ITALICS)), class_2561.method_43471((String)"property.daycareplus.speed").method_27694(Styles.colouredNoItalics(45292)).method_10852((class_2561)class_2561.method_43470((String)ivs.get(Stats.SPEED).toString()).method_27694(Styles.WHITE_NO_ITALICS))});
            if (DaycarePlusOptions.doCompetitiveBreeding()) {
                int newFertility = DaycarePlusOptions.shouldEggsInheritFertility() ? class_3532.method_15340((int)(Math.min(FertilityFeature.get(parent1), FertilityFeature.get(parent2)) - 1), (int)0, (int)FertilityFeature.getMax()) : FertilityFeature.getMax();
                eggData.add((Object[])new class_2561[]{class_2561.method_43473(), class_2561.method_43471((String)"property.daycareplus.fertility").method_27694(Styles.formattedNoItalics(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(newFertility)).method_27694(Styles.WHITE_NO_ITALICS))});
            }
            if (DaycarePlusOptions.shouldShowShinyChance()) {
                eggData.add((Object[])new class_2561[]{class_2561.method_43473(), class_2561.method_43471((String)"property.daycareplus.shiny").method_27694(Styles.formattedNoItalics(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)("1/" + Math.max(1, (int)(1.0 / offspring.get().getShinyRate())))).method_27694(Styles.WHITE_NO_ITALICS))});
            }
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                eggData.add((Object[])new class_2561[]{class_2561.method_43473(), class_2561.method_43470((String)("(Debug) Aspects: " + String.join((CharSequence)", ", tile.getAspects())))});
            }
            offspringInfo = GuiElementBuilder.from((class_1799)PokemonItem.from((PokemonProperties)props)).setName((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.offspring").method_27694(Styles.WHITE_NO_ITALICS)).setLore((List)eggData.build()).build();
        } else {
            offspringInfo = GuiElementBuilder.from((class_1799)class_1802.field_8077.method_7854()).setName((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.offspring.empty").method_27694(style -> style.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1068))).addLoreLine((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.offspring.empty.tooltip").method_27694(style -> style.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080))).build();
        }
        SimpleGui gui2 = new SimpleGui(class_3917.field_18667, player, false){

            public void onOpen() {
                this.player.method_17356(CobblemonSounds.PC_ON, class_3419.field_15245, 1.0f, 1.0f);
            }

            public void onClose() {
                this.player.method_17356(CobblemonSounds.PC_OFF, class_3419.field_15245, 1.0f, 1.0f);
            }
        };
        gui2.setTitle((class_2561)class_2561.method_43471((String)"gui.title.daycareplus.daycare"));
        for (int i = 0; i < gui2.getVirtualSize(); ++i) {
            gui2.setSlot(i, (GuiElementInterface)filler);
        }
        if (mixinPasture.getExtension() != null) {
            if (mixinPasture.getExtension().getTwinBoosts() > 0) {
                gui2.setSlot(0, (GuiElementInterface)twinBoostCounter);
                if (mixinPasture.getExtension().getShinyBoosts() > 0) {
                    gui2.setSlot(1, (GuiElementInterface)shinyBoostCounter);
                }
            } else if (mixinPasture.getExtension().getShinyBoosts() > 0) {
                gui2.setSlot(0, (GuiElementInterface)shinyBoostCounter);
            }
        }
        gui2.setSlot(6, (GuiElementInterface)eggCounter);
        gui2.setSlot(7, (GuiElementInterface)openPasture);
        gui2.setSlot(8, (GuiElementInterface)infoButton);
        gui2.setSlot(20, (GuiElementInterface)parent1Info);
        gui2.setSlot(22, (GuiElementInterface)offspringInfo);
        gui2.setSlot(24, (GuiElementInterface)parent2Info);
        gui2.setSlot(29, (GuiElementInterface)parent1Item);
        gui2.setSlot(33, (GuiElementInterface)parent2Item);
        return gui2;
    }

    public static GuiElement createEggButton(IMixinPastureBlockEntity mixinPasture) {
        return GuiElementBuilder.from((class_1799)DPItems.POKEMON_EGG.method_7854()).hideDefaultTooltip().setName((class_2561)class_2561.method_43469((String)"gui.button.daycareplus.eggs_held", (Object[])new Object[]{mixinPasture.count(), mixinPasture.method_5439()}).method_27694(Styles.WHITE_NO_ITALICS)).build();
    }

    public static GuiElement createTwinBoostButton(IMixinPastureBlockEntity mixinPasture) {
        return GuiElementBuilder.from((class_1799)DPItems.DAYCARE_BOOSTER.method_7854()).hideDefaultTooltip().setName((class_2561)class_2561.method_43469((String)"gui.button.daycareplus.twin_boosts_remaining", (Object[])new Object[]{mixinPasture.getExtension() != null ? mixinPasture.getExtension().getTwinBoosts() : 0}).method_27694(Styles.WHITE_NO_ITALICS)).setLore(List.of(class_2561.method_43471((String)"gui.button.daycareplus.twin_boosts_info").method_27694(Styles.GRAY_NO_ITALICS))).build();
    }

    public static GuiElement createShinyBoostButton(IMixinPastureBlockEntity mixinPasture) {
        return GuiElementBuilder.from((class_1799)DPItems.SHINY_BOOSTER.method_7854()).hideDefaultTooltip().setName((class_2561)class_2561.method_43469((String)"gui.button.daycareplus.shiny_boosts_remaining", (Object[])new Object[]{mixinPasture.getExtension() != null ? mixinPasture.getExtension().getTwinBoosts() : 0}).method_27694(Styles.WHITE_NO_ITALICS)).setLore(List.of(class_2561.method_43469((String)"gui.button.daycareplus.shiny_boost_rate", (Object[])new Object[]{DaycarePlusOptions.getShinyBoosterRate() * 100.0}).method_27694(Styles.GRAY_NO_ITALICS))).build();
    }

    public static GuiElement createButtonForPokemon(Pokemon pokemon) {
        GuiElementBuilder builder = GuiElementBuilder.from((class_1799)PokemonItem.from((Pokemon)pokemon)).hideDefaultTooltip().setName((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.parent").method_27694(Styles.WHITE_NO_ITALICS)).addLoreLine(DaycareGUI.formatProperty("property.daycareplus.species", Styles.formattedNoItalics(class_124.field_1054), pokemon.getSpecies().getTranslatedName())).addLoreLine(DaycareGUI.formatProperty("property.daycareplus.form", Styles.formattedNoItalics(class_124.field_1054), pokemon.getForm().getName())).addLoreLine(DaycareGUI.formatProperty("property.daycareplus.ability", Styles.formattedNoItalics(class_124.field_1054), class_2561.method_43471((String)pokemon.getAbility().getDisplayName()))).addLoreLine(DaycareGUI.formatProperty("property.daycareplus.nature", Styles.formattedNoItalics(class_124.field_1054), class_2561.method_43471((String)pokemon.getNature().getDisplayName()))).addLoreLine((class_2561)class_2561.method_43473()).addLoreLine((class_2561)class_2561.method_43471((String)"property.daycareplus.ivs").method_27694(Styles.WHITE_NO_ITALICS)).addLoreLine(DaycareGUI.formatProperty("property.daycareplus.hp", Styles.colouredNoItalics(10135765), String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.HP)))).addLoreLine(DaycareGUI.formatProperty("property.daycareplus.attack", Styles.colouredNoItalics(15508298), String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.ATTACK)))).addLoreLine(DaycareGUI.formatProperty("property.daycareplus.defence", Styles.colouredNoItalics(5289295), String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.DEFENCE)))).addLoreLine(DaycareGUI.formatProperty("property.daycareplus.special_attack", Styles.colouredNoItalics(16140040), String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_ATTACK)))).addLoreLine(DaycareGUI.formatProperty("property.daycareplus.special_defence", Styles.colouredNoItalics(9356062), String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_DEFENCE)))).addLoreLine(DaycareGUI.formatProperty("property.daycareplus.speed", Styles.colouredNoItalics(45292), String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPEED))));
        if (!BreedableProperty.get(pokemon)) {
            builder.addLoreLine((class_2561)class_2561.method_43473()).addLoreLine((class_2561)class_2561.method_43471((String)"property.daycareplus.unbreedable").method_27694(Styles.formattedNoItalics(class_124.field_1079)));
        } else if (DaycarePlusOptions.doCompetitiveBreeding()) {
            builder.addLoreLine((class_2561)class_2561.method_43473()).addLoreLine(DaycareGUI.formatProperty("property.daycareplus.fertility", Styles.formattedNoItalics(class_124.field_1077), String.valueOf(FertilityFeature.get(pokemon))));
        }
        return builder.build();
    }

    private static class_2561 formatProperty(String translationKey, UnaryOperator<class_2583> style, String value) {
        return DaycareGUI.formatProperty(translationKey, style, class_2561.method_43470((String)value));
    }

    private static class_2561 formatProperty(String translationKey, UnaryOperator<class_2583> style, class_5250 value) {
        return class_2561.method_43471((String)translationKey).method_27694(style).method_10852((class_2561)value.method_27694(Styles.WHITE_NO_ITALICS));
    }

    private static class_2561 listOfTranslatable(class_2561 separator, UnaryOperator<class_2583> style, String ... translatables) {
        class_5250 text = class_2561.method_43473();
        for (int i = 0; i < translatables.length; ++i) {
            text = text.method_10852((class_2561)class_2561.method_43471((String)translatables[i]).method_27694(style));
            if (i >= translatables.length - 1) continue;
            text = text.method_10852(separator);
        }
        return text;
    }
}

