/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.gui;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.pokemon.egg.EggGroup;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.daycareplus.DaycarePlusMain;
import com.provismet.cobblemon.daycareplus.config.ClientOptions;
import com.provismet.cobblemon.daycareplus.feature.BreedableProperty;
import com.provismet.cobblemon.daycareplus.util.ClientEggGroup;
import java.util.Locale;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EggGroupWidget
extends class_339 {
    public static final int WIDTH = 55;
    public static final int HEIGHT = 30;
    public static final class_2960 TEXTURE = DaycarePlusMain.identifier("textures/gui/pc/egg_group_panel.png");
    public static final class_2960 TEXTURE_HOVERED = DaycarePlusMain.identifier("textures/gui/pc/egg_group_panel_hovered.png");
    public static final class_2960 TEXTURE_COLLAPSED = DaycarePlusMain.identifier("textures/gui/pc/egg_group_panel_collapsed.png");
    public static final class_2960 TEXTURE_COLLAPSED_HOVERED = DaycarePlusMain.identifier("textures/gui/pc/egg_group_panel_collapsed_hovered.png");
    private static boolean collapsed = false;
    private Set<EggGroup> eggGroups = Set.of();
    private boolean breedable = true;

    public EggGroupWidget(int x, int y) {
        super(x, y, 55, 30, (class_2561)class_2561.method_43471((String)"daycareplus.ui.egg_group"));
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.eggGroups.isEmpty() && this.breedable || !ClientOptions.shouldShowEggGroupsInPC()) {
            return;
        }
        class_2960 texture = this.method_49606() ? (collapsed ? TEXTURE_COLLAPSED_HOVERED : TEXTURE_HOVERED) : (collapsed ? TEXTURE_COLLAPSED : TEXTURE);
        GuiUtilsKt.blitk((class_4587)context.method_51448(), (class_2960)texture, (Number)this.method_46426(), (Number)this.method_46427(), (Number)30, (Number)55);
        if (collapsed) {
            return;
        }
        RenderHelperKt.drawScaledText((class_332)context, (class_2960)CobblemonResources.INSTANCE.getDEFAULT_LARGE(), (class_5250)class_2561.method_43471((String)"daycareplus.ui.egg_group").method_27694(style -> style.method_10982(Boolean.valueOf(true))), (Number)(this.method_46426() + 32), (Number)(this.method_46427() + 2), (float)0.8f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)true, (boolean)true, (Integer)mouseX, (Integer)mouseY);
        if (!this.breedable) {
            RenderHelperKt.drawScaledText((class_332)context, (class_2960)CobblemonResources.INSTANCE.getDEFAULT_LARGE(), (class_5250)class_2561.method_43471((String)"property.daycareplus.unbreedable"), (Number)(this.method_46426() + 32), (Number)(this.method_46427() + 15), (float)0.8f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)true, (boolean)true, (Integer)mouseX, (Integer)mouseY);
        } else if (this.eggGroups.size() == 1) {
            String eggGroup = this.eggGroups.stream().reduce(EggGroup.UNDISCOVERED, (group1, group2) -> group2).name().toLowerCase(Locale.ROOT);
            RenderHelperKt.drawScaledText((class_332)context, (class_2960)CobblemonResources.INSTANCE.getDEFAULT_LARGE(), (class_5250)class_2561.method_43471((String)("daycareplus.group." + eggGroup)), (Number)(this.method_46426() + 32), (Number)(this.method_46427() + 15), (float)0.8f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)true, (boolean)true, (Integer)mouseX, (Integer)mouseY);
        } else {
            int offset = 11;
            for (EggGroup group : this.eggGroups) {
                RenderHelperKt.drawScaledText((class_332)context, (class_2960)CobblemonResources.INSTANCE.getDEFAULT_LARGE(), (class_5250)class_2561.method_43471((String)("daycareplus.group." + group.name().toLowerCase(Locale.ROOT))), (Number)(this.method_46426() + 32), (Number)(this.method_46427() + offset), (float)0.8f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)true, (boolean)true, (Integer)mouseX, (Integer)mouseY);
                offset += 8;
            }
        }
    }

    protected void method_47399(class_6382 builder) {
    }

    public void method_25348(double mouseX, double mouseY) {
        collapsed = !collapsed;
    }

    public void setPokemon(@Nullable Pokemon pokemon) {
        if (pokemon == null) {
            this.eggGroups = Set.of();
            this.breedable = true;
        } else {
            this.eggGroups = ClientEggGroup.getGroups(pokemon);
            this.breedable = BreedableProperty.get(pokemon);
        }
    }

    public void method_25354(class_1144 soundManager) {
        soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)CobblemonSounds.PC_CLICK, (float)1.0f));
    }

    public boolean method_37303() {
        return false;
    }

    public boolean method_49606() {
        return super.method_49606() && ClientOptions.shouldShowEggGroupsInPC();
    }
}

