/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.handler;

import com.provismet.cobblemon.daycareplus.breeding.BreedingLink;
import com.provismet.cobblemon.daycareplus.storage.IncubatorCollection;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public interface FabricEventHandler {
    public static void register() {
        ServerPlayConnectionEvents.JOIN.register(FabricEventHandler::onPlayerJoin);
        ServerPlayConnectionEvents.DISCONNECT.register(FabricEventHandler::onPlayerDisconnect);
        ServerLifecycleEvents.BEFORE_SAVE.register(FabricEventHandler::beforeSave);
        ServerLifecycleEvents.SERVER_STOPPED.register(FabricEventHandler::onServerClose);
    }

    private static void onPlayerJoin(class_3244 handler, PacketSender packetSender, MinecraftServer server) {
        CompletableFuture.runAsync(() -> IncubatorCollection.loadFromJson((class_1657)handler.method_32311()));
    }

    private static void onPlayerDisconnect(class_3244 handler, MinecraftServer server) {
        String playerUUID = handler.method_32311().method_5845();
        CompletableFuture.runAsync(() -> IncubatorCollection.remove(server, playerUUID));
    }

    private static void beforeSave(MinecraftServer server, boolean flush, boolean force) {
        CompletableFuture.runAsync(() -> IncubatorCollection.saveAll(server));
    }

    private static void onServerClose(MinecraftServer server) {
        BreedingLink.clear();
    }
}

