/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.item;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.provismet.cobblemon.daycareplus.api.PokemonEgg;
import com.provismet.cobblemon.daycareplus.api.PokemonEggProviderItem;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.item.PolymerItem;
import com.provismet.cobblemon.daycareplus.registries.DPItemDataComponents;
import com.provismet.cobblemon.daycareplus.util.StringFormatting;
import com.provismet.cobblemon.daycareplus.util.Styles;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class PokemonEggItem
extends PolymerItem
implements PokemonEggProviderItem {
    private static final int TICKS_PER_MINUTE = 1200;
    private final PolymerModelData shiny;

    public PokemonEggItem(class_1792.class_1793 settings, class_1792 baseVanillaItem, PolymerModelData modelData, PolymerModelData shinyModel) {
        super(settings, baseVanillaItem, modelData);
        this.shiny = shinyModel;
    }

    public class_1799 createEggItem(PokemonProperties properties) {
        return new PokemonEgg(properties).getItem();
    }

    @Override
    public Optional<PokemonEgg> getEgg(class_1799 stack) {
        String properties = (String)stack.method_57824(DPItemDataComponents.POKEMON_PROPERTIES);
        if (properties == null) {
            return Optional.empty();
        }
        PokemonEgg egg = new PokemonEgg(properties, this.getRemainingSteps(stack), this.getMaxSteps(stack), false);
        return Optional.of(egg);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        if (stack.method_57826(class_9334.field_49638)) {
            return;
        }
        Integer steps = (Integer)stack.method_57824(DPItemDataComponents.EGG_STEPS);
        if (steps != null) {
            String minutes = "" + steps / 1200;
            String seconds = "" + steps % 1200 / 20;
            if (minutes.length() < 2) {
                minutes = "0" + minutes;
            }
            if (seconds.length() < 2) {
                seconds = "0" + seconds;
            }
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.daycareplus.egg.ticks", (Object[])new Object[]{minutes + ":" + seconds}));
        }
        if (!DaycarePlusOptions.shouldShowEggTooltip()) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43473());
        String properties = (String)stack.method_57824(DPItemDataComponents.POKEMON_PROPERTIES);
        if (properties == null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.daycareplus.egg.no_data"));
        } else {
            IVs iv;
            PokemonProperties pokemonProperties = PokemonProperties.Companion.parse(properties);
            if (pokemonProperties.getSpecies() != null) {
                class_5250 species = class_2561.method_43471((String)"property.daycareplus.species").method_27692(class_124.field_1054).method_10852((class_2561)this.getTooltipSpeciesName(pokemonProperties));
                tooltip.add((class_2561)species);
            }
            if (pokemonProperties.getForm() != null) {
                tooltip.add((class_2561)class_2561.method_43471((String)"property.daycareplus.form").method_27692(class_124.field_1054).method_10852((class_2561)this.getTooltipFormName(pokemonProperties)));
            }
            if (pokemonProperties.getNature() != null) {
                tooltip.add((class_2561)class_2561.method_43471((String)"property.daycareplus.nature").method_27692(class_124.field_1054).method_10852((class_2561)this.getTooltipNatureName(pokemonProperties)));
            }
            if (pokemonProperties.getAbility() != null) {
                tooltip.add((class_2561)class_2561.method_43471((String)"property.daycareplus.ability").method_27692(class_124.field_1054).method_10852((class_2561)this.getTooltipAbilityName(pokemonProperties)));
            }
            if (pokemonProperties.getGender() != null && pokemonProperties.getGender() != Gender.GENDERLESS) {
                class_5250 gender = switch (pokemonProperties.getGender()) {
                    case Gender.MALE -> class_2561.method_43470((String)"M").method_27692(class_124.field_1078);
                    case Gender.FEMALE -> class_2561.method_43470((String)"F").method_27692(class_124.field_1061);
                    default -> class_2561.method_43470((String)"");
                };
                tooltip.add((class_2561)class_2561.method_43471((String)"property.daycareplus.gender").method_27692(class_124.field_1054).method_10852((class_2561)gender));
            }
            if ((iv = pokemonProperties.getIvs()) != null) {
                tooltip.add((class_2561)class_2561.method_43473());
                tooltip.add((class_2561)class_2561.method_43471((String)"property.daycareplus.hp").method_27694(Styles.colouredNoItalics(10135765)).method_10852((class_2561)class_2561.method_43470((String)this.formatIV(iv, (Stat)Stats.HP)).method_27694(Styles.WHITE_NO_ITALICS)));
                tooltip.add((class_2561)class_2561.method_43471((String)"property.daycareplus.attack").method_27694(Styles.colouredNoItalics(15508298)).method_10852((class_2561)class_2561.method_43470((String)this.formatIV(iv, (Stat)Stats.ATTACK)).method_27694(Styles.WHITE_NO_ITALICS)));
                tooltip.add((class_2561)class_2561.method_43471((String)"property.daycareplus.defence").method_27694(Styles.colouredNoItalics(5289295)).method_10852((class_2561)class_2561.method_43470((String)this.formatIV(iv, (Stat)Stats.DEFENCE)).method_27694(Styles.WHITE_NO_ITALICS)));
                tooltip.add((class_2561)class_2561.method_43471((String)"property.daycareplus.special_attack").method_27694(Styles.colouredNoItalics(16140040)).method_10852((class_2561)class_2561.method_43470((String)this.formatIV(iv, (Stat)Stats.SPECIAL_ATTACK)).method_27694(Styles.WHITE_NO_ITALICS)));
                tooltip.add((class_2561)class_2561.method_43471((String)"property.daycareplus.special_defence").method_27694(Styles.colouredNoItalics(9356062)).method_10852((class_2561)class_2561.method_43470((String)this.formatIV(iv, (Stat)Stats.SPECIAL_DEFENCE)).method_27694(Styles.WHITE_NO_ITALICS)));
                tooltip.add((class_2561)class_2561.method_43471((String)"property.daycareplus.speed").method_27694(Styles.colouredNoItalics(45292)).method_10852((class_2561)class_2561.method_43470((String)this.formatIV(iv, (Stat)Stats.SPEED)).method_27694(Styles.WHITE_NO_ITALICS)));
            }
        }
    }

    private class_5250 getTooltipSpeciesName(PokemonProperties properties) {
        class_5250 text = class_2561.method_43470((String)StringFormatting.titleCase(properties.getSpecies())).method_27694(Styles.WHITE_NO_ITALICS);
        if (Objects.requireNonNullElse(properties.getShiny(), false).booleanValue()) {
            text.method_10852((class_2561)class_2561.method_43470((String)" \u2605").method_27692(class_124.field_1065));
        }
        return text;
    }

    private class_5250 getTooltipFormName(PokemonProperties properties) {
        return class_2561.method_43470((String)StringFormatting.titleCase(properties.getForm())).method_27694(Styles.WHITE_NO_ITALICS);
    }

    private class_5250 getTooltipNatureName(PokemonProperties properties) {
        assert (properties.getNature() != null);
        return class_2561.method_43470((String)StringFormatting.titleCase(class_2960.method_60654((String)properties.getNature()).method_12832())).method_27694(Styles.WHITE_NO_ITALICS);
    }

    private class_5250 getTooltipAbilityName(PokemonProperties properties) {
        return class_2561.method_43471((String)("cobblemon.ability." + properties.getAbility())).method_27694(Styles.WHITE_NO_ITALICS);
    }

    public int getRemainingSteps(class_1799 stack) {
        return (Integer)stack.method_57825(DPItemDataComponents.EGG_STEPS, (Object)7200);
    }

    public int getMaxSteps(class_1799 stack) {
        return (Integer)stack.method_57825(DPItemDataComponents.MAX_EGG_STEPS, (Object)7200);
    }

    @Override
    public int getPolymerCustomModelData(class_1799 stack, @Nullable class_3222 player) {
        if (stack.method_57824(class_9334.field_49637) != null) {
            return -1;
        }
        if (((String)stack.method_57825(DPItemDataComponents.POKEMON_PROPERTIES, (Object)"")).contains("shiny=true")) {
            return this.shiny.value();
        }
        return super.getPolymerCustomModelData(stack, player);
    }

    private String formatIV(IVs ivs, Stat stat) {
        Integer iv = ivs.get(stat);
        if (iv == null) {
            return "?";
        }
        return String.valueOf(iv);
    }
}

