/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TankWidget;
import com.tiviacz.travelersbackpack.item.BackpackTankItem;
import com.tiviacz.travelersbackpack.item.HoseItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4597;

public final class RadialToolsOverlay {
    public static final class_2960 TOOLS_OVERLAY = class_2960.method_60655((String)"travelersbackpack", (String)"textures/gui/tools_overlay.png");
    private static final int ICON_SIZE = 16;
    private static final int ITEM_RING_RADIUS = 42;
    private static final int DEADZONE_RADIUS = 30;
    public static final int ADD_NEW = -999;

    public static void blitCentered(class_332 guiGraphics, class_2960 texture, int centerX, int centerY, int size) {
        int x = centerX - size / 2;
        int y = centerY - size / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25290(texture, x, y, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.disableBlend();
    }

    private static void beginRadialTransform(class_332 guiGraphics, int centerX, int centerY, float openProgress) {
        float t = openProgress = class_3532.method_15363((float)openProgress, (float)0.0f, (float)1.0f);
        float scale = t = t * t * (3.0f - 2.0f * t);
        float opacity = t;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        guiGraphics.method_51448().method_46416((float)(-centerX), (float)(-centerY), 0.0f);
    }

    private static void endRadialTransform(class_332 g) {
        g.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static ArrayList<Integer> buildSegToSlot(class_2371<class_1799> tools, boolean canAdd, int[] outPlusSlot) {
        ArrayList<Integer> segToSlot = new ArrayList<Integer>();
        for (int i = 0; i < tools.size(); ++i) {
            if (((class_1799)tools.get(i)).method_7960()) continue;
            segToSlot.add(i);
        }
        int plusSlot = -1;
        if (canAdd) {
            for (int i = 0; i < tools.size(); ++i) {
                if (!((class_1799)tools.get(i)).method_7960()) continue;
                plusSlot = i;
                break;
            }
            if (plusSlot != -1) {
                int insertPos;
                for (insertPos = 0; insertPos < segToSlot.size() && segToSlot.get(insertPos) < plusSlot; ++insertPos) {
                }
                segToSlot.add(insertPos, plusSlot);
            }
        }
        outPlusSlot[0] = plusSlot;
        return segToSlot;
    }

    public static int renderRadialItems(class_332 guiGraphics, class_1799 backpack, class_2371<class_1799> tools, boolean canAdd, ArrayList<Integer> segToSlot, int plusSlot, int centerX, int centerY, int mouseX, int mouseY) {
        class_1799 hoveredStack;
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        int segments = segToSlot.size();
        int hoveredSeg = RadialToolsOverlay.getHoveredIndex(centerX, centerY, mouseX, mouseY, segments);
        int hoveredResult = -1;
        boolean hoveredIsPlus = false;
        if (hoveredSeg >= 0 && hoveredSeg < segToSlot.size()) {
            int slot = segToSlot.get(hoveredSeg);
            hoveredIsPlus = canAdd && plusSlot != -1 && slot == plusSlot && ((class_1799)tools.get(slot)).method_7960();
            hoveredResult = hoveredIsPlus ? -999 : slot;
        }
        RadialToolsOverlay.renderCenteredItem(guiGraphics, font, backpack, centerX, centerY, 1.25f);
        if (segments == 0 && hoveredSeg == -1) {
            return -1;
        }
        float step = (float)(Math.PI * 2 / (double)segments);
        float start = -1.5707964f;
        for (int seg = 0; seg < segments; ++seg) {
            boolean isPlusHere;
            boolean isHovered;
            float ang = start + (float)seg * step;
            int x = centerX + class_3532.method_15375((float)(class_3532.method_15362((float)ang) * 42.0f)) - 8;
            int y = centerY + class_3532.method_15375((float)(class_3532.method_15374((float)ang) * 42.0f)) - 8;
            boolean bl = isHovered = seg == hoveredSeg;
            if (isHovered) {
                guiGraphics.method_25294(x - 2, y - 2, x + 16 + 2, y + 16 + 2, -2130706433);
            }
            int slot = segToSlot.get(seg);
            boolean bl2 = isPlusHere = canAdd && plusSlot != -1 && slot == plusSlot && ((class_1799)tools.get(slot)).method_7960();
            if (isPlusHere) {
                RadialToolsOverlay.renderPlusButton(guiGraphics, font, x, y);
                continue;
            }
            class_1799 stack = (class_1799)tools.get(slot);
            guiGraphics.method_51427(stack, x, y);
            guiGraphics.method_51431(font, stack, x, y);
        }
        if (hoveredIsPlus) {
            guiGraphics.method_51438(font, (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.add_to_tools"), mouseX, mouseY);
        } else if (hoveredResult >= 0 && !(hoveredStack = (class_1799)tools.get(hoveredResult)).method_7960()) {
            List<class_2561> tooltip = RadialToolsOverlay.getTooltipFromItem(mc, hoveredStack);
            if (hoveredStack.method_7909() instanceof BackpackTankItem && !((RenderInfo)backpack.method_57825(ModDataComponents.RENDER_INFO, (Object)RenderInfo.EMPTY)).isEmpty()) {
                RenderInfo renderInfo = (RenderInfo)backpack.method_57824(ModDataComponents.RENDER_INFO);
                if (hoveredResult == 2) {
                    FluidTank rightTank = new FluidTank(renderInfo.getCapacity());
                    rightTank.setFluid(renderInfo.getRightFluidStack());
                    tooltip.addAll(TankWidget.getTankTooltip(rightTank));
                }
                if (hoveredResult == 3) {
                    FluidTank leftTank = new FluidTank(renderInfo.getCapacity());
                    leftTank.setFluid(renderInfo.getLeftFluidStack());
                    tooltip.addAll(TankWidget.getTankTooltip(leftTank));
                }
            }
            guiGraphics.method_51437(font, tooltip, hoveredStack.method_32347(), mouseX, mouseY);
        }
        return hoveredResult;
    }

    public static List<class_2561> getTooltipFromItem(class_310 minecraft, class_1799 item) {
        return item.method_7950(class_1792.class_9635.method_59528((class_1937)minecraft.field_1687), (class_1657)minecraft.field_1724, (class_1836)class_1836.class_1837.field_41070);
    }

    public static int renderRadial(class_332 guiGraphics, class_1799 backpack, class_1799 heldItem, class_2371<class_1799> tools, boolean canAdd, int centerX, int centerY, int mouseX, int mouseY, float partialTick, float openProgress) {
        if (tools == null) {
            return -1;
        }
        RadialToolsOverlay.beginRadialTransform(guiGraphics, centerX, centerY, openProgress);
        int[] plusSlotRef = new int[1];
        ArrayList<Integer> segToSlot = RadialToolsOverlay.buildSegToSlot(tools, canAdd, plusSlotRef);
        int plusSlot = plusSlotRef[0];
        RadialToolsOverlay.blitCentered(guiGraphics, TOOLS_OVERLAY, centerX, centerY, 256);
        int result = heldItem.method_7909() instanceof HoseItem ? RadialToolsOverlay.renderRadialItems(guiGraphics, backpack, tools, false, segToSlot, plusSlot, centerX, centerY, mouseX, mouseY) : RadialToolsOverlay.renderRadialItems(guiGraphics, backpack, tools, canAdd, segToSlot, plusSlot, centerX, centerY, mouseX, mouseY);
        RadialToolsOverlay.endRadialTransform(guiGraphics);
        return result;
    }

    public static int getHoveredIndex(int cx, int cy, int mx, int my, int segments) {
        if (segments == 0) {
            return -1;
        }
        int dx = mx - cx;
        int dy = my - cy;
        if (dx * dx + dy * dy < 900) {
            return -1;
        }
        double ang = Math.atan2(dy, dx);
        ang = RadialToolsOverlay.normalize0To2Pi(ang);
        double start = 4.71238898038469;
        double rel = RadialToolsOverlay.normalize0To2Pi(ang - start);
        double step = Math.PI * 2 / (double)segments;
        int idx = (int)Math.floor((rel + step / 2.0) / step);
        idx = (idx % segments + segments) % segments;
        return idx;
    }

    private static void renderPlusButton(class_332 guiGraphics, class_327 font, int x, int y) {
        String plus = "+";
        float s = 1.25f;
        float px = (float)x + 8.0f - (float)font.method_1727(plus) / 2.0f;
        float f = (float)y + 8.0f;
        Objects.requireNonNull(font);
        float py = f - 9.0f / 2.0f;
        float cx = (float)x + 8.0f;
        float cy = (float)y + 8.0f;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(cx, cy, 0.0f);
        guiGraphics.method_51448().method_22905(s, s, 1.0f);
        guiGraphics.method_51448().method_46416(-cx, -cy, 0.0f);
        RadialToolsOverlay.drawString(guiGraphics, font, plus, px + 0.5f, py + 1.0f, 0xFFFFFF, false);
        guiGraphics.method_51448().method_22909();
    }

    public static int drawString(class_332 guiGraphics, class_327 pFont, String pText, float pX, float pY, int pColor, boolean pDropShadow) {
        if (pText == null) {
            return 0;
        }
        int i = pFont.method_27522(pText, pX, pY, pColor, pDropShadow, guiGraphics.method_51448().method_23760().method_23761(), (class_4597)guiGraphics.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0, pFont.method_1726());
        guiGraphics.method_51744();
        return i;
    }

    private static void renderCenteredItem(class_332 guiGraphics, class_327 font, class_1799 stack, int centerX, int centerY, float scale) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        guiGraphics.method_51427(stack, -8, -8);
        guiGraphics.method_51431(font, stack, -8, -8);
        guiGraphics.method_51448().method_22909();
    }

    private static double normalize0To2Pi(double a) {
        double twoPi = Math.PI * 2;
        if ((a %= twoPi) < 0.0) {
            a += twoPi;
        }
        return a;
    }
}

