/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.mixin.LevelResourceMixin;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class BackpackManager {
    public static class_5218 BACKPACKS = LevelResourceMixin.invokeInit("backpacks");

    public static void addBackpack(class_3222 player, class_1799 stack) {
        try {
            LocalDateTime deathTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy-HH.mm.ss");
            String formattedDeathTime = deathTime.format(formatter);
            String datedBackpackName = stack.method_41409().method_55840().replace(":", ".") + "_" + formattedDeathTime + ".dat";
            File backpackFile = BackpackManager.getBackpackFile(player, datedBackpackName);
            backpackFile.getParentFile().mkdirs();
            class_2507.method_10630((class_2487)((class_2487)stack.method_57358((class_7225.class_7874)player.method_56673())), (Path)backpackFile.toPath());
            LogHelper.info("Created new backpack backup file for " + player.method_5476().getString() + " with unique ID " + datedBackpackName, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static class_1799 readBackpack(class_3218 serverLevel, UUID playerUUID, String backpackId) {
        try {
            class_2487 data = class_2507.method_10633((Path)BackpackManager.getBackpackFile(serverLevel, playerUUID, backpackId).toPath());
            if (data == null) {
                return null;
            }
            return class_1799.method_57359((class_7225.class_7874)serverLevel.method_30349(), (class_2487)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static class_1799 getBackpack(class_3218 serverLevel, String backpackId) {
        File deathFolder = BackpackManager.getBackpackFolder(serverLevel);
        File[] players = deathFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"));
        if (players == null) {
            return null;
        }
        for (File f : players) {
            File[] files;
            if (!f.isDirectory() || (files = f.listFiles((dir, name) -> name.equals(backpackId))) == null || files.length <= 0) continue;
            return BackpackManager.readBackpack(serverLevel, UUID.fromString(f.getName()), backpackId);
        }
        return null;
    }

    public static File getBackpackFile(class_3218 serverLevel, UUID playerUUID, String backpackId) {
        return new File(BackpackManager.getPlayerBackpackFolder(serverLevel, playerUUID), backpackId);
    }

    public static File getBackpackFile(class_3222 player, String backpackId) {
        return new File(BackpackManager.getPlayerBackpackFolder(player), backpackId);
    }

    public static File getPlayerBackpackFolder(class_3222 player) {
        return BackpackManager.getPlayerBackpackFolder(player.method_51469(), player.method_5667());
    }

    public static File getPlayerBackpackFolder(class_3218 serverLevel, UUID uuid) {
        return new File(BackpackManager.getBackpackFolder(serverLevel), uuid.toString());
    }

    public static File getBackpackFolder(class_3218 serverLevel) {
        return BackpackManager.getWorldFolder(serverLevel, BACKPACKS);
    }

    public static File getWorldFolder(class_3218 serverLevel, class_5218 path) {
        return serverLevel.method_8503().method_27050(path).toFile();
    }
}

