/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.craftingtweaks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.craftingtweaks.api.ButtonAlignment;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingGridBuilder;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.GridBalanceHandler;
import net.blay09.mods.craftingtweaks.api.GridTransferHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9326;

public class BackpackCraftingGridProvider
implements CraftingGridProvider {
    public String getModId() {
        return "travelersbackpack";
    }

    public boolean requiresServerSide() {
        return true;
    }

    public boolean handles(class_1703 menu) {
        return menu instanceof BackpackBaseMenu;
    }

    public void buildCraftingGrids(CraftingGridBuilder craftingGridBuilder, class_1703 abstractContainerMenu) {
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu backpackMenu = (BackpackBaseMenu)abstractContainerMenu;
            craftingGridBuilder.addGrid(backpackMenu.CRAFTING_GRID_START, 9).setButtonAlignment(ButtonAlignment.RIGHT).clearHandler(this::clearGrid).rotateHandler(this::rotateGrid).balanceHandler((GridBalanceHandler)new BackpackBalanceGridHandler()).transferHandler((GridTransferHandler)new BackpackTransferGridHandler()).hideAllTweakButtons();
        }
    }

    public void clearGrid(CraftingGrid grid, class_1657 player, class_1703 menu, boolean forced) {
        if (!(menu instanceof BackpackBaseMenu)) {
            return;
        }
        BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
        Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
        if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
            return;
        }
        class_1263 craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix != null) {
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((class_1735)menu.field_7761.get(i)).method_34266();
                class_1799 itemStack = craftMatrix.method_5438(slotIndex);
                if (itemStack.method_7960()) continue;
                class_1799 returnStack = itemStack.method_7972();
                player.method_31548().method_7394(returnStack);
                craftMatrix.method_5447(slotIndex, returnStack.method_7947() == 0 ? class_1799.field_8037 : returnStack);
                if (returnStack.method_7947() <= 0 || !forced) continue;
                player.method_7328(returnStack, false);
                craftMatrix.method_5447(slotIndex, class_1799.field_8037);
            }
            menu.method_7623();
        }
    }

    protected boolean ignoresSlotId(int slotId) {
        return slotId == 4;
    }

    protected int rotateSlotId(int slotId, boolean counterClockwise) {
        block21: {
            block20: {
                if (counterClockwise) break block20;
                switch (slotId) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 0;
                    }
                    default: {
                        break block21;
                    }
                    case 5: {
                        return 8;
                    }
                    case 6: {
                        return 3;
                    }
                    case 7: {
                        return 6;
                    }
                    case 8: {
                        return 7;
                    }
                }
            }
            switch (slotId) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 6;
                }
                default: {
                    break;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 5;
                }
            }
        }
        return 0;
    }

    public void rotateGrid(CraftingGrid grid, class_1657 player, class_1703 menu, boolean reverse) {
        if (!(menu instanceof BackpackBaseMenu)) {
            return;
        }
        BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
        Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
        if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
            return;
        }
        class_1263 craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix != null) {
            int slotIndex;
            int i;
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            class_1277 matrixClone = new class_1277(size);
            for (i = 0; i < size; ++i) {
                slotIndex = ((class_1735)menu.field_7761.get(start + i)).method_34266();
                matrixClone.method_5447(i, craftMatrix.method_5438(slotIndex));
            }
            for (i = 0; i < size; ++i) {
                if (this.ignoresSlotId(i)) continue;
                slotIndex = ((class_1735)menu.field_7761.get(start + this.rotateSlotId(i, reverse))).method_34266();
                craftMatrix.method_5447(slotIndex, matrixClone.method_5438(i));
            }
            menu.method_7623();
        }
    }

    public static class BackpackBalanceGridHandler
    implements GridBalanceHandler<class_1703> {
        public void balanceGrid(CraftingGrid grid, class_1657 player, class_1703 menu) {
            if (!(menu instanceof BackpackBaseMenu)) {
                return;
            }
            BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
            Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
            if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
                return;
            }
            class_1263 craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix != null) {
                ArrayListMultimap itemMap = ArrayListMultimap.create();
                HashMultiset itemCount = HashMultiset.create();
                int start = grid.getGridStartSlot(player, menu);
                int size = grid.getGridSize(player, menu);
                for (int i = start; i < start + size; ++i) {
                    int slotIndex = ((class_1735)menu.field_7761.get(i)).method_34266();
                    class_1799 itemStack = craftMatrix.method_5438(slotIndex);
                    if (itemStack.method_7960() || itemStack.method_7914() <= 1) continue;
                    class_2960 registryName = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
                    Object key = Objects.toString(registryName);
                    class_9326 componentsPatch = itemStack.method_57380();
                    if (!componentsPatch.method_57848()) {
                        key = (String)key + "@" + String.valueOf(componentsPatch);
                    }
                    itemMap.put(key, (Object)slotIndex);
                    itemCount.add(key, itemStack.method_7947());
                }
                for (String key : itemMap.keySet()) {
                    class_1799 stack;
                    int index;
                    List balanceList = itemMap.get((Object)key);
                    int totalCount = itemCount.count((Object)key);
                    int countPerStack = totalCount / balanceList.size();
                    int restCount = totalCount % balanceList.size();
                    Iterator iterator = balanceList.iterator();
                    while (iterator.hasNext()) {
                        index = (Integer)iterator.next();
                        stack = craftMatrix.method_5438(index);
                        stack.method_7939(countPerStack);
                        craftMatrix.method_5447(index, stack);
                    }
                    int idx = 0;
                    while (restCount > 0) {
                        index = (Integer)balanceList.get(idx);
                        stack = craftMatrix.method_5438(index);
                        if (stack.method_7947() < stack.method_7914()) {
                            class_1799 copy = stack.method_7972();
                            copy.method_7933(1);
                            craftMatrix.method_5447(index, copy);
                            --restCount;
                        }
                        if (++idx < balanceList.size()) continue;
                        idx = 0;
                    }
                }
                menu.method_7623();
            }
        }

        public void spreadGrid(CraftingGrid grid, class_1657 player, class_1703 menu) {
            if (!(menu instanceof BackpackBaseMenu)) {
                return;
            }
            BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
            Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
            if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
                return;
            }
            class_1263 craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix != null) {
                boolean emptyBiggestSlot;
                do {
                    class_1799 itemStack;
                    int slotIndex;
                    int i;
                    class_1799 biggestSlotStack = null;
                    int biggestSlotStackSlot = 0;
                    int biggestSlotSize = 1;
                    int start = grid.getGridStartSlot(player, menu);
                    int size = grid.getGridSize(player, menu);
                    for (i = start; i < start + size; ++i) {
                        slotIndex = ((class_1735)menu.field_7761.get(i)).method_34266();
                        itemStack = craftMatrix.method_5438(slotIndex);
                        if (itemStack.method_7960() || itemStack.method_7947() <= biggestSlotSize) continue;
                        biggestSlotStack = itemStack;
                        biggestSlotStackSlot = slotIndex;
                        biggestSlotSize = itemStack.method_7947();
                    }
                    if (biggestSlotStack == null) {
                        return;
                    }
                    emptyBiggestSlot = false;
                    for (i = start; i < start + size; ++i) {
                        slotIndex = ((class_1735)menu.field_7761.get(i)).method_34266();
                        itemStack = craftMatrix.method_5438(slotIndex);
                        if (!itemStack.method_7960()) continue;
                        if (biggestSlotStack.method_7947() > 1) {
                            class_1799 splitted = biggestSlotStack.method_7971(1);
                            craftMatrix.method_5447(biggestSlotStackSlot, biggestSlotStack);
                            craftMatrix.method_5447(slotIndex, splitted);
                            continue;
                        }
                        emptyBiggestSlot = true;
                    }
                } while (emptyBiggestSlot);
                this.balanceGrid(grid, player, menu);
            }
        }
    }

    public static class BackpackTransferGridHandler
    implements GridTransferHandler<class_1703> {
        public class_1799 putIntoGrid(CraftingGrid grid, class_1657 player, class_1703 menu, int slotId, class_1799 itemStack) {
            class_1263 craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix == null) {
                return itemStack;
            }
            class_1799 craftStack = craftMatrix.method_5438(slotId).method_7972();
            if (!craftStack.method_7960()) {
                int spaceLeft;
                if (class_1799.method_31577((class_1799)craftStack, (class_1799)itemStack) && (spaceLeft = Math.min(craftMatrix.method_5444(), craftStack.method_7914()) - craftStack.method_7947()) > 0) {
                    class_1799 splitStack = itemStack.method_7971(Math.min(spaceLeft, itemStack.method_7947()));
                    craftStack.method_7933(splitStack.method_7947());
                    craftMatrix.method_5447(slotId, craftStack);
                    if (itemStack.method_7947() <= 0) {
                        return class_1799.field_8037;
                    }
                }
            } else {
                class_1799 transferStack = itemStack.method_7971(Math.min(itemStack.method_7947(), craftMatrix.method_5444()));
                craftMatrix.method_5447(slotId, transferStack);
            }
            return itemStack.method_7947() <= 0 ? class_1799.field_8037 : itemStack;
        }

        public boolean transferIntoGrid(CraftingGrid grid, class_1657 player, class_1703 menu, class_1735 fromSlot) {
            class_1263 craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix == null) {
                return false;
            }
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            class_1799 itemStack = fromSlot.method_7677();
            if (itemStack.method_7960()) {
                return false;
            }
            int firstEmptySlot = -1;
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((class_1735)menu.field_7761.get(i)).method_34266();
                class_1799 craftStack = craftMatrix.method_5438(slotIndex).method_7972();
                if (!craftStack.method_7960()) {
                    int spaceLeft;
                    if (!class_1799.method_31577((class_1799)craftStack, (class_1799)itemStack) || (spaceLeft = Math.min(craftMatrix.method_5444(), craftStack.method_7914()) - craftStack.method_7947()) <= 0) continue;
                    class_1799 splitStack = itemStack.method_7971(Math.min(spaceLeft, itemStack.method_7947()));
                    craftStack.method_7933(splitStack.method_7947());
                    craftMatrix.method_5447(slotIndex, craftStack);
                    if (itemStack.method_7947() > 0) continue;
                    return true;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = slotIndex;
            }
            if (itemStack.method_7947() > 0 && firstEmptySlot != -1) {
                class_1799 transferStack = itemStack.method_7971(Math.min(itemStack.method_7947(), craftMatrix.method_5444()));
                craftMatrix.method_5447(firstEmptySlot, transferStack);
                return true;
            }
            return false;
        }

        public boolean canTransferFrom(class_1657 player, class_1703 abstractContainerMenu, class_1735 slot, CraftingGrid craftingGrid) {
            if (abstractContainerMenu instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
                Optional<CraftingUpgrade> upgrade = menu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
                if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
                    return false;
                }
                if (slot.method_7674(player)) {
                    return slot.field_7871 == player.method_31548() || slot.field_7874 < menu.BACKPACK_INV_END;
                }
            }
            return false;
        }
    }
}

