/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.FilterUpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TankWidget;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_7833;

public class VoidWidget
extends FilterUpgradeWidgetBase<VoidWidget, VoidUpgrade> {
    private static final class_2960 TRASH_UPGRADE = class_2960.method_60655((String)"travelersbackpack", (String)"textures/item/void_upgrade.png");
    private static final int RED_HIGHLIGHT_COLOR = 2143884822;
    private static final int RED_ARROW_COLOR = -5636096;
    private static final int HIGHLIGHT_TANK_COLOR = -2130706433;
    private final WidgetElement trashBinSlot = new WidgetElement(new Point(25, 4), new Point(16, 16));
    public final List<Integer> selectedSlots = new ArrayList<Integer>();
    public final List<Integer> selectedTanks = new ArrayList<Integer>();
    private boolean tickAnimation = false;
    private float progress = 0.0f;
    private boolean hoveringTrashBin = false;
    private static final List<class_2561> WHITELIST_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_allow_voiding"), class_2561.method_43471((String)"screen.travelersbackpack.filter_block_voiding"), class_2561.method_43471((String)"screen.travelersbackpack.filter_match_contents_voiding"));
    private static final List<class_2561> OBJECT_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_item"), class_2561.method_43471((String)"screen.travelersbackpack.filter_modid"), class_2561.method_43471((String)"screen.travelersbackpack.filter_tag"));
    private static final List<class_2561> IGNORE_MODE_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_match_components"), class_2561.method_43471((String)"screen.travelersbackpack.filter_ignore_components"));

    public VoidWidget(BackpackScreen screen, VoidUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 0), "screen.travelersbackpack.void_upgrade");
        FilterButton<VoidWidget> whitelistButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(0), ButtonStates.ALLOW, new Point(pos.x() + 6, pos.y() + 22));
        FilterButton<VoidWidget> objectButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(1), ButtonStates.OBJECT_TYPE, new Point(pos.x() + 6 + 18, pos.y() + 22));
        FilterButton<VoidWidget> ignoreModeButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(2), ButtonStates.IGNORE_MODE, new Point(pos.x() + 6 + 36, pos.y() + 22));
        this.addFilterButton(whitelistButton);
        this.addFilterButton(objectButton);
        this.addFilterButton(ignoreModeButton);
    }

    @Override
    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        this.renderMatchContentsSlotOverlay(guiGraphics, ((VoidUpgrade)this.upgrade).getFilter(), 0, 2, TravelersBackpackConfig.getConfig().backpackUpgrades.voidUpgradeSettings.filterSlotCount);
        if (this.isTabOpened()) {
            if (this.isHoveringWithTrashBin()) {
                RenderSystem.enableBlend();
                guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 0.5f);
                this.renderTrashBin(guiGraphics, this.pos.x() + 31, this.pos.y() + 9, this.selectedSlots.isEmpty() && this.selectedTanks.isEmpty() ? 0.0f : 3.0f);
                if (!this.selectedSlots.isEmpty() || !this.selectedTanks.isEmpty()) {
                    guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 0.75f);
                    this.renderRedDownArrow(guiGraphics, this.pos.x() + 31 + 1, this.pos.y() + 5);
                }
                guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.disableBlend();
            } else {
                this.renderTrashBinAnimation(guiGraphics, this.pos.x() + 31, this.pos.y() + 9);
            }
        }
    }

    @Override
    public void renderUnderTooltip(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderUnderTooltip(guiGraphics, mouseX, mouseY, partialTicks);
        class_1735 slot = ((BackpackScreen)this.screen).field_2787;
        if (this.isHoveringWithTrashBin() && slot != null && this.canSelectSlot(slot) && !this.selectedSlots.contains(slot.field_7874)) {
            this.drawRedHighlight(guiGraphics, slot);
        }
        this.selectedSlots.forEach(index -> this.drawRedHighlight(guiGraphics, ((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).method_7611((int)index)));
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isTabOpened()) {
            if (this.isWithinTrashBinSlot(mouseX, mouseY)) {
                if (!(!this.isHoveringWithTrashBin() || this.selectedSlots.isEmpty() && this.selectedTanks.isEmpty())) {
                    guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.void_upgrade_trash_bin_drop").method_27692(class_124.field_1061), mouseX, mouseY);
                }
                if (this.selectedSlots.isEmpty() && this.selectedTanks.isEmpty()) {
                    ArrayList<class_2561> components = new ArrayList<class_2561>(TextUtils.getTranslatedSplittedText("screen.travelersbackpack.void_upgrade_trash_bin", null));
                    if (((BackpackScreen)this.screen).getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).isEmpty()) {
                        components.remove(2);
                    }
                    guiGraphics.method_51434(((BackpackScreen)this.screen).getFont(), components, mouseX, mouseY);
                }
            }
            if (this.getFilterButton(ButtonStates.ALLOW).isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), WHITELIST_TOOLTIPS.get(this.getFilterButton(ButtonStates.ALLOW).getCurrentState()), mouseX, mouseY);
            }
            if (this.getFilterButton(ButtonStates.OBJECT_TYPE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), OBJECT_TOOLTIPS.get(this.getFilterButton(ButtonStates.OBJECT_TYPE).getCurrentState()), mouseX, mouseY);
            }
            if (this.getFilterButton(ButtonStates.IGNORE_MODE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), IGNORE_MODE_TOOLTIPS.get(this.getFilterButton(ButtonStates.IGNORE_MODE).getCurrentState()), mouseX, mouseY);
            }
        }
    }

    @Override
    public void renderOnTop(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderOnTop(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isTabOpened()) {
            boolean bl = this.tickAnimation = this.isHoveringWithTrashBin() || this.isWithinTrashBinSlot(mouseX, mouseY);
            if (this.isHoveringWithTrashBin()) {
                this.renderTrashBinAnimation(guiGraphics, mouseX - 1, mouseY - 1);
            }
        }
    }

    @Override
    public boolean method_25405(double pMouseX, double pMouseY) {
        if (this.isHoveringWithTrashBin()) {
            return true;
        }
        return super.method_25405(pMouseX, pMouseY);
    }

    public boolean isWithinTrashBinSlot(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.trashBinSlot);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.select(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isTabOpened()) {
            if (this.isWithinTrashBinSlot(mouseX, mouseY) && ((BackpackScreen)this.screen).getWrapper().isOwner(((BackpackScreen)this.screen).getScreenPlayer()) && ((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).method_34255().method_7960()) {
                boolean bl = this.hoveringTrashBin = !this.hoveringTrashBin;
                if (!this.isHoveringWithTrashBin()) {
                    this.selectedSlots.forEach(index -> ServerboundActionTagPacket.create(16, 0, class_1799.field_8037, index));
                    this.selectedSlots.clear();
                    this.selectedTanks.forEach(tank -> ServerboundActionTagPacket.create(16, 1, class_1799.field_8037, tank));
                    this.selectedTanks.clear();
                }
            } else if (this.select(mouseX, mouseY, button)) {
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean isHoveringWithTrashBin() {
        return this.hoveringTrashBin;
    }

    public boolean select(double mouseX, double mouseY, int button) {
        if (this.isHoveringWithTrashBin()) {
            if (this.selectSlots(((BackpackScreen)this.screen).field_2787, button)) {
                return true;
            }
            WidgetBase<?> widgetBase = ((BackpackScreen)this.screen).mappedWidgets.get(TanksUpgrade.class);
            if (widgetBase instanceof TankWidget) {
                TankWidget tankWidget = (TankWidget)widgetBase;
                if (this.selectTank(tankWidget, ((TanksUpgrade)tankWidget.getUpgrade()).getLeftTank().isEmpty(), tankWidget.leftTankElement, mouseX, mouseY, 0, button)) {
                    return true;
                }
                if (this.selectTank(tankWidget, ((TanksUpgrade)tankWidget.getUpgrade()).getRightTank().isEmpty(), tankWidget.rightTankElement, mouseX, mouseY, 1, button)) {
                    return true;
                }
            }
            if (!this.isWithinTrashBinSlot(mouseX, mouseY)) {
                return true;
            }
        }
        return false;
    }

    public boolean selectTank(TankWidget tankWidget, boolean isEmpty, WidgetElement tankElement, double mouseX, double mouseY, int tank, int button) {
        if (tankWidget.inTank(tankElement, mouseX, mouseY) && !isEmpty) {
            if (button == 0 && !this.selectedTanks.contains(tank)) {
                this.selectedTanks.add(tank);
                return true;
            }
            if (button == 1 && this.selectedTanks.contains(tank)) {
                this.selectedTanks.remove((Object)tank);
                return true;
            }
        }
        return false;
    }

    public boolean canSelectSlot(class_1735 slot) {
        return slot.field_7874 >= 0 && slot.field_7874 < ((BackpackScreen)this.screen).getWrapper().getStorage().getSlots() || slot.field_7871 instanceof class_1661;
    }

    public boolean selectSlots(class_1735 slot, int button) {
        if (slot != null) {
            if (slot instanceof DisabledSlot || !slot.method_7681()) {
                return false;
            }
            if (this.canSelectSlot(slot) && BackpackSettingsScreen.selectSlotsIndex(this.selectedSlots, this.hoveringTrashBin, slot, button)) {
                return true;
            }
        }
        return false;
    }

    public void drawRedTankHighlight(class_332 guiGraphics, int x, int y, boolean inTank, int height, int tankIndex) {
        boolean flag;
        if (this.isHoveringWithTrashBin() && ((flag = inTank) || this.selectedTanks.contains(tankIndex))) {
            if (flag) {
                guiGraphics.method_51740(class_1921.method_51785(), x, y, x + 16, y + height, -2130706433, -2130706433, 0);
            }
            guiGraphics.method_48196(class_1921.method_51785(), x, y, x + 16, y + height, 0, 2143884822);
        }
    }

    public void drawRedHighlight(class_332 guiGraphics, class_1735 slot) {
        guiGraphics.method_48196(class_1921.method_51785(), ((BackpackScreen)this.screen).getGuiLeft() + slot.field_7873, ((BackpackScreen)this.screen).getGuiTop() + slot.field_7872, ((BackpackScreen)this.screen).getGuiLeft() + slot.field_7873 + 16, ((BackpackScreen)this.screen).getGuiTop() + slot.field_7872 + 16, 0, 2143884822);
    }

    public void renderRedDownArrow(class_332 guiGraphics, int x, int y) {
        guiGraphics.method_51739(class_1921.method_51785(), x, y + 2, x + 2, y + 5, -5636096);
        guiGraphics.method_51739(class_1921.method_51785(), x - 2, y + 5, x + 4, y + 6, -5636096);
        guiGraphics.method_51739(class_1921.method_51785(), x - 1, y + 6, x + 3, y + 7, -5636096);
        guiGraphics.method_51739(class_1921.method_51785(), x, y + 7, x + 2, y + 8, -5636096);
    }

    public void renderTrashBinAnimation(class_332 guiGraphics, int x, int y) {
        this.tickAnimation();
        float time = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        float f = (float)(Math.sin((double)time * Math.PI) * 1.0 + 1.0);
        guiGraphics.method_51448().method_22903();
        if (this.isHoveringWithTrashBin()) {
            RenderSystem.disableDepthTest();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 500.0f);
            guiGraphics.method_51448().method_49278(class_7833.field_40718.rotationDegrees(-12.5f + f * 12.5f), (float)x, (float)y, 0.0f);
            RenderSystem.enableDepthTest();
        }
        this.renderTrashBin(guiGraphics, x, y, this.progress);
        guiGraphics.method_51448().method_22909();
    }

    public void renderTrashBin(class_332 guiGraphics, int x, int y, float progress) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_49278(class_7833.field_40718.rotationDegrees(progress * 7.5f), (float)x, (float)y, 0.0f);
        guiGraphics.method_25290(TRASH_UPGRADE, x, y - (int)(1.0f * progress), 6.0f, 4.0f, 4, 1, 16, 16);
        guiGraphics.method_25290(TRASH_UPGRADE, x - 2, y + 1 - (int)(1.0f * progress), 4.0f, 5.0f, 8, 1, 16, 16);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_25290(TRASH_UPGRADE, x - 2, y + 2, 4.0f, 6.0f, 8, 1, 16, 16);
        guiGraphics.method_25290(TRASH_UPGRADE, x - 1, y + 3, 5.0f, 7.0f, 6, 5, 16, 16);
    }

    public void tickAnimation() {
        this.progress = this.tickAnimation ? (this.progress < 3.0f ? (this.progress += 0.2f) : 3.0f) : (this.progress > 0.0f ? (this.progress -= 0.2f) : 0.0f);
    }
}

