/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.network.message.KnownWaystonesMessage;
import net.blay09.mods.waystones.network.message.PlayerWaystoneCooldownsMessage;
import net.blay09.mods.waystones.network.message.SortingIndexMessage;
import net.blay09.mods.waystones.network.message.UpdateWaystoneMessage;
import net.blay09.mods.waystones.network.message.WaystoneRemovedMessage;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WaystoneSyncManager {
    public static void sendWaystoneUpdateToAll(@Nullable MinecraftServer server, Waystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            WaystoneSyncManager.sendWaystoneUpdate((class_1657)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((class_1657)player);
        }
    }

    public static void sendWaystoneRemovalToAll(@Nullable MinecraftServer server, Waystone waystone, boolean wasDestroyed) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            WaystoneSyncManager.sendWaystoneRemoval((class_1657)player, waystone, wasDestroyed);
        }
    }

    public static void sendSortingIndex(class_1657 player) {
        List<UUID> sortingIndex = PlayerWaystoneManager.getSortingIndex(player);
        Balm.getNetworking().sendTo(player, (class_8710)new SortingIndexMessage(sortingIndex));
    }

    public static void sendActivatedWaystones(class_1657 player) {
        Collection<Waystone> waystones = PlayerWaystoneManager.getActivatedWaystones(player);
        Balm.getNetworking().sendTo(player, (class_8710)new KnownWaystonesMessage(WaystoneTypes.WAYSTONE, waystones));
    }

    public static void sendWaystonesOfType(class_2960 waystoneType, class_3222 player) {
        List<Waystone> warpPlates = WaystoneManagerImpl.get(player.field_13995).getWaystonesByType(waystoneType).collect(Collectors.toList());
        Balm.getNetworking().sendTo((class_1657)player, (class_8710)new KnownWaystonesMessage(waystoneType, warpPlates));
    }

    public static void sendWaystoneUpdate(class_1657 player, Waystone waystone) {
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
            Balm.getNetworking().sendTo(player, (class_8710)new UpdateWaystoneMessage(waystone));
        }
    }

    public static void sendWaystoneRemoval(class_1657 player, Waystone waystone, boolean wasDestroyed) {
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
            Balm.getNetworking().sendTo(player, (class_8710)new WaystoneRemovedMessage(waystone.getWaystoneType(), waystone.getWaystoneUid(), wasDestroyed));
        }
    }

    public static void sendWaystoneCooldowns(class_1657 player) {
        Map<class_2960, Long> cooldowns = PlayerWaystoneManager.getCooldowns(player);
        Balm.getNetworking().sendTo(player, (class_8710)new PlayerWaystoneCooldownsMessage(cooldowns));
    }
}

