/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts;

import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.BenchedMoves;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.net.messages.client.PokemonUpdatePacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.AspectsUpdatePacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.BenchedMovesUpdatePacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.MoveSetUpdatePacket;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.ShadowGate;
import com.jayemceekay.shadowedhearts.config.HeartGaugeConfig;
import com.jayemceekay.shadowedhearts.config.IShadowConfig;
import com.jayemceekay.shadowedhearts.config.ModConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.network.PokemonPropertyUpdatePacket;
import com.jayemceekay.shadowedhearts.pokemon.properties.EVBufferProperty;
import com.jayemceekay.shadowedhearts.pokemon.properties.ExposureProperty;
import com.jayemceekay.shadowedhearts.pokemon.properties.HeartGaugeProperty;
import com.jayemceekay.shadowedhearts.pokemon.properties.ImmunizedProperty;
import com.jayemceekay.shadowedhearts.pokemon.properties.ScentCooldownProperty;
import com.jayemceekay.shadowedhearts.pokemon.properties.XPBufferProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.jvm.functions.Function0;
import net.minecraft.class_3532;

public final class PokemonAspectUtil {
    private static final String METER_PREFIX = "shadowedhearts:heartgauge:";
    private static final String XPBUF_PREFIX = "shadowedhearts:xpbuf:";
    private static final String EVBUF_PREFIX = "shadowedhearts:evbuf:";
    private static final String NBT_HEART_GAUGE = "shadowedhearts:heartgauge";
    private static final String NBT_EXPOSURE = "shadowedhearts:exposure";
    private static final String NBT_IMMUNIZED = "shadowedhearts:immunized";
    private static final String NBT_XP_BUF = "shadowedhearts:xpbuf";
    private static final String NBT_EV_BUF = "shadowedhearts:evbuf";
    private static final String NBT_SCENT_COOLDOWN = "shadowedhearts:scent_cooldown";

    public static void setShadowAspect(Pokemon pokemon, boolean isShadow) {
        PokemonAspectUtil.setShadowAspect(pokemon, isShadow, true);
    }

    public static void setShadowAspect(Pokemon pokemon, boolean isShadow, boolean sync) {
        HashSet<String> aspectsCopy = new HashSet<String>(pokemon.getAspects());
        if (isShadow) {
            aspectsCopy.add("shadowedhearts:shadow");
            PokemonAspectUtil.replaceMovesWithShadowMoves(pokemon);
        } else {
            aspectsCopy.remove("shadowedhearts:shadow");
        }
        pokemon.setForcedAspects(aspectsCopy);
        pokemon.updateAspects();
        if (sync) {
            PokemonAspectUtil.syncAspects(pokemon);
            PokemonAspectUtil.syncBenchedMoves(pokemon);
            PokemonAspectUtil.syncMoveSet(pokemon);
        }
    }

    private static void replaceMovesWithShadowMoves(Pokemon pokemon) {
        long salt = pokemon.getUuid().getLeastSignificantBits();
        Random rng = new Random(salt);
        int replaceCount = ModConfig.resolveReplaceCount(rng);
        if (replaceCount <= 0) {
            return;
        }
        MoveSet moveSet = pokemon.getMoveSet();
        for (int i = 0; i < Math.min(replaceCount, 4); ++i) {
            String shadowMoveName;
            Move oldMove = moveSet.get(i);
            if (oldMove == null || ShadowGate.isShadowMoveId(oldMove.getTemplate().getName())) continue;
            BenchedMove benched = new BenchedMove(oldMove.getTemplate(), oldMove.getRaisedPpStages());
            pokemon.getBenchedMoves().add(benched);
            IShadowConfig cfg = ShadowedHeartsConfigs.getInstance().getShadowConfig();
            if (cfg.shadowMovesOnlyShadowRush()) {
                if (i != 0) continue;
                shadowMoveName = "shadowrush";
            } else {
                shadowMoveName = i == 0 ? PokemonAspectUtil.getRandomDamageShadowMove(pokemon, i) : PokemonAspectUtil.getRandomShadowMove(pokemon, i);
            }
            MoveTemplate template = Moves.getByName((String)shadowMoveName);
            if (template == null) continue;
            moveSet.setMove(i, template.create(template.getPp(), 0));
        }
    }

    private static String getRandomDamageShadowMove(Pokemon pokemon, int seed) {
        String[] shadowMoves = new String[]{"shadowblast", "shadowblitz", "shadowbolt", "shadowbreak", "shadowchill", "shadowdown", "shadowend", "shadowfire", "shadowhalf", "shadowhold", "shadowmist", "shadowpanic", "shadowrave", "shadowrush", "shadowshed", "shadowsky", "shadowstorm", "shadowwave"};
        ArrayList<String> damageMoves = new ArrayList<String>();
        for (String id : shadowMoves) {
            MoveTemplate tmpl = Moves.getByName((String)id);
            if (tmpl == null || tmpl.getDamageCategory() == DamageCategories.INSTANCE.getSTATUS()) continue;
            damageMoves.add(id);
        }
        if (damageMoves.isEmpty()) {
            return "shadowrush";
        }
        long salt = pokemon.getUuid().getLeastSignificantBits() ^ (long)seed;
        Random rng = new Random(salt);
        return (String)damageMoves.get(rng.nextInt(damageMoves.size()));
    }

    private static String getRandomShadowMove(Pokemon pokemon, int seed) {
        String[] shadowMoves = new String[]{"shadowblast", "shadowblitz", "shadowbolt", "shadowbreak", "shadowchill", "shadowdown", "shadowend", "shadowfire", "shadowhalf", "shadowhold", "shadowmist", "shadowpanic", "shadowrave", "shadowrush", "shadowshed", "shadowsky", "shadowstorm", "shadowwave"};
        long salt = pokemon.getUuid().getLeastSignificantBits() ^ (long)seed;
        Random rng = new Random(salt);
        return shadowMoves[rng.nextInt(shadowMoves.length)];
    }

    public static boolean hasShadowAspect(Pokemon pokemon) {
        if (pokemon != null) {
            return pokemon.getAspects().contains("shadowedhearts:shadow");
        }
        return false;
    }

    public static void ensureRequiredShadowAspects(Pokemon pokemon) {
        if (pokemon == null) {
            return;
        }
        if (!PokemonAspectUtil.hasShadowAspect(pokemon)) {
            return;
        }
        boolean changed = false;
        HashSet aspects = new HashSet(pokemon.getAspects());
        int heartGauge = -1;
        int xpBuf = -1;
        int[] evBuf = null;
        Iterator it = aspects.iterator();
        while (it.hasNext()) {
            String a = (String)it.next();
            if (a.startsWith(METER_PREFIX)) {
                try {
                    heartGauge = Integer.parseInt(a.substring(METER_PREFIX.length()));
                    it.remove();
                    changed = true;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (a.startsWith(XPBUF_PREFIX)) {
                try {
                    xpBuf = Integer.parseInt(a.substring(XPBUF_PREFIX.length()));
                    it.remove();
                    changed = true;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!a.startsWith(EVBUF_PREFIX)) continue;
            try {
                String csv = a.substring(EVBUF_PREFIX.length());
                String[] parts = csv.split(",");
                evBuf = new int[]{0, 0, 0, 0, 0, 0};
                for (int i = 0; i < Math.min(parts.length, 6); ++i) {
                    evBuf[i] = Integer.parseInt(parts[i]);
                }
                it.remove();
                changed = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (heartGauge != -1) {
            PokemonAspectUtil.setHeartGaugeProperty(pokemon, heartGauge);
        }
        if (xpBuf != -1) {
            PokemonAspectUtil.setXPBufferProperty(pokemon, xpBuf);
        }
        if (evBuf != null) {
            PokemonAspectUtil.setEVBufferProperty(pokemon, evBuf);
        }
        PokemonAspectUtil.ensureShadowMaxIVs(pokemon);
        if (PokemonAspectUtil.getHeartGaugeValueFromProperty(pokemon) == -1) {
            PokemonAspectUtil.setHeartGaugeProperty(pokemon, HeartGaugeConfig.getMax(pokemon));
        }
        if (PokemonAspectUtil.getXPBufferFromProperty(pokemon) == -1) {
            PokemonAspectUtil.setXPBufferProperty(pokemon, 0);
        }
        if (PokemonAspectUtil.getEVBufferFromProperty(pokemon) == null) {
            PokemonAspectUtil.setEVBufferProperty(pokemon, new int[]{0, 0, 0, 0, 0, 0});
        }
        if (changed) {
            pokemon.setForcedAspects(aspects);
            pokemon.updateAspects();
            PokemonAspectUtil.syncAspects(pokemon);
            PokemonAspectUtil.syncProperties(pokemon);
        }
    }

    public static void syncAspects(Pokemon pokemon) {
        if (pokemon == null) {
            return;
        }
        try {
            Pokemon pk = pokemon;
            Function0 supplier = () -> pk;
            pokemon.onChange((PokemonUpdatePacket)new AspectsUpdatePacket(supplier, new HashSet(pokemon.getAspects())));
        }
        catch (Throwable throwable) {
        }
        finally {
            pokemon.onChange(null);
        }
    }

    public static void syncProperties(Pokemon pokemon) {
        if (pokemon == null) {
            return;
        }
        try {
            Pokemon pk = pokemon;
            Function0 supplier = () -> pk;
            pokemon.onChange((PokemonUpdatePacket)new PokemonPropertyUpdatePacket((Function0<? extends Pokemon>)supplier, new ArrayList(pokemon.getCustomProperties())));
        }
        catch (Throwable throwable) {
        }
        finally {
            pokemon.onChange(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncBenchedMoves(Pokemon pokemon) {
        if (pokemon == null) {
            return;
        }
        try {
            Pokemon pk = pokemon;
            Function0 supplier = () -> pk;
            BenchedMoves snapshot = new BenchedMoves();
            snapshot.doWithoutEmitting(() -> {
                for (BenchedMove bm : pk.getBenchedMoves()) {
                    snapshot.add(bm);
                }
                return null;
            });
            pokemon.onChange((PokemonUpdatePacket)new BenchedMovesUpdatePacket(supplier, snapshot));
        }
        catch (Throwable throwable) {
        }
        finally {
            pokemon.onChange(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncMoveSet(Pokemon pokemon) {
        if (pokemon == null) {
            return;
        }
        try {
            Pokemon pk = pokemon;
            Function0 supplier = () -> pk;
            MoveSet snapshot = new MoveSet();
            snapshot.doWithoutEmitting(() -> {
                for (int i = 0; i < 4; ++i) {
                    Move move = pk.getMoveSet().get(i);
                    if (move == null) continue;
                    snapshot.setMove(i, move);
                }
                return null;
            });
            pokemon.onChange((PokemonUpdatePacket)new MoveSetUpdatePacket(supplier, snapshot));
        }
        catch (Throwable throwable) {
        }
        finally {
            pokemon.onChange(null);
        }
    }

    public static void setHeartGauge(Pokemon pokemon, float value) {
        int meter = Math.round(class_3532.method_15363((float)value, (float)0.0f, (float)HeartGaugeConfig.getMax(pokemon)));
        PokemonAspectUtil.setHeartGaugeValue(pokemon, meter);
    }

    public static void setHeartGaugeValue(Pokemon pokemon, int meter) {
        PokemonAspectUtil.setHeartGaugeValue(pokemon, meter, true);
    }

    public static void setHeartGaugeValue(Pokemon pokemon, int meter, boolean sync) {
        int max = HeartGaugeConfig.getMax(pokemon);
        int clamped = Math.max(0, Math.min(max, meter));
        PokemonAspectUtil.setHeartGaugeProperty(pokemon, clamped, sync);
    }

    public static void setHeartGaugeProperty(Pokemon pokemon, int value) {
        PokemonAspectUtil.setHeartGaugeProperty(pokemon, value, true);
    }

    public static void setHeartGaugeProperty(Pokemon pokemon, int value, boolean sync) {
        pokemon.getCustomProperties().removeIf(p -> p instanceof HeartGaugeProperty);
        pokemon.getCustomProperties().add(new HeartGaugeProperty(value));
        pokemon.getPersistentData().method_10569(NBT_HEART_GAUGE, value);
        if (sync) {
            PokemonAspectUtil.syncProperties(pokemon);
        }
    }

    public static int getHeartGaugeValueFromProperty(Pokemon pokemon) {
        return pokemon.getCustomProperties().stream().filter(p -> p instanceof HeartGaugeProperty).map(p -> ((HeartGaugeProperty)p).getValue()).findFirst().orElse(-1);
    }

    public static void setExposureProperty(Pokemon pokemon, double value) {
        pokemon.getCustomProperties().removeIf(p -> p instanceof ExposureProperty);
        pokemon.getCustomProperties().add(new ExposureProperty(value));
        pokemon.getPersistentData().method_10549(NBT_EXPOSURE, value);
        PokemonAspectUtil.syncProperties(pokemon);
    }

    public static double getExposure(Pokemon pokemon) {
        return pokemon.getCustomProperties().stream().filter(p -> p instanceof ExposureProperty).map(p -> ((ExposureProperty)p).getValue()).findFirst().orElseGet(() -> pokemon.getPersistentData().method_10574(NBT_EXPOSURE));
    }

    public static void setImmunizedProperty(Pokemon pokemon, boolean value) {
        pokemon.getCustomProperties().removeIf(p -> p instanceof ImmunizedProperty);
        pokemon.getCustomProperties().add(new ImmunizedProperty(value));
        pokemon.getPersistentData().method_10556(NBT_IMMUNIZED, value);
        PokemonAspectUtil.syncProperties(pokemon);
    }

    public static boolean isImmunized(Pokemon pokemon) {
        return pokemon.getCustomProperties().stream().filter(p -> p instanceof ImmunizedProperty).map(p -> ((ImmunizedProperty)p).getValue()).findFirst().orElseGet(() -> pokemon.getPersistentData().method_10577(NBT_IMMUNIZED));
    }

    public static void setXPBufferProperty(Pokemon pokemon, int value) {
        pokemon.getCustomProperties().removeIf(p -> p instanceof XPBufferProperty);
        pokemon.getCustomProperties().add(new XPBufferProperty(value));
        pokemon.getPersistentData().method_10569(NBT_XP_BUF, value);
        PokemonAspectUtil.syncProperties(pokemon);
    }

    public static int getXPBufferFromProperty(Pokemon pokemon) {
        return pokemon.getCustomProperties().stream().filter(p -> p instanceof XPBufferProperty).map(p -> ((XPBufferProperty)p).getValue()).findFirst().orElse(-1);
    }

    public static void setEVBufferProperty(Pokemon pokemon, int[] values) {
        pokemon.getCustomProperties().removeIf(p -> p instanceof EVBufferProperty);
        pokemon.getCustomProperties().add(new EVBufferProperty(values));
        pokemon.getPersistentData().method_10539(NBT_EV_BUF, values);
        PokemonAspectUtil.syncProperties(pokemon);
    }

    public static int[] getEVBufferFromProperty(Pokemon pokemon) {
        return pokemon.getCustomProperties().stream().filter(p -> p instanceof EVBufferProperty).map(p -> ((EVBufferProperty)p).getValues()).findFirst().orElse(null);
    }

    public static void setScentCooldown(Pokemon pokemon, long value) {
        pokemon.getCustomProperties().removeIf(p -> p instanceof ScentCooldownProperty);
        pokemon.getCustomProperties().add(new ScentCooldownProperty(value));
        pokemon.getPersistentData().method_10544(NBT_SCENT_COOLDOWN, value);
        PokemonAspectUtil.syncProperties(pokemon);
    }

    public static long getScentCooldown(Pokemon pokemon) {
        return pokemon.getCustomProperties().stream().filter(p -> p instanceof ScentCooldownProperty).map(p -> ((ScentCooldownProperty)p).getLastUseTime()).findFirst().orElseGet(() -> pokemon.getPersistentData().method_10537(NBT_SCENT_COOLDOWN));
    }

    public static float getHeartGauge(Pokemon pokemon) {
        int percent = PokemonAspectUtil.getHeartGaugeValue(pokemon);
        if (percent >= 0) {
            return (float)percent / 100.0f;
        }
        return PokemonAspectUtil.hasShadowAspect(pokemon) ? 1.0f : 0.0f;
    }

    public static int getHeartGaugeValue(Pokemon pokemon) {
        int max = HeartGaugeConfig.getMax(pokemon);
        int propertyValue = PokemonAspectUtil.getHeartGaugeValueFromProperty(pokemon);
        if (propertyValue >= 0) {
            int clamped = Math.max(0, Math.min(max, propertyValue));
            if (max <= 0) {
                return 0;
            }
            int percent = Math.round((float)clamped * 100.0f / (float)max);
            return Math.max(0, Math.min(100, percent));
        }
        if (pokemon.getPersistentData().method_10545(NBT_HEART_GAUGE)) {
            int nbtValue = pokemon.getPersistentData().method_10550(NBT_HEART_GAUGE);
            int clamped = Math.max(0, Math.min(max, nbtValue));
            if (max <= 0) {
                return 0;
            }
            int percent = Math.round((float)clamped * 100.0f / (float)max);
            return Math.max(0, Math.min(100, percent));
        }
        for (String a : new ArrayList(pokemon.getAspects())) {
            if (!a.startsWith(METER_PREFIX)) continue;
            try {
                String num = a.substring(METER_PREFIX.length());
                int parsed = Integer.parseInt(num);
                int clamped = Math.max(0, Math.min(max, parsed));
                if (max <= 0) {
                    return 0;
                }
                int percent = Math.round((float)clamped * 100.0f / (float)max);
                return Math.max(0, Math.min(100, percent));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1;
    }

    public static int getHeartGaugeMeter(Pokemon pokemon) {
        int max = HeartGaugeConfig.getMax(pokemon);
        int propertyValue = PokemonAspectUtil.getHeartGaugeValueFromProperty(pokemon);
        if (propertyValue >= 0) {
            return Math.max(0, Math.min(max, propertyValue));
        }
        if (pokemon.getPersistentData().method_10545(NBT_HEART_GAUGE)) {
            return Math.max(0, Math.min(max, pokemon.getPersistentData().method_10550(NBT_HEART_GAUGE)));
        }
        for (String a : new ArrayList(pokemon.getAspects())) {
            if (!a.startsWith(METER_PREFIX)) continue;
            try {
                String num = a.substring(METER_PREFIX.length());
                int parsed = Integer.parseInt(num);
                return Math.max(0, Math.min(max, parsed));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return PokemonAspectUtil.hasShadowAspect(pokemon) ? max : 0;
    }

    public static int getHeartGaugePercent(Pokemon pokemon) {
        int percent = PokemonAspectUtil.getHeartGaugeValue(pokemon);
        if (percent >= 0) {
            return percent;
        }
        return PokemonAspectUtil.hasShadowAspect(pokemon) ? 100 : 0;
    }

    public static int getBarsRemaining(Pokemon pokemon) {
        int p = Math.max(0, Math.min(100, PokemonAspectUtil.getHeartGaugePercent(pokemon)));
        if (p == 0) {
            return 0;
        }
        return (int)Math.ceil((double)p / 20.0);
    }

    public static boolean isNatureHiddenByGauge(Pokemon pokemon) {
        return PokemonAspectUtil.getBarsRemaining(pokemon) > 2;
    }

    public static boolean isLevelExpHiddenByGauge(Pokemon pokemon) {
        return PokemonAspectUtil.getBarsRemaining(pokemon) > 2;
    }

    public static boolean isEVHiddenByGauge(Pokemon pokemon) {
        return PokemonAspectUtil.getBarsRemaining(pokemon) > 2;
    }

    public static boolean isIVHiddenByGauge(Pokemon pokemon) {
        return PokemonAspectUtil.getBarsRemaining(pokemon) > 2;
    }

    public static int getAllowedVisibleNonShadowMoves(Pokemon pokemon) {
        int percent = Math.max(0, Math.min(100, PokemonAspectUtil.getHeartGaugePercent(pokemon)));
        if (percent == 0) {
            return 4;
        }
        if (percent <= 20) {
            return 3;
        }
        if (percent <= 40) {
            return 2;
        }
        if (percent < 80) {
            return 1;
        }
        return 0;
    }

    public static int getBufferedExp(Pokemon pokemon) {
        int propertyValue = PokemonAspectUtil.getXPBufferFromProperty(pokemon);
        if (propertyValue >= 0) {
            return propertyValue;
        }
        if (pokemon.getPersistentData().method_10545(NBT_XP_BUF)) {
            return Math.max(0, pokemon.getPersistentData().method_10550(NBT_XP_BUF));
        }
        for (String a : new ArrayList(pokemon.getAspects())) {
            if (!a.startsWith(XPBUF_PREFIX)) continue;
            try {
                String num = a.substring(XPBUF_PREFIX.length());
                long parsed = Long.parseLong(num);
                if (parsed < 0L) {
                    return 0;
                }
                return (int)Math.min(parsed, Integer.MAX_VALUE);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return 0;
    }

    public static void setBufferedExp(Pokemon pokemon, int amount) {
        PokemonAspectUtil.setXPBufferProperty(pokemon, Math.max(0, amount));
    }

    public static void addBufferedExp(Pokemon pokemon, int delta) {
        if (delta <= 0) {
            return;
        }
        int current = PokemonAspectUtil.getBufferedExp(pokemon);
        long sum = (long)current + (long)delta;
        PokemonAspectUtil.setBufferedExp(pokemon, (int)Math.min(sum, Integer.MAX_VALUE));
    }

    public static int[] getBufferedEvs(Pokemon pokemon) {
        int[] propertyValues = PokemonAspectUtil.getEVBufferFromProperty(pokemon);
        if (propertyValues != null) {
            return propertyValues;
        }
        if (pokemon.getPersistentData().method_10545(NBT_EV_BUF)) {
            return pokemon.getPersistentData().method_10561(NBT_EV_BUF);
        }
        for (String a : new ArrayList(pokemon.getAspects())) {
            if (!a.startsWith(EVBUF_PREFIX)) continue;
            try {
                String csv = a.substring(EVBUF_PREFIX.length());
                String[] parts = csv.split(",");
                int[] out = new int[]{0, 0, 0, 0, 0, 0};
                for (int i = 0; i < Math.min(parts.length, 6); ++i) {
                    int v = Integer.parseInt(parts[i]);
                    out[i] = Math.max(0, v);
                }
                return out;
            }
            catch (Exception exception) {
            }
        }
        return new int[]{0, 0, 0, 0, 0, 0};
    }

    public static void setBufferedEvs(Pokemon pokemon, int[] values) {
        if (values == null || values.length != 6) {
            values = new int[]{0, 0, 0, 0, 0, 0};
        }
        for (int i = 0; i < 6; ++i) {
            if (values[i] >= 0) continue;
            values[i] = 0;
        }
        PokemonAspectUtil.setEVBufferProperty(pokemon, values);
    }

    public static void addBufferedEv(Pokemon pokemon, Stat stat, int delta) {
        if (delta <= 0) {
            return;
        }
        int[] buf = PokemonAspectUtil.getBufferedEvs(pokemon);
        int idx = PokemonAspectUtil.statToIndex(stat);
        if (idx < 0) {
            return;
        }
        long sum = (long)buf[idx] + (long)delta;
        buf[idx] = (int)Math.min(sum, Integer.MAX_VALUE);
        PokemonAspectUtil.setBufferedEvs(pokemon, buf);
    }

    public static void clearAllBuffers(Pokemon pokemon) {
        PokemonAspectUtil.setBufferedExp(pokemon, 0);
        PokemonAspectUtil.setBufferedEvs(pokemon, new int[]{0, 0, 0, 0, 0, 0});
        pokemon.getPersistentData().method_10551(NBT_XP_BUF);
        pokemon.getPersistentData().method_10551(NBT_EV_BUF);
        HashSet aspectsCopy = new HashSet(pokemon.getAspects());
        boolean changed = false;
        Iterator it = aspectsCopy.iterator();
        while (it.hasNext()) {
            String a = (String)it.next();
            if (!a.startsWith(XPBUF_PREFIX) && !a.startsWith(EVBUF_PREFIX)) continue;
            it.remove();
            changed = true;
        }
        if (changed) {
            pokemon.setForcedAspects(aspectsCopy);
            pokemon.updateAspects();
            PokemonAspectUtil.syncAspects(pokemon);
        }
    }

    private static int statToIndex(Stat stat) {
        if (!(stat instanceof Stats)) {
            return -1;
        }
        Stats s = (Stats)stat;
        return switch (s) {
            case Stats.HP -> 0;
            case Stats.ATTACK -> 1;
            case Stats.DEFENCE -> 2;
            case Stats.SPECIAL_ATTACK -> 3;
            case Stats.SPECIAL_DEFENCE -> 4;
            case Stats.SPEED -> 5;
            default -> -1;
        };
    }

    private static void ensureShadowMaxIVs(Pokemon pokemon) {
        IShadowConfig config = ShadowedHeartsConfigs.getInstance().getShadowConfig();
        String mode = config.shadowIVMode();
        int perfectIVs = 0;
        if (mode.equalsIgnoreCase("FIXED")) {
            perfectIVs = config.shadowFixedPerfectIVs();
        } else if (mode.equalsIgnoreCase("SCALED")) {
            int maxHeartGauge = HeartGaugeConfig.getMax(pokemon);
            float normalized = Math.min(1.0f, (float)maxHeartGauge / (float)HeartGaugeConfig.getGlobalMax());
            perfectIVs = Math.round((float)class_3532.method_16436((double)normalized, (double)1.0, (double)config.shadowMaxPerfectIVs()));
        }
        if (perfectIVs > 0) {
            IVs ivs = pokemon.getIvs();
            ArrayList<Stats> stats = new ArrayList<Stats>(List.of(Stats.HP, Stats.ATTACK, Stats.DEFENCE, Stats.SPECIAL_ATTACK, Stats.SPECIAL_DEFENCE, Stats.SPEED));
            int currentMaxIVs = 0;
            for (Stats stat : stats) {
                if (ivs.get((Stat)stat) < 31) continue;
                ++currentMaxIVs;
            }
            if (currentMaxIVs < perfectIVs) {
                Random rng = new Random(pokemon.getUuid().getLeastSignificantBits());
                Collections.shuffle(stats, rng);
                for (Stats stat : stats) {
                    if (ivs.get((Stat)stat) < 31) {
                        ivs.set((Stat)stat, 31);
                        ++currentMaxIVs;
                    }
                    if (currentMaxIVs < perfectIVs) continue;
                    break;
                }
            }
        }
    }
}

