/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.ShadowService;
import com.jayemceekay.shadowedhearts.config.HeartGaugeConfig;
import com.jayemceekay.shadowedhearts.data.ShadowAspectPresets;
import com.jayemceekay.shadowedhearts.data.ShadowPools;
import com.jayemceekay.shadowedhearts.heart.HeartGaugeEvents;
import com.jayemceekay.shadowedhearts.server.AuraBroadcastQueue;
import com.jayemceekay.shadowedhearts.server.WildShadowSpawnListener;
import com.jayemceekay.shadowedhearts.storage.purification.PurificationChamberStore;
import com.jayemceekay.shadowedhearts.worldgen.CraterGenerator;
import com.jayemceekay.shadowedhearts.worldgen.ImpactScheduler;
import com.jayemceekay.shadowedhearts.worldgen.PlayerActivityHeatmap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5242;
import net.minecraft.class_5425;
import net.minecraft.class_5455;

public class ShadowCommands {
    public static void registerSubcommands(LiteralArgumentBuilder<class_2168> root) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"steps").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            class_3222 player;
            try {
                player = ((class_2168)ctx.getSource()).method_9207();
            }
            catch (Exception ex) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Must be a player to use this command"));
                return 0;
            }
            int count = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count");
            class_5455 reg = player.method_56673();
            PurificationChamberStore store = (PurificationChamberStore)Cobblemon.INSTANCE.getStorage().getCustomStore(PurificationChamberStore.class, player.method_5667(), reg);
            if (store == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Purification Chamber store not available for this player"));
                return 0;
            }
            store.advanceSteps(count);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Purification Chamber advanced by " + count + " step(s)")), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"partysteps").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            class_3222 player;
            try {
                player = ((class_2168)ctx.getSource()).method_9207();
            }
            catch (Exception ex) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Must be a player to use this command"));
                return 0;
            }
            int count = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count");
            int intervals = Math.max(0, count / 256);
            if (intervals <= 0) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("No party ticks from " + count + " step(s); need at least 256 for 1 tick.")), false);
                return 1;
            }
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            ArrayList<Pokemon> snapshot = new ArrayList<Pokemon>();
            for (Pokemon mon : party) {
                snapshot.add(mon);
            }
            int affected = 0;
            HashSet<Pokemon> affectedMons = new HashSet<Pokemon>();
            for (int i = 0; i < intervals; ++i) {
                for (Pokemon mon : snapshot) {
                    if (!PokemonAspectUtil.hasShadowAspect(mon)) continue;
                    HeartGaugeEvents.onPartyStep(mon, null, false);
                    affectedMons.add(mon);
                    ++affected;
                }
            }
            for (Pokemon mon : affectedMons) {
                ShadowService.syncAll(mon);
            }
            int affectedFinal = affected;
            int intervalsFinal = intervals;
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Applied " + intervalsFinal + " party step tick(s) (" + affectedFinal + " applications across shadow Pok\u00e9mon).")), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"npc").requires(src -> src.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tag").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection entities = class_2186.method_9317((CommandContext)ctx, (String)"targets");
            String tag = StringArgumentType.getString((CommandContext)ctx, (String)"tag");
            int applied = 0;
            for (class_1297 e : entities) {
                NPCEntity npc;
                if (!(e instanceof NPCEntity) || !(npc = (NPCEntity)e).method_5780(tag)) continue;
                ++applied;
            }
            int appliedFinal = applied;
            String tagFinal = tag;
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Added tag '" + tagFinal + "' to " + appliedFinal + " NPC(s).")), true);
            return appliedFinal;
        }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection entities = class_2186.method_9317((CommandContext)ctx, (String)"targets");
            String tag = StringArgumentType.getString((CommandContext)ctx, (String)"tag");
            int removed = 0;
            for (class_1297 e : entities) {
                NPCEntity npc;
                if (!(e instanceof NPCEntity) || !(npc = (NPCEntity)e).method_5738(tag)) continue;
                ++removed;
            }
            int removedFinal = removed;
            String tagFinal = tag;
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Removed tag '" + tagFinal + "' from " + removedFinal + " NPC(s).")), true);
            return removedFinal;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"preset").then(class_2170.method_9247((String)"define").then(class_2170.method_9244((String)"presetId", (ArgumentType)class_2232.method_9441()).then(class_2170.method_9244((String)"aspects", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            class_2960 presetId = class_2232.method_9443((CommandContext)ctx, (String)"presetId");
            String aspectsStr = StringArgumentType.getString((CommandContext)ctx, (String)"aspects");
            List<String> aspects = Arrays.stream(aspectsStr.split(" ")).filter(s -> !s.isBlank()).toList();
            if (aspects.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"At least one aspect must be provided."));
                return 0;
            }
            ShadowAspectPresets.savePreset(((class_2168)ctx.getSource()).method_9211(), presetId, aspects);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Defined and saved preset: " + String.valueOf(presetId) + " with " + aspects.size() + " aspects.")), true);
            return 1;
        }))))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"presetId", (ArgumentType)class_2232.method_9441()).executes(ctx -> {
            class_2960 presetId = class_2232.method_9443((CommandContext)ctx, (String)"presetId");
            ShadowAspectPresets.deletePreset(((class_2168)ctx.getSource()).method_9211(), presetId);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Deleted preset: " + String.valueOf(presetId))), true);
            return 1;
        })))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            Map<class_2960, List<String>> presets = ShadowAspectPresets.getRuntimePresets();
            if (presets.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"No runtime presets defined."), false);
            } else {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Runtime presets: " + String.join((CharSequence)", ", presets.keySet().stream().map(class_2960::toString).toList()))), false);
            }
            return presets.size();
        }))).then(class_2170.method_9247((String)"show").then(class_2170.method_9244((String)"presetId", (ArgumentType)class_2232.method_9441()).executes(ctx -> {
            class_2960 presetId = class_2232.method_9443((CommandContext)ctx, (String)"presetId");
            List<String> aspects = ShadowAspectPresets.get(((class_2168)ctx.getSource()).method_9211(), presetId);
            if (aspects.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Preset not found or empty: " + String.valueOf(presetId))));
                return 0;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Preset " + String.valueOf(presetId) + " aspects: " + String.join((CharSequence)", ", aspects))), false);
            return 1;
        })))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"presetId", (ArgumentType)class_2232.method_9441()).then(class_2170.method_9244((String)"aspects", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            class_2960 presetId = class_2232.method_9443((CommandContext)ctx, (String)"presetId");
            ArrayList<String> existing = new ArrayList<String>(ShadowAspectPresets.get(((class_2168)ctx.getSource()).method_9211(), presetId));
            String aspectsStr = StringArgumentType.getString((CommandContext)ctx, (String)"aspects");
            List<String> toAdd = Arrays.stream(aspectsStr.split(" ")).filter(s -> !s.isBlank()).toList();
            if (toAdd.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"At least one aspect must be provided."));
                return 0;
            }
            int addedCount = 0;
            for (String aspect : toAdd) {
                if (existing.contains(aspect)) continue;
                existing.add(aspect);
                ++addedCount;
            }
            if (addedCount == 0) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No new aspects were added (already present)."));
                return 0;
            }
            ShadowAspectPresets.savePreset(((class_2168)ctx.getSource()).method_9211(), presetId, existing);
            int finalAdded = addedCount;
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Added " + finalAdded + " aspect(s) to preset: " + String.valueOf(presetId))), true);
            return 1;
        }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"presetId", (ArgumentType)class_2232.method_9441()).then(class_2170.method_9244((String)"aspects", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            class_2960 presetId = class_2232.method_9443((CommandContext)ctx, (String)"presetId");
            ArrayList<String> existing = new ArrayList<String>(ShadowAspectPresets.get(((class_2168)ctx.getSource()).method_9211(), presetId));
            if (existing.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Preset not found or empty: " + String.valueOf(presetId))));
                return 0;
            }
            String aspectsStr = StringArgumentType.getString((CommandContext)ctx, (String)"aspects");
            List<String> toRemove = Arrays.stream(aspectsStr.split(" ")).filter(s -> !s.isBlank()).toList();
            if (toRemove.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"At least one aspect must be provided."));
                return 0;
            }
            int removedCount = 0;
            for (String aspect : toRemove) {
                if (!existing.remove(aspect)) continue;
                ++removedCount;
            }
            if (removedCount == 0) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No matching aspects were found to remove."));
                return 0;
            }
            ShadowAspectPresets.savePreset(((class_2168)ctx.getSource()).method_9211(), presetId, existing);
            int finalRemoved = removedCount;
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Removed " + finalRemoved + " aspect(s) from preset: " + String.valueOf(presetId))), true);
            return 1;
        }))))).then(class_2170.method_9247((String)"apply").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"presetId", (ArgumentType)class_2232.method_9441()).executes(ctx -> {
            Collection entities = class_2186.method_9317((CommandContext)ctx, (String)"targets");
            class_2960 presetId = class_2232.method_9443((CommandContext)ctx, (String)"presetId");
            String fullTag = "sh_shadow_presets/" + presetId.method_12836() + "/" + presetId.method_12832();
            int applied = 0;
            for (class_1297 e : entities) {
                NPCEntity npc;
                if (!(e instanceof NPCEntity) || !(npc = (NPCEntity)e).method_5780(fullTag)) continue;
                ++applied;
            }
            int appliedFinal = applied;
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Applied preset tag to " + appliedFinal + " NPC(s).")), true);
            return appliedFinal;
        })))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"shadowpool").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"define").then(class_2170.method_9244((String)"poolId", (ArgumentType)class_2232.method_9441()).then(class_2170.method_9244((String)"entries", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            class_2960 poolId = class_2232.method_9443((CommandContext)ctx, (String)"poolId");
            String entriesStr = StringArgumentType.getString((CommandContext)ctx, (String)"entries");
            String[] entryParts = entriesStr.split(",");
            ArrayList<ShadowPools.WeightedEntry> entries = new ArrayList<ShadowPools.WeightedEntry>();
            for (String part : entryParts) {
                if ((part = part.trim()).isEmpty()) continue;
                int weight = 1;
                String propsStr = part;
                if (part.contains("|")) {
                    String[] split = part.split("\\|");
                    propsStr = split[0].trim();
                    try {
                        weight = Integer.parseInt(split[1].trim());
                    }
                    catch (NumberFormatException e) {
                        ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid weight for entry: " + part)));
                        return 0;
                    }
                }
                try {
                    PokemonProperties props = PokemonProperties.Companion.parse(propsStr);
                    entries.add(new ShadowPools.WeightedEntry(props, weight));
                }
                catch (Exception e) {
                    ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid Pok\u00e9mon properties: " + propsStr)));
                    return 0;
                }
            }
            if (entries.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"At least one entry must be provided. Format: 'prop1|weight, prop2|weight'"));
                return 0;
            }
            ShadowPools.savePool(((class_2168)ctx.getSource()).method_9211(), poolId, entries);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Defined and saved shadow pool: " + String.valueOf(poolId) + " with " + entries.size() + " entries.")), true);
            return 1;
        }))))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"poolId", (ArgumentType)class_2232.method_9441()).executes(ctx -> {
            class_2960 poolId = class_2232.method_9443((CommandContext)ctx, (String)"poolId");
            ShadowPools.deletePool(((class_2168)ctx.getSource()).method_9211(), poolId);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Deleted shadow pool: " + String.valueOf(poolId))), true);
            return 1;
        })))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            Map<class_2960, List<ShadowPools.WeightedEntry>> pools = ShadowPools.getRuntimePools();
            if (pools.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"No runtime shadow pools defined."), false);
            } else {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Runtime shadow pools: " + String.join((CharSequence)", ", pools.keySet().stream().map(class_2960::toString).toList()))), false);
            }
            return pools.size();
        }))).then(class_2170.method_9247((String)"show").then(class_2170.method_9244((String)"poolId", (ArgumentType)class_2232.method_9441()).executes(ctx -> {
            class_2960 poolId = class_2232.method_9443((CommandContext)ctx, (String)"poolId");
            List<ShadowPools.WeightedEntry> entries = ShadowPools.get(((class_2168)ctx.getSource()).method_9211(), poolId);
            if (entries.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Pool not found or empty: " + String.valueOf(poolId))));
                return 0;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Shadow Pool " + String.valueOf(poolId) + " entries:")), false);
            for (ShadowPools.WeightedEntry entry : entries) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("- " + entry.props.toString() + " (weight: " + entry.weight + ")")), false);
            }
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"shadowify").requires(src -> src.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(ctx -> {
            class_1297 e = class_2186.method_9313((CommandContext)ctx, (String)"target");
            if (e instanceof PokemonEntity) {
                PokemonEntity pe = (PokemonEntity)e;
                Pokemon pk = pe.getPokemon();
                ShadowService.fullyCorrupt(pk, pe);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Shadowified " + pk.getSpecies().getName())), true);
                return 1;
            }
            if (e instanceof class_3222) {
                class_3222 player = (class_3222)e;
                PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
                int count = 0;
                for (Pokemon pk : party) {
                    ShadowService.fullyCorrupt(pk, null);
                    ++count;
                }
                int countFinal = count;
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Shadowified " + countFinal + " Pok\u00e9mon in " + player.method_5820() + "'s party")), true);
                return count;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Target must be a Pokemon entity or a player"));
            return 0;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)6)).executes(ctx -> {
            class_1297 e = class_2186.method_9313((CommandContext)ctx, (String)"target");
            int val = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot");
            if (e instanceof PokemonEntity) {
                PokemonEntity pe = (PokemonEntity)e;
                Pokemon pk = pe.getPokemon();
                ShadowService.corrupt(pk, pe, val);
                PokemonAspectUtil.ensureRequiredShadowAspects(pk);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Shadowified " + pk.getSpecies().getName() + " with heart gauge " + val)), true);
                return 1;
            }
            if (e instanceof class_3222) {
                class_3222 player = (class_3222)e;
                int slot = val - 1;
                PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
                Pokemon pk = party.get(slot);
                if (pk == null) {
                    ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No Pokemon in slot " + (slot + 1))));
                    return 0;
                }
                ShadowService.fullyCorrupt(pk, null);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Shadowified " + pk.getSpecies().getName() + " in " + player.method_5820() + "'s party")), true);
                return 1;
            }
            return 0;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            class_1297 e = class_2186.method_9313((CommandContext)ctx, (String)"target");
            if (!(e instanceof class_3222)) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Slot argument only applicable when targeting a player"));
                return 0;
            }
            class_3222 player = (class_3222)e;
            int slot = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot") - 1;
            int value = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Pokemon pk = party.get(slot);
            if (pk == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No Pokemon in slot " + (slot + 1))));
                return 0;
            }
            ShadowService.corrupt(pk, null, value);
            PokemonAspectUtil.ensureRequiredShadowAspects(pk);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Shadowified " + pk.getSpecies().getName() + " in " + player.method_5820() + "'s party with heart gauge " + value)), true);
            return 1;
        })))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            class_1297 e = class_2186.method_9313((CommandContext)ctx, (String)"target");
            int value = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            if (e instanceof PokemonEntity) {
                PokemonEntity pe = (PokemonEntity)e;
                Pokemon pk = pe.getPokemon();
                ShadowService.corrupt(pk, pe, value);
                PokemonAspectUtil.ensureRequiredShadowAspects(pk);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Shadowified " + pk.getSpecies().getName() + " with heart gauge " + value)), true);
                return 1;
            }
            if (e instanceof class_3222) {
                class_3222 player = (class_3222)e;
                PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
                int count = 0;
                for (Pokemon pk : party) {
                    ShadowService.corrupt(pk, null, value);
                    PokemonAspectUtil.ensureRequiredShadowAspects(pk);
                    ++count;
                }
                int countFinal = count;
                int valFinal = value;
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Shadowified " + countFinal + " Pok\u00e9mon in " + player.method_5820() + "'s party with heart gauge " + valFinal)), true);
                return count;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Target must be a Pokemon entity or a player"));
            return 0;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"purify").requires(src -> src.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(ctx -> {
            class_1297 e = class_2186.method_9313((CommandContext)ctx, (String)"target");
            if (e instanceof PokemonEntity) {
                PokemonEntity pe = (PokemonEntity)e;
                Pokemon pk = pe.getPokemon();
                ShadowService.fullyPurify(pk, pe);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Purified " + pk.getSpecies().getName())), true);
                return 1;
            }
            if (e instanceof class_3222) {
                class_3222 player = (class_3222)e;
                PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
                int count = 0;
                for (Pokemon pk : party) {
                    ShadowService.fullyPurify(pk, null);
                    ++count;
                }
                int countFinalPurify = count;
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Purified " + countFinalPurify + " Pok\u00e9mon in " + player.method_5820() + "'s party")), true);
                return count;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Target must be a Pokemon entity or a player"));
            return 0;
        })).then(class_2170.method_9244((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)6)).executes(ctx -> {
            class_1297 e = class_2186.method_9313((CommandContext)ctx, (String)"target");
            if (!(e instanceof class_3222)) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Slot argument only applicable when targeting a player"));
                return 0;
            }
            class_3222 player = (class_3222)e;
            int slot = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot") - 1;
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Pokemon pk = party.get(slot);
            if (pk == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No Pokemon in slot " + (slot + 1))));
                return 0;
            }
            ShadowService.fullyPurify(pk, null);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Purified " + pk.getSpecies().getName() + " in " + player.method_5820() + "'s party")), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"properties", (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(ctx -> {
            class_243 pos = ((class_2168)ctx.getSource()).method_9222();
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            class_2338 blockPos = class_2338.method_49638((class_2374)pos);
            if (!class_1937.method_25953((class_2338)blockPos)) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid position"));
                return 0;
            }
            PokemonProperties properties = PokemonPropertiesArgumentType.Companion.getPokemonProperties(ctx, "properties");
            if (!properties.hasSpecies()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No species specified"));
                return 0;
            }
            try {
                PokemonEntity pokemonEntity = properties.createEntity((class_1937)world, null);
                pokemonEntity.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, pokemonEntity.method_36454(), pokemonEntity.method_36455());
                pokemonEntity.method_5841().method_12778(PokemonEntity.Companion.getSPAWN_DIRECTION(), (Object)Float.valueOf(pokemonEntity.method_59922().method_43057() * 360.0f));
                pokemonEntity.method_5943((class_5425)world, world.method_8404(blockPos), class_3730.field_16462, null);
                if (world.method_8649((class_1297)pokemonEntity)) {
                    Pokemon pokemon = pokemonEntity.getPokemon();
                    ShadowService.setShadow(pokemon, pokemonEntity, true);
                    ShadowService.setHeartGauge(pokemon, pokemonEntity, HeartGaugeConfig.getMax(pokemon));
                    PokemonAspectUtil.ensureRequiredShadowAspects(pokemon);
                    WildShadowSpawnListener.assignShadowMoves(pokemon);
                    AuraBroadcastQueue.queueBroadcast((class_1297)pokemonEntity, 2.5f, 200);
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Spawned Shadow " + pokemon.getSpecies().getName())), true);
                    return 1;
                }
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Unable to spawn at the given position"));
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Failed to spawn: " + e.getMessage())));
                return 0;
            }
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"impact").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"force").executes(ctx -> {
            ImpactScheduler.attemptImpact(((class_2168)ctx.getSource()).method_9225());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Forced an impact attempt."), true);
            return 1;
        }))).then(class_2170.method_9247((String)"at").executes(ctx -> {
            CraterGenerator.generateCrater((class_1936)((class_2168)ctx.getSource()).method_9225(), class_2338.method_49638((class_2374)((class_2168)ctx.getSource()).method_9222()));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Generated crater at current position."), true);
            return 1;
        }))).then(class_2170.method_9247((String)"heatmap").executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            double activity = PlayerActivityHeatmap.getActivity(((class_2168)ctx.getSource()).method_9225(), player.method_31476().field_9181, player.method_31476().field_9180);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Current chunk activity: " + activity)), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"inspect").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(ctx -> {
            UUID uuid = class_5242.method_27645((CommandContext)ctx, (String)"uuid");
            class_3218 level = ((class_2168)ctx.getSource()).method_9225();
            class_1297 entity = level.method_14190(uuid);
            if (entity == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No entity found with UUID: " + String.valueOf(uuid))));
                return 0;
            }
            ShadowCommands.inspectEntity((class_2168)ctx.getSource(), entity);
            return 1;
        }))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)6)).executes(ctx -> {
            class_3222 player = class_2186.method_9315((CommandContext)ctx, (String)"target");
            int slot = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot") - 1;
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Pokemon pokemon = party.get(slot);
            if (pokemon == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No Pokemon found in slot " + (slot + 1) + " of " + player.method_5820() + "'s party.")));
                return 0;
            }
            ShadowCommands.inspectPokemon((class_2168)ctx.getSource(), pokemon);
            return 1;
        }))));
    }

    private static void inspectEntity(class_2168 source, class_1297 entity) {
        source.method_9226(() -> class_2561.method_43470((String)("--- Entity Inspection: " + entity.method_5477().getString() + " ---")), false);
        source.method_9226(() -> class_2561.method_43470((String)("UUID: " + String.valueOf(entity.method_5667()))), false);
        source.method_9226(() -> class_2561.method_43470((String)("Type: " + entity.method_5864().method_5897().getString())), false);
        if (entity instanceof PokemonEntity) {
            PokemonEntity pe = (PokemonEntity)entity;
            Pokemon pk = pe.getPokemon();
            ShadowCommands.outputPokemonData(source, pk);
        }
        class_2487 nbt = entity.method_5647(new class_2487());
        source.method_9226(() -> class_2561.method_43470((String)"--- NBT Data ---"), false);
        source.method_9226(() -> class_2561.method_43470((String)nbt.toString()), false);
    }

    private static void inspectPokemon(class_2168 source, Pokemon pokemon) {
        source.method_9226(() -> class_2561.method_43470((String)("--- Pokemon Inspection: " + pokemon.getDisplayName(false).getString() + " ---")), false);
        source.method_9226(() -> class_2561.method_43470((String)("UUID: " + String.valueOf(pokemon.getUuid()))), false);
        ShadowCommands.outputPokemonData(source, pokemon);
        class_2487 nbt = pokemon.saveToNBT(source.method_30497(), new class_2487());
        source.method_9226(() -> class_2561.method_43470((String)"--- NBT Data ---"), false);
        source.method_9226(() -> class_2561.method_43470((String)nbt.toString()), false);
    }

    private static void outputPokemonData(class_2168 source, Pokemon pk) {
        source.method_9226(() -> class_2561.method_43470((String)"--- Pokemon Data ---"), false);
        source.method_9226(() -> class_2561.method_43470((String)("Species: " + pk.getSpecies().getName())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Aspects: " + String.valueOf(pk.getAspects()))), false);
        source.method_9226(() -> class_2561.method_43470((String)("Heart Gauge: " + PokemonAspectUtil.getHeartGaugePercent(pk) + "% (" + PokemonAspectUtil.getHeartGaugeMeter(pk) + "/" + HeartGaugeConfig.getMax(pk) + ")")), false);
        source.method_9226(() -> class_2561.method_43470((String)("Buffered EXP: " + PokemonAspectUtil.getBufferedExp(pk))), false);
        source.method_9226(() -> class_2561.method_43470((String)("Buffered EVs: " + Arrays.toString(PokemonAspectUtil.getBufferedEvs(pk)))), false);
    }
}

