/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts;

import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.pokemon.experience.ExperienceSource;
import com.cobblemon.mod.common.api.pokemon.experience.SidemodExperienceSource;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.ShadowGate;
import com.jayemceekay.shadowedhearts.ShadowPokemonData;
import com.jayemceekay.shadowedhearts.config.HeartGaugeConfig;
import com.jayemceekay.shadowedhearts.pokemon.properties.EVBufferProperty;
import com.jayemceekay.shadowedhearts.pokemon.properties.HeartGaugeProperty;
import com.jayemceekay.shadowedhearts.pokemon.properties.XPBufferProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public final class ShadowService {
    public static void setShadow(Pokemon pokemon, @Nullable PokemonEntity live, boolean shadow) {
        ShadowService.setShadow(pokemon, live, shadow, true);
    }

    public static void setShadow(Pokemon pokemon, @Nullable PokemonEntity live, boolean shadow, boolean sync) {
        PokemonAspectUtil.setShadowAspect(pokemon, shadow, sync);
        PokemonAspectUtil.ensureRequiredShadowAspects(pokemon);
        if (live != null) {
            ShadowPokemonData.set(live, shadow, PokemonAspectUtil.getHeartGauge(pokemon));
        }
        if (sync) {
            PokemonAspectUtil.syncAspects(pokemon);
            PokemonAspectUtil.syncBenchedMoves(pokemon);
            PokemonAspectUtil.syncMoveSet(pokemon);
        }
    }

    public static void setHeartGauge(Pokemon pokemon, @Nullable PokemonEntity live, int meter) {
        ShadowService.setHeartGauge(pokemon, live, meter, true);
    }

    public static void setHeartGauge(Pokemon pokemon, @Nullable PokemonEntity live, int meter, boolean sync) {
        int max = HeartGaugeConfig.getMax(pokemon);
        int clamped = Math.max(0, Math.min(max, meter));
        PokemonAspectUtil.setHeartGaugeValue(pokemon, clamped, sync);
        PokemonAspectUtil.ensureRequiredShadowAspects(pokemon);
        if (live != null) {
            ShadowPokemonData.set(live, ShadowPokemonData.isShadow(live), PokemonAspectUtil.getHeartGauge(pokemon));
        }
        ShadowService.applyMoveUnlocks(pokemon);
        if (sync) {
            PokemonAspectUtil.syncAspects(pokemon);
            PokemonAspectUtil.syncBenchedMoves(pokemon);
            PokemonAspectUtil.syncMoveSet(pokemon);
        }
    }

    public static void syncAll(Pokemon pokemon) {
        PokemonAspectUtil.syncAspects(pokemon);
        PokemonAspectUtil.syncProperties(pokemon);
        PokemonAspectUtil.syncBenchedMoves(pokemon);
        PokemonAspectUtil.syncMoveSet(pokemon);
    }

    /*
     * WARNING - void declaration
     */
    private static void applyMoveUnlocks(Pokemon pokemon) {
        void var7_14;
        if (!ShadowGate.isShadowLocked(pokemon)) {
            return;
        }
        int allowed = PokemonAspectUtil.getAllowedVisibleNonShadowMoves(pokemon);
        if (allowed < 1) {
            return;
        }
        ArrayList<Move> shadowMoves = new ArrayList<Move>();
        for (Move move : pokemon.getMoveSet()) {
            if (move == null || !ShadowGate.isShadowMoveId(move.getName())) continue;
            shadowMoves.add(move);
        }
        if (shadowMoves.isEmpty()) {
            return;
        }
        ArrayList levelUpMoves = new ArrayList(pokemon.getForm().getMoves().getLevelUpMovesUpTo(pokemon.getLevel()));
        Collections.reverse(levelUpMoves);
        HashSet<String> currentMoveNames = new HashSet<String>();
        for (Object m : pokemon.getMoveSet()) {
            if (m == null) continue;
            currentMoveNames.add(m.getTemplate().getName());
        }
        ArrayList<BenchedMove> benchedSnapshot = new ArrayList<BenchedMove>();
        for (BenchedMove benchedMove : pokemon.getBenchedMoves()) {
            benchedSnapshot.add(benchedMove);
        }
        for (BenchedMove benchedMove : benchedSnapshot) {
            currentMoveNames.add(benchedMove.getMoveTemplate().getName());
        }
        ArrayList<MoveTemplate> candidates = new ArrayList<MoveTemplate>();
        for (MoveTemplate template : levelUpMoves) {
            if (currentMoveNames.contains(template.getName())) continue;
            candidates.add(template);
        }
        if (candidates.isEmpty()) {
            return;
        }
        boolean bl = false;
        if (allowed >= 4) {
            int n = 4;
        } else if (allowed >= 3) {
            boolean bl2 = true;
        }
        if (var7_14 <= 0) {
            return;
        }
        int toReplace = Math.min(Math.min(shadowMoves.size(), candidates.size()), (int)var7_14);
        for (int i = 0; i < toReplace; ++i) {
            Move shadowMove = (Move)shadowMoves.get(i);
            MoveTemplate newMoveTemplate = (MoveTemplate)candidates.get(i);
            if (!pokemon.exchangeMove(shadowMove.getTemplate(), newMoveTemplate)) continue;
            pokemon.getBenchedMoves().remove(shadowMove.getTemplate());
        }
    }

    public static void fullyPurify(Pokemon pokemon, @Nullable PokemonEntity live) {
        ShadowService.restoreAllMoves(pokemon);
        HashSet aspects = new HashSet(pokemon.getAspects());
        aspects.remove("shadowedhearts:shadow");
        aspects.remove("shadowedhearts:hyper_mode");
        aspects.remove("shadowedhearts:reverse_mode");
        pokemon.setForcedAspects(aspects);
        pokemon.updateAspects();
        int bufferedExp = PokemonAspectUtil.getBufferedExp(pokemon);
        if (bufferedExp > 0) {
            pokemon.addExperience((ExperienceSource)new SidemodExperienceSource("shadowedhearts"), bufferedExp);
        }
        int[] bufferedEvs = PokemonAspectUtil.getBufferedEvs(pokemon);
        Stats[] stats = new Stats[]{Stats.HP, Stats.ATTACK, Stats.DEFENCE, Stats.SPECIAL_ATTACK, Stats.SPECIAL_DEFENCE, Stats.SPEED};
        for (int i = 0; i < 6; ++i) {
            if (bufferedEvs[i] <= 0) continue;
            pokemon.getEvs().add((Stat)stats[i], bufferedEvs[i]);
        }
        pokemon.getCustomProperties().removeIf(p -> p instanceof HeartGaugeProperty || p instanceof XPBufferProperty || p instanceof EVBufferProperty);
        pokemon.getPersistentData().method_10551("shadowedhearts:heartgauge");
        pokemon.getPersistentData().method_10551("shadowedhearts:xpbuf");
        pokemon.getPersistentData().method_10551("shadowedhearts:evbuf");
        if (live != null) {
            ShadowPokemonData.set(live, false, 0.0f);
        }
        ShadowService.syncAll(pokemon);
    }

    private static void restoreAllMoves(Pokemon pokemon) {
        ArrayList<Move> shadowMoves = new ArrayList<Move>();
        for (Move move : pokemon.getMoveSet()) {
            if (move == null || !ShadowGate.isShadowMoveId(move.getName())) continue;
            shadowMoves.add(move);
        }
        ArrayList levelUpMoves = new ArrayList(pokemon.getForm().getMoves().getLevelUpMovesUpTo(pokemon.getLevel()));
        Collections.reverse(levelUpMoves);
        HashSet<String> currentMoveNames = new HashSet<String>();
        for (int i = 0; i < 4; ++i) {
            Move m = (Move)pokemon.getMoveSet().getMovesWithNulls().get(i);
            if (m == null) continue;
            currentMoveNames.add(m.getTemplate().getName());
        }
        ArrayList<BenchedMove> benchedSnapshotRestore = new ArrayList<BenchedMove>();
        for (Object bm : pokemon.getBenchedMoves()) {
            benchedSnapshotRestore.add((BenchedMove)bm);
        }
        ArrayList<MoveTemplate> candidates = new ArrayList<MoveTemplate>();
        for (MoveTemplate template : levelUpMoves) {
            if (currentMoveNames.contains(template.getName())) continue;
            candidates.add(template);
        }
        int toReplace = Math.min(shadowMoves.size(), candidates.size());
        for (int i = 0; i < toReplace; ++i) {
            pokemon.exchangeMove(((Move)shadowMoves.get(i)).getTemplate(), (MoveTemplate)candidates.get(i));
        }
        ArrayList<BenchedMove> snapshot = new ArrayList<BenchedMove>();
        for (BenchedMove bm : pokemon.getBenchedMoves()) {
            snapshot.add(bm);
        }
        for (BenchedMove bm : snapshot) {
            if (!ShadowGate.isShadowMoveId(bm.getMoveTemplate().getName())) continue;
            pokemon.getBenchedMoves().remove(bm.getMoveTemplate());
        }
    }

    public static void corrupt(Pokemon pokemon, @Nullable PokemonEntity live, int value) {
        ShadowService.corrupt(pokemon, live, value, true);
    }

    public static void corrupt(Pokemon pokemon, @Nullable PokemonEntity live, int value, boolean sync) {
        ShadowService.setShadow(pokemon, live, true, sync);
        ShadowService.setHeartGauge(pokemon, live, value, sync);
    }

    public static void fullyCorrupt(Pokemon pokemon, @Nullable PokemonEntity live) {
        ShadowService.fullyCorrupt(pokemon, live, true);
    }

    public static void fullyCorrupt(Pokemon pokemon, @Nullable PokemonEntity live, boolean sync) {
        ShadowService.corrupt(pokemon, live, HeartGaugeConfig.getMax(pokemon), sync);
    }
}

