/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.api.pokeball.catching;

import com.cobblemon.mod.common.api.pokeball.catching.CatchRateModifier;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.config.HeartGaugeConfig;
import com.jayemceekay.shadowedhearts.config.IShadowConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class ShadowCatchRateModifier
implements CatchRateModifier {
    public float value(@NotNull class_1309 thrower, @NotNull Pokemon pokemon) {
        if (!pokemon.getAspects().contains("shadowedhearts:shadow")) {
            return 1.0f;
        }
        IShadowConfig config = ShadowedHeartsConfigs.getInstance().getShadowConfig();
        if (!config.shadowCatchRateScaleEnabled()) {
            return 1.0f;
        }
        int maxHeartGauge = HeartGaugeConfig.getMax(pokemon);
        if (maxHeartGauge <= 0) {
            return 1.0f;
        }
        float normalized = Math.min(1.0f, (float)maxHeartGauge / (float)HeartGaugeConfig.getGlobalMax());
        double minMultiplier = config.shadowCatchRateMinMultiplier();
        double exponent = config.shadowCatchRateExponent();
        return (float)class_3532.method_16436((double)Math.pow(normalized, exponent), (double)1.0, (double)minMultiplier);
    }

    @NotNull
    public CatchRateModifier.Behavior behavior(@NotNull class_1309 thrower, @NotNull Pokemon pokemon) {
        return CatchRateModifier.Behavior.MULTIPLY;
    }

    public boolean isValid(@NotNull class_1309 thrower, @NotNull Pokemon pokemon) {
        return pokemon.getAspects().contains("shadowedhearts:shadow") && ShadowedHeartsConfigs.getInstance().getShadowConfig().shadowCatchRateScaleEnabled();
    }

    public float modifyCatchRate(float currentCatchRate, @NotNull class_1309 thrower, @NotNull Pokemon pokemon) {
        if (this.isValid(thrower, pokemon)) {
            return currentCatchRate * this.value(thrower, pokemon);
        }
        return currentCatchRate;
    }
}

