/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.aura;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.jayemceekay.shadowedhearts.aura.AuraReaderCharge;
import com.jayemceekay.shadowedhearts.config.ISnagConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.core.ModItemComponents;
import com.jayemceekay.shadowedhearts.integration.accessories.SnagAccessoryBridgeHolder;
import com.jayemceekay.shadowedhearts.network.AuraScannerS2CPacket;
import com.jayemceekay.shadowedhearts.network.ShadowedHeartsNetwork;
import dev.architectury.event.events.common.TickEvent;
import java.util.List;
import kotlin.Unit;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9331;

public final class AuraReaderEvents {
    private AuraReaderEvents() {
    }

    public static void init() {
        TickEvent.PLAYER_POST.register(AuraReaderEvents::onPlayerPostTick);
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, e -> {
            ISnagConfig cfg = ShadowedHeartsConfigs.getInstance().getSnagConfig();
            if (!cfg.auraReaderRechargeOnVictory()) {
                return Unit.INSTANCE;
            }
            PokemonBattle battle = e.getBattle();
            if (battle == null) {
                return Unit.INSTANCE;
            }
            if (battle.isPvP() && !cfg.auraReaderRechargeInPvp()) {
                return Unit.INSTANCE;
            }
            int nonPlayerActorCount = 0;
            int levelSum = 0;
            int levelCount = 0;
            for (BattleActor loser : e.getLosers()) {
                if (loser == null || loser.getType() == ActorType.PLAYER) continue;
                ++nonPlayerActorCount;
                List list = loser.getPokemonList();
                if (list == null) continue;
                for (BattlePokemon bp : list) {
                    if (bp == null) continue;
                    try {
                        int lvl = bp.getEffectedPokemon().getLevel();
                        if (lvl <= 0) continue;
                        levelSum += lvl;
                        ++levelCount;
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (nonPlayerActorCount <= 0 && !battle.isPvP()) {
                return Unit.INSTANCE;
            }
            double avgLevel = levelCount > 0 ? (double)levelSum / (double)levelCount : 1.0;
            double raw = (double)cfg.auraReaderRechargeBase() + avgLevel * cfg.auraReaderRechargePerLevel() + (double)(nonPlayerActorCount * cfg.auraReaderRechargePerNpc());
            int award = (int)Math.round(raw);
            award = Math.max(cfg.auraReaderRechargeMin(), Math.min(award, cfg.auraReaderRechargeMax()));
            if (award <= 0) {
                return Unit.INSTANCE;
            }
            for (BattleActor winner : e.getWinners()) {
                class_1799 auraReader;
                PlayerBattleActor pba;
                class_3222 sp;
                if (winner == null || winner.getType() != ActorType.PLAYER || !(winner instanceof PlayerBattleActor) || (sp = (pba = (PlayerBattleActor)winner).getEntity()) == null || (auraReader = SnagAccessoryBridgeHolder.INSTANCE.getAuraReaderStack((class_1657)sp)).method_7960()) continue;
                int before = AuraReaderCharge.get(auraReader);
                AuraReaderCharge.add(auraReader, award, 12000);
                int after = AuraReaderCharge.get(auraReader);
                int gained = Math.max(0, after - before);
                if (gained <= 0) continue;
                sp.method_43496((class_2561)class_2561.method_43469((String)"message.shadowedhearts.aura_reader.recharged", (Object[])new Object[]{gained, after}));
            }
            return Unit.INSTANCE;
        });
    }

    private static void onPlayerPostTick(class_1657 player) {
        if (player == null || player.method_37908().field_9236) {
            return;
        }
        class_1799 auraReader = SnagAccessoryBridgeHolder.INSTANCE.getAuraReaderStack(player);
        if (!auraReader.method_7960()) {
            AuraReaderEvents.tickAuraReader(player, auraReader);
        }
    }

    private static void tickAuraReader(class_1657 player, class_1799 stack) {
        boolean hasCharge;
        Boolean active = (Boolean)stack.method_57824((class_9331)ModItemComponents.AURA_SCANNER_ACTIVE.get());
        if (active != null && active.booleanValue() && !(hasCharge = AuraReaderCharge.consume(stack, 1, 12000))) {
            stack.method_57379((class_9331)ModItemComponents.AURA_SCANNER_ACTIVE.get(), (Object)false);
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                ShadowedHeartsNetwork.sendToPlayer(sp, new AuraScannerS2CPacket(false));
            }
        }
    }
}

