/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.blocks;

import com.cobblemon.mod.common.api.mark.Mark;
import com.cobblemon.mod.common.api.mark.Marks;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.ShadowService;
import com.jayemceekay.shadowedhearts.advancements.ModCriteriaTriggers;
import com.jayemceekay.shadowedhearts.blocks.entity.RelicStoneBlockEntity;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.core.ModBlockEntities;
import com.jayemceekay.shadowedhearts.core.ModItems;
import com.jayemceekay.shadowedhearts.network.RelicStoneMotePacket;
import com.jayemceekay.shadowedhearts.util.PlayerPersistentData;
import com.jayemceekay.shadowedhearts.util.ShadowedHeartsPlayerData;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelicStoneBlock
extends class_2248
implements class_2343 {
    public static final class_2758 PART = class_2758.method_11867((String)"part", (int)0, (int)8);
    public static final class_2758 LAYER = class_2758.method_11867((String)"layer", (int)0, (int)2);
    public static final class_2746 HAS_BE = class_2746.method_11825((String)"has_be");
    private static final int CENTER_PART = 4;
    private static final int[][] OFFSETS = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {0, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}};
    private static final double TOTAL_HEIGHT = 42.0;
    private static final double TOP_LAYER_HEIGHT = 10.0;
    private static final class_265 OUTLINE_CENTER = class_2248.method_9541((double)-8.0, (double)0.0, (double)-8.0, (double)24.0, (double)42.0, (double)24.0);

    public RelicStoneBlock(class_4970.class_2251 props) {
        super(props);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)PART, (Comparable)Integer.valueOf(4))).method_11657((class_2769)LAYER, (Comparable)Integer.valueOf(0))).method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PART, LAYER, HAS_BE});
    }

    private static boolean isCenter(class_2680 state) {
        return (Integer)state.method_11654((class_2769)PART) == 4 && (Integer)state.method_11654((class_2769)LAYER) == 0;
    }

    private static class_2338 getCenterPos(class_2338 pos, class_2680 state) {
        int part = (Integer)state.method_11654((class_2769)PART);
        int layer = (Integer)state.method_11654((class_2769)LAYER);
        int dx = OFFSETS[part][0];
        int dz = OFFSETS[part][1];
        return pos.method_10069(-dx, -layer, -dz);
    }

    public boolean method_9592(class_2680 state, class_1937 level, class_2338 pos, int id, int param) {
        super.method_9592(state, level, pos, id, param);
        class_2586 blockEntity = level.method_8321(pos);
        return blockEntity != null && blockEntity.method_11004(id, param);
    }

    private static double layerHeight(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LAYER) == 2 ? 10.0 : 16.0;
    }

    private static class_265 westHalf(double h) {
        return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)h, (double)16.0);
    }

    private static class_265 eastHalf(double h) {
        return class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)h, (double)16.0);
    }

    private static class_265 northHalf(double h) {
        return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)h, (double)8.0);
    }

    private static class_265 southHalf(double h) {
        return class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)h, (double)16.0);
    }

    private static class_265 nwQuarter(double h) {
        return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)h, (double)8.0);
    }

    private static class_265 neQuarter(double h) {
        return class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)h, (double)8.0);
    }

    private static class_265 swQuarter(double h) {
        return class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)h, (double)16.0);
    }

    private static class_265 seQuarter(double h) {
        return class_2248.method_9541((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)h, (double)16.0);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_1937 level = ctx.method_8045();
        class_2338 center = ctx.method_8037();
        for (int layer = 0; layer <= 2; ++layer) {
            for (int part = 0; part < 9; ++part) {
                class_2338 p = center.method_10069(OFFSETS[part][0], layer, OFFSETS[part][1]);
                if (level.method_8320(p).method_26166(ctx)) continue;
                return null;
            }
        }
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)PART, (Comparable)Integer.valueOf(4))).method_11657((class_2769)LAYER, (Comparable)Integer.valueOf(0))).method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(true));
    }

    public void method_9567(class_1937 level, class_2338 center, class_2680 state, class_1309 placer, class_1799 stack) {
        if (!RelicStoneBlock.isCenter(state)) {
            return;
        }
        for (int layer = 0; layer <= 2; ++layer) {
            for (int part = 0; part < 9; ++part) {
                if (layer == 0 && part == 4) continue;
                class_2338 p = center.method_10069(OFFSETS[part][0], layer, OFFSETS[part][1]);
                level.method_8652(p, (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)PART, (Comparable)Integer.valueOf(part))).method_11657((class_2769)LAYER, (Comparable)Integer.valueOf(layer))).method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    private void removeAllParts(class_1937 level, class_2338 center) {
        for (int layer = 0; layer <= 2; ++layer) {
            for (int part = 0; part < 9; ++part) {
                class_2338 p = center.method_10069(OFFSETS[part][0], layer, OFFSETS[part][1]);
                if (level.method_8320(p).method_26204() != this) continue;
                level.method_8652(p, class_2246.field_10124.method_9564(), 3);
            }
        }
    }

    @NotNull
    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!level.field_9236) {
            class_2338 center = RelicStoneBlock.getCenterPos(pos, state);
            if (!pos.equals((Object)center)) {
                level.method_8651(center, true, (class_1297)player);
            } else {
                this.removeAllParts(level, center);
            }
        }
        super.method_9576(level, pos, state, player);
        return state;
    }

    private void checkAndFixBroken(class_2680 state, class_1937 level, class_2338 pos) {
        if (!level.field_9236 && RelicStoneBlock.isCenter(state)) {
            if (level.method_8321(pos) == null) {
                level.method_8438((class_2586)new RelicStoneBlockEntity(pos, (class_2680)state.method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(true))));
            }
            if (!((Boolean)state.method_11654((class_2769)HAS_BE)).booleanValue()) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, level, pos, oldState, isMoving);
        this.checkAndFixBroken(state, level, pos);
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.method_9612(state, level, pos, block, fromPos, isMoving);
        this.checkAndFixBroken(state, level, pos);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!level.field_9236 && !state.method_27852(newState.method_26204())) {
            class_2338 center = RelicStoneBlock.getCenterPos(pos, state);
            this.removeAllParts(level, center);
            RelicStoneMotePacket stopPacket = new RelicStoneMotePacket(center, true);
            ((class_3218)level).method_18456().forEach(player -> {
                if (player.method_5649((double)center.method_10263() + 0.5, (double)center.method_10264() + 0.5, (double)center.method_10260() + 0.5) < 1024.0) {
                    stopPacket.sendToPlayer((class_3222)player);
                }
            });
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    @NotNull
    public class_2464 method_9604(class_2680 state) {
        return RelicStoneBlock.isCenter(state) ? class_2464.field_11458 : class_2464.field_11455;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return RelicStoneBlock.isCenter(state) ? OUTLINE_CENTER : class_259.method_1073();
    }

    @NotNull
    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        double h = RelicStoneBlock.layerHeight(state);
        int part = (Integer)state.method_11654((class_2769)PART);
        if (part == 4) {
            return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)h, (double)16.0);
        }
        return switch (part) {
            case 3 -> RelicStoneBlock.eastHalf(h);
            case 5 -> RelicStoneBlock.westHalf(h);
            case 1 -> RelicStoneBlock.southHalf(h);
            case 7 -> RelicStoneBlock.northHalf(h);
            case 0 -> RelicStoneBlock.seQuarter(h);
            case 2 -> RelicStoneBlock.swQuarter(h);
            case 6 -> RelicStoneBlock.neQuarter(h);
            case 8 -> RelicStoneBlock.nwQuarter(h);
            default -> class_259.method_1073();
        };
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new RelicStoneBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return type == ModBlockEntities.RELIC_STONE_BE.get() ? RelicStoneBlockEntity::tick : null;
    }

    @NotNull
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 params) {
        return RelicStoneBlock.isCenter(state) ? super.method_9560(state, params) : List.of();
    }

    @NotNull
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2338 center = RelicStoneBlock.getCenterPos(pos, state);
        class_2680 centerState = level.method_8320(center);
        if (centerState.method_27852((class_2248)this)) {
            this.checkAndFixBroken(centerState, level, center);
        }
        if (stack.method_31574((class_1792)ModItems.SHADOW_SHARD.get()) && stack.method_7947() >= 8) {
            if (!level.field_9236) {
                stack.method_7934(8);
                class_1799 gem = new class_1799((class_1935)ModItems.PURIFIED_GEM.get());
                if (!player.method_31548().method_7394(gem)) {
                    player.method_7328(gem, false);
                }
                level.method_8396(null, center, class_3417.field_26980, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_9062.method_55644((boolean)level.field_9236);
        }
        return super.method_55765(stack, state, level, pos, player, hand, hit);
    }

    @NotNull
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
        class_3222 serverPlayer;
        class_2338 center = RelicStoneBlock.getCenterPos(pos, state);
        class_2680 centerState = level.method_8320(center);
        if (centerState.method_27852((class_2248)this)) {
            this.checkAndFixBroken(centerState, level, center);
        }
        if (player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            ModCriteriaTriggers.triggerRelicStoneInteract(serverPlayer);
        }
        if (level.field_9236) {
            return class_1269.field_5811;
        }
        if (player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            long now = level.method_8510();
            long cooldownTicks = (long)ShadowedHeartsConfigs.getInstance().getShadowConfig().relicStoneCooldownMinutes() * 60L * 20L;
            ShadowedHeartsPlayerData data = PlayerPersistentData.get(serverPlayer);
            long lastPurify = data.getLastRelicStonePurify();
            if (now - lastPurify < cooldownTicks && lastPurify != 0L) {
                long remainingTicks = cooldownTicks - (now - lastPurify);
                long remainingSeconds = remainingTicks / 20L;
                long minutes = remainingSeconds / 60L;
                long seconds = remainingSeconds % 60L;
                serverPlayer.method_7353((class_2561)class_2561.method_43469((String)"message.shadowedhearts.relic_stone.cooldown", (Object[])new Object[]{minutes, seconds}).method_27692(class_124.field_1061), true);
                return class_1269.field_5812;
            }
            class_238 area = new class_238(center).method_1014(5.0);
            List nearbyPokemon = level.method_8390(PokemonEntity.class, area, pe -> {
                Pokemon p = pe.getPokemon();
                return serverPlayer.method_5667().equals(p.getOwnerUUID()) && PokemonAspectUtil.hasShadowAspect(p);
            });
            boolean purifiedAny = false;
            for (PokemonEntity pe2 : nearbyPokemon) {
                Pokemon p = pe2.getPokemon();
                if (PokemonAspectUtil.getHeartGaugePercent(p) != 0) continue;
                ShadowService.fullyPurify(p, pe2);
                Mark nationalRibbon = Marks.getByIdentifier((class_2960)class_2960.method_60655((String)"cobblemon", (String)"ribbon_event_national"));
                p.exchangeMark(nationalRibbon, true);
                class_3222 class_32222 = p.getOwnerPlayer();
                if (class_32222 instanceof class_3222) {
                    class_3222 serverPlayer1 = class_32222;
                    ModCriteriaTriggers.triggerShadowPurified(serverPlayer1);
                }
                purifiedAny = true;
                serverPlayer.method_7353((class_2561)class_2561.method_43469((String)"message.shadowedhearts.relic_stone.purified", (Object[])new Object[]{p.getDisplayName(false)}).method_27692(class_124.field_1060), false);
            }
            if (purifiedAny) {
                PlayerPersistentData.get(serverPlayer).setLastRelicStonePurify(now);
                level.method_8396(null, center, class_3417.field_26980, class_3419.field_15245, 1.0f, 1.0f);
            } else {
                if (nearbyPokemon.isEmpty()) {
                    serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"message.shadowedhearts.relic_stone.no_pokemon"), true);
                    return class_1269.field_5812;
                }
                serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"message.shadowedhearts.relic_stone.not_ready"), true);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5812;
    }
}

