/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.aura;

import com.cobblemon.mod.common.client.gui.summary.widgets.ModelWidget;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.cobblemon.mod.common.util.math.QuaternionUtilsKt;
import com.jayemceekay.shadowedhearts.client.ModShaders;
import com.jayemceekay.shadowedhearts.client.ShadowFogUniforms;
import com.jayemceekay.shadowedhearts.client.aura.ShadowAuraSoundInstance;
import com.jayemceekay.shadowedhearts.client.render.AuraRenderTypes;
import com.jayemceekay.shadowedhearts.client.render.geom.CylinderBuffers;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.network.AuraLifecyclePacket;
import com.jayemceekay.shadowedhearts.network.AuraStatePacket;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_284;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5944;
import net.minecraft.class_9799;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class AuraEmitters {
    public static class_4597.class_4598 buffersSummary = class_4597.method_22991((class_9799)new class_9799(786432));
    public static class_4597.class_4598 buffersPC = class_4597.method_22991((class_9799)new class_9799(786432));
    public static class_4597.class_4598 buffersPurification = class_4597.method_22991((class_9799)new class_9799(786432));
    public static class_4597.class_4598 buffersOverworld = class_4597.method_22991((class_9799)new class_9799(786432));
    private static final Map<Integer, AuraInstance> ACTIVE = new ConcurrentHashMap<Integer, AuraInstance>();
    private static final int FADE_IN = 10;
    private static final int SUSTAIN = 60;
    private static final int FADE_OUT = 10;
    private static final double TELEPORT_SNAP_DIST2 = 36.0;

    private AuraEmitters() {
    }

    public static void receiveState(AuraStatePacket pkt) {
        double ddz;
        double ddy;
        UUID curUuid;
        if (!ShadowedHeartsConfigs.getInstance().getClientConfig().enableShadowAura()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        AuraInstance inst = ACTIVE.getOrDefault(pkt.getEntityId(), null);
        if (inst == null) {
            return;
        }
        class_1297 cur = mc.field_1687.method_8469(pkt.getEntityId());
        UUID uUID = curUuid = cur != null ? cur.method_5667() : null;
        if (inst.entityUuid != null && curUuid != null && !inst.entityUuid.equals(curUuid)) {
            return;
        }
        if (pkt.getServerTick() <= inst.lastServerTick) {
            return;
        }
        inst.lastServerTick = pkt.getServerTick();
        double ddx = pkt.getX() - inst.x;
        double dist2 = ddx * ddx + (ddy = pkt.getY() - inst.y) * ddy + (ddz = pkt.getZ() - inst.z) * ddz;
        if (dist2 > 36.0) {
            inst.lastX = pkt.getX();
            inst.lastY = pkt.getY();
            inst.lastZ = pkt.getZ();
        } else {
            inst.lastX = inst.x;
            inst.lastY = inst.y;
            inst.lastZ = inst.z;
        }
        inst.x = pkt.getX();
        inst.y = pkt.getY();
        inst.z = pkt.getZ();
        inst.lastDeltaX = pkt.getDx();
        inst.lastDeltaY = pkt.getDy();
        inst.lastDeltaZ = pkt.getDz();
        inst.prevBbW = inst.lastBbW;
        inst.prevBbH = inst.lastBbH;
        inst.prevBbSize = inst.lastBbSize;
        inst.prevCorruption = inst.lastCorruption;
        inst.lastBbW = pkt.getBbw();
        inst.lastBbH = pkt.getBbh();
        inst.lastBbSize = pkt.getBbs();
        inst.lastCorruption = pkt.getCorruption();
    }

    public static void receiveLifecycle(AuraLifecyclePacket pkt) {
        if (!ShadowedHeartsConfigs.getInstance().getClientConfig().enableShadowAura()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        long now = mc.field_1687.method_8510();
        switch (pkt.getAction()) {
            case START: {
                UUID newUuid;
                class_1297 ent = mc.field_1687.method_8469(pkt.getEntityId());
                UUID uUID = newUuid = ent != null ? ent.method_5667() : null;
                if (newUuid != null) {
                    for (Map.Entry<Integer, AuraInstance> e : ACTIVE.entrySet()) {
                        AuraInstance ai = e.getValue();
                        if (ai == null || !newUuid.equals(ai.entityUuid) || e.getKey().intValue() == pkt.getEntityId()) continue;
                        ACTIVE.remove(e.getKey());
                    }
                }
                ACTIVE.put(pkt.getEntityId(), new AuraInstance(pkt.getEntityId(), ent, now, 10, pkt.getSustainOverride() > 0 ? pkt.getSustainOverride() : 60, 10, pkt.getX(), pkt.getY(), pkt.getZ(), pkt.getDx(), pkt.getDy(), pkt.getDz(), pkt.getBbw(), pkt.getBbh() * pkt.getHeightMultiplier(), pkt.getBbs(), pkt.getCorruption()));
                break;
            }
            case FADE_OUT: {
                ACTIVE.computeIfPresent(pkt.getEntityId(), (id, inst) -> {
                    inst.beginImmediateFadeOut(now, Math.max(1, pkt.getOutTicks()));
                    return inst;
                });
                break;
            }
        }
    }

    public static void init() {
    }

    public static void onPokemonDespawn(int entityId) {
        class_310 mc = class_310.method_1551();
        long now = mc != null && mc.field_1687 != null ? mc.field_1687.method_8510() : 0L;
        ACTIVE.computeIfPresent(entityId, (id, inst) -> {
            inst.stopSound();
            inst.beginImmediateFadeOut(now, 10);
            return inst;
        });
    }

    public static void renderInSummaryGUI(class_332 context, class_4597 bufferSource, float corruption, float partialTicks, RenderablePokemon pokemon, ModelWidget widget) {
        ShadowFogUniforms uu;
        class_5944 shader;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22905(20.0f, 20.0f, -20.0f);
        PosableModel pokemonModel = VaryingModelRepository.INSTANCE.getPoser(pokemon.getSpecies().resourceIdentifier, (PosableState)widget.getState());
        matrices.method_22904(pokemonModel.getProfileTranslation().field_1352, pokemonModel.getProfileTranslation().field_1351 + 1.5 * (double)pokemonModel.getProfileScale(), pokemonModel.getProfileTranslation().field_1350 - 4.0);
        matrices.method_22905(pokemonModel.getProfileScale(), pokemonModel.getProfileScale(), 1.0f / pokemonModel.getProfileScale());
        Quaternionf rotation = QuaternionUtilsKt.fromEulerXYZDegrees((Quaternionf)new Quaternionf(), (Vector3f)new Vector3f(13.0f, 325.0f, 0.0f));
        matrices.method_22907(rotation);
        matrices.method_22907(new Quaternionf().rotateLocalZ((float)Math.PI));
        float radius = (float)pokemon.getForm().getHitbox().method_30757(new class_243(0.0, 0.0, 0.0)).method_995();
        float halfHeight = (float)pokemon.getForm().getHitbox().method_30757(new class_243(0.0, 0.0, 0.0)).method_17940();
        boolean useXd = false;
        class_5944 class_59442 = shader = useXd ? ModShaders.SHADOW_AURA_XD_CYLINDER : ModShaders.SHADOW_AURA_FOG_CYLINDER;
        if (shader == null) {
            return;
        }
        Matrix4f view = RenderSystem.getModelViewMatrix();
        Matrix4f proj = RenderSystem.getProjectionMatrix();
        Matrix4f model = new Matrix4f((Matrix4fc)matrices.method_23760().method_23761());
        model.translate(0.0f, radius / 2.0f, 0.0f);
        Matrix4f invModel = new Matrix4f((Matrix4fc)model).invert();
        Matrix4f mvp = new Matrix4f((Matrix4fc)proj).mul((Matrix4fc)view).mul((Matrix4fc)model);
        float timeVal = class_310.method_1551() != null ? (class_310.method_1551().field_1687 != null ? (float)class_310.method_1551().field_1687.method_8510() + partialTicks : (float)class_310.method_1551().field_1705.method_1738() + partialTicks) * 0.05f : 0.0f;
        ShadowFogUniforms shadowFogUniforms = uu = useXd ? ModShaders.SHADOW_AURA_XD_CYLINDER_UNIFORMS : ModShaders.SHADOW_AURA_FOG_CYLINDER_UNIFORMS;
        if (uu != null) {
            if (uu.uView() != null) {
                uu.uView().method_1250(view);
            }
            if (uu.uProj() != null) {
                uu.uProj().method_1250(proj);
            }
            if (uu.uModel() != null) {
                uu.uModel().method_1250(model);
            }
            if (uu.uInvModel() != null) {
                uu.uInvModel().method_1250(invModel);
            }
            if (uu.uMVP() != null) {
                uu.uMVP().method_1250(mvp);
            }
            if (uu.uCameraPosWS() != null) {
                uu.uCameraPosWS().method_1249((float)widget.method_46426() + (float)widget.method_25368() / 2.0f, (float)class_310.method_1551().method_22683().method_4502() / 2.0f, 100.0f);
            }
            if (uu.uEntityPosWS() != null) {
                uu.uEntityPosWS().method_1249(0.0f, 0.0f, 0.0f);
            }
            if (uu.uEntityVelWS() != null) {
                uu.uEntityVelWS().method_1249(0.0f, 0.0f, 0.0f);
            }
            if (uu.uVelLagWS() != null) {
                uu.uVelLagWS().method_1249(0.0f, 0.0f, 0.0f);
            }
            if (uu.uSpeed() != null) {
                uu.uSpeed().method_1251(0.0f);
            }
            if (uu.uProxyRadius() != null) {
                uu.uProxyRadius().method_1251(radius);
            }
            if (uu.uProxyHalfHeight() != null) {
                uu.uProxyHalfHeight().method_1251(halfHeight * 0.5f);
            }
            if (uu.uAuraFade() != null) {
                uu.uAuraFade().method_1251(0.7f * corruption);
            }
            if (uu.uDensity() != null) {
                uu.uDensity().method_1251(radius * (useXd ? 2.5f : 1.0f));
            }
            if (uu.uMaxThickness() != null) {
                uu.uMaxThickness().method_1251(radius * (useXd ? 0.25f : 0.65f));
            }
            if (uu.uLimbSoft() != null) {
                uu.uLimbSoft().method_1251(0.22f);
            }
            if (uu.uMinPathNorm() != null) {
                uu.uMinPathNorm().method_1251(0.15f);
            }
            if (uu.uCorePow() != null) {
                uu.uCorePow().method_1251(useXd ? 2.0f : 4.0f);
            }
            if (uu.uGlowGamma() != null) {
                uu.uGlowGamma().method_1251(useXd ? 1.2f : 0.5f);
            }
            if (uu.uRimPower() != null) {
                uu.uRimPower().method_1251(useXd ? 3.5f : 0.05f);
            }
            if (uu.uRimStrength() != null) {
                uu.uRimStrength().method_1251(useXd ? 2.5f : 5.5f);
            }
            if (uu.uPixelsPerRadius() != null) {
                uu.uPixelsPerRadius().method_1251(24.0f);
            }
            if (uu.uPosterizeSteps() != null) {
                uu.uPosterizeSteps().method_1251(useXd ? 0.0f : 3.0f);
            }
            if (uu.uPatchSharpness() != null) {
                uu.uPatchSharpness().method_1251(useXd ? 0.08f : 0.25f);
            }
            if (uu.uPatchGamma() != null) {
                uu.uPatchGamma().method_1251(0.65f);
            }
            if (uu.uPatchThreshTop() != null) {
                uu.uPatchThreshTop().method_1251(useXd ? 0.65f : 0.8f);
            }
            if (uu.uPatchThreshBase() != null) {
                uu.uPatchThreshBase().method_1251(useXd ? 0.35f : 0.3f);
            }
            if (uu.uPatchScaleRel() != null) {
                uu.uPatchScaleRel().method_1251(useXd ? 5.5f : 6.5f);
            }
            if (uu.uScrollSpeedRel() != null) {
                uu.uScrollSpeedRel().method_1251(useXd ? 1.8f : -1.0f);
            }
            if (uu.uWarpAmp() != null) {
                uu.uWarpAmp().method_1251(useXd ? 0.35f : 0.075f);
            }
            if (uu.uNoiseScaleRel() != null) {
                uu.uNoiseScaleRel().method_1251(useXd ? 8.0f : 3.0f);
            }
            boolean bl = isHyper = pokemon != null && pokemon.getAspects() != null && pokemon.getAspects().contains("shadowedhearts:hyper_mode");
            if (isHyper) {
                if (uu.uColorB() != null) {
                    uu.uColorB().method_1249(1.3f, 0.3f, 0.85f);
                }
            } else if (uu.uColorB() != null) {
                uu.uColorB().method_1249(0.85f, 0.3f, 1.3f);
            }
            if (uu.uTime() != null) {
                uu.uTime().method_1251(timeVal);
            }
        } else {
            AuraEmitters.setMat4(shader, "uView", view);
            AuraEmitters.setMat4(shader, "uProj", proj);
            AuraEmitters.setMat4(shader, "uModel", model);
            AuraEmitters.setMat4(shader, "uInvModel", invModel);
            shader.method_35785("uMVP").method_1250(mvp);
            AuraEmitters.setVec3(shader, "uCameraPosWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.setVec3(shader, "uEntityPosWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.setVec3(shader, "uEntityVelWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.setVec3(shader, "uVelLagWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.set1f(shader, "uSpeed", 0.0f);
            AuraEmitters.set1f(shader, "uProxyRadius", radius);
            AuraEmitters.set1f(shader, "uProxyHalfHeight", halfHeight);
            AuraEmitters.set1f(shader, "uAuraFade", Math.max(0.0f, Math.min(1.0f, corruption)) * 0.8f);
            AuraEmitters.set1f(shader, "uDensity", radius);
            AuraEmitters.set1f(shader, "uMaxThickness", radius * 0.65f);
            AuraEmitters.set1f(shader, "uThicknessFeather", 0.0f);
            AuraEmitters.set1f(shader, "uEdgeKill", 0.0f);
            AuraEmitters.set1f(shader, "uLimbSoft", 0.22f);
            AuraEmitters.set1f(shader, "uLimbHardness", 2.25f);
            AuraEmitters.set1f(shader, "uMinPathNorm", 0.15f);
            AuraEmitters.set1f(shader, "uHeightFadePow", 1.25f);
            AuraEmitters.set1f(shader, "uHeightFadeMin", -0.25f);
            AuraEmitters.set1f(shader, "uPixelsPerRadius", 20.0f);
            AuraEmitters.set1f(shader, "uPosterizeSteps", 3.0f);
            AuraEmitters.set1f(shader, "uPatchSharpness", 0.6f);
            AuraEmitters.set1f(shader, "uTime", timeVal);
            boolean bl = isHyper = pokemon != null && pokemon.getAspects() != null && pokemon.getAspects().contains("shadowedhearts:hyper_mode");
            if (isHyper) {
                AuraEmitters.setVec3(shader, "uColorB", 0.85f, 0.3f, 1.3f);
            }
        }
        class_4588 vc = buffersSummary.getBuffer(useXd ? AuraRenderTypes.shadow_xd() : AuraRenderTypes.shadow_fog());
        Matrix4f mat = new Matrix4f();
        mat.scale(radius, halfHeight * 1.5f, radius);
        CylinderBuffers.drawCylinderWithDomesLod(vc, mat, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0);
        buffersSummary.method_37104();
        matrices.method_22909();
    }

    public static void renderInPcGUI(class_332 context, class_4597 bufferSource, float corruption, float partialTicks, RenderablePokemon pokemon, ModelWidget widget) {
        ShadowFogUniforms uu;
        class_5944 shader;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22905(20.0f, 20.0f, -20.0f);
        PosableModel pokemonModel = VaryingModelRepository.INSTANCE.getPoser(pokemon.getSpecies().resourceIdentifier, (PosableState)widget.getState());
        matrices.method_22904(pokemonModel.getProfileTranslation().field_1352, pokemonModel.getProfileTranslation().field_1351 + 1.5 * (double)pokemonModel.getProfileScale(), pokemonModel.getProfileTranslation().field_1350 - 20.0);
        matrices.method_22905(pokemonModel.getProfileScale(), pokemonModel.getProfileScale(), 1.0f / pokemonModel.getProfileScale());
        Quaternionf rotation = QuaternionUtilsKt.fromEulerXYZDegrees((Quaternionf)new Quaternionf(), (Vector3f)new Vector3f(13.0f, 325.0f, 0.0f));
        matrices.method_22907(rotation);
        matrices.method_22907(new Quaternionf().rotateLocalZ((float)Math.PI));
        float radius = (float)pokemon.getForm().getHitbox().method_30757(new class_243(0.0, 0.0, 0.0)).method_995();
        float halfHeight = (float)pokemon.getForm().getHitbox().method_30757(new class_243(0.0, 0.0, 0.0)).method_17940();
        boolean useXd = false;
        class_5944 class_59442 = shader = useXd ? ModShaders.SHADOW_AURA_XD_CYLINDER : ModShaders.SHADOW_AURA_FOG_CYLINDER;
        if (shader == null) {
            return;
        }
        Matrix4f view = RenderSystem.getModelViewMatrix();
        Matrix4f proj = RenderSystem.getProjectionMatrix();
        Matrix4f model = new Matrix4f((Matrix4fc)matrices.method_23760().method_23761());
        model.translate(0.0f, radius / 2.0f, 0.0f);
        Matrix4f invModel = new Matrix4f((Matrix4fc)model).invert();
        Matrix4f mvp = new Matrix4f((Matrix4fc)proj).mul((Matrix4fc)view).mul((Matrix4fc)model);
        float timeVal = class_310.method_1551() != null ? (class_310.method_1551().field_1687 != null ? (float)class_310.method_1551().field_1687.method_8510() + partialTicks : (float)class_310.method_1551().field_1705.method_1738() + partialTicks) * 0.05f : 0.0f;
        ShadowFogUniforms shadowFogUniforms = uu = useXd ? ModShaders.SHADOW_AURA_XD_CYLINDER_UNIFORMS : ModShaders.SHADOW_AURA_FOG_CYLINDER_UNIFORMS;
        if (uu != null) {
            if (uu.uView() != null) {
                uu.uView().method_1250(view);
            }
            if (uu.uProj() != null) {
                uu.uProj().method_1250(proj);
            }
            if (uu.uModel() != null) {
                uu.uModel().method_1250(model);
            }
            if (uu.uInvModel() != null) {
                uu.uInvModel().method_1250(invModel);
            }
            if (uu.uMVP() != null) {
                uu.uMVP().method_1250(mvp);
            }
            if (uu.uCameraPosWS() != null) {
                uu.uCameraPosWS().method_1249((float)widget.method_46426() + (float)widget.method_25368() / 2.0f, (float)widget.method_46427() + (float)widget.method_25364() / 2.0f, 0.0f);
            }
            if (uu.uEntityPosWS() != null) {
                uu.uEntityPosWS().method_1249(0.0f, 0.0f, 0.0f);
            }
            if (uu.uEntityVelWS() != null) {
                uu.uEntityVelWS().method_1249(0.0f, 0.0f, 0.0f);
            }
            if (uu.uVelLagWS() != null) {
                uu.uVelLagWS().method_1249(0.0f, 0.0f, 0.0f);
            }
            if (uu.uSpeed() != null) {
                uu.uSpeed().method_1251(0.0f);
            }
            if (uu.uExpand() != null) {
                uu.uExpand().method_1251(1.0f);
            }
            if (uu.uProxyRadius() != null) {
                uu.uProxyRadius().method_1251(radius);
            }
            if (uu.uProxyHalfHeight() != null) {
                uu.uProxyHalfHeight().method_1251(halfHeight * 0.5f);
            }
            if (uu.uAuraFade() != null) {
                uu.uAuraFade().method_1251(0.7f * corruption);
            }
            if (uu.uDensity() != null) {
                uu.uDensity().method_1251(radius * (useXd ? 2.5f : 1.0f));
            }
            if (uu.uMaxThickness() != null) {
                uu.uMaxThickness().method_1251(radius * (useXd ? 0.25f : 0.65f));
            }
            if (uu.uLimbSoft() != null) {
                uu.uLimbSoft().method_1251(0.22f);
            }
            if (uu.uLimbHardness() != null) {
                uu.uLimbHardness().method_1251(2.25f);
            }
            if (uu.uMinPathNorm() != null) {
                uu.uMinPathNorm().method_1251(0.15f);
            }
            if (uu.uCorePow() != null) {
                uu.uCorePow().method_1251(useXd ? 2.0f : 4.0f);
            }
            if (uu.uGlowGamma() != null) {
                uu.uGlowGamma().method_1251(useXd ? 1.2f : 0.5f);
            }
            if (uu.uRimPower() != null) {
                uu.uRimPower().method_1251(useXd ? 3.5f : 0.05f);
            }
            if (uu.uRimStrength() != null) {
                uu.uRimStrength().method_1251(useXd ? 2.5f : 5.5f);
            }
            if (uu.uPixelsPerRadius() != null) {
                uu.uPixelsPerRadius().method_1251(24.0f);
            }
            if (uu.uPosterizeSteps() != null) {
                uu.uPosterizeSteps().method_1251(useXd ? 0.0f : 3.0f);
            }
            if (uu.uPatchSharpness() != null) {
                uu.uPatchSharpness().method_1251(useXd ? 0.08f : 0.25f);
            }
            if (uu.uPatchGamma() != null) {
                uu.uPatchGamma().method_1251(0.65f);
            }
            if (uu.uPatchThreshTop() != null) {
                uu.uPatchThreshTop().method_1251(useXd ? 0.65f : 0.8f);
            }
            if (uu.uPatchThreshBase() != null) {
                uu.uPatchThreshBase().method_1251(useXd ? 0.35f : 0.3f);
            }
            if (uu.uPatchScaleRel() != null) {
                uu.uPatchScaleRel().method_1251(useXd ? 5.5f : 6.5f);
            }
            if (uu.uScrollSpeedRel() != null) {
                uu.uScrollSpeedRel().method_1251(useXd ? 1.8f : -1.0f);
            }
            if (uu.uWarpAmp() != null) {
                uu.uWarpAmp().method_1251(useXd ? 0.35f : 0.075f);
            }
            if (uu.uNoiseScaleRel() != null) {
                uu.uNoiseScaleRel().method_1251(useXd ? 8.0f : 3.0f);
            }
            boolean bl = isHyper = pokemon != null && pokemon.getAspects() != null && pokemon.getAspects().contains("shadowedhearts:hyper_mode");
            if (isHyper) {
                if (uu.uColorB() != null) {
                    uu.uColorB().method_1249(1.3f, 0.3f, 0.85f);
                }
            } else if (uu.uColorB() != null) {
                uu.uColorB().method_1249(0.85f, 0.3f, 1.3f);
            }
            if (uu.uTime() != null) {
                uu.uTime().method_1251(timeVal);
            }
        } else {
            AuraEmitters.setMat4(shader, "uView", view);
            AuraEmitters.setMat4(shader, "uProj", proj);
            AuraEmitters.setMat4(shader, "uModel", model);
            AuraEmitters.setMat4(shader, "uInvModel", invModel);
            shader.method_35785("uMVP").method_1250(mvp);
            AuraEmitters.setVec3(shader, "uCameraPosWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.setVec3(shader, "uEntityPosWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.setVec3(shader, "uEntityVelWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.setVec3(shader, "uVelLagWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.set1f(shader, "uSpeed", 0.0f);
            AuraEmitters.set1f(shader, "uProxyRadius", radius);
            AuraEmitters.set1f(shader, "uProxyHalfHeight", halfHeight);
            AuraEmitters.set1f(shader, "uAuraFade", Math.max(0.0f, Math.min(1.0f, corruption)) * 0.8f);
            AuraEmitters.set1f(shader, "uDensity", radius);
            AuraEmitters.set1f(shader, "uMaxThickness", radius * 0.65f);
            AuraEmitters.set1f(shader, "uThicknessFeather", 0.0f);
            AuraEmitters.set1f(shader, "uEdgeKill", 0.0f);
            AuraEmitters.set1f(shader, "uLimbSoft", 0.22f);
            AuraEmitters.set1f(shader, "uLimbHardness", 2.25f);
            AuraEmitters.set1f(shader, "uMinPathNorm", 0.15f);
            AuraEmitters.set1f(shader, "uHeightFadePow", 1.25f);
            AuraEmitters.set1f(shader, "uHeightFadeMin", -0.25f);
            AuraEmitters.set1f(shader, "uPixelsPerRadius", 20.0f);
            AuraEmitters.set1f(shader, "uPosterizeSteps", 3.0f);
            AuraEmitters.set1f(shader, "uPatchSharpness", 0.6f);
            AuraEmitters.set1f(shader, "uTime", timeVal);
            boolean bl = isHyper = pokemon != null && pokemon.getAspects() != null && pokemon.getAspects().contains("shadowedhearts:hyper_mode");
            if (isHyper) {
                AuraEmitters.setVec3(shader, "uColorB", 0.85f, 0.3f, 1.3f);
            }
        }
        class_4588 vc = buffersPC.getBuffer(useXd ? AuraRenderTypes.shadow_xd() : AuraRenderTypes.shadow_fog());
        Matrix4f mat = new Matrix4f();
        mat.scale(radius, halfHeight * 1.5f, radius);
        CylinderBuffers.drawCylinderWithDomesLod(vc, mat, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0);
        buffersPC.method_37104();
        matrices.method_22909();
    }

    public static void renderInPurificationGUI(class_332 context, class_4587 matrices, class_4597 bufferSource, float corruption, float partialTicks, RenderablePokemon pokemon, PosableState state, float x, float y, float width, float height) {
        ShadowFogUniforms uu;
        class_5944 shader;
        matrices.method_22903();
        matrices.method_22905(20.0f, 20.0f, -20.0f);
        PosableModel pokemonModel = VaryingModelRepository.INSTANCE.getPoser(pokemon.getSpecies().resourceIdentifier, state);
        matrices.method_22904(pokemonModel.getProfileTranslation().field_1352, pokemonModel.getProfileTranslation().field_1351 + 1.5 * (double)pokemonModel.getProfileScale(), pokemonModel.getProfileTranslation().field_1350 - 20.0);
        matrices.method_22905(pokemonModel.getProfileScale(), pokemonModel.getProfileScale(), 1.0f / pokemonModel.getProfileScale());
        Quaternionf rotation = QuaternionUtilsKt.fromEulerXYZDegrees((Quaternionf)new Quaternionf(), (Vector3f)new Vector3f(13.0f, 325.0f, 0.0f));
        matrices.method_22907(rotation);
        matrices.method_22907(new Quaternionf().rotateLocalZ((float)Math.PI));
        float radius = (float)pokemon.getForm().getHitbox().method_30757(new class_243(0.0, 0.0, 0.0)).method_995();
        float halfHeight = (float)pokemon.getForm().getHitbox().method_30757(new class_243(0.0, 0.0, 0.0)).method_17940();
        boolean useXd = false;
        class_5944 class_59442 = shader = useXd ? ModShaders.SHADOW_AURA_XD_CYLINDER : ModShaders.SHADOW_AURA_FOG_CYLINDER;
        if (shader == null) {
            return;
        }
        Matrix4f view = RenderSystem.getModelViewMatrix();
        Matrix4f proj = RenderSystem.getProjectionMatrix();
        Matrix4f model = new Matrix4f((Matrix4fc)matrices.method_23760().method_23761());
        model.translate(0.0f, radius / 2.0f, 0.0f);
        Matrix4f invModel = new Matrix4f((Matrix4fc)model).invert();
        Matrix4f mvp = new Matrix4f((Matrix4fc)proj).mul((Matrix4fc)view).mul((Matrix4fc)model);
        float timeVal = class_310.method_1551() != null ? (class_310.method_1551().field_1687 != null ? (float)class_310.method_1551().field_1687.method_8510() + partialTicks : (float)class_310.method_1551().field_1705.method_1738() + partialTicks) * 0.05f : 0.0f;
        ShadowFogUniforms shadowFogUniforms = uu = useXd ? ModShaders.SHADOW_AURA_XD_CYLINDER_UNIFORMS : ModShaders.SHADOW_AURA_FOG_CYLINDER_UNIFORMS;
        if (uu != null) {
            if (uu.uView() != null) {
                uu.uView().method_1250(view);
            }
            if (uu.uProj() != null) {
                uu.uProj().method_1250(proj);
            }
            if (uu.uModel() != null) {
                uu.uModel().method_1250(model);
            }
            if (uu.uInvModel() != null) {
                uu.uInvModel().method_1250(invModel);
            }
            if (uu.uMVP() != null) {
                uu.uMVP().method_1250(mvp);
            }
            if (uu.uCameraPosWS() != null) {
                uu.uCameraPosWS().method_1249(x + width / 2.0f, y + height / 2.0f, 0.0f);
            }
            if (uu.uEntityPosWS() != null) {
                uu.uEntityPosWS().method_1249(0.0f, 0.0f, 0.0f);
            }
            if (uu.uEntityVelWS() != null) {
                uu.uEntityVelWS().method_1249(0.0f, 0.0f, 0.0f);
            }
            if (uu.uVelLagWS() != null) {
                uu.uVelLagWS().method_1249(0.0f, 0.0f, 0.0f);
            }
            if (uu.uSpeed() != null) {
                uu.uSpeed().method_1251(0.0f);
            }
            if (uu.uExpand() != null) {
                uu.uExpand().method_1251(1.0f);
            }
            if (uu.uProxyRadius() != null) {
                uu.uProxyRadius().method_1251(radius);
            }
            if (uu.uProxyHalfHeight() != null) {
                uu.uProxyHalfHeight().method_1251(halfHeight * 0.5f);
            }
            if (uu.uAuraFade() != null) {
                uu.uAuraFade().method_1251(0.7f * corruption);
            }
            if (uu.uDensity() != null) {
                uu.uDensity().method_1251(radius * (useXd ? 2.5f : 1.0f));
            }
            if (uu.uMaxThickness() != null) {
                uu.uMaxThickness().method_1251(radius * (useXd ? 0.25f : 0.65f));
            }
            if (uu.uLimbSoft() != null) {
                uu.uLimbSoft().method_1251(0.22f);
            }
            if (uu.uLimbHardness() != null) {
                uu.uLimbHardness().method_1251(2.25f);
            }
            if (uu.uMinPathNorm() != null) {
                uu.uMinPathNorm().method_1251(0.15f);
            }
            if (uu.uCorePow() != null) {
                uu.uCorePow().method_1251(useXd ? 2.0f : 4.0f);
            }
            if (uu.uGlowGamma() != null) {
                uu.uGlowGamma().method_1251(useXd ? 1.2f : 0.5f);
            }
            if (uu.uRimPower() != null) {
                uu.uRimPower().method_1251(useXd ? 3.5f : 0.05f);
            }
            if (uu.uRimStrength() != null) {
                uu.uRimStrength().method_1251(useXd ? 2.5f : 5.5f);
            }
            if (uu.uPixelsPerRadius() != null) {
                uu.uPixelsPerRadius().method_1251(24.0f);
            }
            if (uu.uPosterizeSteps() != null) {
                uu.uPosterizeSteps().method_1251(useXd ? 0.0f : 3.0f);
            }
            if (uu.uPatchSharpness() != null) {
                uu.uPatchSharpness().method_1251(useXd ? 0.08f : 0.25f);
            }
            if (uu.uPatchGamma() != null) {
                uu.uPatchGamma().method_1251(0.65f);
            }
            if (uu.uPatchThreshTop() != null) {
                uu.uPatchThreshTop().method_1251(useXd ? 0.65f : 0.8f);
            }
            if (uu.uPatchThreshBase() != null) {
                uu.uPatchThreshBase().method_1251(useXd ? 0.35f : 0.3f);
            }
            if (uu.uPatchScaleRel() != null) {
                uu.uPatchScaleRel().method_1251(useXd ? 5.5f : 6.5f);
            }
            if (uu.uScrollSpeedRel() != null) {
                uu.uScrollSpeedRel().method_1251(useXd ? 1.8f : -1.0f);
            }
            if (uu.uWarpAmp() != null) {
                uu.uWarpAmp().method_1251(useXd ? 0.35f : 0.075f);
            }
            if (uu.uNoiseScaleRel() != null) {
                uu.uNoiseScaleRel().method_1251(useXd ? 8.0f : 3.0f);
            }
            boolean bl = isHyper = pokemon != null && pokemon.getAspects() != null && pokemon.getAspects().contains("shadowedhearts:hyper_mode");
            if (isHyper) {
                if (uu.uColorB() != null) {
                    uu.uColorB().method_1249(1.3f, 0.3f, 0.85f);
                }
            } else if (uu.uColorB() != null) {
                uu.uColorB().method_1249(0.85f, 0.3f, 1.3f);
            }
            if (uu.uTime() != null) {
                uu.uTime().method_1251(timeVal);
            }
        } else {
            AuraEmitters.setMat4(shader, "uView", view);
            AuraEmitters.setMat4(shader, "uProj", proj);
            AuraEmitters.setMat4(shader, "uModel", model);
            AuraEmitters.setMat4(shader, "uInvModel", invModel);
            shader.method_35785("uMVP").method_1250(mvp);
            AuraEmitters.setVec3(shader, "uCameraPosWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.setVec3(shader, "uEntityPosWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.setVec3(shader, "uEntityVelWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.setVec3(shader, "uVelLagWS", 0.0f, 0.0f, 0.0f);
            AuraEmitters.set1f(shader, "uSpeed", 0.0f);
            AuraEmitters.set1f(shader, "uProxyRadius", radius);
            AuraEmitters.set1f(shader, "uProxyHalfHeight", halfHeight);
            AuraEmitters.set1f(shader, "uAuraFade", Math.max(0.0f, Math.min(1.0f, corruption)) * 0.8f);
            AuraEmitters.set1f(shader, "uDensity", radius);
            AuraEmitters.set1f(shader, "uMaxThickness", radius * 0.65f);
            AuraEmitters.set1f(shader, "uThicknessFeather", 0.0f);
            AuraEmitters.set1f(shader, "uEdgeKill", 0.0f);
            AuraEmitters.set1f(shader, "uLimbSoft", 0.22f);
            AuraEmitters.set1f(shader, "uLimbHardness", 2.25f);
            AuraEmitters.set1f(shader, "uMinPathNorm", 0.15f);
            AuraEmitters.set1f(shader, "uHeightFadePow", 1.25f);
            AuraEmitters.set1f(shader, "uHeightFadeMin", -0.25f);
            AuraEmitters.set1f(shader, "uPixelsPerRadius", 20.0f);
            AuraEmitters.set1f(shader, "uPosterizeSteps", 3.0f);
            AuraEmitters.set1f(shader, "uPatchSharpness", 0.6f);
            AuraEmitters.set1f(shader, "uTime", timeVal);
            boolean bl = isHyper = pokemon != null && pokemon.getAspects() != null && pokemon.getAspects().contains("shadowedhearts:hyper_mode");
            if (isHyper) {
                AuraEmitters.setVec3(shader, "uColorB", 0.85f, 0.3f, 1.3f);
            }
        }
        class_4588 vc = buffersPurification.getBuffer(useXd ? AuraRenderTypes.shadow_xd() : AuraRenderTypes.shadow_fog());
        Matrix4f mat = new Matrix4f();
        mat = mat.scale(radius, halfHeight, radius);
        CylinderBuffers.drawCylinderWithDomesLod(vc, mat, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0);
        buffersPurification.method_37104();
        matrices.method_22909();
    }

    public static void onRender(class_4184 camera, float partialTicks) {
        if (!ShadowedHeartsConfigs.getInstance().getClientConfig().enableShadowAura()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        boolean useXd = false;
        class_5944 activeShader = useXd ? ModShaders.SHADOW_AURA_XD_CYLINDER : ModShaders.SHADOW_AURA_FOG_CYLINDER;
        ShadowFogUniforms activeUniforms = useXd ? ModShaders.SHADOW_AURA_XD_CYLINDER_UNIFORMS : ModShaders.SHADOW_AURA_FOG_CYLINDER_UNIFORMS;
        Matrix4f view = RenderSystem.getModelViewMatrix();
        Matrix4f proj = RenderSystem.getProjectionMatrix();
        Matrix4f invView = new Matrix4f((Matrix4fc)view).invert();
        Matrix4f invProj = new Matrix4f((Matrix4fc)proj).invert();
        int screenHeightPx = mc.method_22683().method_4506();
        float tanHalfFovY = 1.0f / proj.m11();
        class_243 camPos = camera.method_19326();
        long now = mc.field_1687.method_8510();
        class_5944 shFrame = activeShader;
        ShadowFogUniforms uuFrame = activeUniforms;
        float timeValFrame = ((float)class_310.method_1551().field_1687.method_8510() + partialTicks) * 0.05f;
        if (shFrame != null) {
            if (uuFrame != null) {
                if (uuFrame.uView() != null) {
                    uuFrame.uView().method_1250(view);
                }
                if (uuFrame.uProj() != null) {
                    uuFrame.uProj().method_1250(proj);
                }
                if (uuFrame.uInvView() != null) {
                    uuFrame.uInvView().method_1250(invView);
                }
                if (uuFrame.uInvProj() != null) {
                    uuFrame.uInvProj().method_1250(invProj);
                }
                if (uuFrame.uTime() != null) {
                    uuFrame.uTime().method_1251(timeValFrame);
                }
            } else {
                AuraEmitters.setMat4(shFrame, "uView", view);
                AuraEmitters.setMat4(shFrame, "uProj", proj);
                shFrame.method_35785("uInvView").method_1250(invView);
                shFrame.method_35785("uInvProj").method_1250(invProj);
                AuraEmitters.set1f(shFrame, "uTime", timeValFrame);
            }
        }
        for (Map.Entry<Integer, AuraInstance> en : ACTIVE.entrySet()) {
            float pxRadiusShell;
            boolean hasVisibility;
            double iz;
            double iy;
            double ix;
            AuraInstance inst = en.getValue();
            if (inst == null) {
                ACTIVE.remove(en.getKey());
                continue;
            }
            if (inst.isExpired(now)) {
                inst.stopSound();
                ACTIVE.remove(en.getKey());
                continue;
            }
            inst.updateSound();
            class_1297 ent = inst.entityRef != null ? (class_1297)inst.entityRef.get() : null;
            boolean useEnt = false;
            if (ent != null && ent.method_5805() && ent.method_5628() == inst.entityId && (inst.entityUuid == null || inst.entityUuid.equals(ent.method_5667()))) {
                useEnt = true;
            }
            if (useEnt) {
                ix = class_3532.method_16436((double)partialTicks, (double)ent.field_6038, (double)ent.method_23317());
                iy = class_3532.method_16436((double)partialTicks, (double)ent.field_5971, (double)ent.method_23318());
                iz = class_3532.method_16436((double)partialTicks, (double)ent.field_5989, (double)ent.method_23321());
            } else {
                ent = mc.field_1687.method_8469(inst.entityId);
                if (ent != null && ent.method_5805() && (inst.entityUuid == null || inst.entityUuid.equals(ent.method_5667()))) {
                    inst.entityRef = new WeakReference<class_1297>(ent);
                    inst.entityUuid = ent.method_5667();
                }
                ix = class_3532.method_16436((double)partialTicks, (double)inst.lastX, (double)inst.x);
                iy = class_3532.method_16436((double)partialTicks, (double)inst.lastY, (double)inst.y);
                iz = class_3532.method_16436((double)partialTicks, (double)inst.lastZ, (double)inst.z);
            }
            float fade = inst.fadeFactor(now);
            float corruption = class_3532.method_16439((float)partialTicks, (float)inst.prevCorruption, (float)inst.lastCorruption);
            boolean bl = hasVisibility = fade > 0.001f && corruption > 0.01f;
            if (!hasVisibility) continue;
            double x = ix - camPos.field_1352;
            double y = iy - camPos.field_1351;
            double camY = iy - camera.method_19331().method_30950((float)partialTicks).field_1351;
            double z = iz - camPos.field_1350;
            if (!(ent instanceof PokemonEntity)) continue;
            PokemonEntity pokemonEntity = (PokemonEntity)ent;
            float entityHeight = class_3532.method_16439((float)partialTicks, (float)inst.prevBbH, (float)inst.lastBbH);
            float radius = Math.max(0.25f, class_3532.method_16439((float)partialTicks, (float)((float)inst.prevBbSize), (float)((float)inst.lastBbSize)));
            double cy = y;
            double distCenter = Math.sqrt(x * x + cy * cy + z * z);
            float f = pxRadiusShell = distCenter > 1.0E-4 ? radius * (float)screenHeightPx / (2.0f * (float)distCenter * tanHalfFovY) : 9999.0f;
            int lodShell = pxRadiusShell > 150.0f ? 3 : (pxRadiusShell > 60.0f ? 2 : (pxRadiusShell > 20.0f ? 1 : 0));
            Matrix4f model = new Matrix4f().translate((float)x, (float)(y + (double)(radius / 2.0f)), (float)z);
            Matrix4f invModel = new Matrix4f((Matrix4fc)model).invert();
            Matrix4f mvp = new Matrix4f((Matrix4fc)proj).mul((Matrix4fc)view).mul((Matrix4fc)model);
            class_5944 sh = activeShader;
            ShadowFogUniforms uu = activeUniforms;
            if (sh != null) {
                if (uu != null) {
                    if (uu.uModel() != null) {
                        uu.uModel().method_1250(model);
                    }
                    if (uu.uInvModel() != null) {
                        uu.uInvModel().method_1250(invModel);
                    }
                    if (uu.uMVP() != null) {
                        uu.uMVP().method_1250(mvp);
                    }
                    if (uu.uCameraPosWS() != null) {
                        uu.uCameraPosWS().method_1249(0.0f, 0.0f, 0.0f);
                    }
                    if (uu.uEntityPosWS() != null) {
                        uu.uEntityPosWS().method_1249((float)ix, (float)iy, (float)iz);
                    }
                    if (uu.uScrollSpeedRel() != null) {
                        uu.uScrollSpeedRel().method_1251(0.8f);
                    }
                    isHyper = false;
                    if (useEnt && ent instanceof PokemonEntity) {
                        pe = (PokemonEntity)ent;
                        aspects = pe.getAspects();
                        boolean bl2 = isHyper = aspects != null && aspects.contains("shadowedhearts:hyper_mode");
                    }
                    if (isHyper && uu.uColorB() != null) {
                        uu.uColorB().method_1249(1.3f, 0.3f, 0.85f);
                    } else if (uu.uColorB() != null) {
                        uu.uColorB().method_1249(0.85f, 0.3f, 1.3f);
                    }
                } else {
                    AuraEmitters.setMat4(sh, "uModel", model);
                    AuraEmitters.setMat4(sh, "uInvModel", invModel);
                    sh.method_35785("uMVP").method_1250(mvp);
                    AuraEmitters.setVec3(sh, "uCameraPosWS", 0.0f, 0.0f, 0.0f);
                    AuraEmitters.setVec3(sh, "uEntityPosWS", (float)x, (float)y, (float)z);
                    isHyper = false;
                    if (useEnt && ent instanceof PokemonEntity) {
                        pe = (PokemonEntity)ent;
                        aspects = pe.getAspects();
                        boolean bl3 = isHyper = aspects != null && aspects.contains("shadowedhearts:hyper_mode");
                    }
                    if (isHyper) {
                        AuraEmitters.setVec3(sh, "uColorB", 1.0f, 0.3f, 1.3f);
                    }
                }
                if (uu != null) {
                    if (uu.uProxyRadius() != null) {
                        uu.uProxyRadius().method_1251(radius);
                    }
                    if (uu.uProxyHalfHeight() != null) {
                        uu.uProxyHalfHeight().method_1251(entityHeight * 0.5f);
                    }
                    if (uu.uAuraFade() != null) {
                        uu.uAuraFade().method_1251(0.8f * fade);
                    }
                    if (uu.uDensity() != null) {
                        uu.uDensity().method_1251(radius * (useXd ? 1.0f : 1.0f));
                    }
                    if (uu.uMaxThickness() != null) {
                        uu.uMaxThickness().method_1251(radius * (useXd ? 0.65f : 0.65f));
                    }
                }
            }
            class_4588 vcShell = buffersOverworld.getBuffer(useXd ? AuraRenderTypes.shadow_xd() : AuraRenderTypes.shadow_fog());
            Matrix4f mat = new Matrix4f();
            mat = mat.scale(radius, entityHeight, radius);
            CylinderBuffers.drawCylinderWithDomesLod(vcShell, mat, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, lodShell);
            buffersOverworld.method_37104();
        }
    }

    private static void set1f(class_5944 sh, String name, float v) {
        class_284 u = sh.method_34582(name);
        if (u != null) {
            u.method_1251(v);
        }
    }

    private static void setVec3(class_5944 sh, String name, float x, float y, float z) {
        class_284 u = sh.method_34582(name);
        if (u != null) {
            u.method_1249(x, y, z);
        }
    }

    private static void setMat4(class_5944 sh, String name, Matrix4f m) {
        class_284 u = sh.method_34582(name);
        if (u != null) {
            u.method_1250(m);
        }
    }

    public static final class AuraInstance {
        private long startTick;
        private int fadeInTicks;
        private int sustainTicks;
        private int fadeOutTicks;
        private int entityId;
        private WeakReference<class_1297> entityRef;
        private UUID entityUuid;
        private ShadowAuraSoundInstance soundInstance;
        public double x;
        public double y;
        public double z;
        double lastX;
        double lastY;
        double lastZ;
        double lastDeltaX;
        double lastDeltaY;
        double lastDeltaZ;
        float lastBbH;
        float lastBbW;
        float prevBbH;
        float prevBbW;
        double lastBbSize;
        double prevBbSize;
        float lastCorruption = 1.0f;
        float prevCorruption = 1.0f;
        long lastServerTick = -1L;

        AuraInstance(int entityId, class_1297 ent, long startTick, int fadeInTicks, int sustainTicks, int fadeOutTicks, double x, double y, double z, double dx, double dy, double dz, float bbw, float bbh, double bbs, float lastCorruption) {
            this.entityId = entityId;
            this.entityRef = new WeakReference<class_1297>(ent);
            this.entityUuid = ent != null ? ent.method_5667() : null;
            this.startTick = startTick;
            this.fadeInTicks = Math.max(1, fadeInTicks);
            this.sustainTicks = Math.max(0, sustainTicks);
            this.fadeOutTicks = Math.max(1, fadeOutTicks);
            this.x = x;
            this.y = y;
            this.z = z;
            this.lastX = x;
            this.lastY = y;
            this.lastZ = z;
            this.lastDeltaX = dx;
            this.lastDeltaY = dy;
            this.lastDeltaZ = dz;
            this.lastBbH = bbh;
            this.prevBbH = bbh;
            this.lastBbW = bbw;
            this.prevBbW = bbw;
            this.lastBbSize = bbs;
            this.prevBbSize = bbs;
            this.lastCorruption = lastCorruption;
            this.prevCorruption = lastCorruption;
        }

        public class_1297 getEntity() {
            return this.entityRef != null ? (class_1297)this.entityRef.get() : null;
        }

        public void updateSound() {
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.field_1687 == null) {
                return;
            }
            if (this.soundInstance == null || this.soundInstance.method_4793()) {
                this.soundInstance = new ShadowAuraSoundInstance(this);
                mc.method_1483().method_4873((class_1113)this.soundInstance);
            }
        }

        public void stopSound() {
            if (this.soundInstance != null) {
                this.soundInstance.stopSound();
                this.soundInstance = null;
            }
        }

        void beginImmediateFadeOut(long now, int outTicks) {
            this.startTick = now - (long)this.fadeInTicks - (long)this.sustainTicks;
            this.fadeOutTicks = Math.max(1, outTicks);
        }

        public boolean isExpired(long now) {
            long total = (long)this.fadeInTicks + (long)this.sustainTicks + (long)this.fadeOutTicks;
            return now - this.startTick >= total;
        }

        public float fadeFactor(long now) {
            long age = Math.max(0L, now - this.startTick);
            long fi = this.fadeInTicks;
            long sus = this.sustainTicks;
            long fo = this.fadeOutTicks;
            if (age < fi) {
                return (float)age / (float)fi;
            }
            if ((age -= fi) < sus) {
                return 1.0f;
            }
            if ((age -= sus) < fo) {
                return 1.0f - (float)age / (float)fo;
            }
            return 0.0f;
        }

        float getCorruption() {
            return this.lastCorruption;
        }
    }
}

