/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.aura;

import com.jayemceekay.shadowedhearts.client.ModShaders;
import com.jayemceekay.shadowedhearts.client.aura.IrisHandler;
import com.jayemceekay.shadowedhearts.client.aura.IrisHandlerImpl;
import com.jayemceekay.shadowedhearts.client.render.DepthCapture;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.platform.Platform;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

public class AuraPulseRenderer {
    private static final List<PulseInstance> PULSES = Collections.synchronizedList(new ArrayList());
    public static final IrisHandler IRIS_HANDLER = Platform.isModLoaded((String)"iris") ? new IrisHandlerImpl() : null;
    private static int pulseTextureId = -1;
    private static int pulsePboId = 0;
    private static int pboCapacityTexels = 0;
    private static int allocatedTextureWidthCapacity = 0;
    private static int maxTextureSizeCached = -1;
    private static final int INTERNAL_FORMAT = 34842;

    public static void spawnPulse(class_243 origin) {
        AuraPulseRenderer.spawnPulse(origin, 0.0f, 1.0f, 1.0f, 128.0f);
    }

    public static void spawnPulse(class_243 origin, float r, float g, float b, float distance) {
        class_310 mc = class_310.method_1551();
        if (mc != null && !mc.method_18854()) {
            mc.execute(() -> AuraPulseRenderer.addPulse(origin, r, g, b, distance));
            return;
        }
        AuraPulseRenderer.addPulse(origin, r, g, b, distance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPulse(class_243 origin, float r, float g, float b, float distance) {
        List<PulseInstance> list = PULSES;
        synchronized (list) {
            PULSES.add(new PulseInstance(origin, r, g, b, distance));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPulses() {
        class_310 mc = class_310.method_1551();
        if (mc != null && !mc.method_18854()) {
            mc.execute(() -> {
                List<PulseInstance> list = PULSES;
                synchronized (list) {
                    PULSES.clear();
                }
            });
            return;
        }
        List<PulseInstance> list = PULSES;
        synchronized (list) {
            PULSES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        class_310 mc = class_310.method_1551();
        if (mc != null && !mc.method_18854()) {
            mc.execute(() -> {
                List<PulseInstance> list = PULSES;
                synchronized (list) {
                    PULSES.removeIf(PulseInstance::tick);
                }
            });
            return;
        }
        List<PulseInstance> list = PULSES;
        synchronized (list) {
            PULSES.removeIf(PulseInstance::tick);
        }
    }

    public static void init() {
    }

    public static void onWorldRendered(class_4587 matrices, Matrix4f projectionMatrix, Matrix4f modelViewMatrix, class_4184 camera, float tickDelta) {
        AuraPulseRenderer.onRenderWorld(camera, projectionMatrix, modelViewMatrix, tickDelta);
    }

    public static void renderIris() {
        class_310 mc;
        if (IRIS_HANDLER != null && (mc = class_310.method_1551()).method_1560() != null && mc.field_1687 != null) {
            class_4184 camera = mc.field_1773.method_19418();
            Matrix4f proj = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
            Matrix4f view = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
            float partialTick = class_310.method_1551().method_60646().method_60636() + class_310.method_1551().method_60646().method_60637(true);
            AuraPulseRenderer.onRenderWorld(camera, proj, view, partialTick);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRenderWorld(class_4184 camera, Matrix4f projectionMatrix, Matrix4f modelViewMatrix, float partialTicks) {
        List<PulseInstance> pulsesSnapshot;
        List<PulseInstance> list = PULSES;
        synchronized (list) {
            if (PULSES.isEmpty()) {
                return;
            }
            pulsesSnapshot = List.copyOf(PULSES);
        }
        try {
            ByteBuffer mapped;
            int writeBytes;
            int width;
            IrisHandler.IrisRenderingSnapshot snapshot;
            if (ModShaders.AURA_PULSE == null) {
                return;
            }
            class_310 mc = class_310.method_1551();
            DepthCapture.captureIfNeeded();
            Matrix4f proj = projectionMatrix;
            Matrix4f view = modelViewMatrix;
            int diffuseTexture = mc.method_1522().method_30277();
            int depthTexture = DepthCapture.textureId();
            if (IRIS_HANDLER != null && IRIS_HANDLER.isShaderPackInUse() && (snapshot = IRIS_HANDLER.getIrisRenderingSnapshot()) != null) {
                if (snapshot.diffuseTexture != -1) {
                    diffuseTexture = snapshot.diffuseTexture;
                }
                depthTexture = snapshot.depthTexture;
                proj = snapshot.projectionMatrix;
                view = snapshot.modelViewMatrix;
            }
            Matrix4f invProj = new Matrix4f((Matrix4fc)proj).invert();
            Matrix4f invView = new Matrix4f((Matrix4fc)view).invert();
            ModShaders.AURA_PULSE.method_34583("DiffuseSampler", (Object)diffuseTexture);
            ModShaders.AURA_PULSE.method_34583("uDepth", (Object)depthTexture);
            class_243 camPos = camera.method_19326();
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            int count = pulsesSnapshot.size();
            if (pulseTextureId == -1) {
                pulseTextureId = GlStateManager._genTexture();
            }
            if (maxTextureSizeCached <= 0 && (maxTextureSizeCached = GL11.glGetInteger((int)3379)) <= 0) {
                maxTextureSizeCached = 4096;
            }
            if ((width = count * 2) > maxTextureSizeCached) {
                int maxPulses = Math.max(0, maxTextureSizeCached / 2);
                count = Math.min(count, maxPulses);
                width = count * 2;
            }
            int requiredTexels = Math.max(2, width);
            if (pulsePboId == 0) {
                pulsePboId = GL15.glGenBuffers();
            }
            int prevUnpackPbo = GL11.glGetInteger((int)35055);
            GL15.glBindBuffer((int)35052, (int)pulsePboId);
            if (pboCapacityTexels < requiredTexels) {
                int newCapacity = AuraPulseRenderer.nextPow2(requiredTexels);
                newCapacity = Math.min(newCapacity, maxTextureSizeCached);
                int newBytes = newCapacity * 16;
                GL15.glBufferData((int)35052, (long)newBytes, (int)35040);
                pboCapacityTexels = newCapacity;
            }
            if ((writeBytes = width * 16) > 0 && (mapped = GL30.glMapBufferRange((int)35052, (long)0L, (long)writeBytes, (int)6)) != null) {
                mapped.clear();
                for (int i = 0; i < count; ++i) {
                    PulseInstance pulse = pulsesSnapshot.get(i);
                    float radius = pulse.getRadius(partialTicks);
                    Vector3f origin = new Vector3f((float)(pulse.origin.field_1352 - camPos.field_1352), (float)(pulse.origin.field_1351 - camPos.field_1351), (float)(pulse.origin.field_1350 - camPos.field_1350));
                    mapped.putFloat(origin.x);
                    mapped.putFloat(origin.y);
                    mapped.putFloat(origin.z);
                    mapped.putFloat(radius);
                    mapped.putFloat(pulse.r);
                    mapped.putFloat(pulse.g);
                    mapped.putFloat(pulse.b);
                    mapped.putFloat(pulse.distance);
                }
                mapped.flip();
                GL15.glUnmapBuffer((int)35052);
            }
            RenderSystem.activeTexture((int)33986);
            RenderSystem.bindTexture((int)pulseTextureId);
            if (allocatedTextureWidthCapacity != pboCapacityTexels) {
                GL11.glTexImage2D((int)3553, (int)0, (int)34842, (int)pboCapacityTexels, (int)1, (int)0, (int)6408, (int)5126, (long)0L);
                allocatedTextureWidthCapacity = pboCapacityTexels;
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            }
            if (width > 0) {
                GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)1, (int)6408, (int)5126, (long)0L);
            }
            GL15.glBindBuffer((int)35052, (int)prevUnpackPbo);
            ModShaders.AURA_PULSE.method_34583("uPulseTexture", (Object)pulseTextureId);
            if (ModShaders.AURA_PULSE.method_35785("uThickness") != null) {
                ModShaders.AURA_PULSE.method_35785("uThickness").method_1251(2.0f);
            }
            if (ModShaders.AURA_PULSE.method_35785("uPulseCount") != null) {
                ModShaders.AURA_PULSE.method_35785("uPulseCount").method_1251((float)count);
            }
            if (ModShaders.AURA_PULSE.method_35785("uInvProj") != null) {
                ModShaders.AURA_PULSE.method_35785("uInvProj").method_1250(invProj);
            }
            if (ModShaders.AURA_PULSE.method_35785("uInvView") != null) {
                ModShaders.AURA_PULSE.method_35785("uInvView").method_1250(invView);
            }
            if (ModShaders.AURA_PULSE.field_29470 != null) {
                ModShaders.AURA_PULSE.field_29470.method_1250(new Matrix4f());
            }
            if (ModShaders.AURA_PULSE.field_29471 != null) {
                ModShaders.AURA_PULSE.field_29471.method_1250(new Matrix4f());
            }
            ModShaders.AURA_PULSE.method_34586();
            RenderSystem.setShader(() -> ModShaders.AURA_PULSE);
            class_289 tess = class_289.method_1348();
            class_287 buf = tess.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
            buf.method_22912(-1.0f, -1.0f, 0.0f).method_22913(0.0f, 0.0f);
            buf.method_22912(1.0f, -1.0f, 0.0f).method_22913(1.0f, 0.0f);
            buf.method_22912(1.0f, 1.0f, 0.0f).method_22913(1.0f, 1.0f);
            buf.method_22912(-1.0f, 1.0f, 0.0f).method_22913(0.0f, 1.0f);
            class_286.method_43433((class_9801)buf.method_60800());
            ModShaders.AURA_PULSE.method_34585();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int nextPow2(int x) {
        if (x <= 1) {
            return 1;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    private static class PulseInstance {
        final class_243 origin;
        final float r;
        final float g;
        final float b;
        final float distance;
        int age = 0;
        static final int MAX_AGE = 120;

        PulseInstance(class_243 origin, float r, float g, float b, float distance) {
            this.origin = origin;
            this.r = r;
            this.g = g;
            this.b = b;
            this.distance = distance;
        }

        boolean tick() {
            ++this.age;
            return this.age >= 120;
        }

        float getRadius(float partialTicks) {
            return ((float)this.age + partialTicks) * 1.5f;
        }
    }
}

