/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.ball;

import com.cobblemon.mod.common.entity.pokeball.EmptyPokeBallEntity;
import com.jayemceekay.shadowedhearts.client.ModShaders;
import com.jayemceekay.shadowedhearts.client.render.BallRenderTypes;
import com.jayemceekay.shadowedhearts.client.trail.BallTrailManager;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_284;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5944;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class BallEmitters {
    private static final Map<Integer, BallInstance> ACTIVE = new ConcurrentHashMap<Integer, BallInstance>();

    private BallEmitters() {
    }

    public static void startForEntity(EmptyPokeBallEntity entity) {
        if (!entity.getAspects().contains("snag_ball")) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        long now = mc.field_1687.method_8510();
        ACTIVE.put(entity.method_5628(), new BallInstance(entity.method_5628(), (class_1297)entity, now, 4, 400, 8));
    }

    public static void onEntityDespawn(int entityId) {
        class_310 mc = class_310.method_1551();
        long now = mc != null && mc.field_1687 != null ? mc.field_1687.method_8510() : 0L;
        ACTIVE.computeIfPresent(entityId, (id, inst) -> {
            inst.beginImmediateFadeOut(now, 6);
            return inst;
        });
    }

    public static void onRender(class_4184 camera, float partialTicks) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        for (Map.Entry<Integer, BallInstance> en : ACTIVE.entrySet()) {
            BallInstance inst = en.getValue();
            if (inst == null) {
                ACTIVE.remove(en.getKey());
                continue;
            }
            if (inst.isExpired(mc.field_1687.method_8510())) {
                ACTIVE.remove(en.getKey());
                continue;
            }
            class_1297 ent = inst.entityRef != null ? (class_1297)inst.entityRef.get() : null;
            boolean useEnt = ent != null && ent.method_5805() && ent.method_5628() == inst.entityId;
            if (!useEnt) continue;
            double ix = class_3532.method_16436((double)partialTicks, (double)ent.field_6038, (double)ent.method_23317());
            double iy = class_3532.method_16436((double)partialTicks, (double)ent.field_5971, (double)ent.method_23318());
            double iz = class_3532.method_16436((double)partialTicks, (double)ent.field_5989, (double)ent.method_23321());
            BallTrailManager.addPointForId(inst.entityId, ix, iy, iz);
            class_4587 poseStack = new class_4587();
            class_243 camPos = camera.method_19326();
            poseStack.method_22904(ix - camPos.field_1352, iy + (double)(ent.method_17682() / 8.0f) - camPos.field_1351, iz - camPos.field_1350);
            class_4597.class_4598 buf = class_310.method_1551().method_22940().method_23000();
            BallEmitters.renderOrb(poseStack, (class_4597)buf, partialTicks);
            BallTrailManager.renderForId(inst.entityId, partialTicks, poseStack, (class_4597)buf);
            buf.method_22993();
        }
    }

    private static void renderOrb(class_4587 poseStack, class_4597 buffer, float partialTicks) {
        int FULLBRIGHT = 0xF000F0;
        poseStack.method_22903();
        poseStack.method_22907(class_310.method_1551().method_1561().method_24197());
        float base = 0.85f;
        poseStack.method_22905(base, base, base);
        if (ModShaders.BALL_GLOW != null) {
            try {
                BallEmitters.apply(ModShaders.BALL_GLOW);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        class_4588 vc = buffer.getBuffer(BallRenderTypes.ballGlow(null));
        BallEmitters.emitUnitQuad(vc, poseStack, 0xF000F0);
        poseStack.method_22909();
    }

    private static void emitUnitQuad(class_4588 vc, class_4587 stack, int packedLight) {
        class_4587.class_4665 last = stack.method_23760();
        Matrix4f pose = last.method_23761();
        float x0 = -1.0f;
        float y0 = -1.0f;
        float x1 = 1.0f;
        float y1 = 1.0f;
        vc.method_22918(pose, x0, y0, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(last, 0.0f, 0.0f, 1.0f);
        vc.method_22918(pose, x1, y0, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(last, 0.0f, 0.0f, 1.0f);
        vc.method_22918(pose, x1, y1, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(last, 0.0f, 0.0f, 1.0f);
        vc.method_22918(pose, x0, y1, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(last, 0.0f, 0.0f, 1.0f);
    }

    public static void renderHudOrb(class_4587 poseStack, class_4597 buffers, int sizePx, float alpha) {
        int FULLBRIGHT = 0xF000F0;
        poseStack.method_22903();
        float s = (float)sizePx * 0.5f;
        poseStack.method_22905(s, s, s);
        if (ModShaders.BALL_GLOW != null) {
            try {
                BallEmitters.apply(ModShaders.BALL_GLOW);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        class_4588 vc = buffers.getBuffer(BallRenderTypes.ballGlowHud());
        BallEmitters.emitUnitQuadAlpha(vc, poseStack, 0xF000F0, alpha);
        poseStack.method_22909();
    }

    private static void emitUnitQuadAlpha(class_4588 vc, class_4587 stack, int packedLight, float alpha) {
        class_4587.class_4665 last = stack.method_23760();
        Matrix4f pose = last.method_23761();
        float x0 = -1.0f;
        float y0 = -1.0f;
        float x1 = 1.0f;
        float y1 = 1.0f;
        vc.method_22918(pose, x0, y0, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(last, 0.0f, 0.0f, 1.0f);
        vc.method_22918(pose, x1, y0, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(last, 0.0f, 0.0f, 1.0f);
        vc.method_22918(pose, x1, y1, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(last, 0.0f, 0.0f, 1.0f);
        vc.method_22918(pose, x0, y1, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(last, 0.0f, 0.0f, 1.0f);
    }

    public static void apply(class_5944 shader) {
        if (shader == null) {
            return;
        }
        float time = (float)class_310.method_1551().field_1687.method_8510() + class_310.method_1551().method_60646().method_60637(true);
        Object u_c0 = null;
        float[] u_c1 = new float[]{1.25f, 0.72f, 0.12f};
        float[] u_c2 = new float[]{1.25f, 0.25f, 0.1f};
        Object u_c3 = null;
        Float u_t1 = Float.valueOf(0.25f);
        Float u_t2 = null;
        Float u_t3 = null;
        Object u_lumaCoeff = null;
        Object u_glowTint = null;
        BallEmitters.set1f(shader, "u_orbMode", Float.valueOf(1.0f));
        BallEmitters.set1f(shader, "u_time", Float.valueOf(time));
        BallEmitters.set1f(shader, "u_rimStrength", null);
        BallEmitters.set1f(shader, "u_pulseSpeed", Float.valueOf(0.125f));
        BallEmitters.set1f(shader, "u_useMask", Float.valueOf(1.0f));
        BallEmitters.set1f(shader, "u_orbMode", null);
        BallEmitters.set1f(shader, "u_orbIntensity", Float.valueOf(1.4f));
        BallEmitters.set1f(shader, "u_orbSoftness", Float.valueOf(1.0f));
        BallEmitters.set1f(shader, "u_starStrength", Float.valueOf(1.0f));
        BallEmitters.set1f(shader, "u_starSharpness", Float.valueOf(20.0f));
        BallEmitters.set1f(shader, "u_starCount", Float.valueOf(4.0f));
        BallEmitters.set1f(shader, "u_starFalloff", Float.valueOf(0.65f));
        BallEmitters.set1f(shader, "u_starRotateSpeed", Float.valueOf(0.0f));
        BallEmitters.set1f(shader, "u_starPhase", Float.valueOf(0.0f));
        BallEmitters.set1f(shader, "u_glowMix", Float.valueOf(1.0f));
        BallEmitters.set1f(shader, "u_paletteSpeed", Float.valueOf(0.2f));
        BallEmitters.set1f(shader, "u_paletteShift", null);
        BallEmitters.set1f(shader, "u_paletteSaturation", null);
        BallEmitters.set1f(shader, "u_t1", u_t1);
        BallEmitters.set1f(shader, "u_t2", u_t2);
        BallEmitters.set1f(shader, "u_t3", u_t3);
        if (u_glowTint != null && (u_glowTint).length >= 3) {
            BallEmitters.set3f(shader, "u_glowTint", (float)u_glowTint[0], (float)u_glowTint[1], (float)u_glowTint[2]);
        }
        if (u_c0 != null && (u_c0).length >= 3) {
            BallEmitters.set3f(shader, "u_c0", (float)u_c0[0], (float)u_c0[1], (float)u_c0[2]);
        }
        if (u_c1 != null && u_c1.length >= 3) {
            BallEmitters.set3f(shader, "u_c1", u_c1[0], u_c1[1], u_c1[2]);
        }
        if (u_c2 != null && u_c2.length >= 3) {
            BallEmitters.set3f(shader, "u_c2", u_c2[0], u_c2[1], u_c2[2]);
        }
        if (u_c3 != null && (u_c3).length >= 3) {
            BallEmitters.set3f(shader, "u_c3", (float)u_c3[0], (float)u_c3[1], (float)u_c3[2]);
        }
        if (u_lumaCoeff != null && (u_lumaCoeff).length >= 3) {
            BallEmitters.set3f(shader, "u_lumaCoeff", (float)u_lumaCoeff[0], (float)u_lumaCoeff[1], (float)u_lumaCoeff[2]);
        }
    }

    private static void set1f(class_5944 shader, String name, Float value) {
        if (value == null) {
            return;
        }
        class_284 u = shader.method_34582(name);
        if (u != null) {
            u.method_1251(value.floatValue());
        }
    }

    private static void set3f(class_5944 shader, String name, float x, float y, float z) {
        class_284 u = shader.method_34582(name);
        if (u != null) {
            u.method_1249(x, y, z);
        }
    }

    private static final class BallInstance {
        final int entityId;
        final WeakReference<class_1297> entityRef;
        long startTick;
        int fadeInTicks;
        int sustainTicks;
        int fadeOutTicks;

        BallInstance(int entityId, @Nullable class_1297 ent, long startTick, int fi, int sus, int fo) {
            this.entityId = entityId;
            this.entityRef = new WeakReference<class_1297>(ent);
            this.startTick = startTick;
            this.fadeInTicks = Math.max(1, fi);
            this.sustainTicks = Math.max(0, sus);
            this.fadeOutTicks = Math.max(1, fo);
        }

        void beginImmediateFadeOut(long now, int outTicks) {
            this.startTick = now - (long)this.fadeInTicks - (long)this.sustainTicks;
            this.fadeOutTicks = Math.max(1, outTicks);
        }

        boolean isExpired(long now) {
            long total = (long)this.fadeInTicks + (long)this.sustainTicks + (long)this.fadeOutTicks;
            return now - this.startTick >= total;
        }
    }
}

