/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.gui;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.jayemceekay.shadowedhearts.ShadowPokemonData;
import com.jayemceekay.shadowedhearts.aura.AuraReaderCharge;
import com.jayemceekay.shadowedhearts.client.ModKeybinds;
import com.jayemceekay.shadowedhearts.client.aura.AuraPulseRenderer;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.core.ModSounds;
import com.jayemceekay.shadowedhearts.integration.accessories.SnagAccessoryBridgeHolder;
import com.jayemceekay.shadowedhearts.items.AuraReaderItem;
import com.jayemceekay.shadowedhearts.network.AuraPulsePacket;
import com.jayemceekay.shadowedhearts.network.AuraScannerC2SPacket;
import com.jayemceekay.shadowedhearts.network.MeteoroidScanRequestPacket;
import com.jayemceekay.shadowedhearts.network.ShadowedHeartsNetwork;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7833;

public class AuraScannerHUD {
    private static final class_2960 SCAN_RING_INNER = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/scan_ring_inner.png");
    private static final class_2960 SCAN_RING_OUTER = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/scan_ring_outer.png");
    private static final class_2960 SCAN_RING_MIDDLE = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/scan_ring_middle.png");
    private static final class_2960 SCANLINES = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/overlay_scanlines.png");
    private static final class_2960 POINTER = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/pointer.png");
    private static final class_2960 SELECT_ARROW = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/select_arrow.png");
    private static final class_2960 INFO_FRAME = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/scan_info_frame.png");
    private static final class_2960 SCAN_OVERLAY_CORNERS = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/overlay_corners.png");
    private static final class_2960 SCAN_OVERLAY_TOP = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/overlay_border_top.png");
    private static final class_2960 SCAN_OVERLAY_BOTTOM = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/overlay_border_bottom.png");
    private static final class_2960 SCAN_OVERLAY_LEFT = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/overlay_border_left.png");
    private static final class_2960 SCAN_OVERLAY_RIGHT = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/overlay_border_right.png");
    private static final class_2960 SCAN_OVERLAY_NOTCH = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/overlay_notch.png");
    private static final class_2960 UNKNOWN_MARK = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/scan_unknown.png");
    private static final int SCAN_OVERLAY_NOTCH_WIDTH = 200;
    private static final class_2960 CENTER_INFO_FRAME = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/pokedex/scan/scan_info_frame.png");
    private static final int CENTER_INFO_FRAME_WIDTH = 128;
    private static final int CENTER_INFO_FRAME_HEIGHT = 16;
    private static final int OUTER_INFO_FRAME_WIDTH = 92;
    private static final int OUTER_INFO_FRAME_HEIGHT = 55;
    private static final int INNER_INFO_FRAME_WIDTH = 120;
    private static final int INNER_INFO_FRAME_HEIGHT = 20;
    private static final int INNER_INFO_FRAME_STEM_WIDTH = 28;
    private static boolean active = false;
    private static float fadeAmount = 0.0f;
    private static float prevFadeAmount = 0.0f;
    private static float bootTimer = 0.0f;
    private static float prevBootTimer = 0.0f;
    private static final float BOOT_DURATION = 0.5f;
    private static float sweepAngle = 0.0f;
    private static float prevSweepAngle = 0.0f;
    private static float glitchTimer = 0.0f;
    private static float prevGlitchTimer = 0.0f;
    private static float lastXRot = 0.0f;
    private static float lastYRot = 0.0f;
    private static float scanningProgress = 0.0f;
    private static float prevScanningProgress = 0.0f;
    private static PokemonEntity scannedPokemon = null;
    private static int beepTimer = 0;
    private static int pulseQueue = 0;
    private static int pulseTimer = 0;
    private static int pulseCooldown = 0;
    private static int scannerCooldown = 0;
    private static final int PULSE_COOLDOWN_TICKS = 200;
    private static final int SCANNER_COOLDOWN_TICKS = 20;
    private static final Map<UUID, Integer> DETECTED_SHADOWS = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, Integer> PENDING_RESPONSES = Collections.synchronizedMap(new HashMap());
    private static final int DETECTION_DURATION_POKEMON = 100;
    private static final int DETECTION_DURATION_METEOROIDS = 200;
    private static final int RESPONSE_DELAY = 100;
    private static final Map<class_2338, Integer> DETECTED_METEOROIDS = Collections.synchronizedMap(new HashMap());
    private static final Map<class_2338, Integer> PENDING_METEOROID_RESPONSES = Collections.synchronizedMap(new HashMap());
    private static boolean isScanning = false;
    private static float maxIntensity = 0.0f;

    private static class_2960 getInfoFrameResource(boolean isLeft, int tier) {
        return class_2960.method_60655((String)"cobblemon", (String)("textures/gui/pokedex/scan/scan_info_frame_" + (isLeft ? "left" : "right") + "_" + tier + ".png"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        block52: {
            try {
                class_310 mc = class_310.method_1551();
                if (mc.field_1724 == null || mc.field_1687 == null) {
                    return;
                }
                prevFadeAmount = fadeAmount;
                prevBootTimer = bootTimer;
                prevSweepAngle = sweepAngle;
                prevGlitchTimer = glitchTimer;
                prevScanningProgress = scanningProgress;
                float xRot = mc.field_1724.method_36455();
                float yRot = mc.field_1724.method_36454();
                lastXRot = xRot;
                lastYRot = yRot;
                boolean hasAuraReader = SnagAccessoryBridgeHolder.INSTANCE.isAuraReaderEquipped((class_1657)mc.field_1724);
                if (ModKeybinds.consumeAuraScannerPress() && scannerCooldown <= 0) {
                    if (hasAuraReader && ShadowedHeartsConfigs.getInstance().getClientConfig().auraScannerEnabled()) {
                        class_1799 auraReader = SnagAccessoryBridgeHolder.INSTANCE.getAuraReaderStack((class_1657)mc.field_1724);
                        if (!auraReader.method_7960() && AuraReaderCharge.get(auraReader) > 0) {
                            active = !active;
                            scannerCooldown = 20;
                            ShadowedHeartsNetwork.sendToServer(new AuraScannerC2SPacket(active));
                            if (active) {
                                class_310.method_1551().field_1724.method_5783((class_3414)ModSounds.AURA_READER_EQUIP.get(), 1.0f, 1.0f);
                                bootTimer = 0.5f;
                                sweepAngle = 0.0f;
                                prevSweepAngle = 0.0f;
                            } else {
                                class_310.method_1551().field_1724.method_5783((class_3414)ModSounds.AURA_READER_UNEQUIP.get(), 1.0f, 1.0f);
                            }
                        }
                    } else if (active) {
                        active = false;
                        ShadowedHeartsNetwork.sendToServer(new AuraScannerC2SPacket(false));
                    }
                }
                if (active && !hasAuraReader) {
                    active = false;
                    ShadowedHeartsNetwork.sendToServer(new AuraScannerC2SPacket(false));
                }
                if (pulseCooldown > 0) {
                    --pulseCooldown;
                }
                if (scannerCooldown > 0) {
                    --scannerCooldown;
                }
                if (ModKeybinds.consumeAuraPulsePress() && active && pulseCooldown <= 0) {
                    pulseQueue = 3;
                    pulseTimer = 0;
                    ShadowedHeartsNetwork.sendToServer(new AuraPulsePacket());
                    mc.field_1724.method_43077((class_3414)ModSounds.AURA_SCANNER_BEEP.get());
                    int shadowRange = ShadowedHeartsConfigs.getInstance().getShadowConfig().auraScannerShadowRange();
                    List entities = mc.field_1687.method_8335(null, mc.field_1724.method_5829().method_1014((double)shadowRange));
                    for (class_1297 entity : entities) {
                        Object pe;
                        if (!(entity instanceof PokemonEntity) || !ShadowPokemonData.isShadow((PokemonEntity)(pe = (PokemonEntity)entity))) continue;
                        PENDING_RESPONSES.put(entity.method_5667(), 100);
                    }
                    int meteoroidRange = ShadowedHeartsConfigs.getInstance().getShadowConfig().auraScannerMeteoroidRange();
                    ShadowedHeartsNetwork.sendToServer(new MeteoroidScanRequestPacket(meteoroidRange));
                    pulseCooldown = 200;
                }
                if (active) {
                    double dist;
                    if (pulseQueue > 0) {
                        if (pulseTimer <= 0) {
                            AuraPulseRenderer.spawnPulse(mc.field_1724.method_19538());
                            --pulseQueue;
                            pulseTimer = 10;
                        } else {
                            --pulseTimer;
                        }
                    }
                    Map<UUID, Integer> shadowRange = PENDING_RESPONSES;
                    synchronized (shadowRange) {
                        Iterator<Map.Entry<UUID, Integer>> respIter = PENDING_RESPONSES.entrySet().iterator();
                        while (respIter.hasNext()) {
                            class_1297 entity;
                            Map.Entry<UUID, Integer> entry = respIter.next();
                            entry.setValue(entry.getValue() - 1);
                            if (entry.getValue() > 0) continue;
                            entity = null;
                            for (class_1297 e : mc.field_1687.method_18112()) {
                                if (!e.method_5667().equals(entry.getKey())) continue;
                                entity = e;
                                break;
                            }
                            if (entity != null) {
                                AuraPulseRenderer.spawnPulse(entity.method_19538(), 0.6f, 0.3f, 1.0f, 128.0f);
                                DETECTED_SHADOWS.put(entity.method_5667(), 100);
                            }
                            respIter.remove();
                        }
                    }
                    shadowRange = PENDING_METEOROID_RESPONSES;
                    synchronized (shadowRange) {
                        Iterator<Map.Entry<class_2338, Integer>> metRespIter = PENDING_METEOROID_RESPONSES.entrySet().iterator();
                        while (metRespIter.hasNext()) {
                            Map.Entry<class_2338, Integer> entry = metRespIter.next();
                            entry.setValue(entry.getValue() - 1);
                            if (entry.getValue() > 0) continue;
                            AuraPulseRenderer.spawnPulse(entry.getKey().method_46558(), 0.6f, 0.3f, 1.0f, 256.0f);
                            DETECTED_METEOROIDS.put(entry.getKey(), 200);
                            metRespIter.remove();
                        }
                    }
                    shadowRange = DETECTED_SHADOWS;
                    synchronized (shadowRange) {
                        Iterator<Map.Entry<UUID, Integer>> detectIter = DETECTED_SHADOWS.entrySet().iterator();
                        while (detectIter.hasNext()) {
                            Map.Entry<UUID, Integer> entry = detectIter.next();
                            entry.setValue(entry.getValue() - 1);
                            if (entry.getValue() > 0) continue;
                            detectIter.remove();
                        }
                    }
                    shadowRange = DETECTED_METEOROIDS;
                    synchronized (shadowRange) {
                        Iterator<Map.Entry<class_2338, Integer>> metDetectIter = DETECTED_METEOROIDS.entrySet().iterator();
                        while (metDetectIter.hasNext()) {
                            Map.Entry<class_2338, Integer> entry = metDetectIter.next();
                            entry.setValue(entry.getValue() - 1);
                            if (entry.getValue() > 0) continue;
                            metDetectIter.remove();
                        }
                    }
                    fadeAmount = Math.min(1.0f, fadeAmount + 0.1f);
                    if (bootTimer > 0.0f) {
                        bootTimer -= 0.05f;
                    }
                    if ((sweepAngle += 0.1f) > (float)Math.PI * 2) {
                        sweepAngle -= (float)Math.PI * 2;
                        prevSweepAngle -= (float)Math.PI * 2;
                    }
                    PokemonEntity nearest = null;
                    double minDist = Double.MAX_VALUE;
                    List nearbyEntities = mc.field_1687.method_8335(null, mc.field_1724.method_5829().method_1014(16.0));
                    for (class_1297 entity : nearbyEntities) {
                        double dist2;
                        Object pe;
                        if (!(entity instanceof PokemonEntity) || !ShadowPokemonData.isShadow((PokemonEntity)(pe = (PokemonEntity)entity)) || !DETECTED_SHADOWS.containsKey(pe.method_5667()) || !((dist2 = (double)entity.method_5739((class_1297)mc.field_1724)) < minDist)) continue;
                        minDist = dist2;
                        nearest = pe;
                    }
                    if (nearest != null) {
                        if (scannedPokemon != nearest) {
                            scannedPokemon = nearest;
                            scanningProgress = 0.0f;
                        }
                        scanningProgress = Math.min(1.0f, scanningProgress + 0.01f);
                    } else {
                        scannedPokemon = null;
                        scanningProgress = Math.max(0.0f, scanningProgress - 0.05f);
                    }
                    class_1799 auraReader = SnagAccessoryBridgeHolder.INSTANCE.getAuraReaderStack((class_1657)mc.field_1724);
                    if (!auraReader.method_7960() && auraReader.method_7909() instanceof AuraReaderItem && AuraReaderCharge.get(auraReader) <= 0) {
                        active = false;
                    }
                    boolean legendaryNearby = false;
                    nearbyEntities = mc.field_1687.method_8335(null, mc.field_1724.method_5829().method_1014(32.0));
                    for (class_1297 entity : nearbyEntities) {
                        Object pe;
                        if (!(entity instanceof PokemonEntity) || !ShadowPokemonData.isShadow((PokemonEntity)(pe = (PokemonEntity)entity)) || !pe.getPokemon().isLegendary()) continue;
                        legendaryNearby = true;
                        break;
                    }
                    if (legendaryNearby && mc.field_1687.field_9229.method_43057() < 0.1f) {
                        glitchTimer = 0.2f;
                    }
                    if (glitchTimer > 0.0f) {
                        glitchTimer -= 0.05f;
                    }
                    maxIntensity = 0.0f;
                    int shadowRange2 = ShadowedHeartsConfigs.getInstance().getShadowConfig().auraScannerShadowRange();
                    List nearbyShadows = mc.field_1687.method_8335(null, mc.field_1724.method_5829().method_1014((double)shadowRange2));
                    for (Object entity : nearbyShadows) {
                        PokemonEntity pe;
                        if (!(entity instanceof PokemonEntity) || !ShadowPokemonData.isShadow(pe = (PokemonEntity)entity) || !DETECTED_SHADOWS.containsKey(pe.method_5667())) continue;
                        dist = entity.method_5739((class_1297)mc.field_1724);
                        maxIntensity = Math.max(maxIntensity, (float)(1.0 - dist / (double)shadowRange2));
                    }
                    int meteoroidRange = ShadowedHeartsConfigs.getInstance().getShadowConfig().auraScannerMeteoroidRange();
                    for (class_2338 p : DETECTED_METEOROIDS.keySet()) {
                        dist = Math.sqrt(p.method_10262((class_2382)mc.field_1724.method_24515()));
                        maxIntensity = Math.max(maxIntensity, (float)(1.0 - dist / (double)meteoroidRange));
                    }
                    if (beepTimer > 0) {
                        --beepTimer;
                    } else if (maxIntensity > 0.0f) {
                        int delay = (int)class_3532.method_16439((float)maxIntensity, (float)60.0f, (float)5.0f);
                        float pitch = class_3532.method_16439((float)maxIntensity, (float)0.8f, (float)1.5f);
                        mc.field_1687.method_43128((class_1657)mc.field_1724, mc.field_1724.method_23317(), mc.field_1724.method_23318(), mc.field_1724.method_23321(), (class_3414)ModSounds.AURA_SCANNER_BEEP.get(), class_3419.field_15248, 0.3f, pitch);
                        beepTimer = delay;
                    }
                    break block52;
                }
                fadeAmount = Math.max(0.0f, fadeAmount - 0.1f);
                beepTimer = 0;
                maxIntensity = 0.0f;
                pulseQueue = 0;
                pulseTimer = 0;
                AuraPulseRenderer.clearPulses();
                DETECTED_SHADOWS.clear();
                PENDING_RESPONSES.clear();
                DETECTED_METEOROIDS.clear();
                PENDING_METEOROID_RESPONSES.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void render(class_332 guiGraphics, float partialTick) {
        float currentGlitchTimer;
        float baseAlpha = class_3532.method_16439((float)partialTick, (float)prevFadeAmount, (float)fadeAmount);
        if (baseAlpha <= 0.0f) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        int width = mc.method_22683().method_4486();
        int height = mc.method_22683().method_4502();
        float time = ((float)mc.field_1687.method_8510() + partialTick) * 0.05f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float renderAlpha = baseAlpha;
        float currentBootTimer = class_3532.method_16439((float)partialTick, (float)prevBootTimer, (float)bootTimer);
        if (currentBootTimer > 0.0f && (int)(currentBootTimer * 20.0f) % 2 == 0) {
            renderAlpha *= 0.5f;
        }
        if ((currentGlitchTimer = class_3532.method_16439((float)partialTick, (float)prevGlitchTimer, (float)glitchTimer)) > 0.0f) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((mc.field_1687.field_9229.method_43057() - 0.5f) * 10.0f, (mc.field_1687.field_9229.method_43057() - 0.5f) * 10.0f, 0.0f);
            if (mc.field_1687.field_9229.method_43057() < 0.3f) {
                renderAlpha *= 0.5f;
            }
        }
        guiGraphics.method_51448().method_22903();
        float yOffset = (1.0f - baseAlpha) * (float)(-height);
        guiGraphics.method_51448().method_46416(0.0f, yOffset, 0.0f);
        AuraScannerHUD.renderOverlay(guiGraphics, width, height, renderAlpha, time);
        AuraScannerHUD.renderReticle(guiGraphics, width / 2, height / 2, renderAlpha, time, partialTick);
        AuraScannerHUD.renderDirectionalIndicatorsAndSweep(guiGraphics, width / 2, height / 2, renderAlpha, time, partialTick);
        AuraScannerHUD.renderSignalStrength(guiGraphics, width, height, renderAlpha);
        guiGraphics.method_51448().method_22909();
        if (currentGlitchTimer > 0.0f) {
            guiGraphics.method_51448().method_22909();
        }
        RenderSystem.disableBlend();
    }

    private static void renderOverlay(class_332 guiGraphics, int width, int height, float alpha, float time) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        int interlacePos = (int)(Math.ceil((double)(time * 20.0f % 14.0f) * 0.5) * 0.5);
        for (int i = 0; i < height; ++i) {
            if (i % 4 != 0) continue;
            guiGraphics.method_25290(SCANLINES, 0, i - interlacePos, 0.0f, 0.0f, width, 4, width, 4);
        }
        guiGraphics.method_25290(SCAN_OVERLAY_CORNERS, 0, 0, 0.0f, 0.0f, 4, 4, 8, 8);
        guiGraphics.method_25290(SCAN_OVERLAY_CORNERS, width - 4, 0, 4.0f, 0.0f, 4, 4, 8, 8);
        guiGraphics.method_25290(SCAN_OVERLAY_CORNERS, 0, height - 4, 0.0f, 4.0f, 4, 4, 8, 8);
        guiGraphics.method_25290(SCAN_OVERLAY_CORNERS, width - 4, height - 4, 4.0f, 4.0f, 4, 4, 8, 8);
        int notchStartX = (width - 200) / 2;
        guiGraphics.method_25290(SCAN_OVERLAY_TOP, 4, 0, 0.0f, 0.0f, notchStartX - 4, 3, notchStartX - 4, 3);
        guiGraphics.method_25290(SCAN_OVERLAY_TOP, notchStartX + 200, 0, 0.0f, 0.0f, width - (notchStartX + 200 + 4), 3, width - (notchStartX + 200 + 4), 3);
        guiGraphics.method_25290(SCAN_OVERLAY_BOTTOM, 4, height - 3, 0.0f, 0.0f, width - 8, 3, width - 8, 3);
        guiGraphics.method_25290(SCAN_OVERLAY_LEFT, 0, 4, 0.0f, 0.0f, 3, height - 8, 3, height - 8);
        guiGraphics.method_25290(SCAN_OVERLAY_RIGHT, width - 3, 4, 0.0f, 0.0f, 3, height - 8, 3, height - 8);
        guiGraphics.method_25290(SCAN_OVERLAY_NOTCH, notchStartX, 0, 0.0f, 0.0f, 200, 12, 200, 12);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderReticle(class_332 guiGraphics, int centerX, int centerY, float alpha, float time, float partialTick) {
        float currentBootTimer = class_3532.method_16439((float)partialTick, (float)prevBootTimer, (float)bootTimer);
        float scale = 1.0f;
        if (currentBootTimer > 0.0f) {
            scale = 1.0f - currentBootTimer / 0.5f;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        float rotation = time * 20.0f % 360.0f;
        guiGraphics.method_51448().method_22903();
        RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)1.0f, (float)alpha);
        guiGraphics.method_25290(SCAN_RING_OUTER, -58, -58, 0.0f, 0.0f, 116, 116, 116, 116);
        guiGraphics.method_51448().method_22909();
        int segments = 40;
        for (int i = 0; i < segments; ++i) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees((float)((double)i * 4.5 + (double)rotation * 0.5)));
            RenderSystem.setShaderColor((float)0.0f, (float)0.8f, (float)1.0f, (float)(alpha * 0.8f));
            guiGraphics.method_25290(SCAN_RING_MIDDLE, -50, 0, 0.0f, 0.0f, 100, 1, 100, 1);
            guiGraphics.method_51448().method_22909();
        }
        guiGraphics.method_51448().method_22903();
        RenderSystem.setShaderColor((float)0.0f, (float)0.6f, (float)1.0f, (float)(alpha * 0.6f));
        guiGraphics.method_25290(SCAN_RING_INNER, -42, -42, 0.0f, 0.0f, 84, 84, 84, 84);
        guiGraphics.method_51448().method_22909();
        float currentScanningProgress = class_3532.method_16439((float)partialTick, (float)prevScanningProgress, (float)scanningProgress);
        if (scannedPokemon != null && currentScanningProgress < 0.5f) {
            float markAlpha = (0.5f - currentScanningProgress) * 2.0f * alpha;
            RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)1.0f, (float)markAlpha);
            guiGraphics.method_25290(UNKNOWN_MARK, -17, -23, 0.0f, 0.0f, 34, 46, 34, 46);
        }
        guiGraphics.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderDirectionalIndicatorsAndSweep(class_332 guiGraphics, int centerX, int centerY, float alpha, float time, float partialTick) {
        float segmentAlpha;
        float spike;
        float angleDiff;
        float intensity;
        double dist;
        double angle;
        double dz;
        double dx;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null || mc.field_1687 == null) {
            return;
        }
        float currentSweep = class_3532.method_16439((float)partialTick, (float)prevSweepAngle, (float)sweepAngle);
        float currentGlitchTimer = class_3532.method_16439((float)partialTick, (float)prevGlitchTimer, (float)glitchTimer);
        if (currentGlitchTimer > 0.0f) {
            currentSweep += (mc.field_1687.field_9229.method_43057() - 0.5f) * 0.5f;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
        guiGraphics.method_51448().method_22907(class_7833.field_40718.rotation(currentSweep));
        RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.4f));
        guiGraphics.method_25294(-1, -55, 1, 0, (int)(alpha * 0.4f * 255.0f) << 24 | 0xFFFF);
        guiGraphics.method_51448().method_22909();
        int shadowRange = ShadowedHeartsConfigs.getInstance().getShadowConfig().auraScannerShadowRange();
        List nearbyEntities = mc.field_1687.method_8335(null, player.method_5829().method_1014((double)shadowRange));
        for (class_1297 entity : nearbyEntities) {
            PokemonEntity pe;
            if (!(entity instanceof PokemonEntity) || !ShadowPokemonData.isShadow(pe = (PokemonEntity)entity) || !DETECTED_SHADOWS.containsKey(pe.method_5667())) continue;
            dx = entity.method_23317() - player.method_23317();
            dz = entity.method_23321() - player.method_23321();
            angle = Math.atan2(dz, dx) - Math.toRadians(player.method_36454()) - 1.5707963267948966;
            dist = Math.sqrt(dx * dx + dz * dz);
            intensity = (float)Math.max(0.0, 1.0 - dist / (double)shadowRange);
            angleDiff = (float)(angle - (double)currentSweep);
            while ((double)angleDiff < -Math.PI) {
                angleDiff = (float)((double)angleDiff + Math.PI * 2);
            }
            while ((double)angleDiff > Math.PI) {
                angleDiff = (float)((double)angleDiff - Math.PI * 2);
            }
            spike = Math.max(0.0f, 1.0f - Math.abs(angleDiff) * 5.0f);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
            guiGraphics.method_51448().method_22907(class_7833.field_40718.rotation((float)angle));
            segmentAlpha = alpha * intensity * (0.3f + 0.7f * spike);
            RenderSystem.setShaderColor((float)0.6f, (float)0.3f, (float)1.0f, (float)segmentAlpha);
            guiGraphics.method_25290(SELECT_ARROW, -8, -80, 0.0f, 16.0f, 16, -16, 16, 16);
            guiGraphics.method_51448().method_22909();
        }
        int meteoroidRangeIndicator = ShadowedHeartsConfigs.getInstance().getShadowConfig().auraScannerMeteoroidRange();
        for (class_2338 p : DETECTED_METEOROIDS.keySet()) {
            dx = (double)p.method_10263() + 0.5 - player.method_23317();
            dz = (double)p.method_10260() + 0.5 - player.method_23321();
            angle = Math.atan2(dz, dx) - Math.toRadians(player.method_36454()) - 1.5707963267948966;
            dist = Math.sqrt(dx * dx + dz * dz);
            intensity = (float)Math.max(0.0, 1.0 - dist / (double)meteoroidRangeIndicator);
            angleDiff = (float)(angle - (double)currentSweep);
            while ((double)angleDiff < -Math.PI) {
                angleDiff = (float)((double)angleDiff + Math.PI * 2);
            }
            while ((double)angleDiff > Math.PI) {
                angleDiff = (float)((double)angleDiff - Math.PI * 2);
            }
            spike = Math.max(0.0f, 1.0f - Math.abs(angleDiff) * 5.0f);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
            guiGraphics.method_51448().method_22907(class_7833.field_40718.rotation((float)angle));
            segmentAlpha = alpha * intensity * (0.3f + 0.7f * spike);
            RenderSystem.setShaderColor((float)0.8f, (float)0.2f, (float)0.9f, (float)segmentAlpha);
            guiGraphics.method_25290(SELECT_ARROW, -8, -80, 0.0f, 16.0f, 16, -16, 16, 16);
            guiGraphics.method_51448().method_22909();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderSignalStrength(class_332 guiGraphics, int width, int height, float alpha) {
        class_310 mc = class_310.method_1551();
        String label = "NO SIGNAL";
        int color = 0xAAAAAA;
        if ((double)maxIntensity > 0.8) {
            label = "STRONG SHADOW PRESENCE";
            color = 10694911;
        } else if ((double)maxIntensity > 0.5) {
            label = "MODERATE DISTURBANCE";
            color = 41983;
        } else if (maxIntensity > 0.0f) {
            label = "WEAK SIGNAL";
            color = 65535;
        }
        int textAlpha = (int)(alpha * 255.0f) << 24;
        int frameX = (width - 128) / 2;
        int frameY = height / 2 + 85;
        RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25300(mc.field_1772, label, width / 2, frameY + 4, color | textAlpha);
        int waveX = width / 2 - 50;
        int waveY = frameY + 45;
        for (int i = 0; i < 20; ++i) {
            float h = (float)Math.sin((float)mc.field_1687.method_8510() * 0.5f + (float)i * 0.5f) * 10.0f * maxIntensity;
            if (glitchTimer > 0.0f) {
                h *= mc.field_1687.field_9229.method_43057() * 2.0f;
            }
            guiGraphics.method_25294(waveX + i * 5, waveY, waveX + i * 5 + 2, (int)((float)waveY - h), color & 0xFFFFFF | textAlpha / 2);
        }
        AuraScannerHUD.renderChargeBar(guiGraphics, width, height, alpha);
        AuraScannerHUD.renderCooldownBar(guiGraphics, width, height, alpha);
    }

    private static void renderChargeBar(class_332 guiGraphics, int width, int height, float alpha) {
        class_310 mc = class_310.method_1551();
        class_1799 auraReader = SnagAccessoryBridgeHolder.INSTANCE.getAuraReaderStack((class_1657)mc.field_1724);
        if (auraReader.method_7960() || !(auraReader.method_7909() instanceof AuraReaderItem)) {
            return;
        }
        int charge = AuraReaderCharge.get(auraReader);
        float chargeRatio = (float)charge / 12000.0f;
        int barWidth = 100;
        int barHeight = 4;
        int x = (width - barWidth) / 2;
        int y = height / 2 + 75;
        int textAlpha = (int)(alpha * 255.0f) << 24;
        guiGraphics.method_25294(x - 1, y - 1, x + barWidth + 1, y + barHeight + 1, 0xAA000000 | textAlpha & 0xFF000000);
        int fillWidth = (int)((float)barWidth * chargeRatio);
        int color = 65535;
        if (chargeRatio < 0.2f) {
            color = 0xFF0000;
        }
        guiGraphics.method_25294(x, y, x + fillWidth, y + barHeight, color | textAlpha);
        String chargeText = String.format("CHARGE: %d%%", (int)(chargeRatio * 100.0f));
        guiGraphics.method_25300(mc.field_1772, chargeText, width / 2, y - 10, color | textAlpha);
    }

    private static void renderCooldownBar(class_332 guiGraphics, int width, int height, float alpha) {
        if (pulseCooldown <= 0) {
            return;
        }
        int barWidth = 25;
        int barHeight = 2;
        int x = (width - barWidth) / 3;
        int y = height / 2 + 60;
        int textAlpha = (int)(alpha * 255.0f) << 24;
        guiGraphics.method_25294(x - 1, y - 1, x + barWidth + 1, y + barHeight + 1, 0xAA000000 | textAlpha & 0xFF000000);
        float ratio = Math.min(1.0f, Math.max(0.0f, (float)pulseCooldown / 200.0f));
        int fillWidth = (int)((float)barWidth * ratio);
        int color = 0xAAAAAA;
        guiGraphics.method_25294(x, y, x + fillWidth, y + barHeight, color | textAlpha);
        class_310 mc = class_310.method_1551();
        String cdText = String.format("COOLDOWN: %.1fs", Float.valueOf((float)pulseCooldown / 20.0f));
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        guiGraphics.method_25300(mc.field_1772, cdText, width / 3, y - 10, 0xCCCCCC | textAlpha);
        poseStack.method_22905(1.0f, 1.0f, 1.0f);
        poseStack.method_22909();
    }

    private static void renderInfoPane(class_332 guiGraphics, int width, int height, float alpha, float partialTick) {
        float currentScanningProgress = class_3532.method_16439((float)partialTick, (float)prevScanningProgress, (float)scanningProgress);
        if (currentScanningProgress <= 0.0f) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (scannedPokemon == null) {
            return;
        }
        int centerX = width / 2;
        int centerY = height / 2;
        AuraScannerHUD.renderFrame(guiGraphics, centerX, centerY, true, 0, alpha);
        if (currentScanningProgress > 0.25f) {
            int level = scannedPokemon.getPokemon().getLevel();
            AuraScannerHUD.drawFrameText(guiGraphics, mc, "LV. " + level, centerX, centerY, true, 0, alpha);
        }
        AuraScannerHUD.renderFrame(guiGraphics, centerX, centerY, false, 1, alpha);
        if (currentScanningProgress > 0.5f) {
            String name = scannedPokemon.getPokemon().getSpecies().getName().toUpperCase();
            AuraScannerHUD.drawFrameText(guiGraphics, mc, name, centerX, centerY, false, 1, alpha);
        }
        AuraScannerHUD.renderFrame(guiGraphics, centerX, centerY, true, 3, alpha);
        if (currentScanningProgress > 0.75f) {
            String status;
            float corruption = ShadowPokemonData.getHeartGauge(scannedPokemon);
            String string = status = corruption > 0.8f ? "ELITE" : "COMMON";
            if (scannedPokemon.getPokemon().isLegendary()) {
                status = "LEGENDARY";
            }
            AuraScannerHUD.drawFrameText(guiGraphics, mc, status, centerX, centerY, true, 3, alpha);
        }
    }

    private static void renderFrame(class_332 guiGraphics, int centerX, int centerY, boolean isLeft, int tier, float alpha) {
        class_2960 tex = AuraScannerHUD.getInfoFrameResource(isLeft, tier);
        boolean isInner = tier == 1 || tier == 2;
        int frameWidth = isInner ? 120 : 92;
        int frameHeight = isInner ? 20 : 55;
        int xOffset = (isInner ? -177 : -120) + (isLeft ? 0 : (isInner ? 234 : 148));
        int yOffset = switch (tier) {
            case 0 -> -80;
            case 1 -> -26;
            case 2 -> 6;
            case 3 -> 25;
            default -> 0;
        };
        RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)1.0f, (float)alpha);
        guiGraphics.method_25290(tex, centerX + xOffset, centerY + yOffset, 0.0f, 0.0f, frameWidth, frameHeight, frameWidth, frameHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawFrameText(class_332 guiGraphics, class_310 mc, String text, int centerX, int centerY, boolean isLeft, int tier, float alpha) {
        int yOffsetText;
        int frameWidth;
        boolean isInner = tier == 1 || tier == 2;
        int xOffset = (isInner ? -177 : -120) + (isLeft ? 0 : (isInner ? 234 : 148));
        int yOffset = switch (tier) {
            case 0 -> -80;
            case 1 -> -26;
            case 2 -> 6;
            case 3 -> 25;
            default -> 0;
        };
        int n = frameWidth = isInner ? 120 : 92;
        int xOffsetText = isInner ? 46 + (isLeft ? 0 : 28) : 46;
        switch (tier) {
            case 0: {
                int n2 = 15;
                break;
            }
            case 1: {
                int n2 = 6;
                break;
            }
            case 2: {
                int n2 = 6;
                break;
            }
            case 3: {
                int n2 = 35;
                break;
            }
            default: {
                int n2 = yOffsetText = 0;
            }
        }
        if (glitchTimer > 0.0f && mc.field_1687.field_9229.method_43057() < 0.2f) {
            text = "########";
        }
        int textAlpha = (int)(alpha * 255.0f) << 24;
        guiGraphics.method_25300(mc.field_1772, text, centerX + xOffset + xOffsetText, centerY + yOffset + yOffsetText, 0xFFFF | textAlpha);
    }

    public static boolean isActive() {
        return active && fadeAmount > 0.0f;
    }

    public static void setActive(boolean activeIn) {
        active = activeIn;
        if (active) {
            bootTimer = 0.5f;
            sweepAngle = 0.0f;
            prevSweepAngle = 0.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueueMeteoroidCenters(List<class_2338> centers) {
        if (centers == null || centers.isEmpty()) {
            return;
        }
        Map<class_2338, Integer> map = PENDING_METEOROID_RESPONSES;
        synchronized (map) {
            for (class_2338 pos : centers) {
                if (pos == null) continue;
                PENDING_METEOROID_RESPONSES.put(pos.method_10062(), 100);
            }
        }
    }
}

