/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.particle;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.core.ModParticleTypes;
import com.jayemceekay.shadowedhearts.network.LuminousMotePacket;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;

public final class LuminousMoteEmitters {
    private static final Map<Integer, EmitterGroup> ACTIVE = new ConcurrentHashMap<Integer, EmitterGroup>();
    private static final long EMIT_TICKS = 60L;

    private LuminousMoteEmitters() {
    }

    public static void init() {
    }

    public static void receivePacket(LuminousMotePacket pkt) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        class_1297 ent = mc.field_1687.method_8469(pkt.getEntityId());
        if (ent instanceof PokemonEntity) {
            PokemonEntity pe = (PokemonEntity)ent;
            LuminousMoteEmitters.register(pe);
        }
    }

    public static void register(PokemonEntity pe) {
        if (!PokemonAspectUtil.hasShadowAspect(pe.getPokemon())) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        long now = mc.field_1687.method_8510();
        ACTIVE.put(pe.method_5628(), EmitterGroup.create((class_1297)pe, now + 60L));
    }

    public static void onRender(float partialTicks) {
        class_638 level;
        class_310 mc = class_310.method_1551();
        class_638 class_6382 = level = mc != null ? mc.field_1687 : null;
        if (level == null) {
            return;
        }
        long now = level.method_8510();
        Iterator<Map.Entry<Integer, EmitterGroup>> it = ACTIVE.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, EmitterGroup> en = it.next();
            EmitterGroup group = en.getValue();
            if (group == null || group.isExpired(now)) {
                it.remove();
                continue;
            }
            if (group.tickAndEmit(level, partialTicks)) continue;
            it.remove();
        }
    }

    private static final class EmitterGroup {
        private final WeakReference<class_1297> entityRef;
        private final long endTick;
        private final Emitter[] emitters;

        private EmitterGroup(class_1297 e, long endTick) {
            this.entityRef = new WeakReference<class_1297>(e);
            this.endTick = endTick;
            double size = Math.max(0.5, e.method_5829().method_995());
            int minEmitters = 3;
            int maxEmitters = 16;
            int count = (int)Math.round((double)minEmitters + Math.max(0.0, (size - 1.0) * 2.0));
            count = Math.min(maxEmitters, Math.max(minEmitters, count));
            this.emitters = new Emitter[count];
            long seed = (long)e.method_5628() << 32 ^ endTick;
            double[] angles = EmitterGroup.poissonAngles(count, seed);
            double totalRatePerSec = 15.0;
            double perEmitterRate = totalRatePerSec / (double)Math.max(1, count);
            for (int i = 0; i < count; ++i) {
                boolean outside = i % 2 == 0;
                this.emitters[i] = new Emitter(this.entityRef, endTick, angles[i], perEmitterRate, outside);
            }
        }

        private static double[] poissonAngles(int n, long seed) {
            double[] result = new double[n];
            if (n <= 0) {
                return result;
            }
            Random rnd = new Random(seed);
            double twoPi = Math.PI * 2;
            double minSep = twoPi / (double)n * 0.9;
            int placed = 0;
            int maxAttempts = Math.max(200, n * 200);
            for (int attempts = 0; placed < n && attempts < maxAttempts; ++attempts) {
                double a = rnd.nextDouble() * twoPi;
                boolean ok = true;
                for (int j = 0; j < placed; ++j) {
                    double circ;
                    double d = Math.abs(a - result[j]);
                    if (!((circ = Math.min(d %= twoPi, twoPi - d)) < minSep)) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                result[placed++] = a;
            }
            if (placed < n) {
                double base = rnd.nextDouble() * twoPi;
                for (int i = 0; i < n; ++i) {
                    result[i] = base + (double)i * (twoPi / (double)n);
                }
            }
            return result;
        }

        static EmitterGroup create(class_1297 e, long endTick) {
            return new EmitterGroup(e, endTick);
        }

        boolean isExpired(long now) {
            class_1297 ent = (class_1297)this.entityRef.get();
            return ent == null || !ent.method_5805() || now >= this.endTick;
        }

        boolean tickAndEmit(class_638 level, float partialTicks) {
            class_1297 ent = (class_1297)this.entityRef.get();
            if (ent == null || !ent.method_5805()) {
                return false;
            }
            for (Emitter em : this.emitters) {
                if (em == null) continue;
                em.tickAndEmit(level, partialTicks);
            }
            return true;
        }
    }

    private static final class Emitter {
        private final WeakReference<class_1297> entityRef;
        private final long endTick;
        private final double baseAngleRad;
        private final boolean outsideBias;
        private double ratePerSec;
        private double carry = 0.0;

        Emitter(WeakReference<class_1297> entityRef, long endTick, double baseAngleRad, double ratePerSec, boolean outsideBias) {
            this.entityRef = entityRef;
            this.endTick = endTick;
            this.baseAngleRad = baseAngleRad;
            this.ratePerSec = ratePerSec;
            this.outsideBias = outsideBias;
        }

        boolean isExpired(long now) {
            class_1297 e = (class_1297)this.entityRef.get();
            return e == null || !e.method_5805() || now >= this.endTick;
        }

        boolean tickAndEmit(class_638 level, float partialTicks) {
            class_1297 e = (class_1297)this.entityRef.get();
            if (e == null || !e.method_5805()) {
                return false;
            }
            double h = Math.max(0.2, (double)e.method_17682());
            double w = Math.max(0.2, (double)e.method_17681());
            double cx = e.method_23317();
            double cy = e.method_23318() + h * 0.1;
            double cz = e.method_23321();
            float scale = (float)((class_1297)this.entityRef.get()).method_5829().method_995();
            double dtSec = Math.max(0.0, (double)partialTicks / 20.0);
            double emitRate = this.ratePerSec * (0.015 + 1.0 * (double)scale);
            double want = emitRate * dtSec + this.carry;
            int count = (int)Math.floor(want);
            this.carry = want - (double)count;
            long now = level.method_8510();
            double timeLeft = Math.max(0.0, (double)(this.endTick - now) / 20.0);
            if (timeLeft > 4.4) {
                // empty if block
            }
            for (int i = 0; i < count; ++i) {
                double r;
                double spread = 0.5235987755982988;
                double ang = this.baseAngleRad + (level.field_9229.method_43058() * 2.0 - 1.0) * spread;
                double cosA = Math.cos(ang);
                double sinA = Math.sin(ang);
                double hw = Math.max(0.1, w * 0.5);
                double edge = hw / Math.max(Math.abs(cosA), Math.abs(sinA));
                double margin = Math.max(0.03, 0.06 * w);
                if (this.outsideBias) {
                    double jitter = level.field_9229.method_43058() * (0.02 * Math.max(1.0, w));
                    r = edge + margin + jitter;
                } else {
                    double jitterIn = level.field_9229.method_43058() * (0.02 * Math.max(1.0, w));
                    r = Math.max(0.6 * edge, edge - margin - jitterIn);
                }
                double sx = cx + cosA * r;
                double sz = cz + sinA * r;
                double sy = cy + (-0.05 + level.field_9229.method_43058() * 0.1) * Math.max(0.6, h);
                double areaR = Math.max(0.08, 0.12 * w);
                double nx = cosA;
                double nz = sinA;
                double tx = -sinA;
                double tz = cosA;
                double phi2 = level.field_9229.method_43058() * (Math.PI * 2);
                double rr = Math.sqrt(level.field_9229.method_43058()) * areaR;
                double bias = (this.outsideBias ? 0.25 : -0.1) * areaR;
                double offN = rr * Math.sin(phi2) + bias;
                double offT = rr * Math.cos(phi2);
                class_243 dir = new class_243((sx += nx * offN + tx * offT) - cx, 0.0, (sz += nz * offN + tz * offT) - cz).method_1029().method_1021(0.5);
                double speedScale = Math.max(0.2, 0.75 * (double)scale);
                double speedH = (0.008 + level.field_9229.method_43058() * 0.1) * speedScale;
                double vy = (0.04 + level.field_9229.method_43058() * 0.1) * speedScale;
                double vx = dir.field_1352 * speedH;
                double vz = dir.field_1350 * speedH;
                level.method_8406((class_2394)ModParticleTypes.LUMINOUS_MOTE.get(), sx, sy, sz, vx, vy, vz);
            }
            return true;
        }
    }
}

