/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.purification;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.storage.purification.PurificationMath;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\r\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ7\u0010\u0013\u001a\u00020\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J)\u0010\u0017\u001a\u00020\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J;\u0010\u001a\u001a\u00020\u00192\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00152\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/jayemceekay/shadowedhearts/client/purification/PurificationClientMetrics;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "p", "", "Lcom/cobblemon/mod/common/api/types/ElementalType;", "pokemonTypes", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Ljava/util/List;", "shadow", "supports", "", "shadowSharesType", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Ljava/util/List;)Z", "", "globalPerfectSets", "anySetMissingMember", "", "computeFlow", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Ljava/util/List;IZ)F", "", "supportsArray", "computeTempo", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;[Lcom/cobblemon/mod/common/pokemon/Pokemon;)F", "Lcom/jayemceekay/shadowedhearts/client/purification/PurificationClientMetrics$Metrics;", "compute", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;[Lcom/cobblemon/mod/common/pokemon/Pokemon;IZ)Lcom/jayemceekay/shadowedhearts/client/purification/PurificationClientMetrics$Metrics;", "Metrics", "ShadowedHearts-common"})
public final class PurificationClientMetrics {
    @NotNull
    public static final PurificationClientMetrics INSTANCE = new PurificationClientMetrics();

    private PurificationClientMetrics() {
    }

    private final List<ElementalType> pokemonTypes(Pokemon p) {
        Object object = p;
        if (object == null || (object = object.getTypes()) == null || (object = CollectionsKt.toList((Iterable)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final boolean shadowSharesType(Pokemon shadow, List<? extends Pokemon> supports) {
        if (shadow == null) {
            return false;
        }
        Set st = CollectionsKt.toSet((Iterable)this.pokemonTypes(shadow));
        if (st.isEmpty()) {
            return false;
        }
        for (Pokemon pokemon : supports) {
            for (ElementalType t : this.pokemonTypes(pokemon)) {
                if (!st.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    private final float computeFlow(Pokemon shadow, List<? extends Pokemon> supports, int globalPerfectSets, boolean anySetMissingMember) {
        if (supports.isEmpty()) {
            return 0.0f;
        }
        List<PurificationMath.Matchup> edges = PurificationMath.INSTANCE.clockwiseSupportMatchups(supports);
        if (edges.isEmpty()) {
            return 0.0f;
        }
        int score = 0;
        for (PurificationMath.Matchup m : edges) {
            score += (switch (WhenMappings.$EnumSwitchMapping$0[m.ordinal()]) {
                case 1 -> 3;
                case 2 -> 2;
                case 3 -> 1;
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        int max = edges.size() * 3;
        float pct = 0.0f;
        pct = RangesKt.coerceIn((float)((float)score / (float)max), (float)0.0f, (float)1.0f);
        PurificationClientMetrics $this$computeFlow_u24lambda_u240 = this;
        boolean bl = false;
        List<ElementalType> defTypes = $this$computeFlow_u24lambda_u240.pokemonTypes((Pokemon)CollectionsKt.firstOrNull(supports));
        if (!((Collection)defTypes).isEmpty() && shadow != null) {
            double best = 1.0;
            for (ElementalType atk : $this$computeFlow_u24lambda_u240.pokemonTypes(shadow)) {
                double m = PurificationMath.INSTANCE.effectiveness(atk, defTypes);
                if (!(m > best)) continue;
                best = m;
            }
            pct = switch (WhenMappings.$EnumSwitchMapping$0[PurificationMath.INSTANCE.toMatchup(best).ordinal()]) {
                case 1 -> RangesKt.coerceIn((float)(pct * 1.3333334f), (float)0.0f, (float)1.0f);
                case 3 -> RangesKt.coerceIn((float)(pct * 0.6666667f), (float)0.0f, (float)1.0f);
                default -> pct;
            };
        }
        if (supports.size() == 4 && !PurificationMath.INSTANCE.isPerfectSet(supports)) {
            pct = RangesKt.coerceAtMost((float)pct, (float)0.95f);
        }
        float SMALL_BAR = 0.125f;
        if (anySetMissingMember) {
            pct -= SMALL_BAR;
        }
        if (globalPerfectSets >= 2) {
            float add = SMALL_BAR * (float)(globalPerfectSets - 1);
            pct += add;
        }
        if (this.shadowSharesType(shadow, supports)) {
            pct = RangesKt.coerceAtMost((float)pct, (float)0.5f);
        }
        return RangesKt.coerceIn((float)pct, (float)0.0f, (float)1.0f);
    }

    private final float computeTempo(Pokemon shadow, Pokemon[] supportsArray) {
        List ring = ArraysKt.filterNotNull((Object[])supportsArray);
        if (shadow == null || ring.isEmpty()) {
            return 0.0f;
        }
        ClosedFloatingPointRange baseRange = switch (ring.size()) {
            case 1 -> RangesKt.rangeTo((float)0.1f, (float)0.15f);
            case 2 -> RangesKt.rangeTo((float)0.25f, (float)0.35f);
            case 3 -> RangesKt.rangeTo((float)0.5f, (float)0.65f);
            default -> RangesKt.rangeTo((float)0.7f, (float)0.85f);
        };
        List<PurificationMath.Matchup> edges = PurificationMath.INSTANCE.clockwiseSupportMatchups(ring);
        int edgeScore = 0;
        for (PurificationMath.Matchup m : edges) {
            edgeScore += (switch (WhenMappings.$EnumSwitchMapping$0[m.ordinal()]) {
                case 1 -> 3;
                case 2 -> 2;
                case 3 -> 1;
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        int maxEdgeScore = edges.size() * 3;
        float edgePct = maxEdgeScore > 0 ? (float)edgeScore / (float)maxEdgeScore : 0.5f;
        List<ElementalType> defTypes = this.pokemonTypes(supportsArray[PurificationMath.INSTANCE.facingSupportIndex(supportsArray)]);
        if (!((Collection)defTypes).isEmpty()) {
            double best = 1.0;
            for (ElementalType atk : this.pokemonTypes(shadow)) {
                double m = PurificationMath.INSTANCE.effectiveness(atk, defTypes);
                if (!(m > best)) continue;
                best = m;
            }
            edgePct = switch (WhenMappings.$EnumSwitchMapping$0[PurificationMath.INSTANCE.toMatchup(best).ordinal()]) {
                case 1 -> RangesKt.coerceIn((float)(edgePct * 1.3333334f), (float)0.0f, (float)1.0f);
                case 3 -> RangesKt.coerceIn((float)(edgePct * 0.6666667f), (float)0.0f, (float)1.0f);
                default -> edgePct;
            };
        }
        float tempo = ((Number)((Object)baseRange.getStart())).floatValue() + (((Number)((Object)baseRange.getEndInclusive())).floatValue() - ((Number)((Object)baseRange.getStart())).floatValue()) * edgePct;
        if (ring.size() == 4 && PurificationMath.INSTANCE.isPerfectSet(ring)) {
            tempo = 1.0f;
        }
        return RangesKt.coerceIn((float)tempo, (float)0.0f, (float)1.0f);
    }

    @NotNull
    public final Metrics compute(@Nullable Pokemon shadow, @NotNull Pokemon[] supports, int globalPerfectSets, boolean anySetMissingMember) {
        Intrinsics.checkNotNullParameter((Object)supports, (String)"supports");
        List ring = ArraysKt.filterNotNull((Object[])supports);
        float flow = this.computeFlow(shadow, ring, globalPerfectSets, anySetMissingMember);
        float tempo = this.computeTempo(shadow, supports);
        return new Metrics(flow, tempo);
    }

    public static /* synthetic */ Metrics compute$default(PurificationClientMetrics purificationClientMetrics, Pokemon pokemon, Pokemon[] pokemonArray, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return purificationClientMetrics.compute(pokemon, pokemonArray, n, bl);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0018\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/jayemceekay/shadowedhearts/client/purification/PurificationClientMetrics$Metrics;", "", "", "flowPct", "tempoPct", "<init>", "(FF)V", "component1", "()F", "component2", "copy", "(FF)Lcom/jayemceekay/shadowedhearts/client/purification/PurificationClientMetrics$Metrics;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "getFlowPct", "getTempoPct", "ShadowedHearts-common"})
    public static final class Metrics {
        private final float flowPct;
        private final float tempoPct;

        public Metrics(float flowPct, float tempoPct) {
            this.flowPct = flowPct;
            this.tempoPct = tempoPct;
        }

        public final float getFlowPct() {
            return this.flowPct;
        }

        public final float getTempoPct() {
            return this.tempoPct;
        }

        public final float component1() {
            return this.flowPct;
        }

        public final float component2() {
            return this.tempoPct;
        }

        @NotNull
        public final Metrics copy(float flowPct, float tempoPct) {
            return new Metrics(flowPct, tempoPct);
        }

        public static /* synthetic */ Metrics copy$default(Metrics metrics, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = metrics.flowPct;
            }
            if ((n & 2) != 0) {
                f2 = metrics.tempoPct;
            }
            return metrics.copy(f, f2);
        }

        @NotNull
        public String toString() {
            return "Metrics(flowPct=" + this.flowPct + ", tempoPct=" + this.tempoPct + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.flowPct);
            result = result * 31 + Float.hashCode(this.tempoPct);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Metrics)) {
                return false;
            }
            Metrics metrics = (Metrics)other;
            if (Float.compare(this.flowPct, metrics.flowPct) != 0) {
                return false;
            }
            return Float.compare(this.tempoPct, metrics.tempoPct) == 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PurificationMath.Matchup.values().length];
            try {
                nArray[PurificationMath.Matchup.SUPER_EFFECTIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PurificationMath.Matchup.NEUTRAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PurificationMath.Matchup.NOT_VERY_EFFECTIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

