/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.render;

import com.jayemceekay.shadowedhearts.mixin.RenderTargetAccessor;
import java.nio.FloatBuffer;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL30;

public final class DepthCapture {
    private static int depthTex = 0;
    private static int blitFbo = 0;
    private static int w = 0;
    private static int h = 0;
    private static int lastFrameCopied = -1;
    private static boolean blitCompatible = true;
    private static int srcDepthInternalCached = 0;
    private static boolean stencilEnsured = false;

    private DepthCapture() {
    }

    public static void init() {
    }

    public static void onResize(int width, int height) {
        DepthCapture.destroy();
        DepthCapture.ensureAllocated(width, height);
        stencilEnsured = false;
    }

    public static void destroy() {
        if (blitFbo != 0) {
            GL30.glDeleteFramebuffers((int)blitFbo);
            blitFbo = 0;
        }
        if (depthTex != 0) {
            GL11.glDeleteTextures((int)depthTex);
            depthTex = 0;
        }
        h = 0;
        w = 0;
        stencilEnsured = false;
    }

    private static void ensureAllocated(int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        w = width;
        h = height;
        int srcDepthInternal = DepthCapture.detectMainDepthInternalFormat();
        int[] fmt = DepthCapture.chooseDepthTexFormat(srcDepthInternal);
        int internalFormat = fmt[0];
        int pixelFormat = fmt[1];
        int pixelType = fmt[2];
        int attachment = fmt[3];
        srcDepthInternalCached = srcDepthInternal;
        blitCompatible = srcDepthInternal != 6402;
        depthTex = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)depthTex);
        GL11.glTexImage2D((int)3553, (int)0, (int)internalFormat, (int)w, (int)h, (int)0, (int)pixelFormat, (int)pixelType, (long)0L);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)34892, (int)0);
        GL11.glBindTexture((int)3553, (int)0);
        blitFbo = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36160, (int)blitFbo);
        GL30.glFramebufferTexture2D((int)36160, (int)attachment, (int)3553, (int)depthTex, (int)0);
        GL11.glDrawBuffer((int)0);
        GL11.glReadBuffer((int)0);
        int status = GL30.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new IllegalStateException("DepthCapture FBO incomplete: 0x" + Integer.toHexString(status));
        }
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    private static int currentWidth() {
        class_276 main = class_310.method_1551().method_1522();
        return ((RenderTargetAccessor)main).getWidth();
    }

    private static int currentHeight() {
        class_276 main = class_310.method_1551().method_1522();
        return ((RenderTargetAccessor)main).getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int detectMainDepthInternalFormat() {
        class_276 main = class_310.method_1551().method_1522();
        int srcFbo = ((RenderTargetAccessor)main).getFrameBufferId();
        int prevRead = GL11.glGetInteger((int)36010);
        int prevRb = GL11.glGetInteger((int)36007);
        int prevTex2D = GL11.glGetInteger((int)32873);
        try {
            GL30.glBindFramebuffer((int)36008, (int)srcFbo);
            int objType = GL30.glGetFramebufferAttachmentParameteri((int)36008, (int)36096, (int)36048);
            if (objType == 0) {
                int n = 0;
                return n;
            }
            int objName = GL30.glGetFramebufferAttachmentParameteri((int)36008, (int)36096, (int)36049);
            if (objName == 0) {
                int n = 0;
                return n;
            }
            if (objType == 36161) {
                GL30.glBindRenderbuffer((int)36161, (int)objName);
                int n = GL30.glGetRenderbufferParameteri((int)36161, (int)36164);
                return n;
            }
            if (objType == 5890) {
                GL11.glBindTexture((int)3553, (int)objName);
                int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                int internal = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
                if (width != 0) {
                    int n = internal;
                    return n;
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            GL30.glBindFramebuffer((int)36008, (int)prevRead);
            GL30.glBindRenderbuffer((int)36161, (int)prevRb);
            GL11.glBindTexture((int)3553, (int)prevTex2D);
        }
        return 0;
    }

    private static int[] chooseDepthTexFormat(int srcInternal) {
        if (srcInternal == 0) {
            return new int[]{36012, 6402, 5126, 36096};
        }
        switch (srcInternal) {
            case 36013: {
                return new int[]{36013, 34041, 36269, 33306};
            }
            case 36012: {
                return new int[]{36012, 6402, 5126, 36096};
            }
            case 35056: {
                return new int[]{35056, 34041, 34042, 33306};
            }
            case 33190: {
                return new int[]{33190, 6402, 5125, 36096};
            }
            case 33189: {
                return new int[]{33189, 6402, 5123, 36096};
            }
        }
        return new int[]{33190, 6402, 5125, 36096};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void captureIfNeeded() {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        class_276 main = class_310.method_1551().method_1522();
        stencilEnsured = true;
        int srcFbo = ((RenderTargetAccessor)main).getFrameBufferId();
        int mw = ((RenderTargetAccessor)main).getWidth();
        int mh = ((RenderTargetAccessor)main).getHeight();
        if (mw != w || mh != h || depthTex == 0 || blitFbo == 0) {
            DepthCapture.onResize(mw, mh);
        }
        if (!blitCompatible) {
            int prevReadFB = GL11.glGetInteger((int)36010);
            int prevTex2D = GL11.glGetInteger((int)32873);
            int prevActive = GL11.glGetInteger((int)34016) - 33984;
            boolean scissorEnabledFB = GL11.glIsEnabled((int)3089);
            try {
                if (scissorEnabledFB) {
                    GL11.glDisable((int)3089);
                }
                GL30.glBindFramebuffer((int)36008, (int)srcFbo);
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)depthTex);
                if (mw != w || mh != h) {
                    DepthCapture.onResize(mw, mh);
                    GL11.glBindTexture((int)3553, (int)depthTex);
                }
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)w, (int)h);
            }
            finally {
                if (scissorEnabledFB) {
                    GL11.glEnable((int)3089);
                }
                GL30.glBindFramebuffer((int)36008, (int)prevReadFB);
                GL11.glBindTexture((int)3553, (int)prevTex2D);
                GL13.glActiveTexture((int)(33984 + Math.max(prevActive, 0)));
            }
            return;
        }
        int prevRead = GL11.glGetInteger((int)36010);
        int prevDraw = GL11.glGetInteger((int)36006);
        boolean scissorEnabled = GL11.glIsEnabled((int)3089);
        try {
            if (scissorEnabled) {
                GL11.glDisable((int)3089);
            }
            GL30.glBindFramebuffer((int)36008, (int)srcFbo);
            GL30.glBindFramebuffer((int)36009, (int)blitFbo);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)mw, (int)mh, (int)0, (int)0, (int)w, (int)h, (int)256, (int)9728);
        }
        finally {
            if (scissorEnabled) {
                GL11.glEnable((int)3089);
            }
            GL30.glBindFramebuffer((int)36008, (int)prevRead);
            GL30.glBindFramebuffer((int)36009, (int)prevDraw);
        }
    }

    public static void bind(int textureUnit) {
        if (depthTex == 0) {
            return;
        }
        int prevActive = GL11.glGetInteger((int)34016) - 33984;
        GL13.glActiveTexture((int)(33984 + textureUnit));
        GL11.glBindTexture((int)3553, (int)depthTex);
        GL13.glActiveTexture((int)(33984 + Math.max(prevActive, 0)));
    }

    public static int width() {
        return w;
    }

    public static int height() {
        return h;
    }

    public static int textureId() {
        return depthTex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readDepth(FloatBuffer out) {
        if (!blitCompatible) {
            return false;
        }
        if (blitFbo == 0 || w <= 0 || h <= 0 || out == null || out.remaining() < w * h) {
            return false;
        }
        int prevRead = GL11.glGetInteger((int)36010);
        int prevPack = GL11.glGetInteger((int)3333);
        try {
            GL30.glBindFramebuffer((int)36008, (int)blitFbo);
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glReadPixels((int)0, (int)0, (int)w, (int)h, (int)6402, (int)5126, (FloatBuffer)out);
            boolean bl = true;
            return bl;
        }
        finally {
            GL11.glPixelStorei((int)3333, (int)prevPack);
            GL30.glBindFramebuffer((int)36008, (int)prevRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readMainDepth(FloatBuffer out) {
        class_276 main = class_310.method_1551().method_1522();
        int srcFbo = ((RenderTargetAccessor)main).getFrameBufferId();
        int mw = ((RenderTargetAccessor)main).getWidth();
        int mh = ((RenderTargetAccessor)main).getHeight();
        if (out == null || out.remaining() < mw * mh) {
            return false;
        }
        int prevRead = GL11.glGetInteger((int)36010);
        int prevPack = GL11.glGetInteger((int)3333);
        try {
            GL30.glBindFramebuffer((int)36008, (int)srcFbo);
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glReadPixels((int)0, (int)0, (int)mw, (int)mh, (int)6402, (int)5126, (FloatBuffer)out);
            boolean bl = true;
            return bl;
        }
        finally {
            GL11.glPixelStorei((int)3333, (int)prevPack);
            GL30.glBindFramebuffer((int)36008, (int)prevRead);
        }
    }
}

