/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.render;

import com.jayemceekay.shadowedhearts.client.render.DepthCapture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.nio.FloatBuffer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.lwjgl.BufferUtils;

public final class DepthDebugUtil {
    private static volatile boolean pending = false;
    private static volatile boolean pendingLinear = false;

    private DepthDebugUtil() {
    }

    public static void requestDepthDump(boolean linearize) {
        pending = true;
        pendingLinear = linearize;
    }

    public static Boolean pollPending() {
        if (!pending) {
            return null;
        }
        pending = false;
        return pendingLinear;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDepthPng(boolean linearize) {
        RenderSystem.assertOnRenderThread();
        DepthCapture.captureIfNeeded();
        int texId = DepthCapture.textureId();
        int w = DepthCapture.width();
        int h = DepthCapture.height();
        if (texId == 0 || w <= 0 || h <= 0) {
            DepthDebugUtil.toast("Depth texture not available");
            return;
        }
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)(w * h));
        if (!DepthCapture.readDepth(buf)) {
            DepthDebugUtil.toast("Depth read failed; trying main FBO depth");
            buf.rewind();
            if (!DepthCapture.readMainDepth(buf)) {
                DepthDebugUtil.toast("Main FBO depth read also failed");
                return;
            }
        }
        buf.rewind();
        float minZ = Float.POSITIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        float sum = 0.0f;
        for (int i = 0; i < w * h; ++i) {
            float z = buf.get();
            if (z < minZ) {
                minZ = z;
            }
            if (z > maxZ) {
                maxZ = z;
            }
            sum += z;
        }
        float avg = sum / (float)Math.max(1, w * h);
        buf.rewind();
        try (class_1011 img = new class_1011(class_1011.class_1012.field_4997, w, h, false);){
            float minZLocal = minZ;
            float maxZLocal = maxZ;
            float range = maxZLocal - minZLocal;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    float v;
                    float z = buf.get();
                    if (linearize) {
                        float n = 0.05f;
                        float f = 1000.0f;
                        float zndc = z * 2.0f - 1.0f;
                        v = 2.0f * n * f / (f + n - zndc * (f - n));
                        v = Math.min(v / 20.0f, 1.0f);
                    } else {
                        if (range > 1.0E-6f) {
                            float norm = (z - minZLocal) / range;
                            v = 1.0f - norm;
                        } else {
                            v = 1.0f - z;
                        }
                        float gamma = 0.8f;
                        v = (float)Math.pow(Math.max(0.0f, Math.min(1.0f, v)), gamma);
                    }
                    int g = (int)(Math.max(0.0f, Math.min(1.0f, v)) * 255.0f);
                    int argb = 0xFF000000 | g << 16 | g << 8 | g;
                    img.method_4305(x, h - 1 - y, argb);
                }
            }
            DepthDebugUtil.toast(String.format("Depth z range: min=%.4f max=%.4f avg=%.4f", Float.valueOf(minZ), Float.valueOf(maxZ), Float.valueOf(avg)));
            File screenshots = new File(class_310.method_1551().field_1697, "screenshots");
            if (!screenshots.exists()) {
                screenshots.mkdirs();
            }
            String ts = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
            String name = String.format("depth-%s%s.png", ts, linearize ? "-lin" : "");
            File out = new File(screenshots, name);
            img.method_4325(out);
            DepthDebugUtil.toast("Saved " + out.getName());
        }
    }

    private static void toast(String msg) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43470((String)("[ShadowedHearts] " + msg)), false);
        }
    }
}

