/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.render;

import com.jayemceekay.shadowedhearts.mixin.RenderTargetAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public final class DepthInfoUtil {
    private static volatile boolean pending = false;

    private DepthInfoUtil() {
    }

    public static void requestDump() {
        pending = true;
    }

    public static boolean pollPending() {
        if (!pending) {
            return false;
        }
        pending = false;
        return true;
    }

    public static void dumpMainDepthInfo() {
        Object attachStr;
        RenderSystem.assertOnRenderThread();
        class_310 mc = class_310.method_1551();
        class_276 rt = mc.method_1522();
        RenderTargetAccessor acc = (RenderTargetAccessor)rt;
        int fbo = acc.getFrameBufferId();
        int w = acc.getWidth();
        int h = acc.getHeight();
        int vw = acc.getViewWidth();
        int vh = acc.getViewHeight();
        int prevRead = GL11.glGetInteger((int)36010);
        int prevTex = GL11.glGetInteger((int)32873);
        GL30.glBindFramebuffer((int)36008, (int)fbo);
        int objType = GL30.glGetFramebufferAttachmentParameteri((int)36008, (int)36096, (int)36048);
        int objName = 0;
        if (objType != 0) {
            objName = GL30.glGetFramebufferAttachmentParameteri((int)36008, (int)36096, (int)36049);
        }
        String detStr = "";
        if (objType == 0 || objName == 0) {
            attachStr = "none";
        } else if (objType == 36161) {
            GL30.glBindRenderbuffer((int)36161, (int)objName);
            internal = GL30.glGetRenderbufferParameteri((int)36161, (int)36164);
            int rw = GL30.glGetRenderbufferParameteri((int)36161, (int)36162);
            int rh = GL30.glGetRenderbufferParameteri((int)36161, (int)36163);
            samples = 0;
            if (GL.getCapabilities().OpenGL30) {
                samples = GL30.glGetRenderbufferParameteri((int)36161, (int)36011);
            }
            attachStr = "renderbuffer";
            detStr = String.format("id=%d fmt=0x%X size=%dx%d samples=%d", objName, internal, rw, rh, samples);
        } else if (objType == 5890) {
            internal = 0;
            int tw = 0;
            int th = 0;
            samples = 0;
            boolean isMS = false;
            GL11.glBindTexture((int)3553, (int)objName);
            internal = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
            tw = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            th = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            if (tw == 0) {
                // empty if block
            }
            attachStr = isMS ? "texture2DMS" : "texture2D";
            detStr = String.format("id=%d fmt=0x%X size=%dx%d samples=%d", objName, internal, tw, th, samples);
        } else {
            attachStr = "unknown(0x" + Integer.toHexString(objType) + ")";
        }
        boolean depthTest = GL11.glIsEnabled((int)2929);
        int depthFunc = GL11.glGetInteger((int)2932);
        boolean scissor = GL11.glIsEnabled((int)3089);
        boolean msaa = GL11.glIsEnabled((int)32925);
        int samplesGlobal = 0;
        try {
            samplesGlobal = GL11.glGetInteger((int)32937);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int[] vp = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])vp);
        DepthInfoUtil.toast(String.format("Main FBO=%d size=%dx%d view=%dx%d", fbo, w, h, vw, vh));
        DepthInfoUtil.toast(String.format("Depth attachment: %s %s", attachStr, detStr));
        DepthInfoUtil.toast(String.format("DepthTest=%s func=0x%X Scissor=%s MSAA=%s(samples=%d) Viewport=[%d,%d %dx%d]", depthTest, depthFunc, scissor, msaa, samplesGlobal, vp[0], vp[1], vp[2], vp[3]));
        GL30.glBindFramebuffer((int)36008, (int)prevRead);
        GL11.glBindTexture((int)3553, (int)prevTex);
    }

    private static void toast(String msg) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43470((String)("[ShadowedHearts] " + msg)), false);
        }
    }
}

