/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.render;

import com.jayemceekay.shadowedhearts.mixin.RenderTargetAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.class_1011;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_898;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public final class StencilDebugUtil {
    private static volatile boolean pending = false;
    private static volatile Integer pendingEntityId = null;

    private StencilDebugUtil() {
    }

    public static void requestStencilDump() {
        pending = true;
    }

    public static void requestEntityStencilDump(int entityId) {
        pendingEntityId = entityId;
    }

    public static boolean pollPending() {
        if (!pending) {
            return false;
        }
        pending = false;
        return true;
    }

    public static Integer pollPendingEntity() {
        Integer id = pendingEntityId;
        pendingEntityId = null;
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStencilPng() {
        RenderSystem.assertOnRenderThread();
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        class_276 main = mc.method_1522();
        int srcFbo = ((RenderTargetAccessor)main).getFrameBufferId();
        int w = ((RenderTargetAccessor)main).getWidth();
        int h = ((RenderTargetAccessor)main).getHeight();
        if (w <= 0 || h <= 0) {
            StencilDebugUtil.toast("Invalid framebuffer size");
            return;
        }
        int prevReadFB = GL11.glGetInteger((int)36010);
        boolean scissorEnabled = GL11.glIsEnabled((int)3089);
        int prevPack = GL11.glGetInteger((int)3333);
        try {
            boolean hasStencil;
            GL30.glBindFramebuffer((int)36008, (int)srcFbo);
            int objType = GL30.glGetFramebufferAttachmentParameteri((int)36008, (int)36128, (int)36048);
            boolean bl = hasStencil = objType != 0;
            if (!hasStencil) {
                StencilDebugUtil.toast("No stencil attachment present; saving empty mask.");
            }
            if (scissorEnabled) {
                GL11.glDisable((int)3089);
            }
            GL11.glPixelStorei((int)3333, (int)1);
            ByteBuffer buf = BufferUtils.createByteBuffer((int)(w * h));
            GL11.glReadPixels((int)0, (int)0, (int)w, (int)h, (int)6401, (int)5121, (ByteBuffer)buf);
            StencilDebugUtil.writeBufferAsStencilPng(mc, w, h, buf, "stencil");
        }
        finally {
            if (scissorEnabled) {
                GL11.glEnable((int)3089);
            }
            GL11.glPixelStorei((int)3333, (int)prevPack);
            GL30.glBindFramebuffer((int)36008, (int)prevReadFB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveEntityStencilPng(int entityId) {
        RenderSystem.assertOnRenderThread();
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        class_276 main = mc.method_1522();
        int w = ((RenderTargetAccessor)main).getWidth();
        int h = ((RenderTargetAccessor)main).getHeight();
        if (w <= 0 || h <= 0) {
            StencilDebugUtil.toast("Invalid framebuffer size");
            return;
        }
        class_1297 entity = mc.field_1687.method_8469(entityId);
        if (entity == null) {
            StencilDebugUtil.toast("Entity not found for stencil dump");
            return;
        }
        int srcFbo = ((RenderTargetAccessor)main).getFrameBufferId();
        int prevDrawFB = GL11.glGetInteger((int)36006);
        int prevReadFB = GL11.glGetInteger((int)36010);
        boolean scissorEnabled = GL11.glIsEnabled((int)3089);
        int prevDepthFunc = GL11.glGetInteger((int)2932);
        boolean prevDepthMask = GL11.glGetBoolean((int)2930);
        int prevStencilMask = GL11.glGetInteger((int)2968);
        boolean prevStencilTest = GL11.glIsEnabled((int)2960);
        boolean prevDepthTest = GL11.glIsEnabled((int)2929);
        try {
            GL30.glBindFramebuffer((int)36009, (int)srcFbo);
            int objType = GL30.glGetFramebufferAttachmentParameteri((int)36009, (int)36128, (int)36048);
            if (objType == 0) {
                StencilDebugUtil.toast("No stencil attachment on main FBO; dump will be empty");
            }
            GL11.glEnable((int)2960);
            GL11.glStencilMask((int)255);
            if (scissorEnabled) {
                GL11.glDisable((int)3089);
            }
            GL11.glClearStencil((int)0);
            GL11.glClear((int)1024);
            if (scissorEnabled) {
                GL11.glEnable((int)3089);
            }
            GL11.glStencilFunc((int)519, (int)255, (int)255);
            GL11.glStencilOp((int)7681, (int)7681, (int)7681);
            GL11.glStencilMask((int)255);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.depthMask((boolean)false);
            GL11.glDisable((int)2929);
            boolean prevCull = GL11.glIsEnabled((int)2884);
            if (prevCull) {
                GL11.glDisable((int)2884);
            }
            class_898 dispatcher = mc.method_1561();
            class_4184 camera = dispatcher.field_4686;
            class_243 camPos = camera.method_19326();
            double x = entity.method_23317() - camPos.field_1352;
            double y = entity.method_23318() - camPos.field_1351;
            double z = entity.method_23321() - camPos.field_1350;
            class_4597.class_4598 buffers = mc.method_22940().method_23000();
            class_4587 ps = new class_4587();
            dispatcher.method_3954(entity, x, y, z, entity.method_36454(), 0.0f, ps, (class_4597)buffers, 0xF000F0);
            buffers.method_22993();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            if (prevCull) {
                GL11.glEnable((int)2884);
            }
            GL30.glBindFramebuffer((int)36008, (int)srcFbo);
            GL11.glPixelStorei((int)3333, (int)1);
            ByteBuffer buf = BufferUtils.createByteBuffer((int)(w * h));
            GL11.glReadPixels((int)0, (int)0, (int)w, (int)h, (int)6401, (int)5121, (ByteBuffer)buf);
            StencilDebugUtil.writeBufferAsStencilPng(mc, w, h, buf, "stencil-entity");
        }
        finally {
            GL11.glStencilMask((int)prevStencilMask);
            if (!prevStencilTest) {
                GL11.glDisable((int)2960);
            } else {
                GL11.glEnable((int)2960);
            }
            if (prevDepthTest) {
                GL11.glEnable((int)2929);
            } else {
                GL11.glDisable((int)2929);
            }
            GL11.glDepthFunc((int)prevDepthFunc);
            RenderSystem.depthMask((boolean)prevDepthMask);
            GL30.glBindFramebuffer((int)36009, (int)prevDrawFB);
            GL30.glBindFramebuffer((int)36008, (int)prevReadFB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBufferAsStencilPng(class_310 mc, int w, int h, ByteBuffer buf, String baseName) {
        buf.rewind();
        try (class_1011 img = new class_1011(class_1011.class_1012.field_4997, w, h, false);){
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int s;
                    int g = s = buf.get() & 0xFF;
                    int argb = 0xFF000000 | g << 16 | g << 8 | g;
                    img.method_4305(x, h - 1 - y, argb);
                }
            }
            File screenshots = new File(mc.field_1697, "screenshots");
            if (!screenshots.exists()) {
                screenshots.mkdirs();
            }
            String ts = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
            File out = new File(screenshots, baseName + "-" + ts + ".png");
            img.method_4325(out);
            StencilDebugUtil.toast("Saved " + out.getName());
        }
    }

    private static void toast(String msg) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43470((String)("[ShadowedHearts] " + msg)), false);
        }
    }
}

