/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.render.geom;

import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public final class CylinderBuffers {
    private static final int[] LOD_SEGMENTS = new int[]{12, 18, 24, 36};
    private static final int[] LOD_DOME_STACKS = new int[]{4, 5, 6, 8};
    private static Mesh[] LODS = new Mesh[4];
    private static Mesh[] DOME_LODS = new Mesh[4];
    private static Mesh[] DOME_BOTTOM_LODS = new Mesh[4];

    private CylinderBuffers() {
    }

    public static Mesh meshForLod(int lod) {
        int clamped = Math.max(0, Math.min(3, lod));
        Mesh cached = LODS[clamped];
        if (cached == null) {
            CylinderBuffers.LODS[clamped] = cached = CylinderBuffers.buildUnitCylinder(LOD_SEGMENTS[clamped]);
        }
        return cached;
    }

    private static Mesh domeMeshForLod(int lod) {
        int clamped = Math.max(0, Math.min(3, lod));
        Mesh cached = DOME_LODS[clamped];
        if (cached == null) {
            CylinderBuffers.DOME_LODS[clamped] = cached = CylinderBuffers.buildUnitHemisphereTop(LOD_SEGMENTS[clamped], LOD_DOME_STACKS[clamped]);
        }
        return cached;
    }

    private static Mesh domeBottomMeshForLod(int lod) {
        int clamped = Math.max(0, Math.min(3, lod));
        Mesh cached = DOME_BOTTOM_LODS[clamped];
        if (cached == null) {
            CylinderBuffers.DOME_BOTTOM_LODS[clamped] = cached = CylinderBuffers.buildUnitHemisphereBottom(LOD_SEGMENTS[clamped], LOD_DOME_STACKS[clamped]);
        }
        return cached;
    }

    private static Mesh mesh() {
        return CylinderBuffers.meshForLod(2);
    }

    public static void drawUnitCylinderLod(class_4588 vc, Matrix4f mat, float r, float g, float b, float a, int lod) {
        Mesh m = CylinderBuffers.meshForLod(lod);
        float[] pos = m.positions;
        int[] idx = m.indices;
        for (int i = 0; i < idx.length; i += 3) {
            int ia = idx[i] * 3;
            int ib = idx[i + 1] * 3;
            int ic = idx[i + 2] * 3;
            float ax = pos[ia];
            float ay = pos[ia + 1];
            float az = pos[ia + 2];
            float au = 0.5f + 0.5f * ax;
            float av = 0.5f + 0.5f * ay;
            vc.method_22918(mat, ax, ay, az).method_22913(au, av).method_22915(r, g, b, a).method_60803(0xF000F0);
            float bx = pos[ib];
            float by = pos[ib + 1];
            float bz = pos[ib + 2];
            float bu = 0.5f + 0.5f * bx;
            float bv = 0.5f + 0.5f * by;
            vc.method_22918(mat, bx, by, bz).method_22913(bu, bv).method_22915(r, g, b, a).method_60803(0xF000F0);
            float cx = pos[ic];
            float cy = pos[ic + 1];
            float cz = pos[ic + 2];
            float cu = 0.5f + 0.5f * cx;
            float cv = 0.5f + 0.5f * cy;
            vc.method_22918(mat, cx, cy, cz).method_22913(cu, cv).method_22915(r, g, b, a).method_60803(0xF000F0);
        }
    }

    public static void drawUnitCylinder(class_4588 vc, Matrix4f mat, float r, float g, float b, float a) {
        CylinderBuffers.drawUnitCylinderLod(vc, mat, r, g, b, a, 2);
    }

    public static void drawCylinderLod(class_4588 vc, Matrix4f mat, float height, float r, float g, float b, float a, int lod) {
        float yScale = Math.max(1.0E-4f, height * 0.5f);
        Matrix4f side = new Matrix4f((Matrix4fc)mat).scale(1.0f, yScale, 1.0f);
        CylinderBuffers.drawUnitCylinderLod(vc, side, r, g, b, a, lod);
    }

    public static void drawCylinder(class_4588 vc, Matrix4f mat, float height, float r, float g, float b, float a) {
        CylinderBuffers.drawCylinderLod(vc, mat, height, r, g, b, a, 2);
    }

    public static void drawUnitCylinderWithDomeLod(class_4588 vc, Matrix4f mat, float r, float g, float b, float a, int lod) {
        CylinderBuffers.drawUnitCylinderLod(vc, mat, r, g, b, a, lod);
        Mesh dome = CylinderBuffers.domeMeshForLod(lod);
        float[] pos = dome.positions;
        int[] idx = dome.indices;
        for (int i = 0; i < idx.length; i += 3) {
            int ia = idx[i] * 3;
            int ib = idx[i + 1] * 3;
            int ic = idx[i + 2] * 3;
            float ax = pos[ia];
            float ay = pos[ia + 1];
            float az = pos[ia + 2];
            float au = 0.5f + 0.5f * ax;
            float av = 0.5f + 0.5f * ay;
            vc.method_22918(mat, ax, ay, az).method_22913(au, av).method_22915(r, g, b, a).method_60803(0xF000F0);
            float bx = pos[ib];
            float by = pos[ib + 1];
            float bz = pos[ib + 2];
            float bu = 0.5f + 0.5f * bx;
            float bv = 0.5f + 0.5f * by;
            vc.method_22918(mat, bx, by, bz).method_22913(bu, bv).method_22915(r, g, b, a).method_60803(0xF000F0);
            float cx = pos[ic];
            float cy = pos[ic + 1];
            float cz = pos[ic + 2];
            float cu = 0.5f + 0.5f * cx;
            float cv = 0.5f + 0.5f * cy;
            vc.method_22918(mat, cx, cy, cz).method_22913(cu, cv).method_22915(r, g, b, a).method_60803(0xF000F0);
        }
    }

    public static void drawCylinderWithDomeLod(class_4588 vc, Matrix4f mat, float height, float r, float g, float b, float a, int lod) {
        float yScale = Math.max(1.0E-4f, height * 0.5f);
        Matrix4f scaled = new Matrix4f((Matrix4fc)mat).scale(1.0f, yScale, 1.0f);
        CylinderBuffers.drawUnitCylinderWithDomeLod(vc, scaled, r, g, b, a, lod);
    }

    public static void drawCylinderWithDome(class_4588 vc, Matrix4f mat, float height, float r, float g, float b, float a) {
        CylinderBuffers.drawCylinderWithDomeLod(vc, mat, height, r, g, b, a, 2);
    }

    public static void drawPositionOnly(class_4588 vc) {
        Mesh m = CylinderBuffers.mesh();
        float[] pos = m.positions;
        int[] idx = m.indices;
        Matrix4f I = new Matrix4f().identity();
        for (int i = 0; i < idx.length; i += 3) {
            int ia = idx[i] * 3;
            int ib = idx[i + 1] * 3;
            int ic = idx[i + 2] * 3;
            vc.method_22918(I, pos[ia], pos[ia + 1], pos[ia + 2]);
            vc.method_22918(I, pos[ib], pos[ib + 1], pos[ib + 2]);
            vc.method_22918(I, pos[ic], pos[ic + 1], pos[ic + 2]);
        }
    }

    private static Mesh buildUnitCylinder(int segments) {
        segments = Math.max(3, segments);
        int vertCount = segments * 2;
        float[] positions = new float[vertCount * 3];
        double twoPi = Math.PI * 2;
        for (int i = 0; i < segments; ++i) {
            double t = (double)i / (double)segments;
            double ang = t * twoPi;
            float x = (float)Math.cos(ang);
            float z = (float)Math.sin(ang);
            int vb = i * 6;
            positions[vb] = x;
            positions[vb + 1] = -1.0f;
            positions[vb + 2] = z;
            positions[vb + 3] = x;
            positions[vb + 4] = 1.0f;
            positions[vb + 5] = z;
        }
        int triCount = segments * 2;
        int[] indices = new int[triCount * 3];
        int k = 0;
        for (int i = 0; i < segments; ++i) {
            int iNext = (i + 1) % segments;
            int ib0 = i * 2;
            int it0 = ib0 + 1;
            int ib1 = iNext * 2;
            int it1 = ib1 + 1;
            indices[k++] = ib0;
            indices[k++] = it0;
            indices[k++] = it1;
            indices[k++] = ib0;
            indices[k++] = it1;
            indices[k++] = ib1;
        }
        return new Mesh(positions, indices);
    }

    private static Mesh buildUnitHemisphereTop(int segments, int stacks) {
        int i;
        int ringVerts;
        segments = Math.max(3, segments);
        stacks = Math.max(2, stacks);
        int apexIndex = ringVerts = segments * stacks;
        float[] positions = new float[(ringVerts + 1) * 3];
        double twoPi = Math.PI * 2;
        for (int s = 0; s < stacks; ++s) {
            float t = (float)s / (float)stacks;
            double phi = (double)t * 1.5707963267948966;
            float ringR = (float)Math.cos(phi);
            float ringY = 1.0f + (float)Math.sin(phi);
            for (i = 0; i < segments; ++i) {
                double a = (double)i / (double)segments * twoPi;
                float x = ringR * (float)Math.cos(a);
                float z = ringR * (float)Math.sin(a);
                int vi = (s * segments + i) * 3;
                positions[vi] = x;
                positions[vi + 1] = ringY;
                positions[vi + 2] = z;
            }
        }
        positions[apexIndex * 3] = 0.0f;
        positions[apexIndex * 3 + 1] = 2.0f;
        positions[apexIndex * 3 + 2] = 0.0f;
        int quads = (stacks - 1) * segments;
        int trisFromQuads = quads * 2;
        int trisFan = segments;
        int[] indices = new int[(trisFromQuads + trisFan) * 3];
        int k = 0;
        for (int s = 0; s < stacks - 1; ++s) {
            int base0 = s * segments;
            int base1 = (s + 1) * segments;
            for (int i2 = 0; i2 < segments; ++i2) {
                int inext = (i2 + 1) % segments;
                int v00 = base0 + i2;
                int v01 = base0 + inext;
                int v10 = base1 + i2;
                int v11 = base1 + inext;
                indices[k++] = v00;
                indices[k++] = v10;
                indices[k++] = v11;
                indices[k++] = v00;
                indices[k++] = v11;
                indices[k++] = v01;
            }
        }
        int baseTop = (stacks - 1) * segments;
        for (i = 0; i < segments; ++i) {
            int inext = (i + 1) % segments;
            int v0 = baseTop + i;
            int v1 = baseTop + inext;
            indices[k++] = v1;
            indices[k++] = v0;
            indices[k++] = apexIndex;
        }
        return new Mesh(positions, indices);
    }

    private static Mesh buildUnitHemisphereBottom(int segments, int stacks) {
        Mesh top = CylinderBuffers.buildUnitHemisphereTop(segments, stacks);
        float[] posTop = top.positions;
        int[] idxTop = top.indices;
        float[] positions = new float[posTop.length];
        for (int i = 0; i < posTop.length; i += 3) {
            positions[i] = posTop[i];
            positions[i + 1] = -posTop[i + 1];
            positions[i + 2] = posTop[i + 2];
        }
        int[] indices = new int[idxTop.length];
        for (int i = 0; i < idxTop.length; i += 3) {
            indices[i] = idxTop[i];
            indices[i + 1] = idxTop[i + 2];
            indices[i + 2] = idxTop[i + 1];
        }
        return new Mesh(positions, indices);
    }

    public static void drawUnitCylinderWithDomesLod(class_4588 vc, Matrix4f mat, float r, float g, float b, float a, int lod) {
        CylinderBuffers.drawUnitCylinderLod(vc, mat, r, g, b, a, lod);
        Mesh domeBottom = CylinderBuffers.domeBottomMeshForLod(lod);
        float[] posB = domeBottom.positions;
        int[] idxB = domeBottom.indices;
        for (int i = 0; i < idxB.length; i += 3) {
            int ia = idxB[i] * 3;
            int ib = idxB[i + 1] * 3;
            int ic = idxB[i + 2] * 3;
            float ax = posB[ia];
            float ay = posB[ia + 1];
            float az = posB[ia + 2];
            float au = 0.5f + 0.5f * ax;
            float av = 0.5f + 0.5f * ay;
            vc.method_22918(mat, ax, ay, az).method_22913(au, av).method_22915(r, g, b, a).method_60803(0xF000F0);
            float bx = posB[ib];
            float by = posB[ib + 1];
            float bz = posB[ib + 2];
            float bu = 0.5f + 0.5f * bx;
            float bv = 0.5f + 0.5f * by;
            vc.method_22918(mat, bx, by, bz).method_22913(bu, bv).method_22915(r, g, b, a).method_60803(0xF000F0);
            float cx = posB[ic];
            float cy = posB[ic + 1];
            float cz = posB[ic + 2];
            float cu = 0.5f + 0.5f * cx;
            float cv = 0.5f + 0.5f * cy;
            vc.method_22918(mat, cx, cy, cz).method_22913(cu, cv).method_22915(r, g, b, a).method_60803(0xF000F0);
        }
        Mesh domeTop = CylinderBuffers.domeMeshForLod(lod);
        float[] posT = domeTop.positions;
        int[] idxT = domeTop.indices;
        for (int i = 0; i < idxT.length; i += 3) {
            int ia = idxT[i] * 3;
            int ib = idxT[i + 1] * 3;
            int ic = idxT[i + 2] * 3;
            float ax = posT[ia];
            float ay = posT[ia + 1];
            float az = posT[ia + 2];
            float au = 0.5f + 0.5f * ax;
            float av = 0.5f + 0.5f * ay;
            vc.method_22918(mat, ax, ay, az).method_22913(au, av).method_22915(r, g, b, a).method_60803(0xF000F0);
            float bx = posT[ib];
            float by = posT[ib + 1];
            float bz = posT[ib + 2];
            float bu = 0.5f + 0.5f * bx;
            float bv = 0.5f + 0.5f * by;
            vc.method_22918(mat, bx, by, bz).method_22913(bu, bv).method_22915(r, g, b, a).method_60803(0xF000F0);
            float cx = posT[ic];
            float cy = posT[ic + 1];
            float cz = posT[ic + 2];
            float cu = 0.5f + 0.5f * cx;
            float cv = 0.5f + 0.5f * cy;
            vc.method_22918(mat, cx, cy, cz).method_22913(cu, cv).method_22915(r, g, b, a).method_60803(0xF000F0);
        }
    }

    public static void drawCylinderFlatCaps(class_4588 vc, Matrix4f mat, float r, float g, float b, float a, int lod) {
        CylinderBuffers.drawUnitCylinderFlatCaps(vc, mat, r, g, b, a, lod);
    }

    private static void drawUnitCylinderFlatCaps(class_4588 vc, Matrix4f scaled, float r, float g, float b, float a, int lod) {
        float angle2;
        float angle1;
        int i;
        CylinderBuffers.drawUnitCylinderLod(vc, scaled, r, g, b, a, lod);
        Mesh m = CylinderBuffers.meshForLod(lod);
        int segments = LOD_SEGMENTS[Math.max(0, Math.min(3, lod))];
        for (i = 0; i <= segments - 1; ++i) {
            vc.method_22918(scaled, 0.0f, 1.0f, 0.0f).method_22913(0.5f, 1.0f).method_22915(r, g, b, a).method_60803(0xF000F0);
            angle1 = (float)((double)i * Math.PI * 2.0 / (double)segments);
            angle2 = (float)((double)(i + 1) * Math.PI * 2.0 / (double)segments);
            vc.method_22918(scaled, (float)Math.cos(angle1), 1.0f, (float)Math.sin(angle1)).method_22913(0.5f + 0.5f * (float)Math.cos(angle1), 1.0f).method_22915(r, g, b, a).method_60803(0xF000F0);
            vc.method_22918(scaled, (float)Math.cos(angle2), 1.0f, (float)Math.sin(angle2)).method_22913(0.5f + 0.5f * (float)Math.cos(angle2), 1.0f).method_22915(r, g, b, a).method_60803(0xF000F0);
        }
        for (i = 0; i <= segments - 1; ++i) {
            vc.method_22918(scaled, 0.0f, -1.0f, 0.0f).method_22913(0.5f, 0.0f).method_22915(r, g, b, a).method_60803(0xF000F0);
            angle1 = (float)((double)i * Math.PI * 2.0 / (double)segments);
            angle2 = (float)((double)(i + 1) * Math.PI * 2.0 / (double)segments);
            vc.method_22918(scaled, (float)Math.cos(angle2), -1.0f, (float)Math.sin(angle2)).method_22913(0.5f + 0.5f * (float)Math.cos(angle2), 0.0f).method_22915(r, g, b, a).method_60803(0xF000F0);
            vc.method_22918(scaled, (float)Math.cos(angle1), -1.0f, (float)Math.sin(angle1)).method_22913(0.5f + 0.5f * (float)Math.cos(angle1), 0.0f).method_22915(r, g, b, a).method_60803(0xF000F0);
        }
    }

    public static void drawCylinderWithDomesLod(class_4588 vc, Matrix4f mat, float height, float r, float g, float b, float a, int lod) {
        float yScale = Math.max(1.0E-4f, height);
        Matrix4f scaled = mat.scale(1.0f, yScale, 1.0f);
        CylinderBuffers.drawUnitCylinderWithDomesLod(vc, mat, r, g, b, a, lod);
    }

    public static void drawCapsuleLod(class_4588 vc, Matrix4f mat, float height, float r, float g, float b, float a, int lod) {
        CylinderBuffers.drawCylinderWithDomesLod(vc, mat, height, r, g, b, a, lod);
    }

    public static void drawCapsule(class_4588 vc, Matrix4f mat, float height, float r, float g, float b, float a) {
        CylinderBuffers.drawCylinderWithDomesLod(vc, mat, height, r, g, b, a, 2);
    }

    private record Mesh(float[] positions, int[] indices) {
    }
}

