/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.render.geom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public final class SphereBuffers {
    private static Mesh SUBDIV2;
    private static final Mesh[] LODS;

    private SphereBuffers() {
    }

    private static Mesh mesh() {
        if (SUBDIV2 == null) {
            SUBDIV2 = SphereBuffers.buildIcosphere(2);
        }
        return SUBDIV2;
    }

    public static Mesh meshForLod(int lod) {
        int clamped = Math.max(0, Math.min(3, lod));
        Mesh cached = LODS[clamped];
        if (cached == null) {
            SphereBuffers.LODS[clamped] = cached = SphereBuffers.buildIcosphere(clamped);
        }
        return cached;
    }

    public static void drawUnitSphereLod(class_4588 vc, Matrix4f mat, float r, float g, float b, float a, int lod) {
        Mesh m = SphereBuffers.meshForLod(lod);
        float[] pos = m.positions;
        int[] idx = m.indices;
        for (int i = 0; i < idx.length; i += 3) {
            int ia = idx[i] * 3;
            int ib = idx[i + 1] * 3;
            int ic = idx[i + 2] * 3;
            float ax = pos[ia];
            float ay = pos[ia + 1];
            float az = pos[ia + 2];
            float au = 0.5f + 0.5f * ax;
            float av = 0.5f + 0.5f * ay;
            vc.method_22918(mat, ax, ay, az).method_22913(au, av).method_22915(r, g, b, a).method_60803(0xF000F0);
            float bx = pos[ib];
            float by = pos[ib + 1];
            float bz = pos[ib + 2];
            float bu = 0.5f + 0.5f * bx;
            float bv = 0.5f + 0.5f * by;
            vc.method_22918(mat, bx, by, bz).method_22913(bu, bv).method_22915(r, g, b, a).method_60803(0xF000F0);
            float cx = pos[ic];
            float cy = pos[ic + 1];
            float cz = pos[ic + 2];
            float cu = 0.5f + 0.5f * cx;
            float cv = 0.5f + 0.5f * cy;
            vc.method_22918(mat, cx, cy, cz).method_22913(cu, cv).method_22915(r, g, b, a).method_60803(0xF000F0);
        }
    }

    public static void drawPositionOnly(class_4588 vc) {
        Mesh m = SphereBuffers.mesh();
        float[] pos = m.positions;
        int[] idx = m.indices;
        Matrix4f I = new Matrix4f().identity();
        for (int i = 0; i < idx.length; i += 3) {
            int ia = idx[i] * 3;
            int ib = idx[i + 1] * 3;
            int ic = idx[i + 2] * 3;
            vc.method_22918(I, pos[ia], pos[ia + 1], pos[ia + 2]);
            vc.method_22918(I, pos[ib], pos[ib + 1], pos[ib + 2]);
            vc.method_22918(I, pos[ic], pos[ic + 1], pos[ic + 2]);
        }
    }

    public static void drawUnitSphere(class_4588 vc, Matrix4f mat, float r, float g, float b, float a) {
        Mesh m = SphereBuffers.mesh();
        float[] pos = m.positions;
        int[] idx = m.indices;
        for (int i = 0; i < idx.length; i += 3) {
            int ia = idx[i] * 3;
            int ib = idx[i + 1] * 3;
            int ic = idx[i + 2] * 3;
            float ax = pos[ia];
            float ay = pos[ia + 1];
            float az = pos[ia + 2];
            float au = 0.5f + 0.5f * ax;
            float av = 0.5f + 0.5f * ay;
            vc.method_22918(mat, ax, ay, az).method_22913(au, av).method_22915(r, g, b, a).method_60803(0xF000F0);
            float bx = pos[ib];
            float by = pos[ib + 1];
            float bz = pos[ib + 2];
            float bu = 0.5f + 0.5f * bx;
            float bv = 0.5f + 0.5f * by;
            vc.method_22918(mat, bx, by, bz).method_22913(bu, bv).method_22915(r, g, b, a).method_60803(0xF000F0);
            float cx = pos[ic];
            float cy = pos[ic + 1];
            float cz = pos[ic + 2];
            float cu = 0.5f + 0.5f * cx;
            float cv = 0.5f + 0.5f * cy;
            vc.method_22918(mat, cx, cy, cz).method_22913(cu, cv).method_22915(r, g, b, a).method_60803(0xF000F0);
        }
    }

    private static Mesh buildIcosphere(int subdivisions) {
        float t = (float)((1.0 + Math.sqrt(5.0)) / 2.0);
        ArrayList<float[]> verts = new ArrayList<float[]>();
        SphereBuffers.addNorm(verts, -1.0, t, 0.0);
        SphereBuffers.addNorm(verts, 1.0, t, 0.0);
        SphereBuffers.addNorm(verts, -1.0, -t, 0.0);
        SphereBuffers.addNorm(verts, 1.0, -t, 0.0);
        SphereBuffers.addNorm(verts, 0.0, -1.0, t);
        SphereBuffers.addNorm(verts, 0.0, 1.0, t);
        SphereBuffers.addNorm(verts, 0.0, -1.0, -t);
        SphereBuffers.addNorm(verts, 0.0, 1.0, -t);
        SphereBuffers.addNorm(verts, t, 0.0, -1.0);
        SphereBuffers.addNorm(verts, t, 0.0, 1.0);
        SphereBuffers.addNorm(verts, -t, 0.0, -1.0);
        SphereBuffers.addNorm(verts, -t, 0.0, 1.0);
        int[] faces = new int[]{0, 11, 5, 0, 5, 1, 0, 1, 7, 0, 7, 10, 0, 10, 11, 1, 5, 9, 5, 11, 4, 11, 10, 2, 10, 7, 6, 7, 1, 8, 3, 9, 4, 3, 4, 2, 3, 2, 6, 3, 6, 8, 3, 8, 9, 4, 9, 5, 2, 4, 11, 6, 2, 10, 8, 6, 7, 9, 8, 1};
        ArrayList<int[]> tris = new ArrayList<int[]>();
        for (int i = 0; i < faces.length; i += 3) {
            tris.add(new int[]{faces[i], faces[i + 1], faces[i + 2]});
        }
        for (int s = 0; s < subdivisions; ++s) {
            ArrayList<int[]> next = new ArrayList<int[]>();
            HashMap<Long, Integer> midCache = new HashMap<Long, Integer>();
            for (int[] tri : tris) {
                int a = tri[0];
                int b = tri[1];
                int c = tri[2];
                int ab = SphereBuffers.midpointIndex(verts, midCache, a, b);
                int bc = SphereBuffers.midpointIndex(verts, midCache, b, c);
                int ca = SphereBuffers.midpointIndex(verts, midCache, c, a);
                next.add(new int[]{a, ab, ca});
                next.add(new int[]{b, bc, ab});
                next.add(new int[]{c, ca, bc});
                next.add(new int[]{ab, bc, ca});
            }
            tris = next;
        }
        float[] positions = new float[verts.size() * 3];
        for (int i = 0; i < verts.size(); ++i) {
            float[] v = (float[])verts.get(i);
            positions[i * 3] = v[0];
            positions[i * 3 + 1] = v[1];
            positions[i * 3 + 2] = v[2];
        }
        int[] indices = new int[tris.size() * 3];
        int k = 0;
        for (int[] ttri : tris) {
            indices[k++] = ttri[0];
            indices[k++] = ttri[1];
            indices[k++] = ttri[2];
        }
        return new Mesh(positions, indices);
    }

    private static void addNorm(List<float[]> verts, double x, double y, double z) {
        double len = Math.sqrt(x * x + y * y + z * z);
        verts.add(new float[]{(float)(x / len), (float)(y / len), (float)(z / len)});
    }

    private static int midpointIndex(List<float[]> verts, Map<Long, Integer> cache, int i1, int i2) {
        long key = (long)Math.min(i1, i2) << 32 | (long)Math.max(i1, i2);
        Integer cached = cache.get(key);
        if (cached != null) {
            return cached;
        }
        float[] v1 = verts.get(i1);
        float[] v2 = verts.get(i2);
        float mx = (v1[0] + v2[0]) * 0.5f;
        float my = (v1[1] + v2[1]) * 0.5f;
        float mz = (v1[2] + v2[2]) * 0.5f;
        double len = Math.sqrt(mx * mx + my * my + mz * mz);
        int idx = verts.size();
        verts.add(new float[]{(float)((double)mx / len), (float)((double)my / len), (float)((double)mz / len)});
        cache.put(key, idx);
        return idx;
    }

    static {
        LODS = new Mesh[4];
    }

    private record Mesh(float[] positions, int[] indices) {
    }
}

