/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.storage;

import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.client.storage.ClientStorage;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class ClientPurificationStorage
extends ClientStorage<PurificationPosition> {
    public static final int TOTAL_SETS = 9;
    private final Map<Integer, Map<PurificationPosition, Pokemon>> sets = new HashMap<Integer, Map<PurificationPosition, Pokemon>>();
    private int currentSetIndex = 0;

    public ClientPurificationStorage(UUID uuid) {
        super(uuid);
    }

    public Pokemon findByUUID(UUID uuid) {
        for (Map<PurificationPosition, Pokemon> map : this.sets.values()) {
            for (Pokemon p : map.values()) {
                if (p == null || !uuid.equals(p.getUuid())) continue;
                return p;
            }
        }
        return null;
    }

    public void set(PurificationPosition position, Pokemon pokemon) {
        Map map = this.sets.computeIfAbsent(this.currentSetIndex, k -> new HashMap());
        if (pokemon == null) {
            map.remove(position);
        } else {
            map.put(position, pokemon);
        }
    }

    public Pokemon get(PurificationPosition position) {
        Map<PurificationPosition, Pokemon> map = this.sets.get(this.currentSetIndex);
        return map == null ? null : map.get(position);
    }

    public PurificationPosition getPosition(Pokemon pokemon) {
        Map<PurificationPosition, Pokemon> map = this.sets.get(this.currentSetIndex);
        if (map == null) {
            return null;
        }
        for (Map.Entry<PurificationPosition, Pokemon> e : map.entrySet()) {
            if (e.getValue() == null || !e.getValue().getUuid().equals(pokemon.getUuid())) continue;
            return e.getKey();
        }
        return null;
    }

    public int getCurrentSetIndex() {
        return this.currentSetIndex;
    }

    public void setCurrentSetIndex(int idx) {
        if (idx < 0) {
            idx = 0;
        }
        if (idx >= 9) {
            idx = 8;
        }
        this.currentSetIndex = idx;
    }

    public void nextSet() {
        this.setCurrentSetIndex((this.currentSetIndex + 1) % 9);
    }

    public void prevSet() {
        this.setCurrentSetIndex((this.currentSetIndex - 1 + 9) % 9);
    }

    public void clearAll() {
        this.sets.clear();
    }

    public void setAt(int setIndex, PurificationPosition position, Pokemon pokemon) {
        if (setIndex < 0 || setIndex >= 9) {
            return;
        }
        Map map = this.sets.computeIfAbsent(setIndex, k -> new HashMap());
        if (pokemon == null) {
            map.remove(position);
        } else {
            map.put(position, pokemon);
        }
    }

    public Pokemon getAt(int setIndex, PurificationPosition position) {
        if (setIndex < 0 || setIndex >= 9) {
            return null;
        }
        Map<PurificationPosition, Pokemon> map = this.sets.get(setIndex);
        return map == null ? null : map.get(position);
    }

    public static class PurificationPosition
    implements StorePosition {
        public final int index;

        public PurificationPosition(int index) {
            this.index = index;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof PurificationPosition)) return false;
            PurificationPosition pp = (PurificationPosition)o;
            if (pp.index != this.index) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }
    }
}

