/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.trail;

import com.jayemceekay.shadowedhearts.client.ModShaders;
import com.jayemceekay.shadowedhearts.client.render.BallRenderTypes;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_284;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5944;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public final class BallTrailHudDebug {
    private static boolean ENABLED = true;

    private BallTrailHudDebug() {
    }

    public static void render(@NotNull class_332 gg, @NotNull class_9779 tickDelta) {
        if (!ENABLED) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return;
        }
        int screenW = mc.method_22683().method_4486();
        int screenH = mc.method_22683().method_4502();
        int margin = 64;
        int w = Math.max(64, Math.min(256, screenW / 4));
        int h = Math.max(16, w / 4);
        int x = margin;
        int y = screenH - h - margin;
        class_4587 pose = gg.method_51448();
        pose.method_22903();
        pose.method_46416((float)x, (float)y, 0.0f);
        class_4597.class_4598 buffers = mc.method_22940().method_23000();
        BallTrailHudDebug.uploadPaletteUniforms(tickDelta.method_60637(true));
        class_4588 vc = buffers.getBuffer(BallRenderTypes.trailAdditive());
        BallTrailHudDebug.emitHudQuad(vc, 0, 0, w, h, 180, 60, 255, 220, 0.0f, 1.0f, pose);
        buffers.method_37104();
        BallTrailHudDebug.uploadPaletteUniforms(tickDelta.method_60637(true));
        class_4588 vcCore = buffers.getBuffer(BallRenderTypes.trailCoreAdditive());
        int coreH = Math.max(2, (int)((float)h * 0.35f));
        int coreY = (h - coreH) / 2;
        BallTrailHudDebug.emitHudQuad(vcCore, 0, coreY, w, coreH, 255, 255, 255, 220, 0.0f, 1.0f, pose);
        buffers.method_37104();
        pose.method_22909();
    }

    public static void render(@NotNull class_332 gg, float partialTick) {
        BallTrailHudDebug.render(gg, class_310.method_1551().field_1705.method_1738());
    }

    private static void uploadPaletteUniforms(float partialTicks) {
        try {
            class_5944 sh;
            class_5944 class_59442 = sh = ModShaders.BALL_TRAIL != null ? ModShaders.BALL_TRAIL : RenderSystem.getShader();
            if (sh == null) {
                return;
            }
            class_310 mc = class_310.method_1551();
            float partial = partialTicks;
            float t = 0.0f;
            if (mc != null) {
                if (mc.field_1687 != null) {
                    t = ((float)mc.field_1687.method_8510() + partial) * 0.05f;
                } else if (mc.field_1705 != null) {
                    t = ((float)mc.field_1705.method_1738() + partial) * 0.05f;
                }
            }
            BallTrailHudDebug.set1f(sh, "u_paletteMix", 1.0f);
            float speed = 0.0f;
            BallTrailHudDebug.set1f(sh, "u_paletteSpeed", speed);
            BallTrailHudDebug.set1f(sh, "u_paletteShift", 0.5f);
            BallTrailHudDebug.set1f(sh, "u_paletteSaturation", 1.0f);
            BallTrailHudDebug.set3f(sh, "u_lumaCoeff", 0.299f, 0.587f, 0.114f);
            BallTrailHudDebug.set1f(sh, "uStrength", 2.5f);
            BallTrailHudDebug.set3f(sh, "u_c0", 1.0f, 1.0f, 1.0f);
            BallTrailHudDebug.set3f(sh, "u_c1", 0.6f, 0.92f, 0.12f);
            BallTrailHudDebug.set3f(sh, "u_c2", 0.6f, 0.68f, 0.1f);
            BallTrailHudDebug.set3f(sh, "u_c3", 0.6f, 0.25f, 0.95f);
            BallTrailHudDebug.set1f(sh, "u_t1", 0.3f);
            BallTrailHudDebug.set1f(sh, "u_t2", 0.6f);
            BallTrailHudDebug.set1f(sh, "u_t3", 1.0f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void set1f(class_5944 sh, String name, float v) {
        if (sh == null) {
            return;
        }
        class_284 u = sh.method_34582(name);
        if (u != null) {
            u.method_1251(v);
        }
    }

    private static void set3f(class_5944 sh, String name, float x, float y, float z) {
        if (sh == null) {
            return;
        }
        class_284 u = sh.method_34582(name);
        if (u != null) {
            u.method_1249(x, y, z);
        }
    }

    private static void emitHudQuad(@NotNull class_4588 vc, int x, int y, int w, int h, int r, int g, int b, int a, float u1, float u2, class_4587 poseStack) {
        class_4587.class_4665 last = poseStack.method_23760();
        Matrix4f mat = last.method_23761();
        float x0 = x;
        float y0 = y;
        float x1 = x + w;
        float y1 = y + h;
        vc.method_22918(mat, x0, y0, 0.0f).method_1336(r, g, b, a).method_22913(u1, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(last, 0.0f, 0.0f, 1.0f);
        vc.method_22918(mat, x0, y1, 0.0f).method_1336(r, g, b, a).method_22913(u1, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(last, 0.0f, 0.0f, 1.0f);
        vc.method_22918(mat, x1, y1, 0.0f).method_1336(r, g, b, a).method_22913(u2, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(last, 0.0f, 0.0f, 1.0f);
        vc.method_22918(mat, x1, y0, 0.0f).method_1336(r, g, b, a).method_22913(u2, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(last, 0.0f, 0.0f, 1.0f);
    }
}

