/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.client.trail;

import com.jayemceekay.shadowedhearts.client.render.BallRenderTypes;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_284;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5944;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public final class BallTrailManager {
    private static final Map<Integer, TrailRibbon> RIBBONS = new HashMap<Integer, TrailRibbon>();
    private static final float MIN_SPEED = 0.0f;
    private static final float MAX_SPEED = 0.5f;
    private static final float STRENGTH_LERP = 0.1f;
    private static final float EXTRA_DECAY_PER_TICK = 0.08f;

    private BallTrailManager() {
    }

    public static void addPoint(class_1297 entity, double x, double y, double z) {
        RIBBONS.computeIfAbsent(entity.method_5628(), id -> new TrailRibbon()).sample(new class_243(x, y, z));
    }

    public static void addPointForId(int entityId, double x, double y, double z) {
        RIBBONS.computeIfAbsent(entityId, id -> new TrailRibbon()).sample(new class_243(x, y, z));
    }

    public static void remove(class_1297 entity) {
        RIBBONS.remove(entity.method_5628());
    }

    public static void removeById(int entityId) {
        RIBBONS.remove(entityId);
    }

    public static void render(class_1297 entity, float partialTicks, class_4587 poseStack, class_4597 buffer) {
        TrailRibbon ribbon = RIBBONS.get(entity.method_5628());
        if (ribbon == null || ribbon.size() < 2) {
            return;
        }
        class_4184 cam = class_310.method_1551().field_1773.method_19418();
        Vector3f upJ = cam.method_19336();
        class_243 camUp = new class_243((double)upJ.x(), (double)upJ.y(), (double)upJ.z());
        double ox = class_3532.method_16436((double)partialTicks, (double)entity.field_6014, (double)entity.method_23317());
        double oy = class_3532.method_16436((double)partialTicks, (double)entity.field_6036, (double)entity.method_23318());
        double oz = class_3532.method_16436((double)partialTicks, (double)entity.field_5969, (double)entity.method_23321());
        class_243 origin = new class_243(ox, oy, oz);
        BallTrailManager.uploadPaletteUniforms(partialTicks);
        BallTrailManager.setStrengthUniform(ribbon.strength);
        class_4588 vc = buffer.getBuffer(BallRenderTypes.trailAdditive());
        float baseWidth = Math.max(0.01f, (float)((double)entity.method_17681() * 0.5));
        int n = ribbon.size();
        int effectiveN = Math.max(2, (int)Math.floor((float)n * (ribbon.stopped ? Math.max(0.05f, ribbon.strength) : 1.0f)));
        int start = n - effectiveN;
        for (int i = 0; i < effectiveN - 1; ++i) {
            class_243 side;
            double len2;
            int i0 = start + i;
            class_243 p1w = ribbon.get(i0);
            class_243 p2w = ribbon.get(i0 + 1);
            class_243 seg = p2w.method_1020(p1w);
            if (seg.method_1027() < 1.0E-6 || (len2 = (side = seg.method_1036(camUp)).method_1027()) < 1.0E-6) continue;
            side = side.method_1021(1.0 / Math.sqrt(len2));
            float ageFrac = (float)(effectiveN - 1 - i) / (float)(effectiveN - 1);
            float decayBoost = 1.0f + (float)ribbon.stoppedTicks * 0.08f;
            float ageEff = class_3532.method_15363((float)(ageFrac * decayBoost), (float)0.0f, (float)1.0f);
            float width = baseWidth * (0.55f + 0.45f * (float)Math.pow(1.0f - ageEff, 1.4f));
            width *= ribbon.strength;
            int r = 180;
            int g = 60;
            int b = 255;
            int aHead = 240;
            int aTail = 12;
            int a = (int)class_3532.method_16439((float)ageEff, (float)aHead, (float)aTail);
            a = (int)((float)a * ribbon.strength);
            class_243 sScaled = side.method_1021((double)width);
            class_243 p1a = p1w.method_1019(sScaled);
            class_243 p1b = p1w.method_1020(sScaled);
            class_243 p2a = p2w.method_1019(sScaled);
            class_243 p2b = p2w.method_1020(sScaled);
            BallTrailManager.emitQuad(vc, p1a.method_1020(origin), p1b.method_1020(origin), p2b.method_1020(origin), p2a.method_1020(origin), r, g, b, a, 1.0f - (float)i / (float)(effectiveN - 1), 1.0f - (float)(i + 1) / (float)(effectiveN - 1), poseStack);
        }
        BallTrailManager.uploadPaletteUniforms(partialTicks);
        BallTrailManager.setStrengthUniform(ribbon.strength);
        class_4588 vcCore = buffer.getBuffer(BallRenderTypes.trailCoreAdditive());
        float coreScale = 0.45f;
        for (int i = 0; i < effectiveN - 1; ++i) {
            class_243 side;
            double len2;
            int i0 = start + i;
            class_243 p1w = ribbon.get(i0);
            class_243 p2w = ribbon.get(i0 + 1);
            class_243 seg = p2w.method_1020(p1w);
            if (seg.method_1027() < 1.0E-6 || (len2 = (side = seg.method_1036(camUp)).method_1027()) < 1.0E-6) continue;
            side = side.method_1021(1.0 / Math.sqrt(len2));
            float ageFrac = (float)(effectiveN - 1 - i) / (float)(effectiveN - 1);
            float decayBoost = 1.0f + (float)ribbon.stoppedTicks * 0.08f;
            float ageEff = class_3532.method_15363((float)(ageFrac * decayBoost), (float)0.0f, (float)1.0f);
            float width = baseWidth * coreScale * (0.55f + 0.45f * (float)Math.pow(1.0f - ageEff, 1.4f));
            width *= ribbon.strength;
            int r = 255;
            int g = 255;
            int b = 255;
            int aHead = 255;
            int aTail = 10;
            int a = (int)class_3532.method_16439((float)ageEff, (float)aHead, (float)aTail);
            a = (int)((float)a * ribbon.strength);
            class_243 sScaled = side.method_1021((double)width);
            class_243 p1a = p1w.method_1019(sScaled);
            class_243 p1b = p1w.method_1020(sScaled);
            class_243 p2a = p2w.method_1019(sScaled);
            class_243 p2b = p2w.method_1020(sScaled);
            BallTrailManager.emitQuad(vcCore, p1a.method_1020(origin), p1b.method_1020(origin), p2b.method_1020(origin), p2a.method_1020(origin), r, g, b, a, 1.0f - (float)i / (float)(effectiveN - 1), 1.0f - (float)(i + 1) / (float)(effectiveN - 1), poseStack);
        }
    }

    public static void renderForId(int entityId, float partialTicks, class_4587 poseStack, class_4597 buffer) {
        class_243 last;
        TrailRibbon ribbon = RIBBONS.get(entityId);
        if (ribbon == null || ribbon.size() < 2) {
            return;
        }
        class_4184 cam = class_310.method_1551().field_1773.method_19418();
        Vector3f upJ = cam.method_19336();
        class_243 camUp = new class_243((double)upJ.x(), (double)upJ.y(), (double)upJ.z());
        class_243 origin = last = ribbon.get(ribbon.size() - 1);
        BallTrailManager.uploadPaletteUniforms(partialTicks);
        BallTrailManager.setStrengthUniform(ribbon.strength);
        class_4588 vc = buffer.getBuffer(BallRenderTypes.trailAdditive());
        float baseWidth = 0.25f;
        int n = ribbon.size();
        int effectiveN = Math.max(2, n);
        int start = n - effectiveN;
        for (int i = 0; i < effectiveN - 1; ++i) {
            class_243 side;
            double len2;
            int i0 = start + i;
            class_243 p1w = ribbon.get(i0);
            class_243 p2w = ribbon.get(i0 + 1);
            class_243 seg = p2w.method_1020(p1w);
            if (seg.method_1027() < 1.0E-6 || (len2 = (side = seg.method_1036(camUp)).method_1027()) < 1.0E-6) continue;
            side = side.method_1021(1.0 / Math.sqrt(len2));
            float ageFrac = (float)(effectiveN - 1 - i) / (float)(effectiveN - 1);
            float decayBoost = 1.0f + (float)ribbon.stoppedTicks * 0.08f;
            float ageEff = class_3532.method_15363((float)(ageFrac * decayBoost), (float)0.0f, (float)1.0f);
            float width = baseWidth * (0.55f + 0.45f * (float)Math.pow(1.0f - ageEff, 1.4f));
            width *= ribbon.strength;
            int r = 180;
            int g = 60;
            int b = 255;
            int aHead = 240;
            int aTail = 12;
            int a = (int)class_3532.method_16439((float)ageEff, (float)aHead, (float)aTail);
            a = (int)((float)a * ribbon.strength);
            class_243 sScaled = side.method_1021((double)width);
            class_243 p1a = p1w.method_1019(sScaled);
            class_243 p1b = p1w.method_1020(sScaled);
            class_243 p2a = p2w.method_1019(sScaled);
            class_243 p2b = p2w.method_1020(sScaled);
            BallTrailManager.emitQuad(vc, p1a.method_1020(origin), p1b.method_1020(origin), p2b.method_1020(origin), p2a.method_1020(origin), r, g, b, a, 1.0f - (float)i / (float)(effectiveN - 1), 1.0f - (float)(i + 1) / (float)(effectiveN - 1), poseStack);
        }
        BallTrailManager.uploadPaletteUniforms(partialTicks);
        BallTrailManager.setStrengthUniform(ribbon.strength);
        class_4588 vcCore = buffer.getBuffer(BallRenderTypes.trailCoreAdditive());
        float coreScale = 0.45f;
        for (int i = 0; i < effectiveN - 1; ++i) {
            class_243 side;
            double len2;
            int i0 = start + i;
            class_243 p1w = ribbon.get(i0);
            class_243 p2w = ribbon.get(i0 + 1);
            class_243 seg = p2w.method_1020(p1w);
            if (seg.method_1027() < 1.0E-6 || (len2 = (side = seg.method_1036(camUp)).method_1027()) < 1.0E-6) continue;
            side = side.method_1021(1.0 / Math.sqrt(len2));
            float ageFrac = (float)(effectiveN - 1 - i) / (float)(effectiveN - 1);
            float decayBoost = 1.0f + (float)ribbon.stoppedTicks * 0.08f;
            float ageEff = class_3532.method_15363((float)(ageFrac * decayBoost), (float)0.0f, (float)1.0f);
            float width = baseWidth * coreScale * (0.55f + 0.45f * (float)Math.pow(1.0f - ageEff, 1.4f));
            width *= ribbon.strength;
            int r = 255;
            int g = 255;
            int b = 255;
            int aHead = 255;
            int aTail = 10;
            int a = (int)class_3532.method_16439((float)ageEff, (float)aHead, (float)aTail);
            a = (int)((float)a * ribbon.strength);
            class_243 sScaled = side.method_1021((double)width);
            class_243 p1a = p1w.method_1019(sScaled);
            class_243 p1b = p1w.method_1020(sScaled);
            class_243 p2a = p2w.method_1019(sScaled);
            class_243 p2b = p2w.method_1020(sScaled);
            BallTrailManager.emitQuad(vcCore, p1a.method_1020(origin), p1b.method_1020(origin), p2b.method_1020(origin), p2a.method_1020(origin), r, g, b, a, 1.0f - (float)i / (float)(effectiveN - 1), 1.0f - (float)(i + 1) / (float)(effectiveN - 1), poseStack);
        }
    }

    private static void uploadPaletteUniforms(float partialTicks) {
        try {
            class_5944 sh = RenderSystem.getShader();
            if (sh == null) {
                return;
            }
            class_310 mc = class_310.method_1551();
            float t = 0.0f;
            if (mc != null) {
                if (mc.field_1687 != null) {
                    t = ((float)mc.field_1687.method_8510() + partialTicks) * 0.05f;
                } else if (mc.field_1705 != null) {
                    t = ((float)mc.field_1705.method_1738() + partialTicks) * 0.05f;
                }
            }
            BallTrailManager.set1f(sh, "u_paletteMix", 1.0f);
            float speed = 0.0f;
            BallTrailManager.set1f(sh, "u_paletteSpeed", speed);
            BallTrailManager.set1f(sh, "u_paletteShift", 0.5f);
            BallTrailManager.set1f(sh, "u_paletteSaturation", 1.0f);
            BallTrailManager.set3f(sh, "u_lumaCoeff", 0.299f, 0.587f, 0.114f);
            BallTrailManager.set3f(sh, "u_c0", 1.0f, 1.0f, 1.0f);
            BallTrailManager.set3f(sh, "u_c1", 1.0f, 0.92f, 0.12f);
            BallTrailManager.set3f(sh, "u_c2", 1.0f, 0.68f, 0.1f);
            BallTrailManager.set3f(sh, "u_c3", 0.6f, 0.25f, 0.95f);
            BallTrailManager.set1f(sh, "u_t1", 0.3f);
            BallTrailManager.set1f(sh, "u_t2", 0.6f);
            BallTrailManager.set1f(sh, "u_t3", 1.0f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void setStrengthUniform(float strength) {
        try {
            class_5944 sh = RenderSystem.getShader();
            if (sh == null) {
                return;
            }
            float boost = 2.5f;
            float s = Math.max(0.0f, strength * boost);
            BallTrailManager.set1f(sh, "uStrength", Math.min(s, 2.0f));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void set1f(class_5944 sh, String name, float v) {
        if (sh == null) {
            return;
        }
        class_284 u = sh.method_34582(name);
        if (u != null) {
            u.method_1251(v);
        }
    }

    private static void set3f(class_5944 sh, String name, float x, float y, float z) {
        if (sh == null) {
            return;
        }
        class_284 u = sh.method_34582(name);
        if (u != null) {
            u.method_1249(x, y, z);
        }
    }

    private static void emitQuad(@NotNull class_4588 vc, class_243 v0, class_243 v1, class_243 v2, class_243 v3, int r, int g, int b, int a, float u1, float u2, class_4587 poseStack) {
        class_4587.class_4665 last = poseStack.method_23760();
        Matrix4f mat = last.method_23761();
        vc.method_22918(mat, (float)v0.field_1352, (float)v0.field_1351, (float)v0.field_1350).method_1336(r, g, b, a).method_22913(u1, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(last, 0.0f, 1.0f, 0.0f);
        vc.method_22918(mat, (float)v1.field_1352, (float)v1.field_1351, (float)v1.field_1350).method_1336(r, g, b, a).method_22913(u1, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(last, 0.0f, 1.0f, 0.0f);
        vc.method_22918(mat, (float)v2.field_1352, (float)v2.field_1351, (float)v2.field_1350).method_1336(r, g, b, a).method_22913(u2, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(last, 0.0f, 1.0f, 0.0f);
        vc.method_22918(mat, (float)v3.field_1352, (float)v3.field_1351, (float)v3.field_1350).method_1336(r, g, b, a).method_22913(u2, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(last, 0.0f, 1.0f, 0.0f);
    }

    private static float smoothstep(float edge0, float edge1, float x) {
        float t = class_3532.method_15363((float)((x - edge0) / (edge1 - edge0)), (float)0.0f, (float)1.0f);
        return t * t * (3.0f - 2.0f * t);
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * class_3532.method_15363((float)t, (float)0.0f, (float)1.0f);
    }

    public static void renderScrollingRing(class_243 center, class_243 normal, float radius, float thickness, int segments, float strength, float scroll, float partialTicks, class_4587 poseStack, class_4597 buffer) {
        class_243 ref;
        class_243 tangentX;
        class_243 n;
        if (segments < 3 || radius <= 0.0f || thickness <= 0.0f) {
            return;
        }
        Vector3f upVector = class_310.method_1551().field_1773.method_19418().method_19336();
        class_243 camUp = new class_243((double)upVector.x(), (double)upVector.y(), (double)upVector.z());
        class_243 class_2432 = n = normal == null ? new class_243(0.0, 1.0, 0.0) : normal;
        if (n.method_1027() < 1.0E-6) {
            n = new class_243(0.0, 1.0, 0.0);
        }
        if ((tangentX = (n = n.method_1029()).method_1036(ref = Math.abs(n.field_1351) < 0.99 ? new class_243(0.0, 1.0, 0.0) : new class_243(1.0, 0.0, 0.0))).method_1027() < 1.0E-6) {
            tangentX = n.method_1036(new class_243(1.0, 0.0, 0.0));
        }
        tangentX = tangentX.method_1029();
        class_243 tangentY = n.method_1036(tangentX).method_1029();
        BallTrailManager.uploadPaletteUniforms(partialTicks);
        BallTrailManager.setStrengthUniform(Math.max(0.0f, strength));
        class_4588 vc = buffer.getBuffer(BallRenderTypes.trailAdditive());
        float halfW = thickness * 0.5f;
        class_243 origin = center == null ? class_243.field_1353 : center;
        int r = 180;
        int g = 60;
        int b = 255;
        int aHead = 240;
        int aTail = 200;
        for (int i = 0; i < segments; ++i) {
            class_243 side;
            double len2;
            int j = (i + 1) % segments;
            float t0 = (float)i / (float)segments;
            float t1 = (float)j / (float)segments;
            double ang0 = Math.PI * 2 * (double)t0;
            double ang1 = Math.PI * 2 * (double)t1;
            class_243 p0 = origin.method_1019(tangentX.method_1021(Math.cos(ang0) * (double)radius)).method_1019(tangentY.method_1021(Math.sin(ang0) * (double)radius));
            class_243 p1 = origin.method_1019(tangentX.method_1021(Math.cos(ang1) * (double)radius)).method_1019(tangentY.method_1021(Math.sin(ang1) * (double)radius));
            class_243 seg = p1.method_1020(p0);
            if (seg.method_1027() < 1.0E-8 || (len2 = (side = n.method_1036(camUp)).method_1027()) < 1.0E-10) continue;
            side = side.method_1021(1.0 / Math.sqrt(len2));
            class_243 sScaled = side.method_1021((double)halfW);
            class_243 p0a = p0.method_1019(sScaled);
            class_243 p0b = p0.method_1020(sScaled);
            class_243 p1a = p1.method_1019(sScaled);
            class_243 p1b = p1.method_1020(sScaled);
            float ageEff = 0.0f;
            int a = (int)class_3532.method_16439((float)ageEff, (float)aHead, (float)aTail);
            a = (int)((float)a * Math.max(0.0f, Math.min(1.0f, strength)));
            float u0 = t0 + scroll;
            float u1 = t1 + scroll;
            u0 -= (float)Math.floor(u0);
            u1 -= (float)Math.floor(u1);
            BallTrailManager.emitQuad(vc, p0a.method_1020(origin), p0b.method_1020(origin), p1b.method_1020(origin), p1a.method_1020(origin), r, g, b, a, u0, u1, poseStack);
        }
        BallTrailManager.uploadPaletteUniforms(partialTicks);
        BallTrailManager.setStrengthUniform(Math.max(0.0f, strength));
        class_4588 vcCore = buffer.getBuffer(BallRenderTypes.trailCoreAdditive());
        float coreScale = 0.45f;
        float halfWCore = halfW * coreScale;
        int rC = 255;
        int gC = 255;
        int bC = 255;
        int aCHead = 255;
        int aCTail = 180;
        for (int i = 0; i < segments; ++i) {
            class_243 side;
            double len2;
            int j = (i + 1) % segments;
            float t0 = (float)i / (float)segments;
            float t1 = (float)j / (float)segments;
            double ang0 = Math.PI * 2 * (double)t0;
            double ang1 = Math.PI * 2 * (double)t1;
            class_243 p0 = origin.method_1019(tangentX.method_1021(Math.cos(ang0) * (double)radius)).method_1019(tangentY.method_1021(Math.sin(ang0) * (double)radius));
            class_243 p1 = origin.method_1019(tangentX.method_1021(Math.cos(ang1) * (double)radius)).method_1019(tangentY.method_1021(Math.sin(ang1) * (double)radius));
            class_243 seg = p1.method_1020(p0);
            if (seg.method_1027() < 1.0E-8 || (len2 = (side = n.method_1036(camUp)).method_1027()) < 1.0E-10) continue;
            side = side.method_1021(1.0 / Math.sqrt(len2));
            class_243 sScaled = side.method_1021((double)halfWCore);
            class_243 p0a = p0.method_1019(sScaled);
            class_243 p0b = p0.method_1020(sScaled);
            class_243 p1a = p1.method_1019(sScaled);
            class_243 p1b = p1.method_1020(sScaled);
            float ageEff = 0.0f;
            int a = (int)class_3532.method_16439((float)ageEff, (float)aCHead, (float)aCTail);
            a = (int)((float)a * Math.max(0.0f, Math.min(1.0f, strength)));
            float u0 = t0 + scroll;
            float u1 = t1 + scroll;
            u0 -= (float)Math.floor(u0);
            u1 -= (float)Math.floor(u1);
            BallTrailManager.emitQuad(vcCore, p0a.method_1020(origin), p0b.method_1020(origin), p1b.method_1020(origin), p1a.method_1020(origin), rC, gC, bC, a, u0, u1, poseStack);
        }
    }

    private static final class TrailRibbon {
        private static final int MAX_POINTS = 40;
        private final Deque<class_243> points = new ArrayDeque<class_243>(40);
        private class_243 lastPos = null;
        private float strength = 0.0f;
        private int stoppedTicks = 0;
        private boolean stopped = false;

        private TrailRibbon() {
        }

        void sample(class_243 p) {
            if (this.lastPos == null) {
                this.lastPos = p;
                this.points.addLast(p);
                return;
            }
            double dist = p.method_1022(this.lastPos);
            float speed = (float)(dist * 20.0);
            float target = BallTrailManager.smoothstep(0.0f, 0.5f, speed);
            if (speed < 0.0f) {
                this.stopped = true;
                ++this.stoppedTicks;
                this.strength = BallTrailManager.lerp(this.strength, 0.0f, 0.1f);
            } else {
                this.stopped = false;
                this.stoppedTicks = 0;
                if (this.points.isEmpty() || this.points.getLast().method_1025(p) >= 4.0E-4) {
                    this.points.addLast(p);
                    if (this.points.size() > 40) {
                        this.points.removeFirst();
                    }
                }
                this.strength = BallTrailManager.lerp(this.strength, target, 0.1f);
            }
            this.lastPos = p;
        }

        int size() {
            return this.points.size();
        }

        class_243 get(int idx) {
            if (idx < 0 || idx >= this.points.size()) {
                throw new IndexOutOfBoundsException();
            }
            int i = 0;
            for (class_243 p : this.points) {
                if (i++ != idx) continue;
                return p;
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

