/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.config;

import com.jayemceekay.shadowedhearts.Shadowedhearts;
import com.jayemceekay.shadowedhearts.config.IClientConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class ClientConfig
implements IClientConfig {
    private boolean loaded = false;
    public static final ModConfigSpec SPEC;
    private static final Data DATA;

    @Override
    public boolean enableShadowAura() {
        return (Boolean)ClientConfig.DATA.enableShadowAura.get();
    }

    @Override
    public boolean auraScannerEnabled() {
        return (Boolean)ClientConfig.DATA.auraScannerEnabled.get();
    }

    @Override
    public boolean skipIrisWarning() {
        return (Boolean)ClientConfig.DATA.skipIrisWarning.get();
    }

    @Override
    public void setSkipIrisWarning(boolean value) {
        ClientConfig.DATA.skipIrisWarning.set((Object)value);
        ClientConfig.DATA.skipIrisWarning.save();
    }

    @Override
    public float auraReaderYOffset() {
        return ((Double)ClientConfig.DATA.auraReaderYOffset.get()).floatValue();
    }

    @Override
    public ModConfigSpec getSpec() {
        return SPEC;
    }

    @Override
    public void load() {
        this.loaded = true;
        Shadowedhearts.LOGGER.info("ClientConfig loaded via Forge Config API Port.");
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    static {
        DATA = new Data();
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        DATA.build(builder);
        SPEC = builder.build();
    }

    private static final class Data {
        public ModConfigSpec.BooleanValue enableShadowAura;
        public ModConfigSpec.BooleanValue auraScannerEnabled;
        public ModConfigSpec.BooleanValue skipIrisWarning;
        public ModConfigSpec.DoubleValue auraReaderYOffset;

        private Data() {
        }

        private void build(ModConfigSpec.Builder builder) {
            this.enableShadowAura = builder.comment("Master toggle for client-side Shadow aura rendering.").define("enableShadowAura", true);
            this.auraScannerEnabled = builder.comment("Whether the Aura Scanner HUD is enabled.").define("auraScannerEnabled", true);
            this.skipIrisWarning = builder.comment("Whether to skip the Iris shader warning screen.").define("skipIrisWarning", false);
            this.auraReaderYOffset = builder.comment("The Y offset for the Aura Reader model.").defineInRange("auraReaderYOffset", -0.15, -10.0, 10.0);
        }
    }
}

