/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.config;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public final class HeartGaugeConfig {
    public static final int DEFAULT_MAX = 20000;
    private static final Map<String, Integer> DEFAULTS = new HashMap<String, Integer>();
    private static volatile boolean loaded;
    private static final Map<String, Integer> overrides;
    private static int globalMax;

    private HeartGaugeConfig() {
    }

    private static Path configPath() {
        return Path.of("config", "shadowedhearts", "heart_gauge_max.json");
    }

    private static String speciesKey(Species species) {
        try {
            String full = species.getResourceIdentifier().toString().toLowerCase(Locale.ROOT);
            return full;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String speciesAltKey(Species species) {
        try {
            String path = species.getResourceIdentifier().method_12832().toLowerCase(Locale.ROOT);
            return path;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static int getGlobalMax() {
        HeartGaugeConfig.ensureLoaded();
        return globalMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureLoaded() {
        if (loaded) {
            return;
        }
        Class<HeartGaugeConfig> clazz = HeartGaugeConfig.class;
        synchronized (HeartGaugeConfig.class) {
            if (loaded) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            Path path = HeartGaugeConfig.configPath();
            if (Files.exists(path, new LinkOption[0])) {
                try (BufferedReader reader2 = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                    JsonElement root = JsonParser.parseReader((Reader)reader2);
                    if (root != null && root.isJsonObject()) {
                        JsonObject obj = root.getAsJsonObject();
                        for (Map.Entry e : obj.entrySet()) {
                            String key = (String)e.getKey();
                            if (key == null) continue;
                            key = key.toLowerCase(Locale.ROOT).trim();
                            try {
                                int val = ((JsonElement)e.getValue()).getAsInt();
                                if (val <= 0) continue;
                                overrides.put(key, val);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (IOException reader2) {}
            } else {
                overrides.putAll(DEFAULTS);
                HeartGaugeConfig.save();
            }
            int max = 30000;
            for (int v : DEFAULTS.values()) {
                if (v <= max) continue;
                max = v;
            }
            for (int v : overrides.values()) {
                if (v <= max) continue;
                max = v;
            }
            globalMax = max;
            loaded = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void save() {
        Path path = HeartGaugeConfig.configPath();
        try {
            Path parent = path.getParent();
            if (parent != null && !Files.isDirectory(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            JsonObject obj = new JsonObject();
            TreeMap<String, Integer> sorted = new TreeMap<String, Integer>(overrides);
            for (Map.Entry e : sorted.entrySet()) {
                obj.addProperty((String)e.getKey(), (Number)e.getValue());
            }
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj, (Appendable)writer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getMax(Pokemon pokemon) {
        if (pokemon == null) {
            return 20000;
        }
        Species species = pokemon.getSpecies();
        if (species == null) {
            return 20000;
        }
        return HeartGaugeConfig.getMax(species);
    }

    public static int getMax(Species species) {
        Integer v;
        HeartGaugeConfig.ensureLoaded();
        String full = HeartGaugeConfig.speciesKey(species);
        String alt = HeartGaugeConfig.speciesAltKey(species);
        if (full != null) {
            v = overrides.get(full);
            if (v != null) {
                return v;
            }
            v = DEFAULTS.get(full);
            if (v != null) {
                return v;
            }
        }
        if (alt != null) {
            v = overrides.get(alt);
            if (v != null) {
                return v;
            }
            v = DEFAULTS.get(alt);
            if (v != null) {
                return v;
            }
        }
        return 20000;
    }

    public static int getMaxByKey(String key) {
        HeartGaugeConfig.ensureLoaded();
        if (key == null) {
            return 20000;
        }
        String lowerKey = key.toLowerCase(Locale.ROOT).trim();
        Integer v = overrides.get(lowerKey);
        if (v != null) {
            return v;
        }
        v = DEFAULTS.get(lowerKey);
        return v != null ? v : 20000;
    }

    static {
        DEFAULTS.put("cobblemon:abomasnow", 8800);
        DEFAULTS.put("cobblemon:abra", 14600);
        DEFAULTS.put("cobblemon:absol", 7000);
        DEFAULTS.put("cobblemon:accelgor", 12700);
        DEFAULTS.put("cobblemon:aegislash", 14500);
        DEFAULTS.put("cobblemon:aerodactyl", 8700);
        DEFAULTS.put("cobblemon:aggron", 6400);
        DEFAULTS.put("cobblemon:aipom", 6000);
        DEFAULTS.put("cobblemon:alakazam", 6700);
        DEFAULTS.put("cobblemon:alcremie", 7600);
        DEFAULTS.put("cobblemon:alomomola", 4200);
        DEFAULTS.put("cobblemon:altaria", 6500);
        DEFAULTS.put("cobblemon:amaura", 21600);
        DEFAULTS.put("cobblemon:ambipom", 16700);
        DEFAULTS.put("cobblemon:amoonguss", 22300);
        DEFAULTS.put("cobblemon:ampharos", 10600);
        DEFAULTS.put("cobblemon:annihilape", 14300);
        DEFAULTS.put("cobblemon:anorith", 11600);
        DEFAULTS.put("cobblemon:appletun", 14000);
        DEFAULTS.put("cobblemon:applin", 2800);
        DEFAULTS.put("cobblemon:araquanid", 5400);
        DEFAULTS.put("cobblemon:arbok", 5000);
        DEFAULTS.put("cobblemon:arboliva", 12500);
        DEFAULTS.put("cobblemon:arcanine", 5600);
        DEFAULTS.put("cobblemon:arceus", 10300);
        DEFAULTS.put("cobblemon:archaludon", 13400);
        DEFAULTS.put("cobblemon:archen", 14600);
        DEFAULTS.put("cobblemon:archeops", 6200);
        DEFAULTS.put("cobblemon:arctibax", 15500);
        DEFAULTS.put("cobblemon:arctovish", 9400);
        DEFAULTS.put("cobblemon:arctozolt", 13400);
        DEFAULTS.put("cobblemon:ariados", 6000);
        DEFAULTS.put("cobblemon:armaldo", 4400);
        DEFAULTS.put("cobblemon:armarouge", 18600);
        DEFAULTS.put("cobblemon:aromatisse", 6700);
        DEFAULTS.put("cobblemon:aron", 6400);
        DEFAULTS.put("cobblemon:arrokuda", 9700);
        DEFAULTS.put("cobblemon:articuno", 10000);
        DEFAULTS.put("cobblemon:audino", 11200);
        DEFAULTS.put("cobblemon:aurorus", 6300);
        DEFAULTS.put("cobblemon:avalugg", 5000);
        DEFAULTS.put("cobblemon:axew", 12600);
        DEFAULTS.put("cobblemon:azelf", 15200);
        DEFAULTS.put("cobblemon:azumarill", 4300);
        DEFAULTS.put("cobblemon:azurill", 4200);
        DEFAULTS.put("cobblemon:bagon", 5700);
        DEFAULTS.put("cobblemon:baltoy", 1500);
        DEFAULTS.put("cobblemon:banette", 7000);
        DEFAULTS.put("cobblemon:barbaracle", 18200);
        DEFAULTS.put("cobblemon:barboach", 9200);
        DEFAULTS.put("cobblemon:barraskewda", 18400);
        DEFAULTS.put("cobblemon:basculegion", 10600);
        DEFAULTS.put("cobblemon:basculin", 12400);
        DEFAULTS.put("cobblemon:bastiodon", 6000);
        DEFAULTS.put("cobblemon:baxcalibur", 15500);
        DEFAULTS.put("cobblemon:bayleef", 3000);
        DEFAULTS.put("cobblemon:beartic", 6900);
        DEFAULTS.put("cobblemon:beautifly", 5600);
        DEFAULTS.put("cobblemon:beedrill", 4500);
        DEFAULTS.put("cobblemon:beheeyem", 16800);
        DEFAULTS.put("cobblemon:beldum", 9300);
        DEFAULTS.put("cobblemon:bellibolt", 18900);
        DEFAULTS.put("cobblemon:bellossom", 9000);
        DEFAULTS.put("cobblemon:bellsprout", 18200);
        DEFAULTS.put("cobblemon:bergmite", 19200);
        DEFAULTS.put("cobblemon:bewear", 5900);
        DEFAULTS.put("cobblemon:bibarel", 10300);
        DEFAULTS.put("cobblemon:bidoof", 4700);
        DEFAULTS.put("cobblemon:binacle", 12800);
        DEFAULTS.put("cobblemon:bisharp", 19600);
        DEFAULTS.put("cobblemon:blacephalon", 8800);
        DEFAULTS.put("cobblemon:blastoise", 7300);
        DEFAULTS.put("cobblemon:blaziken", 12600);
        DEFAULTS.put("cobblemon:blipbug", 10300);
        DEFAULTS.put("cobblemon:blissey", 6200);
        DEFAULTS.put("cobblemon:blitzle", 2700);
        DEFAULTS.put("cobblemon:boldore", 15200);
        DEFAULTS.put("cobblemon:boltund", 17400);
        DEFAULTS.put("cobblemon:bombirdier", 15700);
        DEFAULTS.put("cobblemon:bonsly", 7200);
        DEFAULTS.put("cobblemon:bouffalant", 13800);
        DEFAULTS.put("cobblemon:bounsweet", 16500);
        DEFAULTS.put("cobblemon:braixen", 4900);
        DEFAULTS.put("cobblemon:brambleghast", 5000);
        DEFAULTS.put("cobblemon:bramblin", 15600);
        DEFAULTS.put("cobblemon:braviary", 14000);
        DEFAULTS.put("cobblemon:breloom", 3700);
        DEFAULTS.put("cobblemon:brionne", 7200);
        DEFAULTS.put("cobblemon:bronzong", 20900);
        DEFAULTS.put("cobblemon:bronzor", 24200);
        DEFAULTS.put("cobblemon:brutebonnet", 16300);
        DEFAULTS.put("cobblemon:bruxish", 8300);
        DEFAULTS.put("cobblemon:budew", 11400);
        DEFAULTS.put("cobblemon:buizel", 5800);
        DEFAULTS.put("cobblemon:bulbasaur", 12100);
        DEFAULTS.put("cobblemon:buneary", 9300);
        DEFAULTS.put("cobblemon:bunnelby", 13500);
        DEFAULTS.put("cobblemon:burmy", 18000);
        DEFAULTS.put("cobblemon:butterfree", 4000);
        DEFAULTS.put("cobblemon:buzzwole", 6800);
        DEFAULTS.put("cobblemon:cacnea", 13000);
        DEFAULTS.put("cobblemon:cacturne", 10300);
        DEFAULTS.put("cobblemon:calyrex", 25600);
        DEFAULTS.put("cobblemon:camerupt", 17400);
        DEFAULTS.put("cobblemon:capsakid", 17400);
        DEFAULTS.put("cobblemon:carbink", 10600);
        DEFAULTS.put("cobblemon:carkol", 12100);
        DEFAULTS.put("cobblemon:carnivine", 17900);
        DEFAULTS.put("cobblemon:carracosta", 10500);
        DEFAULTS.put("cobblemon:carvanha", 1700);
        DEFAULTS.put("cobblemon:cascoon", 23200);
        DEFAULTS.put("cobblemon:castform", 6700);
        DEFAULTS.put("cobblemon:caterpie", 12000);
        DEFAULTS.put("cobblemon:celebi", 23400);
        DEFAULTS.put("cobblemon:celesteela", 8800);
        DEFAULTS.put("cobblemon:centiskorch", 11800);
        DEFAULTS.put("cobblemon:ceruledge", 14400);
        DEFAULTS.put("cobblemon:cetitan", 6700);
        DEFAULTS.put("cobblemon:cetoddle", 14400);
        DEFAULTS.put("cobblemon:chandelure", 4200);
        DEFAULTS.put("cobblemon:chansey", 4000);
        DEFAULTS.put("cobblemon:charcadet", 7200);
        DEFAULTS.put("cobblemon:charizard", 4300);
        DEFAULTS.put("cobblemon:charjabug", 19400);
        DEFAULTS.put("cobblemon:charmander", 21200);
        DEFAULTS.put("cobblemon:charmeleon", 20500);
        DEFAULTS.put("cobblemon:chatot", 12900);
        DEFAULTS.put("cobblemon:cherrim", 7000);
        DEFAULTS.put("cobblemon:cherubi", 6000);
        DEFAULTS.put("cobblemon:chesnaught", 9100);
        DEFAULTS.put("cobblemon:chespin", 18700);
        DEFAULTS.put("cobblemon:chewtle", 4300);
        DEFAULTS.put("cobblemon:chienpao", 10700);
        DEFAULTS.put("cobblemon:chikorita", 12400);
        DEFAULTS.put("cobblemon:chimchar", 16400);
        DEFAULTS.put("cobblemon:chimecho", 11500);
        DEFAULTS.put("cobblemon:chinchou", 14200);
        DEFAULTS.put("cobblemon:chingling", 2200);
        DEFAULTS.put("cobblemon:chiyu", 10300);
        DEFAULTS.put("cobblemon:cinccino", 7900);
        DEFAULTS.put("cobblemon:cinderace", 12400);
        DEFAULTS.put("cobblemon:clamperl", 5500);
        DEFAULTS.put("cobblemon:clauncher", 16100);
        DEFAULTS.put("cobblemon:clawitzer", 7500);
        DEFAULTS.put("cobblemon:claydol", 15700);
        DEFAULTS.put("cobblemon:clefable", 6300);
        DEFAULTS.put("cobblemon:clefairy", 14600);
        DEFAULTS.put("cobblemon:cleffa", 4400);
        DEFAULTS.put("cobblemon:clobbopus", 12100);
        DEFAULTS.put("cobblemon:clodsire", 11500);
        DEFAULTS.put("cobblemon:cloyster", 9400);
        DEFAULTS.put("cobblemon:coalossal", 20800);
        DEFAULTS.put("cobblemon:cobalion", 20700);
        DEFAULTS.put("cobblemon:cofagrigus", 8000);
        DEFAULTS.put("cobblemon:combee", 12600);
        DEFAULTS.put("cobblemon:combusken", 11500);
        DEFAULTS.put("cobblemon:comfey", 12800);
        DEFAULTS.put("cobblemon:conkeldurr", 4700);
        DEFAULTS.put("cobblemon:copperajah", 6700);
        DEFAULTS.put("cobblemon:corphish", 17500);
        DEFAULTS.put("cobblemon:corsola", 6200);
        DEFAULTS.put("cobblemon:corviknight", 11600);
        DEFAULTS.put("cobblemon:corvisquire", 9400);
        DEFAULTS.put("cobblemon:cosmoem", 15700);
        DEFAULTS.put("cobblemon:cosmog", 4100);
        DEFAULTS.put("cobblemon:cottonee", 9600);
        DEFAULTS.put("cobblemon:crabominable", 8300);
        DEFAULTS.put("cobblemon:crabrawler", 15500);
        DEFAULTS.put("cobblemon:cradily", 11900);
        DEFAULTS.put("cobblemon:cramorant", 12000);
        DEFAULTS.put("cobblemon:cranidos", 13800);
        DEFAULTS.put("cobblemon:crawdaunt", 10100);
        DEFAULTS.put("cobblemon:cresselia", 20600);
        DEFAULTS.put("cobblemon:croagunk", 13100);
        DEFAULTS.put("cobblemon:crobat", 5300);
        DEFAULTS.put("cobblemon:crocalor", 16200);
        DEFAULTS.put("cobblemon:croconaw", 3000);
        DEFAULTS.put("cobblemon:crustle", 12000);
        DEFAULTS.put("cobblemon:cryogonal", 8900);
        DEFAULTS.put("cobblemon:cubchoo", 9800);
        DEFAULTS.put("cobblemon:cubone", 5600);
        DEFAULTS.put("cobblemon:cufant", 14100);
        DEFAULTS.put("cobblemon:cursola", 16800);
        DEFAULTS.put("cobblemon:cutiefly", 20000);
        DEFAULTS.put("cobblemon:cyclizar", 7300);
        DEFAULTS.put("cobblemon:cyndaquil", 9200);
        DEFAULTS.put("cobblemon:dachsbun", 4800);
        DEFAULTS.put("cobblemon:darkrai", 19200);
        DEFAULTS.put("cobblemon:darmanitan", 13400);
        DEFAULTS.put("cobblemon:dartrix", 5900);
        DEFAULTS.put("cobblemon:darumaka", 12200);
        DEFAULTS.put("cobblemon:decidueye", 17100);
        DEFAULTS.put("cobblemon:dedenne", 6600);
        DEFAULTS.put("cobblemon:deerling", 11100);
        DEFAULTS.put("cobblemon:deino", 17100);
        DEFAULTS.put("cobblemon:delcatty", 2500);
        DEFAULTS.put("cobblemon:delibird", 7000);
        DEFAULTS.put("cobblemon:delphox", 7500);
        DEFAULTS.put("cobblemon:deoxys", 21100);
        DEFAULTS.put("cobblemon:dewgong", 4600);
        DEFAULTS.put("cobblemon:dewott", 17900);
        DEFAULTS.put("cobblemon:dewpider", 5100);
        DEFAULTS.put("cobblemon:dhelmise", 10500);
        DEFAULTS.put("cobblemon:dialga", 16600);
        DEFAULTS.put("cobblemon:diancie", 26300);
        DEFAULTS.put("cobblemon:diggersby", 5300);
        DEFAULTS.put("cobblemon:diglett", 15100);
        DEFAULTS.put("cobblemon:dipplin", 14700);
        DEFAULTS.put("cobblemon:ditto", 5700);
        DEFAULTS.put("cobblemon:dodrio", 8000);
        DEFAULTS.put("cobblemon:doduo", 8500);
        DEFAULTS.put("cobblemon:dolliv", 17900);
        DEFAULTS.put("cobblemon:dondozo", 11400);
        DEFAULTS.put("cobblemon:donphan", 7900);
        DEFAULTS.put("cobblemon:dottler", 9800);
        DEFAULTS.put("cobblemon:doublade", 10900);
        DEFAULTS.put("cobblemon:dracovish", 4700);
        DEFAULTS.put("cobblemon:dracozolt", 14500);
        DEFAULTS.put("cobblemon:dragalge", 16100);
        DEFAULTS.put("cobblemon:dragapult", 18200);
        DEFAULTS.put("cobblemon:dragonair", 17400);
        DEFAULTS.put("cobblemon:dragonite", 9000);
        DEFAULTS.put("cobblemon:drakloak", 13600);
        DEFAULTS.put("cobblemon:drampa", 8400);
        DEFAULTS.put("cobblemon:drapion", 7100);
        DEFAULTS.put("cobblemon:dratini", 17900);
        DEFAULTS.put("cobblemon:drednaw", 8800);
        DEFAULTS.put("cobblemon:dreepy", 5500);
        DEFAULTS.put("cobblemon:drifblim", 16600);
        DEFAULTS.put("cobblemon:drifloon", 8100);
        DEFAULTS.put("cobblemon:drilbur", 7600);
        DEFAULTS.put("cobblemon:drizzile", 7100);
        DEFAULTS.put("cobblemon:drowzee", 12900);
        DEFAULTS.put("cobblemon:druddigon", 15200);
        DEFAULTS.put("cobblemon:dubwool", 4800);
        DEFAULTS.put("cobblemon:ducklett", 10400);
        DEFAULTS.put("cobblemon:dudunsparce", 9900);
        DEFAULTS.put("cobblemon:dugtrio", 5000);
        DEFAULTS.put("cobblemon:dunsparce", 5000);
        DEFAULTS.put("cobblemon:duosion", 12600);
        DEFAULTS.put("cobblemon:duraludon", 10300);
        DEFAULTS.put("cobblemon:durant", 11500);
        DEFAULTS.put("cobblemon:dusclops", 6100);
        DEFAULTS.put("cobblemon:dusknoir", 4700);
        DEFAULTS.put("cobblemon:duskull", 2200);
        DEFAULTS.put("cobblemon:dustox", 3200);
        DEFAULTS.put("cobblemon:dwebble", 7500);
        DEFAULTS.put("cobblemon:eelektrik", 10100);
        DEFAULTS.put("cobblemon:eelektross", 11900);
        DEFAULTS.put("cobblemon:eevee", 14400);
        DEFAULTS.put("cobblemon:eiscue", 9100);
        DEFAULTS.put("cobblemon:ekans", 18800);
        DEFAULTS.put("cobblemon:eldegoss", 10400);
        DEFAULTS.put("cobblemon:electabuzz", 7000);
        DEFAULTS.put("cobblemon:electivire", 17300);
        DEFAULTS.put("cobblemon:electrike", 5200);
        DEFAULTS.put("cobblemon:electrode", 11500);
        DEFAULTS.put("cobblemon:elekid", 10500);
        DEFAULTS.put("cobblemon:elgyem", 15100);
        DEFAULTS.put("cobblemon:emboar", 22400);
        DEFAULTS.put("cobblemon:emolga", 7100);
        DEFAULTS.put("cobblemon:empoleon", 3900);
        DEFAULTS.put("cobblemon:enamorus", 10200);
        DEFAULTS.put("cobblemon:entei", 13000);
        DEFAULTS.put("cobblemon:escavalier", 7600);
        DEFAULTS.put("cobblemon:espathra", 6500);
        DEFAULTS.put("cobblemon:espeon", 8600);
        DEFAULTS.put("cobblemon:espurr", 19300);
        DEFAULTS.put("cobblemon:eternatus", 15600);
        DEFAULTS.put("cobblemon:excadrill", 5800);
        DEFAULTS.put("cobblemon:exeggcute", 5800);
        DEFAULTS.put("cobblemon:exeggutor", 9000);
        DEFAULTS.put("cobblemon:exploud", 13900);
        DEFAULTS.put("cobblemon:falinks", 6200);
        DEFAULTS.put("cobblemon:farfetchd", 5500);
        DEFAULTS.put("cobblemon:farigiraf", 21400);
        DEFAULTS.put("cobblemon:fearow", 20100);
        DEFAULTS.put("cobblemon:feebas", 14000);
        DEFAULTS.put("cobblemon:fennekin", 13000);
        DEFAULTS.put("cobblemon:feraligatr", 9000);
        DEFAULTS.put("cobblemon:ferroseed", 3600);
        DEFAULTS.put("cobblemon:ferrothorn", 13800);
        DEFAULTS.put("cobblemon:fezandipiti", 4500);
        DEFAULTS.put("cobblemon:fidough", 23600);
        DEFAULTS.put("cobblemon:finizen", 14800);
        DEFAULTS.put("cobblemon:finneon", 12300);
        DEFAULTS.put("cobblemon:flaaffy", 3000);
        DEFAULTS.put("cobblemon:flabebe", 6700);
        DEFAULTS.put("cobblemon:flamigo", 16800);
        DEFAULTS.put("cobblemon:flapple", 7300);
        DEFAULTS.put("cobblemon:flareon", 23800);
        DEFAULTS.put("cobblemon:fletchinder", 10800);
        DEFAULTS.put("cobblemon:fletchling", 18700);
        DEFAULTS.put("cobblemon:flittle", 9900);
        DEFAULTS.put("cobblemon:floatzel", 19800);
        DEFAULTS.put("cobblemon:floette", 16600);
        DEFAULTS.put("cobblemon:floragato", 17400);
        DEFAULTS.put("cobblemon:florges", 4300);
        DEFAULTS.put("cobblemon:fluttermane", 8700);
        DEFAULTS.put("cobblemon:flygon", 10500);
        DEFAULTS.put("cobblemon:fomantis", 12600);
        DEFAULTS.put("cobblemon:foongus", 15300);
        DEFAULTS.put("cobblemon:forretress", 6000);
        DEFAULTS.put("cobblemon:fraxure", 14500);
        DEFAULTS.put("cobblemon:frigibax", 6400);
        DEFAULTS.put("cobblemon:frillish", 7200);
        DEFAULTS.put("cobblemon:froakie", 7700);
        DEFAULTS.put("cobblemon:frogadier", 18600);
        DEFAULTS.put("cobblemon:froslass", 14100);
        DEFAULTS.put("cobblemon:frosmoth", 18700);
        DEFAULTS.put("cobblemon:fuecoco", 11200);
        DEFAULTS.put("cobblemon:furfrou", 10000);
        DEFAULTS.put("cobblemon:furret", 5000);
        DEFAULTS.put("cobblemon:gabite", 14400);
        DEFAULTS.put("cobblemon:gallade", 10400);
        DEFAULTS.put("cobblemon:galvantula", 4200);
        DEFAULTS.put("cobblemon:garbodor", 9300);
        DEFAULTS.put("cobblemon:garchomp", 13800);
        DEFAULTS.put("cobblemon:gardevoir", 15100);
        DEFAULTS.put("cobblemon:garganacl", 10900);
        DEFAULTS.put("cobblemon:gastly", 11000);
        DEFAULTS.put("cobblemon:gastrodon", 7700);
        DEFAULTS.put("cobblemon:genesect", 21800);
        DEFAULTS.put("cobblemon:gengar", 16900);
        DEFAULTS.put("cobblemon:geodude", 6200);
        DEFAULTS.put("cobblemon:gholdengo", 4600);
        DEFAULTS.put("cobblemon:gible", 19400);
        DEFAULTS.put("cobblemon:gigalith", 10700);
        DEFAULTS.put("cobblemon:gimmighoul", 5400);
        DEFAULTS.put("cobblemon:girafarig", 6000);
        DEFAULTS.put("cobblemon:giratina", 12700);
        DEFAULTS.put("cobblemon:glaceon", 6200);
        DEFAULTS.put("cobblemon:glalie", 11000);
        DEFAULTS.put("cobblemon:glameow", 5700);
        DEFAULTS.put("cobblemon:glastrier", 10600);
        DEFAULTS.put("cobblemon:gligar", 6000);
        DEFAULTS.put("cobblemon:glimmet", 17300);
        DEFAULTS.put("cobblemon:glimmora", 5400);
        DEFAULTS.put("cobblemon:gliscor", 19600);
        DEFAULTS.put("cobblemon:gloom", 13600);
        DEFAULTS.put("cobblemon:gogoat", 6000);
        DEFAULTS.put("cobblemon:golbat", 21200);
        DEFAULTS.put("cobblemon:goldeen", 8200);
        DEFAULTS.put("cobblemon:golduck", 6500);
        DEFAULTS.put("cobblemon:golem", 10400);
        DEFAULTS.put("cobblemon:golett", 11700);
        DEFAULTS.put("cobblemon:golisopod", 14400);
        DEFAULTS.put("cobblemon:golurk", 19000);
        DEFAULTS.put("cobblemon:goodra", 10800);
        DEFAULTS.put("cobblemon:goomy", 17200);
        DEFAULTS.put("cobblemon:gorebyss", 9900);
        DEFAULTS.put("cobblemon:gossifleur", 7100);
        DEFAULTS.put("cobblemon:gothita", 6700);
        DEFAULTS.put("cobblemon:gothitelle", 9700);
        DEFAULTS.put("cobblemon:gothorita", 5600);
        DEFAULTS.put("cobblemon:gougingfire", 19200);
        DEFAULTS.put("cobblemon:gourgeist", 17900);
        DEFAULTS.put("cobblemon:grafaiai", 10700);
        DEFAULTS.put("cobblemon:granbull", 6000);
        DEFAULTS.put("cobblemon:grapploct", 3500);
        DEFAULTS.put("cobblemon:graveler", 4800);
        DEFAULTS.put("cobblemon:greattusk", 20300);
        DEFAULTS.put("cobblemon:greavard", 6500);
        DEFAULTS.put("cobblemon:greedent", 11100);
        DEFAULTS.put("cobblemon:greninja", 19500);
        DEFAULTS.put("cobblemon:grimer", 3000);
        DEFAULTS.put("cobblemon:grimmsnarl", 12400);
        DEFAULTS.put("cobblemon:grookey", 8900);
        DEFAULTS.put("cobblemon:grotle", 4500);
        DEFAULTS.put("cobblemon:groudon", 13600);
        DEFAULTS.put("cobblemon:grovyle", 14100);
        DEFAULTS.put("cobblemon:growlithe", 4000);
        DEFAULTS.put("cobblemon:grubbin", 11900);
        DEFAULTS.put("cobblemon:grumpig", 5500);
        DEFAULTS.put("cobblemon:gulpin", 1500);
        DEFAULTS.put("cobblemon:gumshoos", 13100);
        DEFAULTS.put("cobblemon:gurdurr", 5200);
        DEFAULTS.put("cobblemon:guzzlord", 13800);
        DEFAULTS.put("cobblemon:gyarados", 15800);
        DEFAULTS.put("cobblemon:hakamoo", 7900);
        DEFAULTS.put("cobblemon:happiny", 6000);
        DEFAULTS.put("cobblemon:hariyama", 3400);
        DEFAULTS.put("cobblemon:hatenna", 12600);
        DEFAULTS.put("cobblemon:hatterene", 5000);
        DEFAULTS.put("cobblemon:hattrem", 7500);
        DEFAULTS.put("cobblemon:haunter", 18800);
        DEFAULTS.put("cobblemon:hawlucha", 9700);
        DEFAULTS.put("cobblemon:haxorus", 10900);
        DEFAULTS.put("cobblemon:heatmor", 13700);
        DEFAULTS.put("cobblemon:heatran", 15800);
        DEFAULTS.put("cobblemon:heliolisk", 13000);
        DEFAULTS.put("cobblemon:helioptile", 11100);
        DEFAULTS.put("cobblemon:heracross", 7000);
        DEFAULTS.put("cobblemon:herdier", 5800);
        DEFAULTS.put("cobblemon:hippopotas", 6200);
        DEFAULTS.put("cobblemon:hippowdon", 5900);
        DEFAULTS.put("cobblemon:hitmonchan", 6000);
        DEFAULTS.put("cobblemon:hitmonlee", 7000);
        DEFAULTS.put("cobblemon:hitmontop", 6000);
        DEFAULTS.put("cobblemon:honchkrow", 17100);
        DEFAULTS.put("cobblemon:honedge", 13200);
        DEFAULTS.put("cobblemon:hooh", 18600);
        DEFAULTS.put("cobblemon:hoopa", 24500);
        DEFAULTS.put("cobblemon:hoothoot", 13800);
        DEFAULTS.put("cobblemon:hoppip", 8700);
        DEFAULTS.put("cobblemon:horsea", 11000);
        DEFAULTS.put("cobblemon:houndoom", 7000);
        DEFAULTS.put("cobblemon:houndour", 1500);
        DEFAULTS.put("cobblemon:houndstone", 7300);
        DEFAULTS.put("cobblemon:huntail", 24200);
        DEFAULTS.put("cobblemon:hydrapple", 9900);
        DEFAULTS.put("cobblemon:hydreigon", 13500);
        DEFAULTS.put("cobblemon:hypno", 5500);
        DEFAULTS.put("cobblemon:igglybuff", 4700);
        DEFAULTS.put("cobblemon:illumise", 14500);
        DEFAULTS.put("cobblemon:impidimp", 15900);
        DEFAULTS.put("cobblemon:incineroar", 13400);
        DEFAULTS.put("cobblemon:indeedee", 6100);
        DEFAULTS.put("cobblemon:infernape", 21200);
        DEFAULTS.put("cobblemon:inkay", 20100);
        DEFAULTS.put("cobblemon:inteleon", 9600);
        DEFAULTS.put("cobblemon:ironboulder", 12300);
        DEFAULTS.put("cobblemon:ironbundle", 10100);
        DEFAULTS.put("cobblemon:ironcrown", 19000);
        DEFAULTS.put("cobblemon:ironhands", 6100);
        DEFAULTS.put("cobblemon:ironjugulis", 17800);
        DEFAULTS.put("cobblemon:ironleaves", 24800);
        DEFAULTS.put("cobblemon:ironmoth", 9700);
        DEFAULTS.put("cobblemon:ironthorns", 16500);
        DEFAULTS.put("cobblemon:irontreads", 10300);
        DEFAULTS.put("cobblemon:ironvaliant", 12400);
        DEFAULTS.put("cobblemon:ivysaur", 12100);
        DEFAULTS.put("cobblemon:jangmoo", 17800);
        DEFAULTS.put("cobblemon:jellicent", 8400);
        DEFAULTS.put("cobblemon:jigglypuff", 17400);
        DEFAULTS.put("cobblemon:jirachi", 14500);
        DEFAULTS.put("cobblemon:jolteon", 6300);
        DEFAULTS.put("cobblemon:joltik", 5100);
        DEFAULTS.put("cobblemon:jumpluff", 16200);
        DEFAULTS.put("cobblemon:jynx", 13500);
        DEFAULTS.put("cobblemon:kabuto", 9700);
        DEFAULTS.put("cobblemon:kabutops", 22300);
        DEFAULTS.put("cobblemon:kadabra", 15400);
        DEFAULTS.put("cobblemon:kakuna", 11400);
        DEFAULTS.put("cobblemon:kangaskhan", 6000);
        DEFAULTS.put("cobblemon:karrablast", 9000);
        DEFAULTS.put("cobblemon:kartana", 3700);
        DEFAULTS.put("cobblemon:kecleon", 10200);
        DEFAULTS.put("cobblemon:keldeo", 16900);
        DEFAULTS.put("cobblemon:kilowattrel", 12800);
        DEFAULTS.put("cobblemon:kingambit", 11300);
        DEFAULTS.put("cobblemon:kingdra", 13700);
        DEFAULTS.put("cobblemon:kingler", 16300);
        DEFAULTS.put("cobblemon:kirlia", 11300);
        DEFAULTS.put("cobblemon:klang", 9900);
        DEFAULTS.put("cobblemon:klang", 9900);
        DEFAULTS.put("cobblemon:klawf", 15300);
        DEFAULTS.put("cobblemon:kleavor", 10100);
        DEFAULTS.put("cobblemon:klefki", 14600);
        DEFAULTS.put("cobblemon:klink", 13300);
        DEFAULTS.put("cobblemon:klinklang", 15500);
        DEFAULTS.put("cobblemon:koffing", 8900);
        DEFAULTS.put("cobblemon:komala", 4100);
        DEFAULTS.put("cobblemon:kommoo", 20000);
        DEFAULTS.put("cobblemon:koraidon", 18600);
        DEFAULTS.put("cobblemon:krabby", 22500);
        DEFAULTS.put("cobblemon:kricketot", 6600);
        DEFAULTS.put("cobblemon:kricketune", 17900);
        DEFAULTS.put("cobblemon:krokorok", 12400);
        DEFAULTS.put("cobblemon:krookodile", 21800);
        DEFAULTS.put("cobblemon:kubfu", 7600);
        DEFAULTS.put("cobblemon:kyogre", 20400);
        DEFAULTS.put("cobblemon:kyurem", 28400);
        DEFAULTS.put("cobblemon:lairon", 16000);
        DEFAULTS.put("cobblemon:lampent", 20700);
        DEFAULTS.put("cobblemon:landorus", 19000);
        DEFAULTS.put("cobblemon:lanturn", 12000);
        DEFAULTS.put("cobblemon:lapras", 6000);
        DEFAULTS.put("cobblemon:larvesta", 13900);
        DEFAULTS.put("cobblemon:larvitar", 4900);
        DEFAULTS.put("cobblemon:latias", 18500);
        DEFAULTS.put("cobblemon:latios", 12600);
        DEFAULTS.put("cobblemon:leafeon", 11800);
        DEFAULTS.put("cobblemon:leavanny", 12800);
        DEFAULTS.put("cobblemon:lechonk", 5600);
        DEFAULTS.put("cobblemon:ledian", 6000);
        DEFAULTS.put("cobblemon:ledyba", 2500);
        DEFAULTS.put("cobblemon:lickilicky", 4400);
        DEFAULTS.put("cobblemon:lickitung", 5000);
        DEFAULTS.put("cobblemon:liepard", 5400);
        DEFAULTS.put("cobblemon:lileep", 3900);
        DEFAULTS.put("cobblemon:lilligant", 13500);
        DEFAULTS.put("cobblemon:lillipup", 9500);
        DEFAULTS.put("cobblemon:linoone", 12000);
        DEFAULTS.put("cobblemon:litleo", 5500);
        DEFAULTS.put("cobblemon:litten", 6000);
        DEFAULTS.put("cobblemon:litwick", 6400);
        DEFAULTS.put("cobblemon:lokix", 4900);
        DEFAULTS.put("cobblemon:lombre", 5800);
        DEFAULTS.put("cobblemon:lopunny", 12300);
        DEFAULTS.put("cobblemon:lotad", 7800);
        DEFAULTS.put("cobblemon:loudred", 7900);
        DEFAULTS.put("cobblemon:lucario", 18400);
        DEFAULTS.put("cobblemon:ludicolo", 14400);
        DEFAULTS.put("cobblemon:lugia", 12000);
        DEFAULTS.put("cobblemon:lumineon", 16600);
        DEFAULTS.put("cobblemon:lunala", 10200);
        DEFAULTS.put("cobblemon:lunatone", 5000);
        DEFAULTS.put("cobblemon:lurantis", 6800);
        DEFAULTS.put("cobblemon:luvdisc", 9000);
        DEFAULTS.put("cobblemon:luxio", 6800);
        DEFAULTS.put("cobblemon:luxray", 20900);
        DEFAULTS.put("cobblemon:lycanroc", 6200);
        DEFAULTS.put("cobblemon:mabosstiff", 4700);
        DEFAULTS.put("cobblemon:machamp", 11500);
        DEFAULTS.put("cobblemon:machoke", 7600);
        DEFAULTS.put("cobblemon:machop", 5000);
        DEFAULTS.put("cobblemon:magby", 15500);
        DEFAULTS.put("cobblemon:magcargo", 5500);
        DEFAULTS.put("cobblemon:magearna", 24300);
        DEFAULTS.put("cobblemon:magikarp", 4600);
        DEFAULTS.put("cobblemon:magmar", 7000);
        DEFAULTS.put("cobblemon:magmortar", 10300);
        DEFAULTS.put("cobblemon:magnemite", 3500);
        DEFAULTS.put("cobblemon:magneton", 4500);
        DEFAULTS.put("cobblemon:magnezone", 5300);
        DEFAULTS.put("cobblemon:makuhita", 3000);
        DEFAULTS.put("cobblemon:malamar", 11400);
        DEFAULTS.put("cobblemon:mamoswine", 7100);
        DEFAULTS.put("cobblemon:manaphy", 27100);
        DEFAULTS.put("cobblemon:mandibuzz", 3500);
        DEFAULTS.put("cobblemon:manectric", 7000);
        DEFAULTS.put("cobblemon:mankey", 3000);
        DEFAULTS.put("cobblemon:mantine", 5000);
        DEFAULTS.put("cobblemon:mantyke", 12800);
        DEFAULTS.put("cobblemon:maractus", 10000);
        DEFAULTS.put("cobblemon:mareanie", 17300);
        DEFAULTS.put("cobblemon:mareep", 7000);
        DEFAULTS.put("cobblemon:marill", 7800);
        DEFAULTS.put("cobblemon:marowak", 6500);
        DEFAULTS.put("cobblemon:marshadow", 13300);
        DEFAULTS.put("cobblemon:marshtomp", 3800);
        DEFAULTS.put("cobblemon:maschiff", 24500);
        DEFAULTS.put("cobblemon:masquerain", 11800);
        DEFAULTS.put("cobblemon:maushold", 8000);
        DEFAULTS.put("cobblemon:mawile", 2500);
        DEFAULTS.put("cobblemon:medicham", 17600);
        DEFAULTS.put("cobblemon:meditite", 5000);
        DEFAULTS.put("cobblemon:meganium", 9000);
        DEFAULTS.put("cobblemon:melmetal", 29500);
        DEFAULTS.put("cobblemon:meloetta", 13000);
        DEFAULTS.put("cobblemon:meltan", 21100);
        DEFAULTS.put("cobblemon:meowscarada", 7700);
        DEFAULTS.put("cobblemon:meowstic", 13200);
        DEFAULTS.put("cobblemon:meowth", 3500);
        DEFAULTS.put("cobblemon:mesprit", 16300);
        DEFAULTS.put("cobblemon:metagross", 15000);
        DEFAULTS.put("cobblemon:metang", 12700);
        DEFAULTS.put("cobblemon:metapod", 13600);
        DEFAULTS.put("cobblemon:mew", 14800);
        DEFAULTS.put("cobblemon:mewtwo", 21400);
        DEFAULTS.put("cobblemon:mienfoo", 8800);
        DEFAULTS.put("cobblemon:mienshao", 20700);
        DEFAULTS.put("cobblemon:mightyena", 10300);
        DEFAULTS.put("cobblemon:milcery", 15500);
        DEFAULTS.put("cobblemon:milotic", 15300);
        DEFAULTS.put("cobblemon:miltank", 7000);
        DEFAULTS.put("cobblemon:mimejr", 14200);
        DEFAULTS.put("cobblemon:mimikyu", 8100);
        DEFAULTS.put("cobblemon:minccino", 11200);
        DEFAULTS.put("cobblemon:minior", 9300);
        DEFAULTS.put("cobblemon:minun", 17800);
        DEFAULTS.put("cobblemon:miraidon", 16900);
        DEFAULTS.put("cobblemon:misdreavus", 4000);
        DEFAULTS.put("cobblemon:mismagius", 10000);
        DEFAULTS.put("cobblemon:moltres", 10000);
        DEFAULTS.put("cobblemon:monferno", 13400);
        DEFAULTS.put("cobblemon:morelull", 7900);
        DEFAULTS.put("cobblemon:morgrem", 11500);
        DEFAULTS.put("cobblemon:morpeko", 13100);
        DEFAULTS.put("cobblemon:mothim", 10300);
        DEFAULTS.put("cobblemon:mrmime", 6500);
        DEFAULTS.put("cobblemon:mrrime", 10200);
        DEFAULTS.put("cobblemon:mudbray", 5500);
        DEFAULTS.put("cobblemon:mudkip", 7200);
        DEFAULTS.put("cobblemon:mudsdale", 17400);
        DEFAULTS.put("cobblemon:muk", 7800);
        DEFAULTS.put("cobblemon:munchlax", 12400);
        DEFAULTS.put("cobblemon:munkidori", 20200);
        DEFAULTS.put("cobblemon:munna", 10600);
        DEFAULTS.put("cobblemon:murkrow", 6000);
        DEFAULTS.put("cobblemon:musharna", 16300);
        DEFAULTS.put("cobblemon:nacli", 5800);
        DEFAULTS.put("cobblemon:naclstack", 6200);
        DEFAULTS.put("cobblemon:naganadel", 10800);
        DEFAULTS.put("cobblemon:natu", 2500);
        DEFAULTS.put("cobblemon:necrozma", 19100);
        DEFAULTS.put("cobblemon:nickit", 3700);
        DEFAULTS.put("cobblemon:nidoking", 6100);
        DEFAULTS.put("cobblemon:nidoqueen", 7300);
        DEFAULTS.put("cobblemon:nidoranf", 3500);
        DEFAULTS.put("cobblemon:nidoranm", 16800);
        DEFAULTS.put("cobblemon:nidorina", 10400);
        DEFAULTS.put("cobblemon:nidorino", 11300);
        DEFAULTS.put("cobblemon:nihilego", 19500);
        DEFAULTS.put("cobblemon:nincada", 19200);
        DEFAULTS.put("cobblemon:ninetales", 9500);
        DEFAULTS.put("cobblemon:ninjask", 20300);
        DEFAULTS.put("cobblemon:noctowl", 3000);
        DEFAULTS.put("cobblemon:noibat", 17700);
        DEFAULTS.put("cobblemon:noivern", 5300);
        DEFAULTS.put("cobblemon:nosepass", 4000);
        DEFAULTS.put("cobblemon:numel", 1500);
        DEFAULTS.put("cobblemon:nuzleaf", 6000);
        DEFAULTS.put("cobblemon:nymble", 15900);
        DEFAULTS.put("cobblemon:obstagoon", 17800);
        DEFAULTS.put("cobblemon:octillery", 16500);
        DEFAULTS.put("cobblemon:oddish", 18100);
        DEFAULTS.put("cobblemon:ogerpon", 8200);
        DEFAULTS.put("cobblemon:oinkologne", 17500);
        DEFAULTS.put("cobblemon:okidogi", 9300);
        DEFAULTS.put("cobblemon:omanyte", 12700);
        DEFAULTS.put("cobblemon:omastar", 21900);
        DEFAULTS.put("cobblemon:onix", 7300);
        DEFAULTS.put("cobblemon:oranguru", 12200);
        DEFAULTS.put("cobblemon:orbeetle", 17800);
        DEFAULTS.put("cobblemon:oricorio", 3200);
        DEFAULTS.put("cobblemon:orthworm", 5700);
        DEFAULTS.put("cobblemon:oshawott", 14800);
        DEFAULTS.put("cobblemon:overqwil", 12500);
        DEFAULTS.put("cobblemon:pachirisu", 7100);
        DEFAULTS.put("cobblemon:palafin", 14800);
        DEFAULTS.put("cobblemon:palkia", 25900);
        DEFAULTS.put("cobblemon:palossand", 6500);
        DEFAULTS.put("cobblemon:palpitoad", 10800);
        DEFAULTS.put("cobblemon:pancham", 5400);
        DEFAULTS.put("cobblemon:pangoro", 14100);
        DEFAULTS.put("cobblemon:panpour", 15800);
        DEFAULTS.put("cobblemon:pansage", 6800);
        DEFAULTS.put("cobblemon:pansear", 10200);
        DEFAULTS.put("cobblemon:paras", 4000);
        DEFAULTS.put("cobblemon:parasect", 4300);
        DEFAULTS.put("cobblemon:passimian", 16400);
        DEFAULTS.put("cobblemon:patrat", 13200);
        DEFAULTS.put("cobblemon:pawmi", 3400);
        DEFAULTS.put("cobblemon:pawmo", 16400);
        DEFAULTS.put("cobblemon:pawmot", 5500);
        DEFAULTS.put("cobblemon:pawniard", 22000);
        DEFAULTS.put("cobblemon:pecharunt", 16700);
        DEFAULTS.put("cobblemon:pelipper", 21100);
        DEFAULTS.put("cobblemon:perrserker", 7900);
        DEFAULTS.put("cobblemon:persian", 15700);
        DEFAULTS.put("cobblemon:petilil", 8500);
        DEFAULTS.put("cobblemon:phanpy", 14100);
        DEFAULTS.put("cobblemon:phanpy", 14100);
        DEFAULTS.put("cobblemon:phantump", 14300);
        DEFAULTS.put("cobblemon:pheromosa", 17900);
        DEFAULTS.put("cobblemon:phione", 12700);
        DEFAULTS.put("cobblemon:pichu", 9700);
        DEFAULTS.put("cobblemon:pidgeot", 14100);
        DEFAULTS.put("cobblemon:pidgeotto", 4000);
        DEFAULTS.put("cobblemon:pidgey", 16000);
        DEFAULTS.put("cobblemon:pidove", 15900);
        DEFAULTS.put("cobblemon:pignite", 18400);
        DEFAULTS.put("cobblemon:pikachu", 9400);
        DEFAULTS.put("cobblemon:pikipek", 11800);
        DEFAULTS.put("cobblemon:piloswine", 6000);
        DEFAULTS.put("cobblemon:pincurchin", 7500);
        DEFAULTS.put("cobblemon:pineco", 2500);
        DEFAULTS.put("cobblemon:pinsir", 7000);
        DEFAULTS.put("cobblemon:piplup", 19800);
        DEFAULTS.put("cobblemon:plusle", 17900);
        DEFAULTS.put("cobblemon:poipole", 6100);
        DEFAULTS.put("cobblemon:politoed", 4100);
        DEFAULTS.put("cobblemon:poliwag", 5100);
        DEFAULTS.put("cobblemon:poliwhirl", 15000);
        DEFAULTS.put("cobblemon:poliwrath", 7500);
        DEFAULTS.put("cobblemon:poltchageist", 7400);
        DEFAULTS.put("cobblemon:polteageist", 10500);
        DEFAULTS.put("cobblemon:ponyta", 18300);
        DEFAULTS.put("cobblemon:poochyena", 2500);
        DEFAULTS.put("cobblemon:popplio", 13400);
        DEFAULTS.put("cobblemon:porygon", 13100);
        DEFAULTS.put("cobblemon:porygon2", 9200);
        DEFAULTS.put("cobblemon:porygonz", 11900);
        DEFAULTS.put("cobblemon:primarina", 15000);
        DEFAULTS.put("cobblemon:primeape", 6000);
        DEFAULTS.put("cobblemon:prinplup", 5200);
        DEFAULTS.put("cobblemon:probopass", 20300);
        DEFAULTS.put("cobblemon:psyduck", 16700);
        DEFAULTS.put("cobblemon:pumpkaboo", 8700);
        DEFAULTS.put("cobblemon:pupitar", 10500);
        DEFAULTS.put("cobblemon:purrloin", 14900);
        DEFAULTS.put("cobblemon:purugly", 13700);
        DEFAULTS.put("cobblemon:pyroar", 16600);
        DEFAULTS.put("cobblemon:pyukumuku", 20500);
        DEFAULTS.put("cobblemon:quagsire", 4000);
        DEFAULTS.put("cobblemon:quaquaval", 10700);
        DEFAULTS.put("cobblemon:quaxly", 8500);
        DEFAULTS.put("cobblemon:quaxwell", 10800);
        DEFAULTS.put("cobblemon:quilava", 3000);
        DEFAULTS.put("cobblemon:quilladin", 13600);
        DEFAULTS.put("cobblemon:qwilfish", 5000);
        DEFAULTS.put("cobblemon:raboot", 8300);
        DEFAULTS.put("cobblemon:rabsca", 17000);
        DEFAULTS.put("cobblemon:ragingbolt", 22000);
        DEFAULTS.put("cobblemon:raichu", 16400);
        DEFAULTS.put("cobblemon:raikou", 13000);
        DEFAULTS.put("cobblemon:ralts", 2200);
        DEFAULTS.put("cobblemon:rampardos", 14100);
        DEFAULTS.put("cobblemon:rapidash", 6000);
        DEFAULTS.put("cobblemon:raticate", 6000);
        DEFAULTS.put("cobblemon:rattata", 10000);
        DEFAULTS.put("cobblemon:rayquaza", 11300);
        DEFAULTS.put("cobblemon:regice", 17400);
        DEFAULTS.put("cobblemon:regidrago", 18700);
        DEFAULTS.put("cobblemon:regieleki", 12000);
        DEFAULTS.put("cobblemon:regigigas", 11900);
        DEFAULTS.put("cobblemon:regirock", 13700);
        DEFAULTS.put("cobblemon:registeel", 21200);
        DEFAULTS.put("cobblemon:relicanth", 12600);
        DEFAULTS.put("cobblemon:rellor", 9100);
        DEFAULTS.put("cobblemon:remoraid", 4000);
        DEFAULTS.put("cobblemon:reshiram", 14800);
        DEFAULTS.put("cobblemon:reuniclus", 7800);
        DEFAULTS.put("cobblemon:revavroom", 15200);
        DEFAULTS.put("cobblemon:rhydon", 7000);
        DEFAULTS.put("cobblemon:rhyhorn", 4200);
        DEFAULTS.put("cobblemon:rhyperior", 7400);
        DEFAULTS.put("cobblemon:ribombee", 15000);
        DEFAULTS.put("cobblemon:rillaboom", 12000);
        DEFAULTS.put("cobblemon:riolu", 8900);
        DEFAULTS.put("cobblemon:roaringmoon", 20900);
        DEFAULTS.put("cobblemon:rockruff", 17700);
        DEFAULTS.put("cobblemon:roggenrola", 21500);
        DEFAULTS.put("cobblemon:rolycoly", 12000);
        DEFAULTS.put("cobblemon:rookidee", 21100);
        DEFAULTS.put("cobblemon:roselia", 3000);
        DEFAULTS.put("cobblemon:roserade", 16700);
        DEFAULTS.put("cobblemon:rotom", 2900);
        DEFAULTS.put("cobblemon:rowlet", 9200);
        DEFAULTS.put("cobblemon:rufflet", 10200);
        DEFAULTS.put("cobblemon:runerigus", 11400);
        DEFAULTS.put("cobblemon:sableye", 7000);
        DEFAULTS.put("cobblemon:salamence", 9000);
        DEFAULTS.put("cobblemon:salandit", 4400);
        DEFAULTS.put("cobblemon:salazzle", 5700);
        DEFAULTS.put("cobblemon:samurott", 16100);
        DEFAULTS.put("cobblemon:sandaconda", 5600);
        DEFAULTS.put("cobblemon:sandile", 7200);
        DEFAULTS.put("cobblemon:sandshrew", 7600);
        DEFAULTS.put("cobblemon:sandslash", 7500);
        DEFAULTS.put("cobblemon:sandygast", 15000);
        DEFAULTS.put("cobblemon:sandyshocks", 15200);
        DEFAULTS.put("cobblemon:sawk", 6400);
        DEFAULTS.put("cobblemon:sawsbuck", 7100);
        DEFAULTS.put("cobblemon:scatterbug", 20200);
        DEFAULTS.put("cobblemon:sceptile", 11200);
        DEFAULTS.put("cobblemon:scizor", 10000);
        DEFAULTS.put("cobblemon:scolipede", 10100);
        DEFAULTS.put("cobblemon:scorbunny", 12700);
        DEFAULTS.put("cobblemon:scovillain", 11100);
        DEFAULTS.put("cobblemon:scrafty", 18900);
        DEFAULTS.put("cobblemon:scraggy", 5700);
        DEFAULTS.put("cobblemon:screamtail", 12800);
        DEFAULTS.put("cobblemon:scyther", 8000);
        DEFAULTS.put("cobblemon:seadra", 12500);
        DEFAULTS.put("cobblemon:seaking", 12900);
        DEFAULTS.put("cobblemon:sealeo", 13500);
        DEFAULTS.put("cobblemon:seedot", 1500);
        DEFAULTS.put("cobblemon:seel", 3500);
        DEFAULTS.put("cobblemon:seismitoad", 5500);
        DEFAULTS.put("cobblemon:sentret", 5300);
        DEFAULTS.put("cobblemon:serperior", 20400);
        DEFAULTS.put("cobblemon:servine", 7800);
        DEFAULTS.put("cobblemon:seviper", 15500);
        DEFAULTS.put("cobblemon:sewaddle", 6100);
        DEFAULTS.put("cobblemon:sharpedo", 13000);
        DEFAULTS.put("cobblemon:shaymin", 25100);
        DEFAULTS.put("cobblemon:shedinja", 2700);
        DEFAULTS.put("cobblemon:shelgon", 16100);
        DEFAULTS.put("cobblemon:shellder", 4000);
        DEFAULTS.put("cobblemon:shellos", 20600);
        DEFAULTS.put("cobblemon:shelmet", 4000);
        DEFAULTS.put("cobblemon:shieldon", 17900);
        DEFAULTS.put("cobblemon:shiftry", 18700);
        DEFAULTS.put("cobblemon:shiinotic", 9000);
        DEFAULTS.put("cobblemon:shinx", 9900);
        DEFAULTS.put("cobblemon:shroodle", 21700);
        DEFAULTS.put("cobblemon:shroomish", 1800);
        DEFAULTS.put("cobblemon:shuckle", 7000);
        DEFAULTS.put("cobblemon:shuppet", 5500);
        DEFAULTS.put("cobblemon:sigilyph", 10100);
        DEFAULTS.put("cobblemon:silcoon", 16200);
        DEFAULTS.put("cobblemon:silicobra", 3200);
        DEFAULTS.put("cobblemon:silvally", 6900);
        DEFAULTS.put("cobblemon:simipour", 20400);
        DEFAULTS.put("cobblemon:simisage", 15600);
        DEFAULTS.put("cobblemon:simisear", 9900);
        DEFAULTS.put("cobblemon:sinistcha", 14900);
        DEFAULTS.put("cobblemon:sinistea", 16600);
        DEFAULTS.put("cobblemon:sirfetchd", 22400);
        DEFAULTS.put("cobblemon:sizzlipede", 14900);
        DEFAULTS.put("cobblemon:skarmory", 13000);
        DEFAULTS.put("cobblemon:skeledirge", 4800);
        DEFAULTS.put("cobblemon:skiddo", 4700);
        DEFAULTS.put("cobblemon:skiploom", 3000);
        DEFAULTS.put("cobblemon:skitty", 21800);
        DEFAULTS.put("cobblemon:skorupi", 4800);
        DEFAULTS.put("cobblemon:skrelp", 23600);
        DEFAULTS.put("cobblemon:skuntank", 18500);
        DEFAULTS.put("cobblemon:skwovet", 8100);
        DEFAULTS.put("cobblemon:slaking", 15600);
        DEFAULTS.put("cobblemon:slakoth", 13600);
        DEFAULTS.put("cobblemon:sliggoo", 8800);
        DEFAULTS.put("cobblemon:slitherwing", 11500);
        DEFAULTS.put("cobblemon:slowbro", 10500);
        DEFAULTS.put("cobblemon:slowking", 15100);
        DEFAULTS.put("cobblemon:slowpoke", 18400);
        DEFAULTS.put("cobblemon:slugma", 4000);
        DEFAULTS.put("cobblemon:slurpuff", 10500);
        DEFAULTS.put("cobblemon:smeargle", 7000);
        DEFAULTS.put("cobblemon:smoliv", 11000);
        DEFAULTS.put("cobblemon:smoochum", 8900);
        DEFAULTS.put("cobblemon:sneasel", 6000);
        DEFAULTS.put("cobblemon:sneasler", 6600);
        DEFAULTS.put("cobblemon:snivy", 11300);
        DEFAULTS.put("cobblemon:snom", 12100);
        DEFAULTS.put("cobblemon:snorlax", 9000);
        DEFAULTS.put("cobblemon:snorunt", 2500);
        DEFAULTS.put("cobblemon:snover", 4800);
        DEFAULTS.put("cobblemon:snubbull", 23000);
        DEFAULTS.put("cobblemon:sobble", 19000);
        DEFAULTS.put("cobblemon:solgaleo", 20600);
        DEFAULTS.put("cobblemon:solosis", 21400);
        DEFAULTS.put("cobblemon:solrock", 7500);
        DEFAULTS.put("cobblemon:spearow", 4500);
        DEFAULTS.put("cobblemon:spectrier", 4800);
        DEFAULTS.put("cobblemon:spewpa", 12500);
        DEFAULTS.put("cobblemon:spheal", 1500);
        DEFAULTS.put("cobblemon:spidops", 10500);
        DEFAULTS.put("cobblemon:spinarak", 1500);
        DEFAULTS.put("cobblemon:spinda", 10100);
        DEFAULTS.put("cobblemon:spiritomb", 5500);
        DEFAULTS.put("cobblemon:spoink", 7900);
        DEFAULTS.put("cobblemon:sprigatito", 9000);
        DEFAULTS.put("cobblemon:spritzee", 11900);
        DEFAULTS.put("cobblemon:squawkabilly", 5400);
        DEFAULTS.put("cobblemon:squirtle", 20700);
        DEFAULTS.put("cobblemon:stakataka", 10300);
        DEFAULTS.put("cobblemon:stantler", 6000);
        DEFAULTS.put("cobblemon:staraptor", 7800);
        DEFAULTS.put("cobblemon:staravia", 18700);
        DEFAULTS.put("cobblemon:starly", 12000);
        DEFAULTS.put("cobblemon:starmie", 7500);
        DEFAULTS.put("cobblemon:staryu", 11500);
        DEFAULTS.put("cobblemon:steelix", 11900);
        DEFAULTS.put("cobblemon:steenee", 5800);
        DEFAULTS.put("cobblemon:stonjourner", 23000);
        DEFAULTS.put("cobblemon:stoutland", 3400);
        DEFAULTS.put("cobblemon:stufful", 3000);
        DEFAULTS.put("cobblemon:stunfisk", 16800);
        DEFAULTS.put("cobblemon:stunky", 6200);
        DEFAULTS.put("cobblemon:sudowoodo", 10000);
        DEFAULTS.put("cobblemon:suicune", 13000);
        DEFAULTS.put("cobblemon:sunflora", 7000);
        DEFAULTS.put("cobblemon:sunkern", 10600);
        DEFAULTS.put("cobblemon:surskit", 18100);
        DEFAULTS.put("cobblemon:swablu", 5000);
        DEFAULTS.put("cobblemon:swadloon", 22600);
        DEFAULTS.put("cobblemon:swalot", 4600);
        DEFAULTS.put("cobblemon:swampert", 10100);
        DEFAULTS.put("cobblemon:swanna", 5100);
        DEFAULTS.put("cobblemon:swellow", 7000);
        DEFAULTS.put("cobblemon:swinub", 2500);
        DEFAULTS.put("cobblemon:swirlix", 7900);
        DEFAULTS.put("cobblemon:swoobat", 10200);
        DEFAULTS.put("cobblemon:sylveon", 13100);
        DEFAULTS.put("cobblemon:tadbulb", 13400);
        DEFAULTS.put("cobblemon:taillow", 5900);
        DEFAULTS.put("cobblemon:talonflame", 10200);
        DEFAULTS.put("cobblemon:tandemaus", 9600);
        DEFAULTS.put("cobblemon:tangela", 4000);
        DEFAULTS.put("cobblemon:tangrowth", 8100);
        DEFAULTS.put("cobblemon:tapubulu", 4600);
        DEFAULTS.put("cobblemon:tapufini", 20700);
        DEFAULTS.put("cobblemon:tapukoko", 8900);
        DEFAULTS.put("cobblemon:tapulele", 6100);
        DEFAULTS.put("cobblemon:tarountula", 10400);
        DEFAULTS.put("cobblemon:tatsugiri", 12400);
        DEFAULTS.put("cobblemon:tauros", 9000);
        DEFAULTS.put("cobblemon:teddiursa", 3000);
        DEFAULTS.put("cobblemon:tentacool", 15600);
        DEFAULTS.put("cobblemon:tentacruel", 7200);
        DEFAULTS.put("cobblemon:tepig", 6300);
        DEFAULTS.put("cobblemon:terapagos", 19200);
        DEFAULTS.put("cobblemon:terrakion", 28600);
        DEFAULTS.put("cobblemon:thievul", 14600);
        DEFAULTS.put("cobblemon:throh", 4800);
        DEFAULTS.put("cobblemon:thundurus", 17700);
        DEFAULTS.put("cobblemon:thwackey", 11800);
        DEFAULTS.put("cobblemon:timburr", 6100);
        DEFAULTS.put("cobblemon:tinglu", 5500);
        DEFAULTS.put("cobblemon:tinkatink", 10800);
        DEFAULTS.put("cobblemon:tinkaton", 6600);
        DEFAULTS.put("cobblemon:tinkatuff", 16900);
        DEFAULTS.put("cobblemon:tirtouga", 5400);
        DEFAULTS.put("cobblemon:toedscool", 15900);
        DEFAULTS.put("cobblemon:toedscruel", 13200);
        DEFAULTS.put("cobblemon:togedemaru", 19500);
        DEFAULTS.put("cobblemon:togekiss", 2500);
        DEFAULTS.put("cobblemon:togepi", 7000);
        DEFAULTS.put("cobblemon:togetic", 5000);
        DEFAULTS.put("cobblemon:torchic", 15500);
        DEFAULTS.put("cobblemon:torkoal", 17300);
        DEFAULTS.put("cobblemon:tornadus", 13500);
        DEFAULTS.put("cobblemon:torracat", 8500);
        DEFAULTS.put("cobblemon:torterra", 7200);
        DEFAULTS.put("cobblemon:totodile", 18900);
        DEFAULTS.put("cobblemon:toucannon", 10500);
        DEFAULTS.put("cobblemon:toxapex", 4500);
        DEFAULTS.put("cobblemon:toxel", 3200);
        DEFAULTS.put("cobblemon:toxicroak", 16000);
        DEFAULTS.put("cobblemon:toxtricity", 13700);
        DEFAULTS.put("cobblemon:tranquill", 17400);
        DEFAULTS.put("cobblemon:trapinch", 12300);
        DEFAULTS.put("cobblemon:treecko", 16400);
        DEFAULTS.put("cobblemon:trevenant", 9700);
        DEFAULTS.put("cobblemon:tropius", 7000);
        DEFAULTS.put("cobblemon:trubbish", 14200);
        DEFAULTS.put("cobblemon:trumbeak", 12300);
        DEFAULTS.put("cobblemon:tsareena", 13900);
        DEFAULTS.put("cobblemon:turtonator", 8500);
        DEFAULTS.put("cobblemon:turtwig", 11500);
        DEFAULTS.put("cobblemon:tympole", 12500);
        DEFAULTS.put("cobblemon:tynamo", 21300);
        DEFAULTS.put("cobblemon:typenull", 6100);
        DEFAULTS.put("cobblemon:typhlosion", 5300);
        DEFAULTS.put("cobblemon:tyranitar", 20000);
        DEFAULTS.put("cobblemon:tyrantrum", 12500);
        DEFAULTS.put("cobblemon:tyrogue", 13700);
        DEFAULTS.put("cobblemon:tyrunt", 7100);
        DEFAULTS.put("cobblemon:umbreon", 11900);
        DEFAULTS.put("cobblemon:unfezant", 9000);
        DEFAULTS.put("cobblemon:unown", 10700);
        DEFAULTS.put("cobblemon:ursaluna", 4300);
        DEFAULTS.put("cobblemon:ursaring", 7000);
        DEFAULTS.put("cobblemon:urshifu", 8400);
        DEFAULTS.put("cobblemon:uxie", 4100);
        DEFAULTS.put("cobblemon:vanillish", 6300);
        DEFAULTS.put("cobblemon:vanillite", 14100);
        DEFAULTS.put("cobblemon:vanilluxe", 14900);
        DEFAULTS.put("cobblemon:vaporeon", 6000);
        DEFAULTS.put("cobblemon:varoom", 10000);
        DEFAULTS.put("cobblemon:veluza", 14800);
        DEFAULTS.put("cobblemon:venipede", 8500);
        DEFAULTS.put("cobblemon:venomoth", 4000);
        DEFAULTS.put("cobblemon:venonat", 7400);
        DEFAULTS.put("cobblemon:venusaur", 20000);
        DEFAULTS.put("cobblemon:vespiquen", 7700);
        DEFAULTS.put("cobblemon:vibrava", 6000);
        DEFAULTS.put("cobblemon:victini", 18800);
        DEFAULTS.put("cobblemon:victreebel", 12900);
        DEFAULTS.put("cobblemon:vigoroth", 7700);
        DEFAULTS.put("cobblemon:vikavolt", 16700);
        DEFAULTS.put("cobblemon:vileplume", 6700);
        DEFAULTS.put("cobblemon:virizion", 15300);
        DEFAULTS.put("cobblemon:vivillon", 6400);
        DEFAULTS.put("cobblemon:volbeat", 4400);
        DEFAULTS.put("cobblemon:volcanion", 18900);
        DEFAULTS.put("cobblemon:volcarona", 12000);
        DEFAULTS.put("cobblemon:voltorb", 2500);
        DEFAULTS.put("cobblemon:vullaby", 7200);
        DEFAULTS.put("cobblemon:vulpix", 2000);
        DEFAULTS.put("cobblemon:wailmer", 16000);
        DEFAULTS.put("cobblemon:wailord", 18700);
        DEFAULTS.put("cobblemon:walkingwake", 9200);
        DEFAULTS.put("cobblemon:walrein", 5800);
        DEFAULTS.put("cobblemon:wartortle", 7400);
        DEFAULTS.put("cobblemon:watchog", 3300);
        DEFAULTS.put("cobblemon:wattrel", 17100);
        DEFAULTS.put("cobblemon:weavile", 7600);
        DEFAULTS.put("cobblemon:weedle", 5800);
        DEFAULTS.put("cobblemon:weepinbell", 4000);
        DEFAULTS.put("cobblemon:weezing", 15900);
        DEFAULTS.put("cobblemon:whimsicott", 11900);
        DEFAULTS.put("cobblemon:whirlipede", 17900);
        DEFAULTS.put("cobblemon:whiscash", 9500);
        DEFAULTS.put("cobblemon:whismur", 14300);
        DEFAULTS.put("cobblemon:wigglytuff", 10400);
        DEFAULTS.put("cobblemon:wiglett", 15500);
        DEFAULTS.put("cobblemon:wimpod", 4700);
        DEFAULTS.put("cobblemon:wingull", 16100);
        DEFAULTS.put("cobblemon:wishiwashi", 11100);
        DEFAULTS.put("cobblemon:wobbuffet", 7200);
        DEFAULTS.put("cobblemon:wochien", 4200);
        DEFAULTS.put("cobblemon:woobat", 24000);
        DEFAULTS.put("cobblemon:wooloo", 9800);
        DEFAULTS.put("cobblemon:wooper", 20700);
        DEFAULTS.put("cobblemon:wormadam", 19100);
        DEFAULTS.put("cobblemon:wugtrio", 6500);
        DEFAULTS.put("cobblemon:wurmple", 15600);
        DEFAULTS.put("cobblemon:wynaut", 4500);
        DEFAULTS.put("cobblemon:wyrdeer", 6400);
        DEFAULTS.put("cobblemon:xatu", 9100);
        DEFAULTS.put("cobblemon:xerneas", 12800);
        DEFAULTS.put("cobblemon:xurkitree", 13700);
        DEFAULTS.put("cobblemon:yamask", 15100);
        DEFAULTS.put("cobblemon:yamper", 11600);
        DEFAULTS.put("cobblemon:yanma", 5000);
        DEFAULTS.put("cobblemon:yanmega", 16500);
        DEFAULTS.put("cobblemon:yungoos", 23200);
        DEFAULTS.put("cobblemon:yveltal", 11700);
        DEFAULTS.put("cobblemon:zacian", 13200);
        DEFAULTS.put("cobblemon:zamazenta", 20400);
        DEFAULTS.put("cobblemon:zangoose", 5000);
        DEFAULTS.put("cobblemon:zapdos", 10000);
        DEFAULTS.put("cobblemon:zarude", 26800);
        DEFAULTS.put("cobblemon:zebstrika", 3900);
        DEFAULTS.put("cobblemon:zekrom", 12000);
        DEFAULTS.put("cobblemon:zeraora", 11300);
        DEFAULTS.put("cobblemon:zigzagoon", 4400);
        DEFAULTS.put("cobblemon:zoroark", 20600);
        DEFAULTS.put("cobblemon:zorua", 11500);
        DEFAULTS.put("cobblemon:zubat", 13300);
        DEFAULTS.put("cobblemon:zweilous", 5000);
        DEFAULTS.put("cobblemon:zygarde", 28500);
        loaded = false;
        overrides = new HashMap<String, Integer>();
        globalMax = 30000;
    }
}

