/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.config;

import com.jayemceekay.shadowedhearts.Shadowedhearts;
import com.jayemceekay.shadowedhearts.config.IShadowConfig;
import com.jayemceekay.shadowedhearts.config.IWorldAlterationConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import dev.architectury.platform.Platform;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class ModConfig
implements IShadowConfig {
    private boolean loaded = false;
    public static final ModConfigSpec SPEC;
    private static final Data DATA;

    @Override
    public double shadowSpawnChancePercent() {
        return (Double)ModConfig.DATA.shadowSpawnChancePercent.get();
    }

    @Override
    public List<? extends String> shadowSpawnBlacklist() {
        return (List)ModConfig.DATA.shadowSpawnBlacklist.get();
    }

    @Override
    public boolean hyperModeEnabled() {
        return (Boolean)ModConfig.DATA.hyperMode.enabled.get();
    }

    @Override
    public boolean reverseModeEnabled() {
        return (Boolean)ModConfig.DATA.reverseMode.enabled.get();
    }

    @Override
    public boolean goDamageModifierEnabled() {
        return (Boolean)ModConfig.DATA.goDamageModifier.enabled.get();
    }

    @Override
    public boolean callButtonReducesHeartGauge() {
        return (Boolean)ModConfig.DATA.callButton.reducesHeartGauge.get();
    }

    @Override
    public boolean callButtonAccuracyBoost() {
        return (Boolean)ModConfig.DATA.callButton.accuracyBoost.get();
    }

    @Override
    public boolean callButtonRemoveSleep() {
        return (Boolean)ModConfig.DATA.callButton.removeSleep.get();
    }

    @Override
    public int scentCooldownSeconds() {
        return (Integer)ModConfig.DATA.scent.cooldownSeconds.get();
    }

    @Override
    public boolean expandedScentSystemEnabled() {
        return (Boolean)ModConfig.DATA.scent.expandedSystemEnabled.get();
    }

    @Override
    public boolean superEffectiveShadowMovesEnabled() {
        return (Boolean)ModConfig.DATA.shadowMoves.superEffectiveEnabled.get();
    }

    @Override
    public String shadowMovesReplaceCount() {
        return (String)ModConfig.DATA.shadowMoves.replaceCount.get();
    }

    @Override
    public boolean shadowMovesOnlyShadowRush() {
        return (Boolean)ModConfig.DATA.shadowMoves.onlyShadowRush.get();
    }

    @Override
    public String shadowIVMode() {
        return (String)ModConfig.DATA.shadowStatChanges.ivMode.get();
    }

    @Override
    public int shadowFixedPerfectIVs() {
        return (Integer)ModConfig.DATA.shadowStatChanges.fixedPerfectIVs.get();
    }

    @Override
    public int shadowMaxPerfectIVs() {
        return (Integer)ModConfig.DATA.shadowStatChanges.maxPerfectIVs.get();
    }

    @Override
    public boolean shadowCatchRateScaleEnabled() {
        return (Boolean)ModConfig.DATA.shadowStatChanges.catchRateScaleEnabled.get();
    }

    @Override
    public double shadowCatchRateMinMultiplier() {
        return (Double)ModConfig.DATA.shadowStatChanges.catchRateMinMultiplier.get();
    }

    @Override
    public double shadowCatchRateExponent() {
        return (Double)ModConfig.DATA.shadowStatChanges.catchRateExponent.get();
    }

    @Override
    public boolean rctIntegrationEnabled() {
        return (Boolean)ModConfig.DATA.rctIntegration.enabled.get();
    }

    @Override
    public int relicStoneCooldownMinutes() {
        return (Integer)ModConfig.DATA.relicStone.cooldownMinutes.get();
    }

    @Override
    public int auraScannerShadowRange() {
        return (Integer)ModConfig.DATA.auraScanner.auraScannerShadowRange.get();
    }

    @Override
    public int auraScannerMeteoroidRange() {
        return (Integer)ModConfig.DATA.auraScanner.auraScannerMeteoroidRange.get();
    }

    @Override
    public IShadowConfig.IRCTSection append() {
        return ModConfig.DATA.rctIntegration.append;
    }

    @Override
    public IShadowConfig.IRCTSection convert() {
        return ModConfig.DATA.rctIntegration.convert;
    }

    @Override
    public IShadowConfig.IRCTSection replace() {
        return ModConfig.DATA.rctIntegration.replace;
    }

    @Override
    public IWorldAlterationConfig worldAlteration() {
        return ModConfig.DATA.worldAlteration;
    }

    @Override
    public ModConfigSpec getSpec() {
        return SPEC;
    }

    @Override
    public void load() {
        this.loaded = true;
        Shadowedhearts.LOGGER.info("ModConfig loaded via Forge Config API Port.");
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    public static int resolveReplaceCount(Random rng) {
        IShadowConfig cfg = ShadowedHeartsConfigs.getInstance().getShadowConfig();
        String raw = cfg.shadowMovesReplaceCount();
        return ModConfig.resolveConfigRange(raw, rng, 1);
    }

    private static int resolveConfigRange(String raw, Random rng, int defaultValue) {
        if (raw == null || raw.isBlank()) {
            return defaultValue;
        }
        try {
            String[] parts;
            if (raw.contains("-") && (parts = raw.split("-")).length == 2) {
                int min = Integer.parseInt(parts[0].trim());
                int max = Integer.parseInt(parts[1].trim());
                if (max < min) {
                    int temp = min;
                    min = max;
                    max = temp;
                }
                return min + rng.nextInt(max - min + 1);
            }
            return Integer.parseInt(raw.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static {
        DATA = new Data();
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        DATA.build(builder);
        SPEC = builder.build();
    }

    private static final class Data {
        public ModConfigSpec.DoubleValue shadowSpawnChancePercent;
        public ModConfigSpec.ConfigValue<List<? extends String>> shadowSpawnBlacklist;
        public final HyperModeConfig hyperMode = new HyperModeConfig();
        public final ReverseModeConfig reverseMode = new ReverseModeConfig();
        public final GODamageModifierConfig goDamageModifier = new GODamageModifierConfig();
        public final CallButtonConfig callButton = new CallButtonConfig();
        public final ScentConfig scent = new ScentConfig();
        public final ShadowMovesConfig shadowMoves = new ShadowMovesConfig();
        public final ShadowStatConfig shadowStatChanges = new ShadowStatConfig();
        public final AuraScannerConfig auraScanner = new AuraScannerConfig();
        public final RelicStoneConfig relicStone = new RelicStoneConfig();
        public final RCTIntegrationConfig rctIntegration = new RCTIntegrationConfig();
        public final WorldAlterationConfig worldAlteration = new WorldAlterationConfig();

        private Data() {
        }

        private void build(ModConfigSpec.Builder builder) {
            builder.push("hyperMode");
            this.hyperMode.build(builder);
            builder.pop();
            builder.push("reverseMode");
            this.reverseMode.build(builder);
            builder.pop();
            builder.push("goDamageModifier");
            this.goDamageModifier.build(builder);
            builder.pop();
            builder.push("callButton");
            this.callButton.build(builder);
            builder.pop();
            builder.push("scent");
            this.scent.build(builder);
            builder.pop();
            builder.push("shadowMoves");
            this.shadowMoves.build(builder);
            builder.pop();
            builder.push("shadowStatChanges");
            this.shadowStatChanges.build(builder);
            builder.pop();
            builder.push("auraScanner");
            this.auraScanner.build(builder);
            builder.pop();
            builder.push("relicStone");
            this.relicStone.build(builder);
            builder.pop();
            builder.push("shadowSpawn");
            this.shadowSpawnChancePercent = builder.comment("The percentage chance (0.0-100.0) for a wild Pok\u00e9mon to spawn as a Shadow Pok\u00e9mon.").defineInRange("chancePercent", 0.78125, 0.0, 100.0);
            this.shadowSpawnBlacklist = builder.comment("List of Pok\u00e9mon species or tags that cannot spawn as Shadow Pok\u00e9mon.").defineList("blacklist", List.of("#shadowedhearts:legendaries", "#shadowedhearts:mythical"), o -> o instanceof String);
            builder.pop();
            builder.push("modIntegrations");
            builder.push("rctmod");
            this.rctIntegration.build(builder);
            builder.pop();
            builder.pop();
            builder.push("worldAlteration");
            this.worldAlteration.build(builder);
            builder.pop();
        }
    }

    public static final class HyperModeConfig {
        public ModConfigSpec.BooleanValue enabled;

        private void build(ModConfigSpec.Builder builder) {
            this.enabled = builder.comment("Whether Hyper Mode mechanics are enabled.").define("enabled", true);
        }
    }

    public static final class ReverseModeConfig {
        public ModConfigSpec.BooleanValue enabled;

        private void build(ModConfigSpec.Builder builder) {
            this.enabled = builder.comment("Whether Reverse Mode mechanics are enabled.").define("enabled", true);
        }
    }

    public static final class GODamageModifierConfig {
        public ModConfigSpec.BooleanValue enabled;

        private void build(ModConfigSpec.Builder builder) {
            this.enabled = builder.comment("Whether Shadow Pokemon do 20% more and take 20% more damage like in Pokemon GO.").define("enabled", false);
        }
    }

    public static final class CallButtonConfig {
        public ModConfigSpec.BooleanValue reducesHeartGauge;
        public ModConfigSpec.BooleanValue accuracyBoost;
        public ModConfigSpec.BooleanValue removeSleep;

        private void build(ModConfigSpec.Builder builder) {
            this.reducesHeartGauge = builder.comment("If true, the Call button in battle reduces the Heart Gauge of Shadow Pok\u00e9mon when snapping them out of Hyper Mode or Reverse Mode.").define("reducesHeartGauge", true);
            this.accuracyBoost = builder.comment("If true, the Call button provides an accuracy boost to the Pok\u00e9mon if they are not in Hyper Mode or Reverse Mode.").define("accuracyBoost", true);
            this.removeSleep = builder.comment("If true, the Call button can wake up a sleeping Pok\u00e9mon.").define("removeSleep", true);
        }
    }

    public static final class ScentConfig {
        public ModConfigSpec.IntValue cooldownSeconds;
        public ModConfigSpec.BooleanValue expandedSystemEnabled;

        private void build(ModConfigSpec.Builder builder) {
            this.cooldownSeconds = builder.comment("Cooldown in seconds between using Scent items on a Pok\u00e9mon.").defineInRange("cooldownSeconds", 300, 0, Integer.MAX_VALUE);
            this.expandedSystemEnabled = builder.comment("If true, the expanded scent system with more scents and nature affinities is enabled.").define("expandedSystemEnabled", true);
        }
    }

    public static final class ShadowMovesConfig {
        public ModConfigSpec.BooleanValue superEffectiveEnabled;
        public ModConfigSpec.ConfigValue<String> replaceCount;
        public ModConfigSpec.BooleanValue onlyShadowRush;

        private void build(ModConfigSpec.Builder builder) {
            this.superEffectiveEnabled = builder.comment("If true, Shadow moves are super effective against non-Shadow Pok\u00e9mon.").define("superEffectiveEnabled", true);
            this.replaceCount = builder.comment("How many moves to replace with Shadow moves. Supports single values (e.g. '1') or ranges (e.g. '1-3').").define("replaceCount", (Object)"1");
            this.onlyShadowRush = builder.comment("If true, only 'Shadow Rush' will be assigned, even if replaceCount > 1.").define("onlyShadowRush", false);
        }
    }

    public static final class ShadowStatConfig {
        public ModConfigSpec.ConfigValue<String> ivMode;
        public ModConfigSpec.IntValue fixedPerfectIVs;
        public ModConfigSpec.IntValue maxPerfectIVs;
        public ModConfigSpec.BooleanValue catchRateScaleEnabled;
        public ModConfigSpec.DoubleValue catchRateMinMultiplier;
        public ModConfigSpec.DoubleValue catchRateExponent;

        private void build(ModConfigSpec.Builder builder) {
            this.ivMode = builder.comment("The mode for determining perfect IVs for Shadow Pok\u00e9mon. Options: OFF, FIXED, SCALED").define("ivMode", (Object)"SCALED");
            this.fixedPerfectIVs = builder.comment("The number of perfect IVs for Shadow Pok\u00e9mon when ivMode is FIXED.").defineInRange("fixedPerfectIVs", 3, 0, 6);
            this.maxPerfectIVs = builder.comment("The maximum number of perfect IVs for Shadow Pok\u00e9mon when ivMode is SCALED.").defineInRange("maxPerfectIVs", 5, 0, 6);
            this.catchRateScaleEnabled = builder.comment("If true, the catch rate of Shadow Pok\u00e9mon scales with their maximum heart gauge.").define("catchRateScaleEnabled", true);
            this.catchRateMinMultiplier = builder.comment("The minimum catch rate multiplier for Shadow Pok\u00e9mon at maximum heart gauge.").defineInRange("catchRateMinMultiplier", 0.25, 0.0, 1.0);
            this.catchRateExponent = builder.comment("The exponent for the catch rate scaling curve.").defineInRange("catchRateExponent", 1.4, 0.0, 10.0);
        }
    }

    public static final class RCTIntegrationConfig {
        public ModConfigSpec.BooleanValue enabled;
        public RCTSection append;
        public RCTSection convert;
        public RCTSection replace;

        private void build(ModConfigSpec.Builder builder) {
            this.enabled = builder.comment("Enables integration with Radical Cobblemon Trainers.").define("enabled", Platform.isModLoaded((String)"rctmod"));
            builder.push("append");
            this.append = new RCTSection();
            this.append.build(builder);
            builder.pop();
            builder.push("convert");
            this.convert = new RCTSection();
            this.convert.build(builder);
            builder.pop();
            builder.push("replace");
            this.replace = new RCTSection(true);
            this.replace.build(builder);
            builder.pop();
        }
    }

    public static final class RelicStoneConfig {
        public ModConfigSpec.IntValue cooldownMinutes;

        private void build(ModConfigSpec.Builder builder) {
            this.cooldownMinutes = builder.comment("Cooldown in minutes between using the Relic Stone's purification function.").defineInRange("cooldownMinutes", 5, 0, Integer.MAX_VALUE);
        }
    }

    public static final class AuraScannerConfig {
        public ModConfigSpec.IntValue auraScannerShadowRange;
        public ModConfigSpec.IntValue auraScannerMeteoroidRange;

        private void build(ModConfigSpec.Builder builder) {
            this.auraScannerShadowRange = builder.comment("The range (in blocks) at which the Aura Scanner can detect Shadow Pokemon.").defineInRange("auraScannerShadowRange", 128, 1, 512);
            this.auraScannerMeteoroidRange = builder.comment("The range (in blocks) at which the Aura Scanner can detect Shadowfall meteoroids.").defineInRange("auraScannerMeteoroidRange", 256, 1, 512);
        }
    }

    public static final class RCTSection
    implements IShadowConfig.IRCTSection {
        public ModConfigSpec.ConfigValue<List<? extends String>> trainerTypes;
        public ModConfigSpec.ConfigValue<List<? extends String>> typePresets;
        public ModConfigSpec.ConfigValue<List<? extends String>> trainerBlacklist;
        public ModConfigSpec.ConfigValue<List<? extends String>> trainers;
        private final boolean isDefaultReplace;

        public RCTSection() {
            this(false);
        }

        public RCTSection(boolean isDefaultReplace) {
            this.isDefaultReplace = isDefaultReplace;
        }

        private void build(ModConfigSpec.Builder builder) {
            this.trainerTypes = builder.comment("The trainer types that this section applies to.").defineList("trainerTypes", this.isDefaultReplace ? List.of("team_rocket", "team_galactic", "team_shadow") : List.of("normal"), o -> o instanceof String);
            this.typePresets = builder.comment("Format: type=presetId. Mapping of trainer types to their respective Shadow Pok\u00e9mon presets.").defineList("typePresets", this.isDefaultReplace ? List.of("team_rocket=shadowedhearts/team_rocket", "team_galactic=shadowedhearts/team_galactic", "team_shadow=shadowedhearts/team_shadow") : List.of("normal=shadowedhearts/normal_20"), o -> o instanceof String && ((String)o).contains("="));
            this.trainerBlacklist = builder.comment("List of specific trainer IDs that should be excluded from Shadow Pok\u00e9mon injection.").defineList("trainerBlacklist", Collections.emptyList(), o -> o instanceof String);
            this.trainers = builder.comment("Format: id;preset;tag1,tag2... Specific trainer definitions with presets and optional tags.").defineList("trainers", this.isDefaultReplace ? List.of("team_rocket;shadowedhearts/team_rocket;", "team_galactic;shadowedhearts/team_galactic;", "team_shadow;shadowedhearts/team_shadow;") : List.of("normal;shadowedhearts/normal_20;"), o -> o instanceof String);
        }

        @Override
        public List<? extends String> trainerTypes() {
            return (List)this.trainerTypes.get();
        }

        @Override
        public List<? extends String> typePresets() {
            return (List)this.typePresets.get();
        }

        @Override
        public List<? extends String> trainerBlacklist() {
            return (List)this.trainerBlacklist.get();
        }

        @Override
        public List<? extends String> trainers() {
            return (List)this.trainers.get();
        }
    }

    public static final class WorldAlterationConfig
    implements IWorldAlterationConfig {
        public ModConfigSpec.BooleanValue shadowfallActive;
        public ModConfigSpec.IntValue impactChanceOneInTicks;
        public ModConfigSpec.IntValue civilizedHeatmapThreshold;
        public ModConfigSpec.IntValue heatmapDecayTicks;
        public ModConfigSpec.DoubleValue heatmapDecayAmount;
        public ModConfigSpec.IntValue minImpactDistanceToPlayer;
        public ModConfigSpec.IntValue maxImpactDistanceToPlayer;
        public ModConfigSpec.IntValue minImpactDistanceToStructures;
        public ModConfigSpec.IntValue minImpactDistanceToSpawn;
        public ModConfigSpec.IntValue minCraterRadius;
        public ModConfigSpec.IntValue maxCraterRadius;
        public ModConfigSpec.IntValue heatmapPresenceRadius;
        public ModConfigSpec.IntValue heatmapFlushIntervalTicks;
        public ModConfigSpec.IntValue meteoroidImpactBroadcastRadius;
        public ModConfigSpec.BooleanValue meteoroidShadowTransformationEnabled;
        public ModConfigSpec.IntValue meteoroidShadowTransformationRadius;
        public ModConfigSpec.IntValue meteoroidShadowTransformationCheckIntervalTicks;
        public ModConfigSpec.DoubleValue meteoroidShadowTransformationChancePerInterval;
        public ModConfigSpec.DoubleValue meteoroidShadowTransformationExposureIncrease;
        public ModConfigSpec.DoubleValue meteoroidShadowTransformationExposureDecay;
        public ModConfigSpec.DoubleValue meteoroidShadowSpawnChanceMultiplier;
        public ModConfigSpec.BooleanValue meteoroidWorldGenEnabled;
        public ModConfigSpec.IntValue meteoroidSpacing;
        public ModConfigSpec.IntValue meteoroidSeparation;
        public ModConfigSpec.ConfigValue<List<? extends String>> meteoroidBiomeBlacklist;
        public ModConfigSpec.ConfigValue<List<? extends String>> meteoroidBiomeWhitelist;

        private void build(ModConfigSpec.Builder builder) {
            this.shadowfallActive = builder.comment("Whether the Shadowfall event is active, enabling meteoroid impacts.").define("shadowfallActive", false);
            this.impactChanceOneInTicks = builder.comment("The average number of ticks between impact attempts. (e.g., 12000 ticks = 10 minutes)").defineInRange("impactChanceOneInTicks", 12000, 1, Integer.MAX_VALUE);
            this.civilizedHeatmapThreshold = builder.comment("Chunks with activity heatmap above this value are considered 'civilized' and protected from impacts.").defineInRange("civilizedHeatmapThreshold", 100, 0, Integer.MAX_VALUE);
            this.heatmapDecayTicks = builder.comment("How often (in ticks) the player activity heatmap decays.").defineInRange("heatmapDecayTicks", 1200, 1, Integer.MAX_VALUE);
            this.heatmapDecayAmount = builder.comment("The amount of activity that decays from each chunk every decay cycle.").defineInRange("heatmapDecayAmount", 1.0, 0.0, 1000.0);
            this.minImpactDistanceToPlayer = builder.comment("Minimum distance (in blocks) from any player for an impact to occur.").defineInRange("minImpactDistanceToPlayer", 64, 0, Integer.MAX_VALUE);
            this.maxImpactDistanceToPlayer = builder.comment("Maximum distance (in blocks) from a player to consider for an impact.").defineInRange("maxImpactDistanceToPlayer", 256, 1, Integer.MAX_VALUE);
            this.minImpactDistanceToStructures = builder.comment("Minimum distance (in blocks) from any generated structures for an impact to occur.").defineInRange("minImpactDistanceToStructures", 64, 0, Integer.MAX_VALUE);
            this.minImpactDistanceToSpawn = builder.comment("Minimum distance (in blocks) from the world spawn point for an impact to occur.").defineInRange("minImpactDistanceToSpawn", 128, 0, Integer.MAX_VALUE);
            this.minCraterRadius = builder.comment("Minimum radius of generated craters.").defineInRange("minCraterRadius", 8, 1, 100);
            this.maxCraterRadius = builder.comment("Maximum radius of generated craters.").defineInRange("maxCraterRadius", 16, 1, 100);
            this.heatmapPresenceRadius = builder.comment("Radius (in chunks) around players where activity heatmap is increased.").defineInRange("heatmapPresenceRadius", 2, 0, 16);
            this.heatmapFlushIntervalTicks = builder.comment("How often (in ticks) the activity heatmap is flushed to disk.").defineInRange("heatmapFlushIntervalTicks", 1200, 1, Integer.MAX_VALUE);
            this.meteoroidImpactBroadcastRadius = builder.comment("Radius (in blocks) within which players will receive a message and hear a sound when a meteoroid impacts.").defineInRange("meteoroidImpactBroadcastRadius", 256, 0, Integer.MAX_VALUE);
            this.meteoroidShadowTransformationEnabled = builder.comment("Whether wild Pokemon near shadowfall meteoroids can become Shadow Pokemon over time.").define("meteoroidShadowTransformationEnabled", true);
            this.meteoroidShadowTransformationRadius = builder.comment("Radius around meteoroids to check for wild Pokemon.").defineInRange("meteoroidShadowTransformationRadius", 16, 1, 64);
            this.meteoroidShadowTransformationCheckIntervalTicks = builder.comment("How often (in ticks) to check for wild Pokemon near meteoroids.").defineInRange("meteoroidShadowTransformationCheckIntervalTicks", 100, 20, 12000);
            this.meteoroidShadowTransformationChancePerInterval = builder.comment("The base chance per check interval for a wild Pokemon near a meteoroid to become a Shadow Pokemon.").defineInRange("meteoroidShadowTransformationChancePerInterval", 0.05, 0.0, 1.0);
            this.meteoroidShadowTransformationExposureIncrease = builder.comment("The amount of exposure a wild Pokemon gains per check interval when near a meteoroid.").defineInRange("meteoroidShadowTransformationExposureIncrease", 1.0, 0.0, 100.0);
            this.meteoroidShadowTransformationExposureDecay = builder.comment("The amount of exposure a wild Pokemon loses per check interval when NOT near a meteoroid.").defineInRange("meteoroidShadowTransformationExposureDecay", 0.5, 0.0, 100.0);
            this.meteoroidShadowSpawnChanceMultiplier = builder.comment("The multiplier applied to the base shadow spawn chance when a Pokemon spawns near a meteoroid.").defineInRange("meteoroidShadowSpawnChanceMultiplier", 5.0, 0.0, 100.0);
            this.meteoroidWorldGenEnabled = builder.comment("Whether shadowfall meteoroids and craters are placed in the world during chunk generation.").define("meteoroidWorldGenEnabled", true);
            this.meteoroidSpacing = builder.comment("Average distance (in chunks) between meteoroid structure placement attempts.").defineInRange("meteoroidSpacing", 26, 0, 4096);
            this.meteoroidSeparation = builder.comment("Minimum distance (in chunks) between meteoroid structure placement attempts. Must be less than spacing.").defineInRange("meteoroidSeparation", 11, 0, 4096);
            this.meteoroidBiomeBlacklist = builder.comment("A list of biomes where shadowfall meteoroids cannot impact. Biome Tags, such as #minecraft:is_forest are also acceptable.").defineList("meteoroidBiomeBlacklist", Collections.emptyList(), o -> o instanceof String);
            this.meteoroidBiomeWhitelist = builder.comment("A list of biomes where shadowfall meteoroids can impact. If not empty, only these biomes will be allowed.  Biome Tags, such as #minecraft:is_forest are also acceptable.").defineList("meteoroidBiomeWhitelist", Collections.emptyList(), o -> o instanceof String);
        }

        @Override
        public boolean shadowfallActive() {
            return (Boolean)this.shadowfallActive.get();
        }

        @Override
        public int impactChanceOneInTicks() {
            return (Integer)this.impactChanceOneInTicks.get();
        }

        @Override
        public int civilizedHeatmapThreshold() {
            return (Integer)this.civilizedHeatmapThreshold.get();
        }

        @Override
        public int heatmapDecayTicks() {
            return (Integer)this.heatmapDecayTicks.get();
        }

        @Override
        public double heatmapDecayAmount() {
            return (Double)this.heatmapDecayAmount.get();
        }

        @Override
        public int minImpactDistanceToPlayer() {
            return (Integer)this.minImpactDistanceToPlayer.get();
        }

        @Override
        public int maxImpactDistanceToPlayer() {
            return (Integer)this.maxImpactDistanceToPlayer.get();
        }

        @Override
        public int minImpactDistanceToStructures() {
            return (Integer)this.minImpactDistanceToStructures.get();
        }

        @Override
        public int minImpactDistanceToSpawn() {
            return (Integer)this.minImpactDistanceToSpawn.get();
        }

        @Override
        public int minCraterRadius() {
            return (Integer)this.minCraterRadius.get();
        }

        @Override
        public int maxCraterRadius() {
            return (Integer)this.maxCraterRadius.get();
        }

        @Override
        public int heatmapPresenceRadius() {
            return (Integer)this.heatmapPresenceRadius.get();
        }

        @Override
        public int heatmapFlushIntervalTicks() {
            return (Integer)this.heatmapFlushIntervalTicks.get();
        }

        @Override
        public int meteoroidImpactBroadcastRadius() {
            return (Integer)this.meteoroidImpactBroadcastRadius.get();
        }

        @Override
        public boolean meteoroidShadowTransformationEnabled() {
            return (Boolean)this.meteoroidShadowTransformationEnabled.get();
        }

        @Override
        public int meteoroidShadowTransformationRadius() {
            return (Integer)this.meteoroidShadowTransformationRadius.get();
        }

        @Override
        public int meteoroidShadowTransformationCheckIntervalTicks() {
            return (Integer)this.meteoroidShadowTransformationCheckIntervalTicks.get();
        }

        @Override
        public double meteoroidShadowTransformationChancePerInterval() {
            return (Double)this.meteoroidShadowTransformationChancePerInterval.get();
        }

        @Override
        public double meteoroidShadowTransformationExposureIncrease() {
            return (Double)this.meteoroidShadowTransformationExposureIncrease.get();
        }

        @Override
        public double meteoroidShadowTransformationExposureDecay() {
            return (Double)this.meteoroidShadowTransformationExposureDecay.get();
        }

        @Override
        public double meteoroidShadowSpawnChanceMultiplier() {
            return (Double)this.meteoroidShadowSpawnChanceMultiplier.get();
        }

        @Override
        public boolean meteoroidWorldGenEnabled() {
            return (Boolean)this.meteoroidWorldGenEnabled.get();
        }

        @Override
        public int meteoroidSpacing() {
            return (Integer)this.meteoroidSpacing.get();
        }

        @Override
        public int meteoroidSeparation() {
            return (Integer)this.meteoroidSeparation.get();
        }

        @Override
        public List<? extends String> meteoroidBiomeBlacklist() {
            return (List)this.meteoroidBiomeBlacklist.get();
        }

        @Override
        public List<? extends String> meteoroidBiomeWhitelist() {
            return (List)this.meteoroidBiomeWhitelist.get();
        }
    }
}

