/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.config;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.server.SpeciesTagManager;
import java.util.List;
import java.util.Locale;

public final class ShadowSpawnConfig {
    private ShadowSpawnConfig() {
    }

    private static String keyFor(Species species) {
        try {
            return species.getResourceIdentifier().toString().toLowerCase(Locale.ROOT);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String altKeyFor(Species species) {
        try {
            return species.getResourceIdentifier().method_12832().toLowerCase(Locale.ROOT);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static double getChancePercent() {
        return ShadowedHeartsConfigs.getInstance().getShadowConfig().shadowSpawnChancePercent();
    }

    public static boolean isBlacklisted(Pokemon pokemon) {
        if (pokemon == null) {
            return false;
        }
        Species sp = pokemon.getSpecies();
        return ShadowSpawnConfig.isBlacklisted(sp);
    }

    public static boolean isBlacklisted(Species species) {
        if (species == null) {
            return false;
        }
        String full = ShadowSpawnConfig.keyFor(species);
        String alt = ShadowSpawnConfig.altKeyFor(species);
        List<? extends String> bl = ShadowedHeartsConfigs.getInstance().getShadowConfig().shadowSpawnBlacklist();
        for (String string : bl) {
            if (!(string.startsWith("#") ? SpeciesTagManager.INSTANCE.isInTag(species, string) : string.equals(full) || string.equals(alt))) continue;
            return true;
        }
        return false;
    }
}

