/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.config;

import com.jayemceekay.shadowedhearts.Shadowedhearts;
import com.jayemceekay.shadowedhearts.config.ISnagConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class SnagConfig
implements ISnagConfig {
    private boolean loaded = false;
    public static final ModConfigSpec SPEC;
    private static final Data DATA;

    @Override
    public int energyPerAttempt() {
        return (Integer)SnagConfig.DATA.energyPerAttempt.get();
    }

    @Override
    public int toggleCooldownTicks() {
        return (Integer)SnagConfig.DATA.toggleCooldownTicks.get();
    }

    @Override
    public boolean rechargeOnVictory() {
        return (Boolean)SnagConfig.DATA.rechargeOnVictory.get();
    }

    @Override
    public boolean rechargeInPvp() {
        return (Boolean)SnagConfig.DATA.rechargeInPvp.get();
    }

    @Override
    public int rechargeBase() {
        return (Integer)SnagConfig.DATA.rechargeBase.get();
    }

    @Override
    public double rechargePerLevel() {
        return (Double)SnagConfig.DATA.rechargePerLevel.get();
    }

    @Override
    public int rechargePerNpc() {
        return (Integer)SnagConfig.DATA.rechargePerNpc.get();
    }

    @Override
    public int rechargeMin() {
        return (Integer)SnagConfig.DATA.rechargeMin.get();
    }

    @Override
    public int rechargeMax() {
        return (Integer)SnagConfig.DATA.rechargeMax.get();
    }

    @Override
    public boolean auraReaderRechargeOnVictory() {
        return (Boolean)SnagConfig.DATA.auraReaderRechargeOnVictory.get();
    }

    @Override
    public boolean auraReaderRechargeInPvp() {
        return (Boolean)SnagConfig.DATA.auraReaderRechargeInPvp.get();
    }

    @Override
    public int auraReaderRechargeBase() {
        return (Integer)SnagConfig.DATA.auraReaderRechargeBase.get();
    }

    @Override
    public double auraReaderRechargePerLevel() {
        return (Double)SnagConfig.DATA.auraReaderRechargePerLevel.get();
    }

    @Override
    public int auraReaderRechargePerNpc() {
        return (Integer)SnagConfig.DATA.auraReaderRechargePerNpc.get();
    }

    @Override
    public int auraReaderRechargeMin() {
        return (Integer)SnagConfig.DATA.auraReaderRechargeMin.get();
    }

    @Override
    public int auraReaderRechargeMax() {
        return (Integer)SnagConfig.DATA.auraReaderRechargeMax.get();
    }

    @Override
    public int prototypeCapacity() {
        return (Integer)SnagConfig.DATA.prototypeCapacity.get();
    }

    @Override
    public int advancedCapacity() {
        return (Integer)SnagConfig.DATA.advancedCapacity.get();
    }

    @Override
    public boolean failStackingBonus() {
        return (Boolean)SnagConfig.DATA.snaggingPity.failStackingBonus.get();
    }

    @Override
    public double failBonusPerAttempt() {
        return (Double)SnagConfig.DATA.snaggingPity.failBonusPerAttempt.get();
    }

    @Override
    public double maxFailBonus() {
        return (Double)SnagConfig.DATA.snaggingPity.maxFailBonus.get();
    }

    @Override
    public ModConfigSpec getSpec() {
        return SPEC;
    }

    @Override
    public void load() {
        this.loaded = true;
        Shadowedhearts.LOGGER.info("SnagConfig loaded...");
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    static {
        DATA = new Data();
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        DATA.build(builder);
        SPEC = builder.build();
    }

    private static final class Data {
        public ModConfigSpec.IntValue energyPerAttempt;
        public ModConfigSpec.IntValue toggleCooldownTicks;
        public ModConfigSpec.IntValue prototypeCapacity;
        public ModConfigSpec.IntValue advancedCapacity;
        public ModConfigSpec.BooleanValue rechargeOnVictory;
        public ModConfigSpec.BooleanValue rechargeInPvp;
        public ModConfigSpec.IntValue rechargeBase;
        public ModConfigSpec.DoubleValue rechargePerLevel;
        public ModConfigSpec.IntValue rechargePerNpc;
        public ModConfigSpec.IntValue rechargeMin;
        public ModConfigSpec.IntValue rechargeMax;
        public ModConfigSpec.BooleanValue auraReaderRechargeOnVictory;
        public ModConfigSpec.BooleanValue auraReaderRechargeInPvp;
        public ModConfigSpec.IntValue auraReaderRechargeBase;
        public ModConfigSpec.DoubleValue auraReaderRechargePerLevel;
        public ModConfigSpec.IntValue auraReaderRechargePerNpc;
        public ModConfigSpec.IntValue auraReaderRechargeMin;
        public ModConfigSpec.IntValue auraReaderRechargeMax;
        public final SnaggingPityConfig snaggingPity = new SnaggingPityConfig();

        private Data() {
        }

        private void build(ModConfigSpec.Builder builder) {
            this.energyPerAttempt = builder.comment("The amount of energy consumed by the Snag Machine for each snag attempt.").defineInRange("energy_per_attempt", 50, 0, 1000);
            this.toggleCooldownTicks = builder.comment("Cooldown in ticks (20 ticks = 1 second) between toggling the Snag Machine on or off.").defineInRange("toggle_cooldown_ticks", 20, 0, 1200);
            builder.push("prototype_snag_machine");
            this.prototypeCapacity = builder.comment("The energy capacity of the Prototype Snag Machine.").defineInRange("capacity", 50, 1, 10000);
            builder.pop();
            builder.push("advanced_snag_machine");
            this.advancedCapacity = builder.comment("The energy capacity of the Advanced Snag Machine.").defineInRange("capacity", 100, 1, 10000);
            builder.pop();
            builder.push("recharge");
            this.rechargeOnVictory = builder.comment("If true, the Snag Machine recharges energy when the player wins a battle.").define("on_victory", true);
            this.rechargeInPvp = builder.comment("If true, the Snag Machine recharges energy when the player wins a PvP battle.").define("in_pvp", false);
            this.rechargeBase = builder.comment("The base amount of energy recharged on victory.").defineInRange("base", 10, 0, 1000);
            this.rechargePerLevel = builder.comment("Additional energy recharged per level of the defeated Pok\u00e9mon.").defineInRange("per_level", 0.25, 0.0, 100.0);
            this.rechargePerNpc = builder.comment("Additional energy recharged per Pok\u00e9mon in the NPC's party.").defineInRange("per_npc", 3, 0, 100);
            this.rechargeMin = builder.comment("The minimum energy recharged on victory.").defineInRange("min", 5, 0, 1000);
            this.rechargeMax = builder.comment("The maximum energy recharged on victory.").defineInRange("max", 15, 0, 1000);
            builder.pop();
            builder.push("aura_reader_recharge");
            this.auraReaderRechargeOnVictory = builder.comment("If true, the Aura Reader recharges energy when the player wins a battle.").define("on_victory", true);
            this.auraReaderRechargeInPvp = builder.comment("If true, the Aura Reader recharges energy when the player wins a PvP battle.").define("in_pvp", false);
            this.auraReaderRechargeBase = builder.comment("The base amount of energy recharged for the Aura Reader on victory.").defineInRange("base", 200, 0, 12000);
            this.auraReaderRechargePerLevel = builder.comment("Additional energy recharged for the Aura Reader per level of the defeated Pok\u00e9mon.").defineInRange("per_level", 5.0, 0.0, 1000.0);
            this.auraReaderRechargePerNpc = builder.comment("Additional energy recharged for the Aura Reader per Pok\u00e9mon in the NPC's party.").defineInRange("per_npc", 60, 0, 12000);
            this.auraReaderRechargeMin = builder.comment("The minimum energy recharged for the Aura Reader on victory.").defineInRange("min", 100, 0, 12000);
            this.auraReaderRechargeMax = builder.comment("The maximum energy recharged for the Aura Reader on victory.").defineInRange("max", 3000, 0, 12000);
            builder.pop();
            builder.push("snagging_pity");
            this.snaggingPity.build(builder);
            builder.pop();
        }
    }

    public static final class SnaggingPityConfig {
        public ModConfigSpec.BooleanValue failStackingBonus;
        public ModConfigSpec.DoubleValue failBonusPerAttempt;
        public ModConfigSpec.DoubleValue maxFailBonus;

        private void build(ModConfigSpec.Builder builder) {
            this.failStackingBonus = builder.comment("If true, each failed snag attempt increases the success chance of the next attempt.").define("failStackingBonus", true);
            this.failBonusPerAttempt = builder.comment("The bonus added to the catch rate for each failed snag attempt.").defineInRange("failBonusPerAttempt", 0.05, 0.0, 1.0);
            this.maxFailBonus = builder.comment("The maximum bonus that can be accumulated from failed snag attempts.").defineInRange("maxFailBonus", 0.25, 0.0, 1.0);
        }
    }
}

