/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;

public final class ShadowAspectPresets {
    private static final Map<class_2960, List<String>> CACHE = new HashMap<class_2960, List<String>>();
    private static final Map<class_2960, List<String>> RUNTIME_PRESETS = new HashMap<class_2960, List<String>>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private ShadowAspectPresets() {
    }

    public static boolean isPresetKey(String aspect) {
        return aspect != null && aspect.startsWith("sh_shadow_presets/");
    }

    public static class_2960 toPresetId(String presetAspect) {
        if (!ShadowAspectPresets.isPresetKey(presetAspect)) {
            return null;
        }
        String path = presetAspect.substring("sh_shadow_presets/".length());
        int slash = path.indexOf(47);
        if (slash <= 0) {
            return null;
        }
        String ns = path.substring(0, slash);
        String id = path.substring(slash + 1);
        if (ns.isBlank() || id.isBlank()) {
            return null;
        }
        return new class_2960(ns, id);
    }

    public static List<String> get(MinecraftServer server, class_2960 presetId) {
        if (presetId == null) {
            return Collections.emptyList();
        }
        if (RUNTIME_PRESETS.containsKey(presetId)) {
            return RUNTIME_PRESETS.get(presetId);
        }
        if (server == null) {
            return Collections.emptyList();
        }
        return CACHE.computeIfAbsent(presetId, id -> ShadowAspectPresets.load(server.method_34864(), id));
    }

    public static void savePreset(MinecraftServer server, class_2960 presetId, List<String> aspects) {
        RUNTIME_PRESETS.put(presetId, new ArrayList<String>(aspects));
        ShadowAspectPresets.saveToDisk(presetId, aspects);
        CACHE.remove(presetId);
    }

    public static void deletePreset(MinecraftServer server, class_2960 presetId) {
        RUNTIME_PRESETS.remove(presetId);
        ShadowAspectPresets.deleteFromDisk(presetId);
        CACHE.remove(presetId);
    }

    public static Map<class_2960, List<String>> getRuntimePresets() {
        return Collections.unmodifiableMap(RUNTIME_PRESETS);
    }

    public static void init() {
        ShadowAspectPresets.loadFromDisk();
    }

    private static Path getPresetsDir() {
        Path configDir = Platform.getConfigFolder();
        return configDir.resolve("shadowedhearts").resolve("presets");
    }

    private static void saveToDisk(class_2960 presetId, List<String> aspects) {
        try {
            Path dir = ShadowAspectPresets.getPresetsDir();
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(presetId.method_12836() + "_" + presetId.method_12832() + ".json");
            JsonObject obj = new JsonObject();
            JsonArray arr = new JsonArray();
            for (String s : aspects) {
                arr.add(s);
            }
            obj.add("aspects", (JsonElement)arr);
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((JsonElement)obj, (Appendable)writer);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void deleteFromDisk(class_2960 presetId) {
        try {
            Path dir = ShadowAspectPresets.getPresetsDir();
            Path file = dir.resolve(presetId.method_12836() + "_" + presetId.method_12832() + ".json");
            Files.deleteIfExists(file);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void loadFromDisk() {
        try {
            Path dir = ShadowAspectPresets.getPresetsDir();
            if (!Files.exists(dir, new LinkOption[0])) {
                return;
            }
            Files.list(dir).forEach(file -> {
                if (file.toString().endsWith(".json")) {
                    try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                        String filename = file.getFileName().toString();
                        filename = filename.substring(0, filename.length() - 5);
                        int underscore = filename.indexOf(95);
                        if (underscore <= 0) {
                            return;
                        }
                        String ns = filename.substring(0, underscore);
                        String id = filename.substring(underscore + 1);
                        class_2960 presetId = new class_2960(ns, id);
                        JsonElement root = JsonParser.parseReader((Reader)reader);
                        RUNTIME_PRESETS.put(presetId, ShadowAspectPresets.parse(root));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<String> load(class_3300 rm, class_2960 id) {
        try {
            class_2960 file = new class_2960("shadowedhearts", "shadow_presets/" + id.method_12836() + "/" + id.method_12832() + ".json");
            Optional res = rm.method_14486(file);
            if (res.isEmpty()) {
                return Collections.emptyList();
            }
            try (InputStream in = ((class_3298)res.get()).method_14482();){
                List<String> list;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    JsonElement root = JsonParser.parseReader((Reader)reader);
                    list = ShadowAspectPresets.parse(root);
                }
                return list;
            }
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    private static List<String> parse(JsonElement root) {
        JsonObject obj;
        JsonArray arr;
        ArrayList<String> out = new ArrayList<String>();
        if (root == null || root.isJsonNull()) {
            return out;
        }
        if (root.isJsonArray()) {
            ShadowAspectPresets.parseArray(root.getAsJsonArray(), out);
            return out;
        }
        if (root.isJsonObject() && (arr = (obj = root.getAsJsonObject()).getAsJsonArray("aspects")) != null) {
            ShadowAspectPresets.parseArray(arr, out);
        }
        return out;
    }

    private static void parseArray(JsonArray arr, List<String> out) {
        for (JsonElement el : arr) {
            String s;
            JsonObject o;
            if (el == null || el.isJsonNull()) continue;
            if (el.isJsonPrimitive()) {
                String s2 = el.getAsString();
                if (s2 == null || s2.isBlank()) continue;
                out.add(s2);
                continue;
            }
            if (!el.isJsonObject() || !(o = el.getAsJsonObject()).has("aspect") || (s = o.get("aspect").getAsString()) == null || s.isBlank()) continue;
            out.add(s);
        }
    }
}

