/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.data;

import com.cobblemon.mod.common.api.npc.NPCClasses;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;

public final class ShadowPools {
    private static final Map<class_2960, List<WeightedEntry>> CACHE = new HashMap<class_2960, List<WeightedEntry>>();
    private static final Map<class_2960, List<WeightedEntry>> RUNTIME_POOLS = new HashMap<class_2960, List<WeightedEntry>>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private ShadowPools() {
    }

    public static List<WeightedEntry> get(MinecraftServer server, class_2960 id) {
        if (id == null) {
            return Collections.emptyList();
        }
        if (RUNTIME_POOLS.containsKey(id)) {
            return RUNTIME_POOLS.get(id);
        }
        if (server == null) {
            return Collections.emptyList();
        }
        return CACHE.computeIfAbsent(id, key -> ShadowPools.load(server.method_34864(), key));
    }

    public static void savePool(MinecraftServer server, class_2960 id, List<WeightedEntry> entries) {
        RUNTIME_POOLS.put(id, new ArrayList<WeightedEntry>(entries));
        ShadowPools.saveToDisk(id, entries);
        CACHE.remove(id);
    }

    public static void deletePool(MinecraftServer server, class_2960 id) {
        RUNTIME_POOLS.remove(id);
        ShadowPools.deleteFromDisk(id);
        CACHE.remove(id);
    }

    public static Map<class_2960, List<WeightedEntry>> getRuntimePools() {
        return Collections.unmodifiableMap(RUNTIME_POOLS);
    }

    public static void init() {
        ShadowPools.loadFromDisk();
    }

    private static Path getPoolsDir() {
        Path configDir = Platform.getConfigFolder();
        return configDir.resolve("shadowedhearts").resolve("shadow_pools");
    }

    private static void saveToDisk(class_2960 id, List<WeightedEntry> entries) {
        try {
            Path dir = ShadowPools.getPoolsDir();
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(id.method_12836() + "_" + id.method_12832() + ".json");
            JsonObject root = new JsonObject();
            JsonArray arr = new JsonArray();
            for (WeightedEntry entry : entries) {
                arr.add(entry.toJson());
            }
            root.add("entries", (JsonElement)arr);
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void deleteFromDisk(class_2960 id) {
        try {
            Path dir = ShadowPools.getPoolsDir();
            Path file = dir.resolve(id.method_12836() + "_" + id.method_12832() + ".json");
            Files.deleteIfExists(file);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void loadFromDisk() {
        try {
            Path dir = ShadowPools.getPoolsDir();
            if (!Files.exists(dir, new LinkOption[0])) {
                return;
            }
            Files.list(dir).forEach(file -> {
                if (file.toString().endsWith(".json")) {
                    try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                        String filename = file.getFileName().toString();
                        filename = filename.substring(0, filename.length() - 5);
                        int underscore = filename.indexOf(95);
                        if (underscore <= 0) {
                            return;
                        }
                        String ns = filename.substring(0, underscore);
                        String idStr = filename.substring(underscore + 1);
                        class_2960 id = new class_2960(ns, idStr);
                        JsonElement root = JsonParser.parseReader((Reader)reader);
                        RUNTIME_POOLS.put(id, ShadowPools.parsePool(root));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<WeightedEntry> load(class_3300 rm, class_2960 id) {
        try {
            class_2960 file = new class_2960(id.method_12836(), "shadow_pools/" + id.method_12832() + ".json");
            Optional res = rm.method_14486(file);
            if (res.isEmpty()) {
                return Collections.emptyList();
            }
            try (InputStream in = ((class_3298)res.get()).method_14482();){
                List<WeightedEntry> list;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    JsonElement root = JsonParser.parseReader((Reader)reader);
                    list = ShadowPools.parsePool(root);
                }
                return list;
            }
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    private static List<WeightedEntry> parsePool(JsonElement root) {
        JsonObject obj;
        JsonArray arr;
        ArrayList<WeightedEntry> out = new ArrayList<WeightedEntry>();
        if (root == null || root.isJsonNull()) {
            return out;
        }
        if (root.isJsonArray()) {
            ShadowPools.parseEntriesArray(root.getAsJsonArray(), out);
            return out;
        }
        if (root.isJsonObject() && (arr = (obj = root.getAsJsonObject()).getAsJsonArray("entries")) != null) {
            ShadowPools.parseEntriesArray(arr, out);
        }
        return out;
    }

    private static void parseEntriesArray(JsonArray arr, List<WeightedEntry> out) {
        for (JsonElement el : arr) {
            PokemonProperties props;
            int weight;
            JsonObject o;
            String s;
            if (el == null || el.isJsonNull()) continue;
            if (el.isJsonPrimitive()) {
                String s2 = el.getAsString();
                PokemonProperties props2 = PokemonProperties.Companion.parse(s2);
                out.add(new WeightedEntry(props2, 1));
                continue;
            }
            if (!el.isJsonObject() || (s = (o = el.getAsJsonObject()).has("pokemon") ? o.get("pokemon").getAsString() : null) == null || s.isBlank()) continue;
            int n = weight = o.has("weight") ? ShadowPools.safeInt(o.get("weight")) : 1;
            if (o.has("properties") && o.get("properties").isJsonObject()) {
                props = (PokemonProperties)NPCClasses.INSTANCE.getGson().fromJson(o.get("properties"), PokemonProperties.class);
                if (props.getSpecies() == null) {
                    PokemonProperties parsed = PokemonProperties.Companion.parse(s);
                    ShadowPools.mergeInto(props, parsed);
                }
            } else {
                props = PokemonProperties.Companion.parse(s);
            }
            out.add(new WeightedEntry(props, weight));
        }
    }

    private static int safeInt(JsonElement e) {
        try {
            return e.getAsInt();
        }
        catch (Throwable t) {
            return 1;
        }
    }

    private static void mergeInto(PokemonProperties base, PokemonProperties extra) {
        try {
            if (base.getLevel() == null) {
                base.setLevel(extra.getLevel());
            }
            if (base.getSpecies() == null) {
                base.setSpecies(extra.getSpecies());
            }
            if (base.getForm() == null) {
                base.setForm(extra.getForm());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static List<PokemonProperties> pick(Random rng, List<WeightedEntry> entries, int count) {
        if (entries == null || entries.isEmpty() || count <= 0) {
            return Collections.emptyList();
        }
        int total = 0;
        for (WeightedEntry e : entries) {
            total += Math.max(1, e.weight);
        }
        ArrayList<PokemonProperties> result = new ArrayList<PokemonProperties>();
        block1: for (int i = 0; i < count; ++i) {
            int r = rng.nextInt(Math.max(1, total));
            int acc = 0;
            for (WeightedEntry e : entries) {
                if (r >= (acc += Math.max(1, e.weight))) continue;
                result.add(e.props);
                continue block1;
            }
        }
        return result;
    }

    public static final class WeightedEntry {
        public final PokemonProperties props;
        public final int weight;

        public WeightedEntry(PokemonProperties props, int weight) {
            this.props = props;
            this.weight = Math.max(1, weight);
        }

        public JsonElement toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("pokemon", this.props.toString());
            if (this.weight != 1) {
                obj.addProperty("weight", (Number)this.weight);
            }
            return obj;
        }
    }
}

