/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.heart;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.ShadowService;
import com.jayemceekay.shadowedhearts.heart.HeartGaugeDeltas;

public final class HeartGaugeEvents {
    private HeartGaugeEvents() {
    }

    private static void apply(Pokemon pokemon, PokemonEntity live, int delta) {
        HeartGaugeEvents.apply(pokemon, live, delta, true);
    }

    private static void apply(Pokemon pokemon, PokemonEntity live, int delta, boolean sync) {
        if (pokemon == null || !PokemonAspectUtil.hasShadowAspect(pokemon)) {
            return;
        }
        PokemonAspectUtil.ensureRequiredShadowAspects(pokemon);
        int cur = PokemonAspectUtil.getHeartGaugeMeter(pokemon);
        int next = cur + delta;
        ShadowService.setHeartGauge(pokemon, live, next, sync);
        PokemonAspectUtil.ensureRequiredShadowAspects(pokemon);
    }

    public static void onBattleSentOut(PokemonEntity live) {
        Pokemon p = live.getPokemon();
        int d = HeartGaugeDeltas.getDelta(p, HeartGaugeDeltas.EventType.BATTLE);
        HeartGaugeEvents.apply(p, live, d);
    }

    public static void onCalledInBattle(PokemonEntity live) {
        Pokemon p = live.getPokemon();
        int d = HeartGaugeDeltas.getDelta(p, HeartGaugeDeltas.EventType.CALL);
        HeartGaugeEvents.apply(p, live, d);
    }

    public static void onPartyStep(Pokemon pokemon, PokemonEntity live) {
        HeartGaugeEvents.onPartyStep(pokemon, live, true);
    }

    public static void onPartyStep(Pokemon pokemon, PokemonEntity live, boolean sync) {
        int d = HeartGaugeDeltas.getDelta(pokemon, HeartGaugeDeltas.EventType.PARTY);
        HeartGaugeEvents.apply(pokemon, live, d, sync);
    }

    public static void onChamberStep(Pokemon pokemon, PokemonEntity live) {
        HeartGaugeEvents.onChamberStep(pokemon, live, true);
    }

    public static void onChamberStep(Pokemon pokemon, PokemonEntity live, boolean sync) {
        int d = HeartGaugeDeltas.getDelta(pokemon, HeartGaugeDeltas.EventType.CHAMBER);
        HeartGaugeEvents.apply(pokemon, live, d, sync);
    }
}

