/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.items;

import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.ShadowService;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.core.ModItems;
import com.jayemceekay.shadowedhearts.heart.HeartGaugeDeltas;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class ScentItem
extends class_1792 {
    private final int multiplier;
    private final String scentType;
    private final int color;
    private static final String TYPE_SOOTHING = "soothing";
    private static final String TYPE_STIMULATING = "stimulating";
    private static final String TYPE_AFFECTIONATE = "affectionate";
    private static final String TYPE_CLARIFYING = "clarifying";
    private static final String TYPE_RESOLUTE = "resolute";
    private static final Map<Nature, String> PRIMARY_TYPE_BY_NATURE = Map.ofEntries(Map.entry(Natures.CALM, "soothing"), Map.entry(Natures.GENTLE, "soothing"), Map.entry(Natures.RELAXED, "soothing"), Map.entry(Natures.BASHFUL, "soothing"), Map.entry(Natures.TIMID, "soothing"), Map.entry(Natures.HASTY, "stimulating"), Map.entry(Natures.JOLLY, "stimulating"), Map.entry(Natures.NAIVE, "stimulating"), Map.entry(Natures.LAX, "stimulating"), Map.entry(Natures.RASH, "stimulating"), Map.entry(Natures.LONELY, "affectionate"), Map.entry(Natures.DOCILE, "affectionate"), Map.entry(Natures.HARDY, "affectionate"), Map.entry(Natures.QUIRKY, "affectionate"), Map.entry(Natures.CAREFUL, "affectionate"), Map.entry(Natures.MODEST, "clarifying"), Map.entry(Natures.MILD, "clarifying"), Map.entry(Natures.QUIET, "clarifying"), Map.entry(Natures.SERIOUS, "clarifying"), Map.entry(Natures.SASSY, "clarifying"), Map.entry(Natures.BRAVE, "resolute"), Map.entry(Natures.ADAMANT, "resolute"), Map.entry(Natures.IMPISH, "resolute"), Map.entry(Natures.NAUGHTY, "resolute"), Map.entry(Natures.BOLD, "resolute"));
    private static final Map<Nature, Map<String, AffinityTier>> AFFINITY = ScentItem.buildAffinityTable();

    private static Map<Nature, Map<String, AffinityTier>> buildAffinityTable() {
        record Template(String primary, String like, String neutral, String dislike, String strongDislike) {
        }
        Map<String, Template> templates = Map.of(TYPE_SOOTHING, new Template(TYPE_SOOTHING, TYPE_AFFECTIONATE, TYPE_CLARIFYING, TYPE_STIMULATING, TYPE_RESOLUTE), TYPE_STIMULATING, new Template(TYPE_STIMULATING, TYPE_CLARIFYING, TYPE_RESOLUTE, TYPE_SOOTHING, TYPE_AFFECTIONATE), TYPE_AFFECTIONATE, new Template(TYPE_AFFECTIONATE, TYPE_SOOTHING, TYPE_RESOLUTE, TYPE_CLARIFYING, TYPE_STIMULATING), TYPE_CLARIFYING, new Template(TYPE_CLARIFYING, TYPE_STIMULATING, TYPE_AFFECTIONATE, TYPE_RESOLUTE, TYPE_SOOTHING), TYPE_RESOLUTE, new Template(TYPE_RESOLUTE, TYPE_CLARIFYING, TYPE_STIMULATING, TYPE_AFFECTIONATE, TYPE_SOOTHING));
        HashMap out = new HashMap();
        for (Map.Entry<Nature, String> entry : PRIMARY_TYPE_BY_NATURE.entrySet()) {
            Nature nature = entry.getKey();
            String primaryType = entry.getValue();
            Template t = templates.get(primaryType);
            if (t == null) continue;
            HashMap<String, AffinityTier> map = new HashMap<String, AffinityTier>();
            map.put(t.primary(), AffinityTier.STRONG_LIKE);
            map.put(t.like(), AffinityTier.LIKE);
            map.put(t.neutral(), AffinityTier.NEUTRAL);
            map.put(t.dislike(), AffinityTier.DISLIKE);
            map.put(t.strongDislike(), AffinityTier.STRONG_DISLIKE);
            map.putIfAbsent(TYPE_SOOTHING, AffinityTier.NEUTRAL);
            map.putIfAbsent(TYPE_STIMULATING, AffinityTier.NEUTRAL);
            map.putIfAbsent(TYPE_AFFECTIONATE, AffinityTier.NEUTRAL);
            map.putIfAbsent(TYPE_CLARIFYING, AffinityTier.NEUTRAL);
            map.putIfAbsent(TYPE_RESOLUTE, AffinityTier.NEUTRAL);
            out.put(nature, Collections.unmodifiableMap(map));
        }
        return Collections.unmodifiableMap(out);
    }

    private static AffinityTier getAffinityTier(@Nullable Nature nature, String scentType) {
        if (nature == null) {
            return AffinityTier.NEUTRAL;
        }
        return AFFINITY.getOrDefault(nature, Map.of()).getOrDefault(scentType, AffinityTier.NEUTRAL);
    }

    public ScentItem(class_1792.class_1793 props, int multiplier) {
        this(props, multiplier, "none", 0xFFFFFF);
    }

    public ScentItem(class_1792.class_1793 props, int multiplier, String scentType, int color) {
        super(props);
        this.multiplier = Math.max(1, multiplier);
        this.scentType = scentType;
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (ShadowedHeartsConfigs.getInstance().getShadowConfig().expandedScentSystemEnabled()) {
            if (!this.scentType.equals("none")) {
                String typeKey = "tooltip.shadowedhearts.scent_type." + this.scentType;
                tooltip.add((class_2561)class_2561.method_43471((String)typeKey).method_27692(class_124.field_1080));
            }
        } else {
            class_1792 item = stack.method_7909();
            if (item == ModItems.JOY_SCENT.get()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.shadowedhearts.joy_scent.description").method_27692(class_124.field_1080));
            } else if (item == ModItems.EXCITE_SCENT.get()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.shadowedhearts.excite_scent.description").method_27692(class_124.field_1080));
            } else if (item == ModItems.VIVID_SCENT.get()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.shadowedhearts.vivid_scent.description").method_27692(class_124.field_1080));
            }
        }
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 hand) {
        int cooldownTicks;
        long lastUse;
        class_1937 level = player.method_37908();
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        if (!(target instanceof PokemonEntity)) {
            return class_1269.field_5811;
        }
        PokemonEntity pe = (PokemonEntity)target;
        Pokemon pokemon = pe.getPokemon();
        if (pokemon == null) {
            return class_1269.field_5811;
        }
        if (!PokemonAspectUtil.hasShadowAspect(pokemon)) {
            return class_1269.field_5811;
        }
        long now = level.method_8510();
        if (now - (lastUse = PokemonAspectUtil.getScentCooldown(pokemon)) < (long)(cooldownTicks = ShadowedHeartsConfigs.getInstance().getShadowConfig().scentCooldownSeconds() * 20)) {
            if (!level.field_9236) {
                long remainingTicks = (long)cooldownTicks - (now - lastUse);
                long remainingSeconds = remainingTicks / 20L;
                player.method_7353((class_2561)class_2561.method_43469((String)"message.shadowedhearts.scent_cooldown", (Object[])new Object[]{remainingSeconds}).method_27692(class_124.field_1061), true);
            }
            return class_1269.field_5814;
        }
        int base = ShadowedHeartsConfigs.getInstance().getShadowConfig().expandedScentSystemEnabled() ? -100 : HeartGaugeDeltas.getDelta(pokemon, HeartGaugeDeltas.EventType.SCENT);
        double finalMultiplier = this.multiplier;
        if (ShadowedHeartsConfigs.getInstance().getShadowConfig().expandedScentSystemEnabled() && !this.scentType.equals("none")) {
            Nature nature = pokemon.getNature();
            AffinityTier tier = ScentItem.getAffinityTier(nature, this.scentType);
            finalMultiplier *= tier.multiplier;
            if (tier == AffinityTier.STRONG_LIKE || tier == AffinityTier.LIKE) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.shadowedhearts.scent_preferred").method_27692(class_124.field_1060), true);
            } else if (tier == AffinityTier.DISLIKE || tier == AffinityTier.STRONG_DISLIKE) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.shadowedhearts.scent_disliked").method_27692(class_124.field_1061), true);
            }
        }
        int delta = (int)((double)base * finalMultiplier);
        int current = PokemonAspectUtil.getHeartGaugeMeter(pokemon);
        int next = current + delta;
        ShadowService.setHeartGauge(pokemon, pe, next);
        PokemonAspectUtil.setScentCooldown(pokemon, now);
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        return class_1269.field_21466;
    }

    private static enum AffinityTier {
        STRONG_LIKE(1.5),
        LIKE(1.25),
        NEUTRAL(1.0),
        DISLIKE(0.75),
        STRONG_DISLIKE(0.5);

        final double multiplier;

        private AffinityTier(double multiplier) {
            this.multiplier = multiplier;
        }
    }
}

