/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.mixin;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.entity.PokemonSideDelegate;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokeball.ThrownPokeballHitEvent;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleCaptureAction;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.entity.pokeball.EmptyPokeBallEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonServerDelegate;
import com.cobblemon.mod.common.net.messages.client.battle.BattleCaptureStartPacket;
import com.cobblemon.mod.common.pokemon.properties.UncatchableProperty;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.google.common.collect.Iterables;
import com.jayemceekay.shadowedhearts.network.ShadowedHeartsNetwork;
import com.jayemceekay.shadowedhearts.network.SnagArmedPacket;
import com.jayemceekay.shadowedhearts.snag.PlayerSnagData;
import com.jayemceekay.shadowedhearts.snag.SnagCaps;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import kotlin.Unit;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_3222;
import net.minecraft.class_3857;
import net.minecraft.class_3966;
import net.minecraft.class_5251;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EmptyPokeBallEntity.class}, priority=10000)
public abstract class MixinEmptyPokeBallEntity
extends class_3857 {
    @Shadow
    @Final
    private static class_2940<class_243> HIT_VELOCITY;
    @Shadow
    @Final
    private static class_2940<class_243> HIT_TARGET_POSITION;

    public MixinEmptyPokeBallEntity(class_1299<? extends class_3857> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract void drop();

    @Shadow
    protected abstract void attemptCatch(PokemonEntity var1);

    @WrapMethod(method={"onHitEntity"})
    public void onHitEntity(class_3966 hitResult, Operation<Void> original) {
        PokemonEntity pokemonEntity;
        class_1297 class_12972 = hitResult.method_17782();
        if (class_12972 instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)class_12972).getAspects().contains("shadowedhearts:shadow")) {
            if (((EmptyPokeBallEntity)this).getCaptureState() == EmptyPokeBallEntity.CaptureState.NOT && !hitResult.method_17782().method_37908().field_9236) {
                PokemonSideDelegate pokemonSideDelegate = pokemonEntity.getDelegate();
                if (pokemonSideDelegate instanceof PokemonServerDelegate) {
                    PokemonServerDelegate delegate = (PokemonServerDelegate)pokemonSideDelegate;
                    PokemonBattle battle = delegate.getBattle();
                    class_1297 owner = ((EmptyPokeBallEntity)this).method_24921();
                    if (pokemonEntity.getPokemon().isPlayerOwned()) {
                        owner.method_43496((class_2561)LocalizationUtilsKt.lang((String)"capture.not_wild", (Object[])new Object[]{pokemonEntity.getExposedSpecies().getTranslatedName()}).method_54663(((class_5251)class_5251.method_27719((String)"red").getOrThrow()).method_27716()));
                        this.drop();
                        return;
                    }
                    if (!UncatchableProperty.INSTANCE.isCatchable(pokemonEntity)) {
                        owner.method_43496((class_2561)LocalizationUtilsKt.lang((String)"capture.cannot_be_caught", (Object[])new Object[0]).method_27692(class_124.field_1061));
                        this.drop();
                        return;
                    }
                    if (battle != null && owner != null) {
                        class_3222 sp;
                        PlayerSnagData cap;
                        if (!((EmptyPokeBallEntity)this).getAspects().contains("snag_ball") && !pokemonEntity.getPokemon().isWild()) {
                            owner.method_43496((class_2561)LocalizationUtilsKt.lang((String)"message.shadowedhearts.snag_machine.requires_snag_ball", (Object[])new Object[0]).method_27692(class_124.field_1061));
                            this.drop();
                            return;
                        }
                        BattleActor throwerActor = battle.getActor(owner.method_5667());
                        BattleActor hitActor = (BattleActor)Iterables.find((Iterable)battle.getActors(), actor -> actor.isForPokemon(pokemonEntity));
                        ActiveBattlePokemon hitBattlePokemon = (ActiveBattlePokemon)Iterables.find((Iterable)hitActor.getActivePokemon(), battlePokemon -> battlePokemon.getBattlePokemon().getEffectedPokemon().getEntity() == pokemonEntity, null);
                        if (throwerActor == null) {
                            owner.method_43496((class_2561)LocalizationUtilsKt.lang((String)"capture.in_battle", (Object[])new Object[]{pokemonEntity.getExposedSpecies().getTranslatedName().method_27692(class_124.field_1061)}));
                            this.drop();
                            return;
                        }
                        if (hitActor == null || hitBattlePokemon == null) {
                            this.drop();
                            return;
                        }
                        boolean canFitForcedAction = throwerActor.canFitForcedAction();
                        if (!canFitForcedAction) {
                            owner.method_43496((class_2561)LocalizationUtilsKt.lang((String)"capture.not_your_turn", (Object[])new Object[0]).method_27692(class_124.field_1061));
                            this.drop();
                            return;
                        }
                        BattleCaptureAction battleCaptureAction = new BattleCaptureAction(battle, hitBattlePokemon, (EmptyPokeBallEntity)this);
                        battleCaptureAction.attach();
                        battle.getCaptureActions().add(battleCaptureAction);
                        battle.broadcastChatMessage((class_2561)LocalizationUtilsKt.lang((String)"capture.attempted_capture", (Object[])new Object[]{throwerActor.getName(), ((EmptyPokeBallEntity)this).getPokeBall().item.method_7848(), pokemonEntity.getExposedSpecies().getTranslatedName()}).method_27692(class_124.field_1054));
                        battle.sendUpdate((NetworkPacket)new BattleCaptureStartPacket(((EmptyPokeBallEntity)this).getPokeBall().getName(), ((EmptyPokeBallEntity)this).getAspects(), hitBattlePokemon.getPNX()));
                        if (owner instanceof class_3222 && (cap = SnagCaps.get((class_1657)(sp = (class_3222)owner))).isArmed()) {
                            cap.setArmed(false);
                            ShadowedHeartsNetwork.sendToPlayer(sp, new SnagArmedPacket(false));
                        }
                        throwerActor.getActivePokemon().forEach(activeBattlePokemon -> throwerActor.forceChoose((ShowdownActionResponse)PassActionResponse.INSTANCE));
                    } else {
                        if (pokemonEntity.isBusy()) {
                            owner.method_43496((class_2561)LocalizationUtilsKt.lang((String)"capture.busy", (Object[])new Object[]{pokemonEntity.getExposedSpecies().getTranslatedName().method_27692(class_124.field_1061)}));
                            this.drop();
                            return;
                        }
                        if (owner instanceof class_3222) {
                            if (BattleRegistry.getBattleByParticipatingPlayer((class_3222)((class_3222)owner)) != null) {
                                owner.method_43496((class_2561)LocalizationUtilsKt.lang((String)"capture.in_battle", (Object[])new Object[]{pokemonEntity.getExposedSpecies().getTranslatedName().method_27692(class_124.field_1061)}));
                                this.drop();
                                return;
                            }
                        }
                    }
                    ((EmptyPokeBallEntity)this).setCapturingPokemon(pokemonEntity);
                    ((EmptyPokeBallEntity)this).method_5841().method_12778(HIT_VELOCITY, (Object)((EmptyPokeBallEntity)this).method_18798());
                    ((EmptyPokeBallEntity)this).method_5841().method_12778(HIT_TARGET_POSITION, (Object)hitResult.method_17784());
                    CobblemonEvents.THROWN_POKEBALL_HIT.postThen((Cancelable)new ThrownPokeballHitEvent((EmptyPokeBallEntity)this, pokemonEntity), thrownPokeballHitEvent -> {
                        if (thrownPokeballHitEvent.isCanceled()) {
                            this.drop();
                        }
                        return Unit.INSTANCE;
                    }, thrownPokeballHitEvent -> {
                        this.attemptCatch(pokemonEntity);
                        return Unit.INSTANCE;
                    });
                }
                return;
            }
            super.method_7454(hitResult);
        } else {
            original.call(new Object[]{hitResult});
        }
    }
}

