/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.mixin;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.client.gui.summary.widgets.screens.moves.MoveSlotWidget;
import com.cobblemon.mod.common.client.gui.summary.widgets.screens.moves.MovesWidget;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.ShadowGate;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MovesWidget.class})
public abstract class MixinMovesWidget {
    @Shadow
    @Nullable
    public abstract Move getSelectedMove();

    @Unique
    private boolean shadowedhearts$shouldMask(Move m, Pokemon pokemon) {
        if (m == null || pokemon == null) {
            return false;
        }
        if (ShadowGate.isShadowMoveId(m.getName())) {
            return false;
        }
        int nonShadowIndex = 0;
        int allowed = PokemonAspectUtil.getAllowedVisibleNonShadowMoves(pokemon);
        for (Move mv : pokemon.getMoveSet().getMovesWithNulls()) {
            if (mv == null || ShadowGate.isShadowMoveId(mv.getName())) continue;
            if (mv == m) {
                return nonShadowIndex >= allowed;
            }
            ++nonShadowIndex;
        }
        return false;
    }

    @Inject(method={"reorderMove"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void shadowedhearts$disableReorder(MoveSlotWidget move, boolean up, CallbackInfo ci) {
        Pokemon pokemon = ((MovesWidget)this).getSummary().getSelectedPokemon$common();
        if (ShadowGate.isShadowLockedClient(pokemon)) {
            ci.cancel();
        }
    }

    @ModifyArg(method={"selectMove"}, at=@At(value="INVOKE", target="Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MoveDescriptionScrollList;setMoveDescription(Lnet/minecraft/network/chat/MutableComponent;)V"))
    @NotNull
    private class_5250 shadowedhearts$maskMoveDescription(@NotNull class_5250 moveDescription, @Local(argsOnly=true) Move move) {
        Pokemon pokemon = ((MovesWidget)this).getSummary().getSelectedPokemon$common();
        if (this.shadowedhearts$shouldMask(move, pokemon)) {
            return class_2561.method_43470((String)"?????");
        }
        return moveDescription;
    }

    @ModifyVariable(method={"renderWidget(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="STORE"), name={"movePower"})
    private class_5250 shadowedhearts$maskMovePower(class_5250 value) {
        Pokemon pokemon = ((MovesWidget)this).getSummary().getSelectedPokemon$common();
        if (this.shadowedhearts$shouldMask(this.getSelectedMove(), pokemon)) {
            return class_2561.method_43470((String)"???");
        }
        return value;
    }

    @ModifyVariable(method={"renderWidget(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="STORE"), name={"moveAccuracy"})
    private class_5250 shadowedhearts$maskMoveAccuracy(class_5250 value) {
        Pokemon pokemon = ((MovesWidget)this).getSummary().getSelectedPokemon$common();
        if (this.shadowedhearts$shouldMask(this.getSelectedMove(), pokemon)) {
            return class_2561.method_43470((String)"???");
        }
        return value;
    }

    @ModifyVariable(method={"renderWidget(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="STORE"), name={"moveEffect"})
    private class_5250 shadowedhearts$maskMoveEffect(class_5250 value) {
        Pokemon pokemon = ((MovesWidget)this).getSummary().getSelectedPokemon$common();
        if (this.shadowedhearts$shouldMask(this.getSelectedMove(), pokemon)) {
            return class_2561.method_43470((String)"???");
        }
        return value;
    }
}

